/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsublite.internal;

import com.google.api.core.ApiService;
import com.google.api.gax.rpc.ApiException;
import com.google.cloud.pubsublite.internal.wire.ApiServiceUtils;
import com.google.cloud.pubsublite.internal.wire.SystemExecutors;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import java.util.HashMap;
import java.util.function.Supplier;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ServiceCache<@UnknownKeyFor K, @UnknownKeyFor V extends @UnknownKeyFor @NonNull @Initialized ApiService>
implements AutoCloseable {
    private final @UnknownKeyFor @NonNull @Initialized Logger logger = LoggerFactory.getLogger(ServiceCache.class);
    @GuardedBy(value="this")
    private final @UnknownKeyFor @NonNull @Initialized HashMap<K, V> liveMap = new HashMap();

    ServiceCache() {
    }

    private synchronized void evict(K key, V service) {
        this.liveMap.remove(key, service);
    }

    synchronized V get(final K key, @UnknownKeyFor @NonNull @Initialized Supplier<V> factory) throws @UnknownKeyFor @NonNull @Initialized ApiException {
        ApiService service = (ApiService)this.liveMap.get(key);
        if (service != null) {
            return (V)service;
        }
        final ApiService newService = (ApiService)factory.get();
        this.liveMap.put(key, newService);
        newService.addListener(new ApiService.Listener(){

            public void failed(// Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @NonNull @Initialized ApiService.State s, @UnknownKeyFor @NonNull @Initialized Throwable t) {
                ServiceCache.this.logger.warn(newService.getClass().getSimpleName() + " failed.", t);
                ServiceCache.this.evict(key, newService);
            }

            public void terminated(// Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @NonNull @Initialized ApiService.State from) {
                ServiceCache.this.evict(key, newService);
            }
        }, SystemExecutors.getFuturesExecutor());
        newService.startAsync().awaitRunning();
        return (V)newService;
    }

    @VisibleForTesting
    synchronized void set(K key, V service) {
        this.liveMap.put(key, service);
    }

    @Override
    public synchronized void close() {
        ApiServiceUtils.blockingShutdown(this.liveMap.values());
        this.liveMap.clear();
    }
}

