/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws.sqs;

import com.amazonaws.services.sqs.model.Message;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.SerializableCoder;
import org.apache.beam.sdk.io.UnboundedSource;
import org.apache.beam.sdk.io.aws.sqs.SqsCheckpointMark;
import org.apache.beam.sdk.io.aws.sqs.SqsConfiguration;
import org.apache.beam.sdk.io.aws.sqs.SqsIO;
import org.apache.beam.sdk.io.aws.sqs.SqsUnboundedReader;
import org.apache.beam.sdk.options.PipelineOptions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

class SqsUnboundedSource
extends UnboundedSource<Message, SqsCheckpointMark> {
    private final @UnknownKeyFor @NonNull @Initialized SqsIO.Read read;
    private final @UnknownKeyFor @NonNull @Initialized SqsConfiguration sqsConfiguration;
    private final @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized Message> outputCoder;

    public SqsUnboundedSource(@UnknownKeyFor @NonNull @Initialized SqsIO.Read read, @UnknownKeyFor @NonNull @Initialized SqsConfiguration sqsConfiguration, @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized Message> outputCoder) {
        this.read = read;
        this.sqsConfiguration = sqsConfiguration;
        this.outputCoder = outputCoder;
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized SqsUnboundedSource> split(@UnknownKeyFor @NonNull @Initialized int desiredNumSplits, @UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
        ArrayList<SqsUnboundedSource> sources = new ArrayList<SqsUnboundedSource>();
        for (int i = 0; i < Math.max(1, desiredNumSplits); ++i) {
            sources.add(new SqsUnboundedSource(this.read, this.sqsConfiguration, this.outputCoder));
        }
        return sources;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized UnboundedSource.UnboundedReader<@UnknownKeyFor @NonNull @Initialized Message> createReader(@UnknownKeyFor @NonNull @Initialized PipelineOptions options, @Nullable @UnknownKeyFor @Initialized SqsCheckpointMark checkpointMark) {
        try {
            return new SqsUnboundedReader(this, checkpointMark);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to subscribe to " + this.read.queueUrl() + ": ", e);
        }
    }

    public @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized SqsCheckpointMark> getCheckpointMarkCoder() {
        return SerializableCoder.of(SqsCheckpointMark.class);
    }

    public @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized Message> getOutputCoder() {
        return this.outputCoder;
    }

    public @UnknownKeyFor @NonNull @Initialized SqsIO.Read getRead() {
        return this.read;
    }

    @UnknownKeyFor @NonNull @Initialized SqsConfiguration getSqsConfiguration() {
        return this.sqsConfiguration;
    }

    public @UnknownKeyFor @NonNull @Initialized boolean requiresDeduping() {
        return true;
    }
}

