/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.security.modules;

import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.security.SecurityConfiguration;
import org.apache.flink.runtime.security.modules.HadoopModule;
import org.apache.flink.runtime.security.modules.SecurityModule;
import org.apache.flink.runtime.security.modules.SecurityModuleFactory;
import org.apache.flink.runtime.util.HadoopUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HadoopModuleFactory
implements SecurityModuleFactory {
    private static final Logger LOG = LoggerFactory.getLogger(HadoopModuleFactory.class);

    @Override
    public SecurityModule createModule(SecurityConfiguration securityConfig) {
        try {
            Class.forName("org.apache.hadoop.conf.Configuration", false, HadoopModule.class.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            LOG.info("Cannot create Hadoop Security Module because Hadoop cannot be found in the Classpath.");
            return null;
        }
        try {
            org.apache.hadoop.conf.Configuration hadoopConfiguration = HadoopUtils.getHadoopConfiguration((Configuration)securityConfig.getFlinkConfig());
            return new HadoopModule(securityConfig, hadoopConfiguration);
        }
        catch (LinkageError e) {
            LOG.warn("Cannot create Hadoop Security Module due to an error that happened while instantiating the module. No security module will be loaded.", (Throwable)e);
            return null;
        }
    }
}

