/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms;

import com.google.auto.value.AutoValue;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.transforms.AutoValue_WithFailures_ExceptionElement;
import org.apache.beam.sdk.transforms.AutoValue_WithFailures_Result;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.values.EncodableThrowable;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.PInput;
import org.apache.beam.sdk.values.POutput;
import org.apache.beam.sdk.values.PValue;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@Experimental(value=Experimental.Kind.WITH_EXCEPTIONS)
public class WithFailures {

    @AutoValue
    public static abstract class Result<@UnknownKeyFor OutputT extends @UnknownKeyFor @NonNull @Initialized POutput, @UnknownKeyFor FailureElementT>
    implements PInput,
    POutput {
        public abstract OutputT output();

        abstract /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @Nullable @UnknownKeyFor @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> outputTag();

        public abstract @UnknownKeyFor @NonNull @Initialized PCollection<FailureElementT> failures();

        abstract @UnknownKeyFor @NonNull @Initialized TupleTag<FailureElementT> failuresTag();

        public static <OutputT extends POutput, FailureElementT> @UnknownKeyFor @NonNull @Initialized Result<OutputT, FailureElementT> of(OutputT output, @UnknownKeyFor @NonNull @Initialized PCollection<FailureElementT> failures) {
            return new AutoValue_WithFailures_Result<OutputT, FailureElementT>(output, null, failures, new TupleTag());
        }

        public static <OutputElementT, FailureElementT> @UnknownKeyFor @NonNull @Initialized Result<@UnknownKeyFor @NonNull @Initialized PCollection<OutputElementT>, FailureElementT> of(@UnknownKeyFor @NonNull @Initialized PCollection<OutputElementT> output, @UnknownKeyFor @NonNull @Initialized PCollection<FailureElementT> failures) {
            return new AutoValue_WithFailures_Result<PCollection<OutputElementT>, FailureElementT>(output, new TupleTag(), failures, new TupleTag());
        }

        public static <OutputElementT, FailureElementT> @UnknownKeyFor @NonNull @Initialized Result<@UnknownKeyFor @NonNull @Initialized PCollection<OutputElementT>, FailureElementT> of(@UnknownKeyFor @NonNull @Initialized PCollectionTuple tuple, @UnknownKeyFor @NonNull @Initialized TupleTag<OutputElementT> outputTag, @UnknownKeyFor @NonNull @Initialized TupleTag<FailureElementT> failureTag) {
            return new AutoValue_WithFailures_Result<PCollection<OutputElementT>, FailureElementT>(tuple.get(outputTag), outputTag, tuple.get(failureTag), failureTag);
        }

        public OutputT failuresTo(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized PCollection<FailureElementT>> failureCollections) {
            failureCollections.add(this.failures());
            return this.output();
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Pipeline getPipeline() {
            return this.output().getPipeline();
        }

        @Override
        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized PValue> expand() {
            HashMap values = new HashMap();
            values.put(this.failuresTag(), this.failures());
            if (this.outputTag() != null && this.output() instanceof PValue) {
                values.put(this.outputTag(), (PValue)this.output());
            }
            return values;
        }

        @Override
        public void finishSpecifyingOutput(@UnknownKeyFor @NonNull @Initialized String transformName, @UnknownKeyFor @NonNull @Initialized PInput input, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> transform) {
        }
    }

    public static class ExceptionAsMapHandler<@UnknownKeyFor T>
    extends SimpleFunction<ExceptionElement<T>, KV<T, Map<String, String>>> {
        @Override
        public @UnknownKeyFor @NonNull @Initialized KV<T, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String>> apply(@UnknownKeyFor @NonNull @Initialized ExceptionElement<T> f) {
            return KV.of(f.element(), ImmutableMap.of((Object)"className", (Object)f.exception().getClass().getName(), (Object)"message", (Object)f.exception().getMessage(), (Object)"stackTrace", (Object)Arrays.toString(f.exception().getStackTrace())));
        }
    }

    public static class ThrowableHandler<@UnknownKeyFor T>
    extends SimpleFunction<ExceptionElement<T>, KV<T, EncodableThrowable>> {
        @Override
        public @UnknownKeyFor @NonNull @Initialized KV<T, @UnknownKeyFor @NonNull @Initialized EncodableThrowable> apply(@UnknownKeyFor @NonNull @Initialized ExceptionElement<T> f) {
            return KV.of(f.element(), EncodableThrowable.forThrowable(f.exception()));
        }
    }

    @AutoValue
    public static abstract class ExceptionElement<@UnknownKeyFor T> {
        public abstract T element();

        public abstract @UnknownKeyFor @NonNull @Initialized Exception exception();

        public static <T> @UnknownKeyFor @NonNull @Initialized ExceptionElement<T> of(T element, @UnknownKeyFor @NonNull @Initialized Exception exception) {
            return new AutoValue_WithFailures_ExceptionElement<T>(element, exception);
        }
    }
}

