/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.core;

import java.util.Collections;
import java.util.Objects;
import org.apache.beam.runners.core.KeyedWorkItem;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.MoreObjects;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterables;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

public class KeyedWorkItems {
    public static <K, ElemT> @UnknownKeyFor @NonNull @Initialized KeyedWorkItem<K, ElemT> elementsWorkItem(K key, @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized WindowedValue<ElemT>> elementsIterable) {
        return new ComposedKeyedWorkItem(key, Collections.emptyList(), elementsIterable);
    }

    public static <K, ElemT> @UnknownKeyFor @NonNull @Initialized KeyedWorkItem<K, ElemT> timersWorkItem(K key, @UnknownKeyFor @NonNull @Initialized Iterable< @UnknownKeyFor @NonNull @Initialized TimerInternals.TimerData> timersIterable) {
        return new ComposedKeyedWorkItem(key, timersIterable, Collections.emptyList());
    }

    public static <K, ElemT> @UnknownKeyFor @NonNull @Initialized KeyedWorkItem<K, ElemT> workItem(K key, @UnknownKeyFor @NonNull @Initialized Iterable< @UnknownKeyFor @NonNull @Initialized TimerInternals.TimerData> timersIterable, @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized WindowedValue<ElemT>> elementsIterable) {
        return new ComposedKeyedWorkItem(key, timersIterable, elementsIterable);
    }

    public static class ComposedKeyedWorkItem<@UnknownKeyFor K, @UnknownKeyFor ElemT>
    implements KeyedWorkItem<K, ElemT> {
        private final K key;
        private final @UnknownKeyFor @NonNull @Initialized Iterable< @UnknownKeyFor @NonNull @Initialized TimerInternals.TimerData> timers;
        private final @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized WindowedValue<ElemT>> elements;

        private ComposedKeyedWorkItem(K key, @UnknownKeyFor @NonNull @Initialized Iterable< @UnknownKeyFor @NonNull @Initialized TimerInternals.TimerData> timers, @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized WindowedValue<ElemT>> elements) {
            this.key = key;
            this.timers = timers;
            this.elements = elements;
        }

        @Override
        public K key() {
            return this.key;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Iterable< @UnknownKeyFor @NonNull @Initialized TimerInternals.TimerData> timersIterable() {
            return this.timers;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized WindowedValue<ElemT>> elementsIterable() {
            return this.elements;
        }

        @EnsuresNonNullIf(expression={"#1"}, result=true)
        @Pure
        public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object other) {
            if (other == null || !(other instanceof ComposedKeyedWorkItem)) {
                return false;
            }
            KeyedWorkItem that = (KeyedWorkItem)other;
            return Objects.equals(this.key, that.key()) && Iterables.elementsEqual(this.timersIterable(), that.timersIterable()) && Iterables.elementsEqual(this.elementsIterable(), that.elementsIterable());
        }

        @Pure
        public @UnknownKeyFor @NonNull @Initialized int hashCode() {
            return Objects.hash(this.key, this.timers, this.elements);
        }

        @SideEffectFree
        public @UnknownKeyFor @NonNull @Initialized String toString() {
            return MoreObjects.toStringHelper(ComposedKeyedWorkItem.class).add("key", this.key).add("elements", this.elements).add("timers", this.timers).toString();
        }
    }
}

