/*
 * Decompiled with CFR 0.152.
 */
package com.trilead.ssh2.channel;

import com.trilead.ssh2.channel.Channel;
import com.trilead.ssh2.channel.ChannelManager;
import com.trilead.ssh2.channel.IChannelWorkerThread;
import com.trilead.ssh2.channel.StreamForwarder;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import org.connectbot.simplesocks.Socks5Server;

public class DynamicAcceptThread
extends Thread
implements IChannelWorkerThread {
    private ChannelManager cm;
    private ServerSocket ss;

    public DynamicAcceptThread(ChannelManager cm, int local_port) throws IOException {
        this.cm = cm;
        this.setName("DynamicAcceptThread");
        this.ss = new ServerSocket(local_port);
    }

    public DynamicAcceptThread(ChannelManager cm, InetSocketAddress localAddress) throws IOException {
        this.cm = cm;
        this.ss = new ServerSocket();
        this.ss.bind(localAddress);
    }

    @Override
    public void run() {
        try {
            this.cm.registerThread(this);
        }
        catch (IOException e) {
            this.stopWorking();
            return;
        }
        while (true) {
            Socket sock;
            try {
                sock = this.ss.accept();
            }
            catch (IOException e) {
                this.stopWorking();
                return;
            }
            DynamicAcceptRunnable dar = new DynamicAcceptRunnable(sock);
            Thread t = new Thread(dar);
            t.setDaemon(true);
            t.start();
        }
    }

    @Override
    public void stopWorking() {
        try {
            this.ss.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    class DynamicAcceptRunnable
    implements Runnable {
        private static final int idleTimeout = 180000;
        private Socket sock;
        private InputStream in;
        private OutputStream out;

        public DynamicAcceptRunnable(Socket sock) {
            this.sock = sock;
            DynamicAcceptThread.this.setName("DynamicAcceptRunnable");
        }

        @Override
        public void run() {
            try {
                this.startSession();
            }
            catch (IOException ioe) {
                try {
                    this.sock.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        private void startSession() throws IOException {
            this.sock.setSoTimeout(180000);
            this.in = this.sock.getInputStream();
            this.out = this.sock.getOutputStream();
            Socks5Server server = new Socks5Server(this.in, this.out);
            try {
                if (!server.acceptAuthentication() || !server.readRequest()) {
                    System.out.println("Could not start SOCKS session");
                    return;
                }
            }
            catch (IOException ioe) {
                server.sendReply(Socks5Server.ResponseCode.GENERAL_FAILURE);
                return;
            }
            if (server.getCommand() == Socks5Server.Command.CONNECT) {
                this.onConnect(server);
            } else {
                server.sendReply(Socks5Server.ResponseCode.COMMAND_NOT_SUPPORTED);
            }
        }

        private void onConnect(Socks5Server server) throws IOException {
            Channel cn;
            String destHost = server.getHostName();
            if (destHost == null) {
                destHost = server.getAddress().getHostAddress();
            }
            try {
                cn = DynamicAcceptThread.this.cm.openDirectTCPIPChannel(destHost, server.getPort(), "127.0.0.1", 0);
            }
            catch (IOException e) {
                try {
                    server.sendReply(Socks5Server.ResponseCode.GENERAL_FAILURE);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    this.sock.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return;
            }
            server.sendReply(Socks5Server.ResponseCode.SUCCESS);
            StreamForwarder r2l = new StreamForwarder(cn, null, this.sock, cn.stdoutStream, this.out, "RemoteToLocal");
            StreamForwarder l2r = new StreamForwarder(cn, r2l, this.sock, this.in, cn.stdinStream, "LocalToRemote");
            r2l.setDaemon(true);
            l2r.setDaemon(true);
            r2l.start();
            l2r.start();
        }
    }
}

