/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service.pager;

import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.DataRange;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.PartitionPosition;
import org.apache.cassandra.db.PartitionRangeReadQuery;
import org.apache.cassandra.db.filter.DataLimits;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.dht.Bounds;
import org.apache.cassandra.dht.ExcludingBounds;
import org.apache.cassandra.dht.IncludingExcludingBounds;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.service.pager.AbstractQueryPager;
import org.apache.cassandra.service.pager.PagingState;
import org.apache.cassandra.transport.ProtocolVersion;

public class PartitionRangeQueryPager
extends AbstractQueryPager<PartitionRangeReadQuery> {
    private volatile DecoratedKey lastReturnedKey;
    private volatile PagingState.RowMark lastReturnedRow;

    public PartitionRangeQueryPager(PartitionRangeReadQuery query, PagingState state, ProtocolVersion protocolVersion) {
        super(query, protocolVersion);
        if (state != null) {
            this.lastReturnedKey = query.metadata().partitioner.decorateKey(state.partitionKey);
            this.lastReturnedRow = state.rowMark;
            this.restoreState(this.lastReturnedKey, state.remaining, state.remainingInPartition);
        }
    }

    public PartitionRangeQueryPager(PartitionRangeReadQuery query, ProtocolVersion protocolVersion, DecoratedKey lastReturnedKey, PagingState.RowMark lastReturnedRow, int remaining, int remainingInPartition) {
        super(query, protocolVersion);
        this.lastReturnedKey = lastReturnedKey;
        this.lastReturnedRow = lastReturnedRow;
        this.restoreState(lastReturnedKey, remaining, remainingInPartition);
    }

    @Override
    public PartitionRangeQueryPager withUpdatedLimit(DataLimits newLimits) {
        return new PartitionRangeQueryPager(((PartitionRangeReadQuery)this.query).withUpdatedLimit(newLimits), this.protocolVersion, this.lastReturnedKey, this.lastReturnedRow, this.maxRemaining(), this.remainingInPartition());
    }

    @Override
    public PagingState state() {
        return this.lastReturnedKey == null ? null : new PagingState(this.lastReturnedKey.getKey(), this.lastReturnedRow, this.maxRemaining(), this.remainingInPartition());
    }

    @Override
    protected PartitionRangeReadQuery nextPageReadQuery(int pageSize) {
        DataLimits limits;
        DataRange pageRange;
        DataRange fullRange = ((PartitionRangeReadQuery)this.query).dataRange();
        if (this.lastReturnedKey == null) {
            pageRange = fullRange;
            limits = ((PartitionRangeReadQuery)this.query).limits().forPaging(pageSize);
        } else {
            if (this.lastReturnedKey.equals(fullRange.keyRange().right) && this.remainingInPartition() == 0 && this.lastReturnedRow == null) {
                return null;
            }
            boolean includeLastKey = this.remainingInPartition() > 0 && this.lastReturnedRow != null;
            AbstractBounds<PartitionPosition> bounds = this.makeKeyBounds(this.lastReturnedKey, includeLastKey);
            if (includeLastKey) {
                pageRange = fullRange.forPaging(bounds, ((PartitionRangeReadQuery)this.query).metadata().comparator, this.lastReturnedRow.clustering(((PartitionRangeReadQuery)this.query).metadata()), false);
                limits = ((PartitionRangeReadQuery)this.query).limits().forPaging(pageSize, this.lastReturnedKey.getKey(), this.remainingInPartition());
            } else {
                pageRange = fullRange.forSubRange(bounds);
                limits = ((PartitionRangeReadQuery)this.query).limits().forPaging(pageSize);
            }
        }
        return ((PartitionRangeReadQuery)this.query).withUpdatedLimitsAndDataRange(limits, pageRange);
    }

    @Override
    protected void recordLast(DecoratedKey key, Row last) {
        if (last != null) {
            this.lastReturnedKey = key;
            if (last.clustering() != Clustering.STATIC_CLUSTERING) {
                this.lastReturnedRow = PagingState.RowMark.create(((PartitionRangeReadQuery)this.query).metadata(), last, this.protocolVersion);
            }
        }
    }

    @Override
    protected boolean isPreviouslyReturnedPartition(DecoratedKey key) {
        return key.equals(this.lastReturnedKey);
    }

    private AbstractBounds<PartitionPosition> makeKeyBounds(PartitionPosition lastReturnedKey, boolean includeLastKey) {
        AbstractBounds<PartitionPosition> bounds = ((PartitionRangeReadQuery)this.query).dataRange().keyRange();
        if (bounds instanceof Range || bounds instanceof Bounds) {
            return includeLastKey ? new Bounds<PartitionPosition>(lastReturnedKey, (PartitionPosition)bounds.right) : new Range<PartitionPosition>(lastReturnedKey, (PartitionPosition)bounds.right);
        }
        return includeLastKey ? new IncludingExcludingBounds<PartitionPosition>(lastReturnedKey, (PartitionPosition)bounds.right) : new ExcludingBounds<PartitionPosition>(lastReturnedKey, (PartitionPosition)bounds.right);
    }
}

