/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.vfs.gs.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.Gson;
import org.apache.hop.core.config.HopConfig;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.json.HopJson;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.vfs.gs.config.GoogleCloudConfig;

public class GoogleCloudConfigSingleton {
    private static GoogleCloudConfigSingleton configSingleton;
    private GoogleCloudConfig googleCloudConfig;

    private GoogleCloudConfigSingleton() {
        Object configObject = HopConfig.getInstance().getConfigMap().get("googleCloud");
        if (configObject == null) {
            this.googleCloudConfig = new GoogleCloudConfig();
        } else {
            try {
                ObjectMapper mapper = HopJson.newMapper();
                this.googleCloudConfig = (GoogleCloudConfig)mapper.readValue(new Gson().toJson(configObject), GoogleCloudConfig.class);
            }
            catch (Exception e) {
                LogChannel.GENERAL.logError("Error reading Google Drive configuration, check property 'googleCloud' in the Hop config json file", (Throwable)e);
                this.googleCloudConfig = new GoogleCloudConfig();
            }
        }
        HopConfig.getInstance().getConfigMap().put("googleCloud", this.googleCloudConfig);
    }

    public static GoogleCloudConfigSingleton getInstance() {
        return configSingleton;
    }

    public static GoogleCloudConfig getConfig() {
        if (configSingleton == null) {
            configSingleton = new GoogleCloudConfigSingleton();
        }
        return GoogleCloudConfigSingleton.configSingleton.googleCloudConfig;
    }

    public static void saveConfig() throws HopException {
        HopConfig.getInstance().saveOption("googleCloud", (Object)GoogleCloudConfigSingleton.configSingleton.googleCloudConfig);
        HopConfig.getInstance().saveToFile();
    }
}

