/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.metadata.rest;

import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.metadata.api.HopMetadata;
import org.apache.hop.metadata.api.HopMetadataBase;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.HopMetadataPropertyType;
import org.apache.hop.metadata.api.IHopMetadata;

@HopMetadata(key="restconnection", name="i18n::RestConnection.name", description="i18n::RestConnection.description", image="rest.svg", documentationUrl="/metadata-types/rest-connection.html", hopMetadataPropertyType=HopMetadataPropertyType.REST_CONNECTION)
public class RestConnection
extends HopMetadataBase
implements IHopMetadata {
    private ClientBuilder builder;
    private Client client;
    @HopMetadataProperty(key="base_url", injectionKey="BASE_URL")
    private String baseUrl;
    @HopMetadataProperty(key="test_url", injectionKey="TEST_URL")
    private String testUrl;
    @HopMetadataProperty(key="auth_header_name", injectionKey="AUTH_HEADER_NAME")
    private String authorizationHeaderName;
    @HopMetadataProperty(key="auth_header_prefix", injectionKey="AUTH_HEADER_PREFIX")
    private String authorizationPrefix;
    @HopMetadataProperty(key="auth_header_value", injectionKey="AUTH_HEADER_VALUE")
    private String authorizationHeaderValue;

    public RestConnection() {
        this.builder = ClientBuilder.newBuilder();
        this.client = this.builder.build();
    }

    public String getResponse(String url) throws HopException {
        WebTarget target = this.client.target(this.testUrl);
        Invocation.Builder invocationBuilder = target.request();
        if (!StringUtils.isEmpty((String)this.authorizationPrefix)) {
            invocationBuilder.header(this.authorizationHeaderName, (Object)(this.authorizationPrefix + " " + this.authorizationHeaderValue));
        } else {
            invocationBuilder.header(this.authorizationHeaderName, (Object)this.authorizationHeaderValue);
        }
        Response response = invocationBuilder.get();
        if (response.getStatus() != Response.Status.OK.getStatusCode()) {
            throw new HopException("Error connecting to " + this.testUrl + ": " + response.getStatus());
        }
        return (String)response.readEntity(String.class);
    }

    public void disconnect() throws HopException {
        this.client.close();
    }

    public void testConnection() throws HopException {
        WebTarget target = this.client.target(this.testUrl);
        Invocation.Builder invocationBuilder = target.request();
        if (!StringUtils.isEmpty((String)this.authorizationPrefix)) {
            invocationBuilder.header(this.authorizationHeaderName, (Object)(this.authorizationPrefix + " " + this.authorizationHeaderValue));
        } else {
            invocationBuilder.header(this.authorizationHeaderName, (Object)this.authorizationHeaderValue);
        }
        Response response = invocationBuilder.get();
        if (response.getStatus() != Response.Status.OK.getStatusCode()) {
            throw new HopException("Error connecting to " + this.testUrl + ": " + response.getStatus());
        }
        response.close();
    }

    public RestConnection(RestConnection connection) {
        this.baseUrl = connection.baseUrl;
    }

    public String toString() {
        return this.name == null ? super.toString() : this.name;
    }

    public int hashCode() {
        return this.name == null ? super.hashCode() : this.name.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof RestConnection)) {
            return false;
        }
        RestConnection connection = (RestConnection)((Object)object);
        return this.name != null && this.name.equalsIgnoreCase(connection.name);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public String getTestUrl() {
        return this.testUrl;
    }

    public void setTestUrl(String testUrl) {
        this.testUrl = testUrl;
    }

    public String getAuthorizationHeaderName() {
        return this.authorizationHeaderName;
    }

    public void setAuthorizationHeaderName(String authorizationHeaderName) {
        this.authorizationHeaderName = authorizationHeaderName;
    }

    public String getAuthHeaderPrefix() {
        return this.authorizationPrefix;
    }

    public void setAuthHeaderPrefix(String authHeaderPrefix) {
        this.authorizationPrefix = authHeaderPrefix;
    }

    public String getAuthorizationHeaderValue() {
        return this.authorizationHeaderValue;
    }

    public void setAuthorizationHeaderValue(String authorizationHeaderValue) {
        this.authorizationHeaderValue = authorizationHeaderValue;
    }
}

