/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.hadoop.util;

import java.io.IOException;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.parquet.io.PositionOutputStream;

public class HadoopPositionOutputStream
extends PositionOutputStream {
    private final FSDataOutputStream wrapped;

    HadoopPositionOutputStream(FSDataOutputStream wrapped) {
        this.wrapped = wrapped;
    }

    public long getPos() throws IOException {
        return this.wrapped.getPos();
    }

    public void write(int b) throws IOException {
        this.wrapped.write(b);
    }

    public void write(byte[] b) throws IOException {
        this.wrapped.write(b);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.wrapped.write(b, off, len);
    }

    public void sync() throws IOException {
        this.wrapped.hsync();
    }

    public void flush() throws IOException {
        this.wrapped.flush();
    }

    public void close() throws IOException {
        try (FSDataOutputStream fdos = this.wrapped;){
            fdos.hflush();
        }
    }
}

