/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.actions.eval;

import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.MessageBox;
import org.apache.hop.ui.core.widget.StyledTextComp;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.apache.hop.ui.workflow.action.ActionDialog;
import org.apache.hop.ui.workflow.dialog.WorkflowDialog;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.IAction;
import org.apache.hop.workflow.actions.eval.ActionEval;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class ActionEvalDialog
extends ActionDialog {
    private static final Class<?> PKG = ActionEval.class;
    private Text wName;
    private StyledTextComp wScript;
    private Label wlPosition;
    private ActionEval action;
    private boolean changed;

    public ActionEvalDialog(Shell parent, ActionEval action, WorkflowMeta workflowMeta, IVariables variables) {
        super(parent, workflowMeta, variables);
        this.action = action;
        if (this.action.getName() == null) {
            this.action.setName(BaseMessages.getString(PKG, (String)"ActionEval.Name.Default", (String[])new String[0]));
        }
    }

    public IAction open() {
        this.shell = new Shell(this.getParent(), 3312);
        PropsUi.setLook((Widget)this.shell);
        WorkflowDialog.setShellImage((Shell)this.shell, (IAction)this.action);
        ModifyListener lsMod = e -> this.action.setChanged();
        this.changed = this.action.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"ActionEval.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = PropsUi.getMargin();
        Button wOk = new Button((Composite)this.shell, 8);
        wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        wOk.addListener(13, e -> this.ok());
        Button wCancel = new Button((Composite)this.shell, 8);
        wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        wCancel.addListener(13, e -> this.cancel());
        BaseTransformDialog.positionBottomButtons((Composite)this.shell, (Button[])new Button[]{wOk, wCancel}, (int)margin, null);
        Label wlName = new Label((Composite)this.shell, 131072);
        wlName.setText(BaseMessages.getString(PKG, (String)"ActionEval.ActionName.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlName);
        FormData fdlName = new FormData();
        fdlName.left = new FormAttachment(0, 0);
        fdlName.right = new FormAttachment(middle, -margin);
        fdlName.top = new FormAttachment(0, margin);
        wlName.setLayoutData((Object)fdlName);
        this.wName = new Text((Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wName);
        this.wName.addModifyListener(lsMod);
        FormData fdName = new FormData();
        fdName.left = new FormAttachment(middle, 0);
        fdName.top = new FormAttachment(0, margin);
        fdName.right = new FormAttachment(100, 0);
        this.wName.setLayoutData((Object)fdName);
        this.wlPosition = new Label((Composite)this.shell, 0);
        this.wlPosition.setText(BaseMessages.getString(PKG, (String)"ActionEval.LineNr.Label", (String[])new String[]{"0"}));
        PropsUi.setLook((Widget)this.wlPosition);
        FormData fdlPosition = new FormData();
        fdlPosition.left = new FormAttachment(0, 0);
        fdlPosition.bottom = new FormAttachment((Control)wOk, -margin);
        this.wlPosition.setLayoutData((Object)fdlPosition);
        Label wlScript = new Label((Composite)this.shell, 0);
        wlScript.setText(BaseMessages.getString(PKG, (String)"ActionEval.Script.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlScript);
        FormData fdlScript = new FormData();
        fdlScript.left = new FormAttachment(0, 0);
        fdlScript.top = new FormAttachment((Control)this.wName, margin);
        wlScript.setLayoutData((Object)fdlScript);
        this.wScript = new StyledTextComp((IVariables)this.action, (Composite)this.shell, 19202);
        this.wScript.setText(BaseMessages.getString(PKG, (String)"ActionEval.Script.Default", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wScript, (int)1);
        this.wScript.addModifyListener(lsMod);
        FormData fdScript = new FormData();
        fdScript.left = new FormAttachment(0, 0);
        fdScript.top = new FormAttachment((Control)wlScript, margin);
        fdScript.right = new FormAttachment(100, -10);
        fdScript.bottom = new FormAttachment((Control)this.wlPosition, -margin);
        this.wScript.setLayoutData((Object)fdScript);
        this.wScript.addModifyListener(arg0 -> this.setPosition());
        this.wScript.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                ActionEvalDialog.this.setPosition();
            }

            public void keyReleased(KeyEvent e) {
                ActionEvalDialog.this.setPosition();
            }
        });
        this.wScript.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                ActionEvalDialog.this.setPosition();
            }

            public void focusLost(FocusEvent e) {
                ActionEvalDialog.this.setPosition();
            }
        });
        this.wScript.addMouseListener(new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                ActionEvalDialog.this.setPosition();
            }

            public void mouseDown(MouseEvent e) {
                ActionEvalDialog.this.setPosition();
            }

            public void mouseUp(MouseEvent e) {
                ActionEvalDialog.this.setPosition();
            }
        });
        this.wScript.addModifyListener(lsMod);
        this.getData();
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.action;
    }

    public void setPosition() {
        int lineNumber = this.wScript.getLineNumber();
        int columnNumber = this.wScript.getColumnNumber();
        this.wlPosition.setText(BaseMessages.getString(PKG, (String)"ActionEval.Position.Label", (String[])new String[]{"" + lineNumber, "" + columnNumber}));
    }

    public void getData() {
        if (this.action.getName() != null) {
            this.wName.setText(this.action.getName());
        }
        if (this.action.getScript() != null) {
            this.wScript.setText(this.action.getScript());
        }
        this.wName.selectAll();
        this.wName.setFocus();
    }

    private void cancel() {
        this.action.setChanged(this.changed);
        this.action = null;
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wName.getText())) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setText(BaseMessages.getString(PKG, (String)"System.TransformActionNameMissing.Title", (String[])new String[0]));
            mb.setMessage(BaseMessages.getString(PKG, (String)"System.ActionNameMissing.Msg", (String[])new String[0]));
            mb.open();
            return;
        }
        this.action.setName(this.wName.getText());
        this.action.setScript(this.wScript.getText());
        this.dispose();
    }
}

