/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.vertica.bulkloader;

import com.google.common.annotations.VisibleForTesting;
import com.vertica.jdbc.VerticaConnection;
import com.vertica.jdbc.VerticaCopyStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.PipedInputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import javax.sql.PooledConnection;
import org.apache.commons.dbcp2.DelegatingConnection;
import org.apache.hop.core.database.Database;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.exception.HopDatabaseException;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.exception.HopValueException;
import org.apache.hop.core.logging.ILoggingObject;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.util.StringUtil;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.vertica.bulkloader.VerticaBulkLoaderData;
import org.apache.hop.pipeline.transforms.vertica.bulkloader.VerticaBulkLoaderField;
import org.apache.hop.pipeline.transforms.vertica.bulkloader.VerticaBulkLoaderMeta;
import org.apache.hop.pipeline.transforms.vertica.bulkloader.nativebinary.ColumnSpec;
import org.apache.hop.pipeline.transforms.vertica.bulkloader.nativebinary.ColumnType;
import org.apache.hop.pipeline.transforms.vertica.bulkloader.nativebinary.StreamEncoder;

public class VerticaBulkLoader
extends BaseTransform<VerticaBulkLoaderMeta, VerticaBulkLoaderData> {
    private static final Class<?> PKG = VerticaBulkLoader.class;
    private static final SimpleDateFormat SIMPLE_DATE_FORMAT = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
    public static final String CONST_FIELD = "Field ";
    public static final String CONST_MUST_BE_A_DATE_COMPATIBLE_TYPE_TO_MATCH_TARGET_COLUMN = " must be a Date compatible type to match target column ";
    private FileOutputStream exceptionLog;
    private FileOutputStream rejectedLog;

    public VerticaBulkLoader(TransformMeta transformMeta, VerticaBulkLoaderMeta meta, VerticaBulkLoaderData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    public boolean processRow() throws HopException {
        Object[] r = this.getRow();
        if (r == null) {
            if (this.first && ((VerticaBulkLoaderMeta)this.meta).isTruncateTable() && !((VerticaBulkLoaderMeta)this.meta).isOnlyWhenHaveRows()) {
                this.truncateTable();
            }
            try {
                ((VerticaBulkLoaderData)this.data).close();
            }
            catch (IOException ioe) {
                throw new HopTransformException("Error releasing resources", (Throwable)ioe);
            }
            return false;
        }
        if (this.first) {
            this.first = false;
            if (((VerticaBulkLoaderMeta)this.meta).isTruncateTable()) {
                this.truncateTable();
            }
            ((VerticaBulkLoaderData)this.data).outputRowMeta = this.getInputRowMeta().clone();
            ((VerticaBulkLoaderMeta)this.meta).getFields(((VerticaBulkLoaderData)this.data).outputRowMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
            IRowMeta tableMeta = ((VerticaBulkLoaderMeta)this.meta).getRequiredFields(this.variables);
            if (!((VerticaBulkLoaderMeta)this.meta).specifyFields()) {
                ((VerticaBulkLoaderData)this.data).insertRowMeta = this.getInputRowMeta().clone();
                ((VerticaBulkLoaderData)this.data).selectedRowFieldIndices = new int[((VerticaBulkLoaderData)this.data).insertRowMeta.size()];
                ((VerticaBulkLoaderData)this.data).colSpecs = new ArrayList<ColumnSpec>(((VerticaBulkLoaderData)this.data).insertRowMeta.size());
                for (int insertFieldIdx = 0; insertFieldIdx < ((VerticaBulkLoaderData)this.data).insertRowMeta.size(); ++insertFieldIdx) {
                    ((VerticaBulkLoaderData)this.data).selectedRowFieldIndices[insertFieldIdx] = insertFieldIdx;
                    IValueMeta inputValueMeta = ((VerticaBulkLoaderData)this.data).insertRowMeta.getValueMeta(insertFieldIdx);
                    IValueMeta insertValueMeta = inputValueMeta.clone();
                    IValueMeta targetValueMeta = tableMeta.getValueMeta(insertFieldIdx);
                    insertValueMeta.setName(targetValueMeta.getName());
                    ((VerticaBulkLoaderData)this.data).insertRowMeta.setValueMeta(insertFieldIdx, insertValueMeta);
                    ColumnSpec cs = this.getColumnSpecFromField(inputValueMeta, insertValueMeta, targetValueMeta);
                    ((VerticaBulkLoaderData)this.data).colSpecs.add(insertFieldIdx, cs);
                }
            } else {
                int numberOfInsertFields = ((VerticaBulkLoaderMeta)this.meta).getFields().size();
                ((VerticaBulkLoaderData)this.data).insertRowMeta = new RowMeta();
                ((VerticaBulkLoaderData)this.data).colSpecs = new ArrayList<ColumnSpec>(numberOfInsertFields);
                ((VerticaBulkLoaderData)this.data).selectedRowFieldIndices = new int[numberOfInsertFields];
                for (int insertFieldIdx = 0; insertFieldIdx < numberOfInsertFields; ++insertFieldIdx) {
                    VerticaBulkLoaderField vbf = ((VerticaBulkLoaderMeta)this.meta).getFields().get(insertFieldIdx);
                    String inputFieldName = vbf.getFieldStream();
                    int inputFieldIdx = this.getInputRowMeta().indexOfValue(inputFieldName);
                    if (inputFieldIdx < 0) {
                        throw new HopTransformException(BaseMessages.getString(PKG, (String)"VerticaBulkLoader.Exception.FieldRequired", (String[])new String[]{inputFieldName}));
                    }
                    ((VerticaBulkLoaderData)this.data).selectedRowFieldIndices[insertFieldIdx] = inputFieldIdx;
                    String insertFieldName = vbf.getFieldDatabase();
                    IValueMeta inputValueMeta = this.getInputRowMeta().getValueMeta(inputFieldIdx);
                    if (inputValueMeta == null) {
                        throw new HopTransformException(BaseMessages.getString(PKG, (String)"VerticaBulkLoader.Exception.FailedToFindField", (String[])new String[]{vbf.getFieldStream()}));
                    }
                    IValueMeta insertValueMeta = inputValueMeta.clone();
                    insertValueMeta.setName(insertFieldName);
                    ((VerticaBulkLoaderData)this.data).insertRowMeta.addValueMeta(insertValueMeta);
                    IValueMeta targetValueMeta = tableMeta.searchValueMeta(insertFieldName);
                    ColumnSpec cs = this.getColumnSpecFromField(inputValueMeta, insertValueMeta, targetValueMeta);
                    ((VerticaBulkLoaderData)this.data).colSpecs.add(insertFieldIdx, cs);
                }
            }
            try {
                ((VerticaBulkLoaderData)this.data).pipedInputStream = new PipedInputStream();
                if (((VerticaBulkLoaderData)this.data).colSpecs == null || ((VerticaBulkLoaderData)this.data).colSpecs.isEmpty()) {
                    return false;
                }
                ((VerticaBulkLoaderData)this.data).encoder = this.createStreamEncoder(((VerticaBulkLoaderData)this.data).colSpecs, ((VerticaBulkLoaderData)this.data).pipedInputStream);
                this.initializeWorker();
                ((VerticaBulkLoaderData)this.data).encoder.writeHeader();
            }
            catch (IOException ioe) {
                throw new HopTransformException("Error creating stream encoder", (Throwable)ioe);
            }
        }
        try {
            Object[] outputRowData = this.writeToOutputStream(r);
            if (outputRowData != null) {
                this.putRow(((VerticaBulkLoaderData)this.data).outputRowMeta, outputRowData);
                this.incrementLinesOutput();
            }
            if (this.checkFeedback(this.getLinesRead()) && this.isBasic()) {
                this.logBasic("linenr " + this.getLinesRead());
            }
        }
        catch (HopException e) {
            this.logError("Because of an error, this transform can't continue: ", e);
            this.setErrors(1L);
            this.stopAll();
            this.setOutputDone();
            return false;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return true;
    }

    @VisibleForTesting
    void initializeLogFiles() throws HopException {
        try {
            if (!StringUtil.isEmpty((String)((VerticaBulkLoaderMeta)this.meta).getExceptionsFileName())) {
                this.exceptionLog = new FileOutputStream(((VerticaBulkLoaderMeta)this.meta).getExceptionsFileName(), true);
            }
            if (!StringUtil.isEmpty((String)((VerticaBulkLoaderMeta)this.meta).getRejectedDataFileName())) {
                this.rejectedLog = new FileOutputStream(((VerticaBulkLoaderMeta)this.meta).getRejectedDataFileName(), true);
            }
        }
        catch (FileNotFoundException ex) {
            throw new HopException((Throwable)ex);
        }
    }

    @VisibleForTesting
    void writeExceptionRejectionLogs(HopValueException valueException, Object[] outputRowData) throws IOException {
        String dateTimeString = SIMPLE_DATE_FORMAT.format(new Date(System.currentTimeMillis())) + " - ";
        this.logError(BaseMessages.getString(PKG, (String)"VerticaBulkLoader.Exception.RowRejected", (String[])new String[]{Arrays.stream(outputRowData).map(Object::toString).collect(Collectors.joining(" | "))}));
        if (this.exceptionLog != null) {
            this.exceptionLog.write((dateTimeString + valueException.getMessage().replace(System.lineSeparator(), System.lineSeparator() + dateTimeString)).getBytes());
            this.exceptionLog.write(System.lineSeparator().getBytes());
            for (StackTraceElement element : valueException.getStackTrace()) {
                this.exceptionLog.write((dateTimeString + "at " + element.toString() + System.lineSeparator()).getBytes());
            }
            this.exceptionLog.write((dateTimeString + "Caused by: " + valueException.getClass().toString() + System.lineSeparator()).getBytes());
            this.exceptionLog.write((dateTimeString + valueException.getCause().getMessage().replace(System.lineSeparator(), System.lineSeparator() + dateTimeString)).getBytes());
            this.exceptionLog.write(System.lineSeparator().getBytes());
        }
        if (this.rejectedLog != null) {
            this.rejectedLog.write((dateTimeString + BaseMessages.getString(PKG, (String)"VerticaBulkLoader.Exception.RowRejected", (String[])new String[]{Arrays.stream(outputRowData).map(Object::toString).collect(Collectors.joining(" | "))})).getBytes());
            for (Object outputRowDatum : outputRowData) {
                this.rejectedLog.write((outputRowDatum.toString() + " | ").getBytes());
            }
            this.rejectedLog.write(System.lineSeparator().getBytes());
        }
    }

    @VisibleForTesting
    void closeLogFiles() throws HopException {
        try {
            if (this.exceptionLog != null) {
                this.exceptionLog.close();
            }
            if (this.rejectedLog != null) {
                this.rejectedLog.close();
            }
        }
        catch (IOException exception) {
            throw new HopException((Throwable)exception);
        }
    }

    private ColumnSpec getColumnSpecFromField(IValueMeta inputValueMeta, IValueMeta insertValueMeta, IValueMeta targetValueMeta) {
        this.logBasic("Mapping input field " + inputValueMeta.getName() + " (" + inputValueMeta.getTypeDesc() + ") to target column " + insertValueMeta.getName() + " (" + targetValueMeta.getOriginalColumnTypeName() + ") ");
        String targetColumnTypeName = targetValueMeta.getOriginalColumnTypeName().toUpperCase();
        if (targetColumnTypeName.equals("INTEGER") || targetColumnTypeName.equals("BIGINT")) {
            return new ColumnSpec(ColumnSpec.ConstantWidthType.INTEGER_64);
        }
        if (targetColumnTypeName.equals("BOOLEAN")) {
            return new ColumnSpec(ColumnSpec.ConstantWidthType.BOOLEAN);
        }
        if (targetColumnTypeName.equals("FLOAT") || targetColumnTypeName.equals("DOUBLE PRECISION")) {
            return new ColumnSpec(ColumnSpec.ConstantWidthType.FLOAT);
        }
        if (targetColumnTypeName.equals("CHAR")) {
            return new ColumnSpec(ColumnSpec.UserDefinedWidthType.CHAR, targetValueMeta.getLength());
        }
        if (targetColumnTypeName.equals("VARCHAR") || targetColumnTypeName.equals("CHARACTER VARYING")) {
            return new ColumnSpec(ColumnSpec.VariableWidthType.VARCHAR, targetValueMeta.getLength());
        }
        if (targetColumnTypeName.equals("DATE")) {
            if (!inputValueMeta.isDate()) {
                throw new IllegalArgumentException(CONST_FIELD + inputValueMeta.getName() + CONST_MUST_BE_A_DATE_COMPATIBLE_TYPE_TO_MATCH_TARGET_COLUMN + insertValueMeta.getName());
            }
            return new ColumnSpec(ColumnSpec.ConstantWidthType.DATE);
        }
        if (targetColumnTypeName.equals("TIME")) {
            if (!inputValueMeta.isDate()) {
                throw new IllegalArgumentException(CONST_FIELD + inputValueMeta.getName() + CONST_MUST_BE_A_DATE_COMPATIBLE_TYPE_TO_MATCH_TARGET_COLUMN + insertValueMeta.getName());
            }
            return new ColumnSpec(ColumnSpec.ConstantWidthType.TIME);
        }
        if (targetColumnTypeName.equals("TIMETZ")) {
            if (!inputValueMeta.isDate()) {
                throw new IllegalArgumentException(CONST_FIELD + inputValueMeta.getName() + CONST_MUST_BE_A_DATE_COMPATIBLE_TYPE_TO_MATCH_TARGET_COLUMN + insertValueMeta.getName());
            }
            return new ColumnSpec(ColumnSpec.ConstantWidthType.TIMETZ);
        }
        if (targetColumnTypeName.equals("TIMESTAMP")) {
            if (!inputValueMeta.isDate()) {
                throw new IllegalArgumentException(CONST_FIELD + inputValueMeta.getName() + CONST_MUST_BE_A_DATE_COMPATIBLE_TYPE_TO_MATCH_TARGET_COLUMN + insertValueMeta.getName());
            }
            return new ColumnSpec(ColumnSpec.ConstantWidthType.TIMESTAMP);
        }
        if (targetColumnTypeName.equals("TIMESTAMPTZ")) {
            if (!inputValueMeta.isDate()) {
                throw new IllegalArgumentException(CONST_FIELD + inputValueMeta.getName() + CONST_MUST_BE_A_DATE_COMPATIBLE_TYPE_TO_MATCH_TARGET_COLUMN + insertValueMeta.getName());
            }
            return new ColumnSpec(ColumnSpec.ConstantWidthType.TIMESTAMPTZ);
        }
        if (targetColumnTypeName.equals("INTERVAL") || targetColumnTypeName.equals("INTERVAL DAY TO SECOND")) {
            if (!inputValueMeta.isDate()) {
                throw new IllegalArgumentException(CONST_FIELD + inputValueMeta.getName() + CONST_MUST_BE_A_DATE_COMPATIBLE_TYPE_TO_MATCH_TARGET_COLUMN + insertValueMeta.getName());
            }
            return new ColumnSpec(ColumnSpec.ConstantWidthType.INTERVAL);
        }
        if (targetColumnTypeName.equals("BINARY")) {
            return new ColumnSpec(ColumnSpec.VariableWidthType.VARBINARY, targetValueMeta.getLength());
        }
        if (targetColumnTypeName.equals("VARBINARY")) {
            return new ColumnSpec(ColumnSpec.VariableWidthType.VARBINARY, targetValueMeta.getLength());
        }
        if (targetColumnTypeName.equals("NUMERIC")) {
            return new ColumnSpec(ColumnSpec.PrecisionScaleWidthType.NUMERIC, targetValueMeta.getLength(), targetValueMeta.getPrecision());
        }
        throw new IllegalArgumentException("Column type " + targetColumnTypeName + " not supported.");
    }

    private void initializeWorker() {
        final String dml = this.buildCopyStatementSqlString();
        ((VerticaBulkLoaderData)this.data).workerThread = Executors.defaultThreadFactory().newThread(new Runnable(){

            @Override
            public void run() {
                try {
                    VerticaCopyStream stream = VerticaBulkLoader.this.createVerticaCopyStream(dml);
                    stream.start();
                    stream.addStream((InputStream)((VerticaBulkLoaderData)((VerticaBulkLoader)VerticaBulkLoader.this).data).pipedInputStream);
                    VerticaBulkLoader.this.setLinesRejected(stream.getRejects().size());
                    stream.execute();
                    long rowsLoaded = stream.finish();
                    if (VerticaBulkLoader.this.getLinesOutput() != rowsLoaded) {
                        VerticaBulkLoader.this.logMinimal(String.format("%d records loaded out of %d records sent.", rowsLoaded, VerticaBulkLoader.this.getLinesOutput()));
                    }
                    ((VerticaBulkLoaderData)((VerticaBulkLoader)VerticaBulkLoader.this).data).db.disconnect();
                }
                catch (ClassNotFoundException | IllegalStateException | SQLException | HopException e) {
                    if (e.getCause() instanceof InterruptedIOException) {
                        VerticaBulkLoader.this.logBasic("SQL statement interrupted by halt of pipeline");
                    }
                    VerticaBulkLoader.this.logError("SQL Error during statement execution.", e);
                    VerticaBulkLoader.this.setErrors(1L);
                    VerticaBulkLoader.this.stopAll();
                    VerticaBulkLoader.this.setOutputDone();
                }
            }
        });
        ((VerticaBulkLoaderData)this.data).workerThread.start();
    }

    private String buildCopyStatementSqlString() {
        DatabaseMeta databaseMeta = ((VerticaBulkLoaderData)this.data).db.getDatabaseMeta();
        StringBuilder sb = new StringBuilder(150);
        sb.append("COPY ");
        sb.append(databaseMeta.getQuotedSchemaTableCombination(this.variables, ((VerticaBulkLoaderData)this.data).db.resolve(((VerticaBulkLoaderMeta)this.meta).getSchemaName()), ((VerticaBulkLoaderData)this.data).db.resolve(((VerticaBulkLoaderMeta)this.meta).getTableName())));
        sb.append(" (");
        IRowMeta fields = ((VerticaBulkLoaderData)this.data).insertRowMeta;
        block3: for (int i = 0; i < fields.size(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            ColumnType columnType = ((VerticaBulkLoaderData)this.data).colSpecs.get((int)i).type;
            IValueMeta valueMeta = fields.getValueMeta(i);
            switch (columnType) {
                case NUMERIC: {
                    sb.append("TMPFILLERCOL").append(i).append(" FILLER VARCHAR(1000), ");
                    sb.append(databaseMeta.getStartQuote() + valueMeta.getName() + databaseMeta.getEndQuote());
                    sb.append(" AS CAST(").append("TMPFILLERCOL").append(i).append(" AS NUMERIC");
                    sb.append(")");
                    continue block3;
                }
                default: {
                    sb.append(databaseMeta.getStartQuote() + valueMeta.getName() + databaseMeta.getEndQuote());
                }
            }
        }
        sb.append(")");
        sb.append(" FROM STDIN NATIVE ");
        if (!StringUtil.isEmpty((String)((VerticaBulkLoaderMeta)this.meta).getExceptionsFileName())) {
            sb.append("EXCEPTIONS E'").append(((VerticaBulkLoaderMeta)this.meta).getExceptionsFileName().replace("'", "\\'")).append("' ");
        }
        if (!StringUtil.isEmpty((String)((VerticaBulkLoaderMeta)this.meta).getRejectedDataFileName())) {
            sb.append("REJECTED DATA E'").append(((VerticaBulkLoaderMeta)this.meta).getRejectedDataFileName().replace("'", "\\'")).append("' ");
        }
        sb.append("ENFORCELENGTH ");
        if (((VerticaBulkLoaderMeta)this.meta).isAbortOnError()) {
            sb.append("ABORT ON ERROR ");
        }
        if (((VerticaBulkLoaderMeta)this.meta).isDirect()) {
            sb.append("DIRECT ");
        }
        if (!StringUtil.isEmpty((String)((VerticaBulkLoaderMeta)this.meta).getStreamName())) {
            sb.append("STREAM NAME E'").append(((VerticaBulkLoaderData)this.data).db.resolve(((VerticaBulkLoaderMeta)this.meta).getStreamName()).replace("'", "\\'")).append("' ");
        }
        this.logDebug("copy stmt: " + sb.toString());
        return sb.toString();
    }

    private Object[] writeToOutputStream(Object[] r) throws HopException, IOException {
        Object[] outputRowData;
        block7: {
            assert (r != null);
            Object[] insertRowData = r;
            outputRowData = r;
            if (((VerticaBulkLoaderMeta)this.meta).specifyFields()) {
                insertRowData = new Object[((VerticaBulkLoaderData)this.data).selectedRowFieldIndices.length];
                for (int idx = 0; idx < ((VerticaBulkLoaderData)this.data).selectedRowFieldIndices.length; ++idx) {
                    insertRowData[idx] = r[((VerticaBulkLoaderData)this.data).selectedRowFieldIndices[idx]];
                }
            }
            try {
                ((VerticaBulkLoaderData)this.data).encoder.writeRow(((VerticaBulkLoaderData)this.data).insertRowMeta, insertRowData);
            }
            catch (HopValueException valueException) {
                this.writeExceptionRejectionLogs(valueException, outputRowData);
                if (((VerticaBulkLoaderMeta)this.meta).isAbortOnError()) {
                    throw valueException;
                }
                outputRowData = null;
            }
            catch (IOException e) {
                if (((VerticaBulkLoaderData)this.data).isStopped()) break block7;
                throw new HopException("I/O Error during row write.", (Throwable)e);
            }
        }
        return outputRowData;
    }

    protected void verifyDatabaseConnection() throws HopException {
        if (((VerticaBulkLoaderMeta)this.meta).getConnection() == null) {
            throw new HopException(BaseMessages.getString(PKG, (String)"VerticaBulkLoaderMeta.Error.NoConnection", (String[])new String[0]));
        }
    }

    public boolean init() {
        if (super.init()) {
            try {
                this.verifyDatabaseConnection();
                ((VerticaBulkLoaderData)this.data).databaseMeta = this.getPipelineMeta().findDatabase(((VerticaBulkLoaderMeta)this.meta).getConnection(), this.variables);
                this.initializeLogFiles();
                ((VerticaBulkLoaderData)this.data).db = new Database((ILoggingObject)this, (IVariables)this, ((VerticaBulkLoaderData)this.data).databaseMeta);
                ((VerticaBulkLoaderData)this.data).db.connect();
                if (this.isBasic()) {
                    this.logBasic("Connected to database [" + ((VerticaBulkLoaderMeta)this.meta).getDatabaseMeta() + "]");
                }
                ((VerticaBulkLoaderData)this.data).db.setAutoCommit(false);
                return true;
            }
            catch (HopException e) {
                this.logError("An error occurred intialising this transform: " + e.getMessage());
                this.stopAll();
                this.setErrors(1L);
            }
        }
        return false;
    }

    public void markStop() {
        try {
            this.closeLogFiles();
        }
        catch (HopException ex) {
            this.logError(BaseMessages.getString(PKG, (String)"VerticaBulkLoader.Exception.ClosingLogError", (Object[])new Object[]{ex}));
        }
        super.markStop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopRunning() throws HopException {
        this.setStopped(true);
        if (((VerticaBulkLoaderData)this.data).workerThread != null) {
            Thread thread = ((VerticaBulkLoaderData)this.data).workerThread;
            synchronized (thread) {
                if (((VerticaBulkLoaderData)this.data).workerThread.isAlive() && !((VerticaBulkLoaderData)this.data).workerThread.isInterrupted()) {
                    try {
                        ((VerticaBulkLoaderData)this.data).workerThread.interrupt();
                        ((VerticaBulkLoaderData)this.data).workerThread.join();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
        super.stopRunning();
    }

    void truncateTable() throws HopDatabaseException {
        if (((VerticaBulkLoaderMeta)this.meta).isTruncateTable() && (this.getCopy() == 0 || !Utils.isEmpty((CharSequence)this.getPartitionId()))) {
            ((VerticaBulkLoaderData)this.data).db.truncateTable(this.resolve(((VerticaBulkLoaderMeta)this.meta).getSchemaName()), this.resolve(((VerticaBulkLoaderMeta)this.meta).getTableName()));
        }
    }

    public void dispose() {
        ((VerticaBulkLoaderData)this.data).colSpecs = null;
        ((VerticaBulkLoaderData)this.data).encoder = null;
        this.setOutputDone();
        try {
            if (this.getErrors() > 0L) {
                ((VerticaBulkLoaderData)this.data).db.rollback();
            }
        }
        catch (HopDatabaseException e) {
            this.logError("Unexpected error rolling back the database connection.", e);
        }
        if (((VerticaBulkLoaderData)this.data).workerThread != null) {
            try {
                ((VerticaBulkLoaderData)this.data).workerThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (((VerticaBulkLoaderData)this.data).db != null) {
            ((VerticaBulkLoaderData)this.data).db.disconnect();
        }
        super.dispose();
    }

    @VisibleForTesting
    StreamEncoder createStreamEncoder(List<ColumnSpec> colSpecs, PipedInputStream pipedInputStream) throws IOException {
        return new StreamEncoder(colSpecs, pipedInputStream);
    }

    @VisibleForTesting
    VerticaCopyStream createVerticaCopyStream(String dml) throws SQLException, ClassNotFoundException, HopDatabaseException {
        return new VerticaCopyStream(this.getVerticaConnection(), dml);
    }

    @VisibleForTesting
    VerticaConnection getVerticaConnection() throws SQLException {
        Connection conn = ((VerticaBulkLoaderData)this.data).db.getConnection();
        if (conn != null) {
            if (conn instanceof VerticaConnection) {
                VerticaConnection verticaConnection = (VerticaConnection)conn;
                return verticaConnection;
            }
            Connection underlyingConn = null;
            if (conn instanceof DelegatingConnection) {
                DelegatingConnection delegatingConnection;
                DelegatingConnection pooledConn = delegatingConnection = (DelegatingConnection)conn;
                underlyingConn = pooledConn.getInnermostDelegate();
            } else if (conn instanceof PooledConnection) {
                PooledConnection pooledConnection;
                PooledConnection pooledConn = pooledConnection = (PooledConnection)((Object)conn);
                underlyingConn = pooledConn.getConnection();
            } else {
                try {
                    if (conn.isWrapperFor(VerticaConnection.class)) {
                        return conn.unwrap(VerticaConnection.class);
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            if (underlyingConn != null && underlyingConn instanceof VerticaConnection) {
                VerticaConnection verticaConnection = (VerticaConnection)underlyingConn;
                return verticaConnection;
            }
            throw new IllegalStateException("Could not retrieve a VerticaConnection from " + conn.getClass().getName());
        }
        throw new IllegalStateException("Could not retrieve a VerticaConnection from null");
    }
}

