/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.hopgui.file.workflow.delegates;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.hop.core.Const;
import org.apache.hop.core.Result;
import org.apache.hop.core.gui.WorkflowTracker;
import org.apache.hop.core.gui.plugin.GuiPlugin;
import org.apache.hop.core.util.Utils;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.widget.TreeMemory;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.ui.hopgui.file.workflow.HopGuiWorkflowGraph;
import org.apache.hop.workflow.ActionResult;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

@GuiPlugin(description="Workflow Graph Grid Delegate")
public class HopGuiWorkflowGridDelegate {
    private static final Class<?> PKG = HopGuiWorkflowGridDelegate.class;
    private HopGui hopGui;
    public static final long REFRESH_TIME = 100L;
    public static final long UPDATE_TIME_VIEW = 1000L;
    private static final String STRING_CHEF_LOG_TREE_NAME = "Workflow Log Tree";
    private HopGuiWorkflowGraph workflowGraph;
    private CTabItem workflowGridTab;
    private Tree wTree;
    private WorkflowTracker<?> workflowTracker;
    private int previousNrItems;
    private int nrRow = 0;

    public HopGuiWorkflowGridDelegate(HopGui hopGui, HopGuiWorkflowGraph workflowGraph) {
        this.hopGui = hopGui;
        this.workflowGraph = workflowGraph;
    }

    public void addWorkflowGrid() {
        if (this.workflowGraph.extraViewTabFolder == null || this.workflowGraph.extraViewTabFolder.isDisposed()) {
            this.workflowGraph.addExtraView();
        } else if (this.workflowGridTab != null && !this.workflowGridTab.isDisposed()) {
            this.workflowGraph.extraViewTabFolder.setSelection(this.workflowGridTab);
            return;
        }
        this.workflowGridTab = new CTabItem(this.workflowGraph.extraViewTabFolder, 0);
        this.workflowGridTab.setFont(GuiResource.getInstance().getFontDefault());
        this.workflowGridTab.setImage(GuiResource.getInstance().getImageShowGrid());
        this.workflowGridTab.setText(BaseMessages.getString(PKG, (String)"HopGui.WorkflowGraph.GridTab.Name", (String[])new String[0]));
        this.addControls();
        this.workflowGridTab.setControl((Control)this.wTree);
        this.workflowGraph.extraViewTabFolder.setSelection(this.workflowGridTab);
    }

    private void addControls() {
        this.wTree = new Tree((Composite)this.workflowGraph.extraViewTabFolder, 768);
        this.wTree.setHeaderVisible(true);
        PropsUi.setLook((Widget)this.wTree);
        TreeMemory.addTreeListener(this.wTree, STRING_CHEF_LOG_TREE_NAME);
        TreeColumn column1 = new TreeColumn(this.wTree, 16384);
        column1.setText(BaseMessages.getString(PKG, (String)"WorkflowLog.Column.WorkflowAction", (String[])new String[0]));
        column1.setWidth(200);
        TreeColumn column2 = new TreeColumn(this.wTree, 16384);
        column2.setText(BaseMessages.getString(PKG, (String)"WorkflowLog.Column.Comment", (String[])new String[0]));
        column2.setWidth(200);
        TreeColumn column3 = new TreeColumn(this.wTree, 16384);
        column3.setText(BaseMessages.getString(PKG, (String)"WorkflowLog.Column.Result", (String[])new String[0]));
        column3.setWidth(100);
        TreeColumn column4 = new TreeColumn(this.wTree, 16384);
        column4.setText(BaseMessages.getString(PKG, (String)"WorkflowLog.Column.Reason", (String[])new String[0]));
        column4.setWidth(200);
        TreeColumn column5 = new TreeColumn(this.wTree, 16384);
        column5.setText(BaseMessages.getString(PKG, (String)"WorkflowLog.Column.Filename", (String[])new String[0]));
        column5.setWidth(300);
        TreeColumn column6 = new TreeColumn(this.wTree, 131072);
        column6.setText(BaseMessages.getString(PKG, (String)"WorkflowLog.Column.Nr", (String[])new String[0]));
        column6.setWidth(50);
        TreeColumn column7 = new TreeColumn(this.wTree, 131072);
        column7.setText(BaseMessages.getString(PKG, (String)"WorkflowLog.Column.LogDate", (String[])new String[0]));
        column7.setWidth(150);
        FormData fdTree = new FormData();
        fdTree.left = new FormAttachment(0, 0);
        fdTree.top = new FormAttachment(0, 0);
        fdTree.right = new FormAttachment(100, 0);
        fdTree.bottom = new FormAttachment(100, 0);
        this.wTree.setLayoutData((Object)fdTree);
        Timer timer = new Timer("WorkflowGridAutoRefresh: " + this.workflowGraph.getName());
        TimerTask refreshTask = new TimerTask(){

            @Override
            public void run() {
                Display display = HopGuiWorkflowGridDelegate.this.workflowGraph.getDisplay();
                if (display != null && !display.isDisposed()) {
                    display.asyncExec(() -> {
                        if (!HopGuiWorkflowGridDelegate.this.wTree.isDisposed()) {
                            HopGuiWorkflowGridDelegate.this.refreshTreeTable();
                        }
                    });
                }
            }
        };
        timer.schedule(refreshTask, 10L, 2000L);
        this.wTree.addListener(12, event -> timer.cancel());
    }

    private void refreshTreeTable() {
        int nrItems;
        if (this.workflowTracker != null && (nrItems = this.workflowTracker.getTotalNumberOfItems()) != this.previousNrItems) {
            this.wTree.setRedraw(false);
            this.wTree.removeAll();
            TreeItem treeItem = new TreeItem(this.wTree, 0);
            String workflowName = this.workflowTracker.getWorkflowName();
            if (Utils.isEmpty((CharSequence)workflowName)) {
                workflowName = !Utils.isEmpty((CharSequence)this.workflowTracker.getWorfkflowFilename()) ? this.workflowTracker.getWorfkflowFilename() : BaseMessages.getString(PKG, (String)"WorkflowLog.Tree.StringToDisplayWhenWorkflowHasNoName", (String[])new String[0]);
            }
            treeItem.setText(0, workflowName);
            treeItem.setText(4, Const.NVL((String)this.workflowTracker.getWorfkflowFilename(), (String)""));
            TreeMemory.getInstance().storeExpanded(STRING_CHEF_LOG_TREE_NAME, new String[]{workflowName}, true);
            this.nrRow = 1;
            for (int i = 0; i < this.workflowTracker.nrWorkflowTrackers(); ++i) {
                this.addTrackerToTree(this.workflowTracker.getWorkflowTracker(i), treeItem);
            }
            this.previousNrItems = nrItems;
            TreeMemory.setExpandedFromMemory(this.wTree, STRING_CHEF_LOG_TREE_NAME);
            this.wTree.setRedraw(true);
        }
    }

    private void addTrackerToTree(WorkflowTracker<?> workflowTracker, TreeItem parentItem) {
        try {
            if (workflowTracker != null) {
                TreeItem treeItem = new TreeItem(parentItem, 0);
                if (this.nrRow % 2 != 0) {
                    if (PropsUi.getInstance().isDarkMode()) {
                        treeItem.setBackground(GuiResource.getInstance().getColorDemoGray());
                    } else {
                        treeItem.setBackground(GuiResource.getInstance().getColorBlueCustomGrid());
                    }
                }
                ++this.nrRow;
                if (workflowTracker.nrWorkflowTrackers() > 0) {
                    treeItem.setText(0, BaseMessages.getString(PKG, (String)"WorkflowLog.Tree.WorkflowPrefix", (String[])new String[0]) + workflowTracker.getWorkflowName());
                    for (int i = 0; i < workflowTracker.nrWorkflowTrackers(); ++i) {
                        this.addTrackerToTree(workflowTracker.getWorkflowTracker(i), treeItem);
                    }
                } else {
                    ActionResult result = workflowTracker.getActionResult();
                    if (result != null) {
                        Date logDate;
                        String reason;
                        Result res;
                        String actionName = result.getActionName();
                        if (!Utils.isEmpty((CharSequence)actionName)) {
                            treeItem.setText(0, actionName);
                            treeItem.setText(4, Const.NVL((String)result.getActionFilename(), (String)""));
                        } else {
                            treeItem.setText(0, BaseMessages.getString(PKG, (String)"WorkflowLog.Tree.WorkflowPrefix2", (String[])new String[0]) + workflowTracker.getWorkflowName());
                        }
                        String comment = result.getComment();
                        if (comment != null) {
                            treeItem.setText(1, comment);
                        }
                        if ((res = result.getResult()) != null) {
                            treeItem.setText(2, res.getResult() ? BaseMessages.getString(PKG, (String)"WorkflowLog.Tree.Success", (String[])new String[0]) : BaseMessages.getString(PKG, (String)"WorkflowLog.Tree.Failure", (String[])new String[0]));
                            treeItem.setText(5, Long.toString(res.getEntryNr()));
                            if (res.getResult()) {
                                treeItem.setImage(2, GuiResource.getInstance().getImageSuccess());
                                treeItem.setForeground(2, GuiResource.getInstance().getColorSuccessGreen());
                            } else {
                                treeItem.setImage(2, GuiResource.getInstance().getImageFailure());
                                treeItem.setForeground(GuiResource.getInstance().getColorRed());
                            }
                        }
                        if ((reason = result.getReason()) != null) {
                            treeItem.setText(3, reason);
                        }
                        if ((logDate = result.getLogDate()) != null) {
                            treeItem.setText(6, new SimpleDateFormat("yyyy/MM/dd HH:mm:ss").format(logDate));
                        }
                    }
                }
                treeItem.setExpanded(true);
            }
        }
        catch (Exception e) {
            this.workflowGraph.getLogChannel().logError(Const.getStackTracker((Throwable)e));
        }
    }

    public CTabItem getWorkflowGridTab() {
        return this.workflowGridTab;
    }

    public void setWorkflowTracker(WorkflowTracker<?> workflowTracker) {
        this.workflowTracker = workflowTracker;
        this.previousNrItems = -1;
    }
}

