/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.avro.transforms.avroinput;

import java.io.InputStream;
import org.apache.avro.file.DataFileStream;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.DatumReader;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.avro.transforms.avroinput.AvroFileInputData;
import org.apache.hop.avro.transforms.avroinput.AvroFileInputMeta;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.RowDataUtil;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;

public class AvroFileInput
extends BaseTransform<AvroFileInputMeta, AvroFileInputData> {
    public AvroFileInput(TransformMeta transformMeta, AvroFileInputMeta meta, AvroFileInputData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    public boolean processRow() throws HopException {
        Object[] row = this.getRow();
        if (row == null) {
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            this.first = false;
            ((AvroFileInputData)this.data).dataFilenameField = this.resolve(((AvroFileInputMeta)this.meta).getDataFilenameField());
            if (StringUtils.isEmpty((String)((AvroFileInputData)this.data).dataFilenameField)) {
                throw new HopException("Please specify a field to use as the source of data filenames to read");
            }
            if (this.getInputRowMeta().indexOfValue(((AvroFileInputData)this.data).dataFilenameField) < 0) {
                throw new HopException("Data filename field '" + ((AvroFileInputData)this.data).dataFilenameField + "' doesn't exist in the input of this transform");
            }
            ((AvroFileInputData)this.data).rowsLimit = Const.toInt((String)this.resolve(((AvroFileInputMeta)this.meta).getRowsLimit()), (int)-1);
            ((AvroFileInputData)this.data).outputRowMeta = this.getInputRowMeta().clone();
            ((AvroFileInputMeta)this.meta).getFields(((AvroFileInputData)this.data).outputRowMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
        }
        String filename = this.getInputRowMeta().getString(row, ((AvroFileInputData)this.data).dataFilenameField, null);
        try (InputStream inputStream = HopVfs.getInputStream((String)filename, (IVariables)this.variables);){
            GenericDatumReader datumReader = new GenericDatumReader();
            DataFileStream fileStream = new DataFileStream(inputStream, (DatumReader)datumReader);
            while (fileStream.hasNext()) {
                GenericRecord genericRecord = (GenericRecord)fileStream.next();
                this.incrementLinesInput();
                Object[] outputRow = RowDataUtil.createResizedCopy((Object[])row, (int)((AvroFileInputData)this.data).outputRowMeta.size());
                int outputIndex = this.getInputRowMeta().size();
                outputRow[outputIndex] = genericRecord;
                this.putRow(((AvroFileInputData)this.data).outputRowMeta, outputRow);
                if (((AvroFileInputData)this.data).rowsLimit <= 0 || this.getLinesInput() < (long)((AvroFileInputData)this.data).rowsLimit) continue;
                break;
            }
        }
        catch (Exception e) {
            throw new HopException("Error reading from file '" + filename + "'", (Throwable)e);
        }
        return true;
    }
}

