/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.metadata.serializer.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.metadata.api.HopMetadata;
import org.apache.hop.metadata.api.IHopMetadata;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.metadata.api.IHopMetadataSerializer;
import org.apache.hop.metadata.serializer.json.JsonMetadataParser;
import org.json.simple.JSONObject;

public class JsonMetadataSerializer<T extends IHopMetadata>
implements IHopMetadataSerializer<T> {
    protected IHopMetadataProvider metadataProvider;
    protected String baseFolder;
    protected Class<T> managedClass;
    protected JsonMetadataParser<T> parser;
    protected IVariables variables;
    protected String description;

    public JsonMetadataSerializer(IHopMetadataProvider metadataProvider, String baseFolder, Class<T> managedClass, IVariables variables, String description) {
        this.metadataProvider = metadataProvider;
        this.baseFolder = baseFolder;
        this.managedClass = managedClass;
        this.parser = new JsonMetadataParser<T>(managedClass, metadataProvider);
        this.variables = variables;
        this.description = description;
    }

    @Override
    public String getDescription() {
        HopMetadata hopMetadata = this.managedClass.getAnnotation(HopMetadata.class);
        if (hopMetadata != null) {
            return hopMetadata.description();
        }
        return null;
    }

    @Override
    public List<T> loadAll() throws HopException {
        List<String> names = this.listObjectNames();
        Collections.sort(names);
        ArrayList<T> list = new ArrayList<T>();
        for (String name : names) {
            list.add(this.load(name));
        }
        return list;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public T load(String name) throws HopException {
        if (name == null) {
            throw new HopException("Error: you need to specify the name of the metadata object to load");
        }
        if (!this.exists(name)) {
            return null;
        }
        String filename = this.calculateFilename(name);
        try (InputStream fileInputStream = null;){
            T t;
            block14: {
                fileInputStream = HopVfs.getInputStream(filename);
                JsonFactory jsonFactory = new JsonFactory();
                JsonParser jsonParser = jsonFactory.createParser(fileInputStream);
                try {
                    jsonParser.nextToken();
                    T t2 = this.parser.loadJsonObject(this.managedClass, jsonParser);
                    this.inheritVariables(t2);
                    t2.setMetadataProviderName(this.metadataProvider.getDescription());
                    t = t2;
                    if (jsonParser == null) break block14;
                }
                catch (Throwable throwable) {
                    if (jsonParser != null) {
                        try {
                            jsonParser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                jsonParser.close();
            }
            return t;
        }
        catch (Exception e) {
            throw new HopException("Error loading metadata object '" + name + "' from file '" + filename + "'", e);
        }
    }

    private void inheritVariables(T t) {
        if (t instanceof IVariables) {
            IVariables iVariables = (IVariables)t;
            iVariables.initializeFrom(this.variables);
        }
    }

    @Override
    public void save(T t) throws HopException {
        if (StringUtils.isEmpty((String)t.getName())) {
            throw new HopException("Error: To save a metadata object it needs to have a name");
        }
        String filename = this.calculateFilename(t.getName());
        try {
            JSONObject jObject = this.parser.getJsonObject(t);
            try (OutputStream outputStream = HopVfs.getOutputStream(filename, false);){
                String jsonString = jObject.toJSONString();
                Gson gson = new GsonBuilder().setPrettyPrinting().create();
                JsonElement je = com.google.gson.JsonParser.parseString((String)jsonString);
                String formattedJson = gson.toJson(je);
                outputStream.write(formattedJson.getBytes(StandardCharsets.UTF_8));
                outputStream.flush();
                t.setMetadataProviderName(this.getMetadataProvider().getDescription());
            }
            catch (IOException e) {
                throw new HopException("Error serializing JSON to file '" + filename + "'", e);
            }
        }
        catch (Exception e) {
            throw new HopException("Unable to save object '" + t.getName() + "' to JSON file '" + filename + "'", e);
        }
    }

    public String calculateFilename(String name) {
        return this.baseFolder + "/" + name + ".json";
    }

    @Override
    public T delete(String name) throws HopException {
        if (name == null) {
            throw new HopException("Error: you need to specify the name of the metadata object to delete");
        }
        if (!this.exists(name)) {
            throw new HopException("Error: Object '" + name + "' doesn't exist");
        }
        T t = this.load(name);
        String filename = this.calculateFilename(name);
        try {
            boolean deleted = HopVfs.getFileObject(filename).delete();
            if (!deleted) {
                throw new HopException("Error: Object '" + name + "' could not be deleted, filename : " + filename);
            }
        }
        catch (FileSystemException e) {
            throw new HopException("Error deleting Object '" + name + "' with filename : " + filename);
        }
        return t;
    }

    @Override
    public List<String> listObjectNames() throws HopException {
        FileObject folder = HopVfs.getFileObject(this.baseFolder);
        try {
            List<FileObject> jsonFiles = HopVfs.findFiles(folder, "json", false);
            ArrayList<String> names = new ArrayList<String>();
            for (FileObject jsonFile : jsonFiles) {
                String baseName = jsonFile.getName().getBaseName();
                names.add(baseName.replaceAll("\\.json$", ""));
            }
            return names;
        }
        catch (Exception e) {
            throw new HopException("Error searching for JSON files", e);
        }
    }

    @Override
    public boolean exists(String name) throws HopException {
        return HopVfs.fileExists(this.calculateFilename(name));
    }

    @Override
    public Class<T> getManagedClass() {
        return this.managedClass;
    }

    public String getBaseFolder() {
        return this.baseFolder;
    }

    @Override
    public IHopMetadataProvider getMetadataProvider() {
        return this.metadataProvider;
    }

    public void setMetadataProvider(IHopMetadataProvider metadataProvider) {
        this.metadataProvider = metadataProvider;
    }

    public void setBaseFolder(String baseFolder) {
        this.baseFolder = baseFolder;
    }

    public void setManagedClass(Class<T> managedClass) {
        this.managedClass = managedClass;
    }

    public void setDescription(String description) {
        this.description = description;
    }
}

