/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.languagemodelchat.internals.ui;

import org.apache.commons.lang3.StringUtils;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transforms.languagemodelchat.internals.ui.CompositeParameters;
import org.apache.hop.pipeline.transforms.languagemodelchat.internals.ui.IDialogComposite;
import org.apache.hop.pipeline.transforms.languagemodelchat.internals.ui.i18nUtil;
import org.apache.hop.ui.core.PropsUi;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class TransformNameComposite
implements IDialogComposite {
    private final Label label;
    private final Text inputField;
    private final ITransformMeta meta;
    private final Control control;
    private final CompositeParameters parameters;

    public TransformNameComposite(CompositeParameters parameters) {
        this.parameters = parameters;
        this.meta = parameters.meta();
        this.label = new Label((Composite)parameters.shell(), 131072);
        this.inputField = new Text((Composite)parameters.shell(), 18436);
        PropsUi.setLook((Widget)this.label);
        PropsUi.setLook((Widget)this.inputField);
        this.label.setText(i18nUtil.i18n("System.Label.TransformName"));
        this.inputField.setText(parameters.transformName());
        this.inputField.addModifyListener(e -> this.meta.setChanged());
        FormData fdlTransformName = new FormData();
        fdlTransformName.left = new FormAttachment(0, 0);
        fdlTransformName.right = new FormAttachment(parameters.middlePct(), -parameters.margin());
        fdlTransformName.top = new FormAttachment(0, parameters.margin());
        FormData fdTransformName = new FormData();
        fdTransformName.left = new FormAttachment(parameters.middlePct(), 0);
        fdTransformName.top = new FormAttachment(0, parameters.margin());
        fdTransformName.right = new FormAttachment(100, 0);
        this.label.setLayoutData((Object)fdlTransformName);
        this.inputField.setLayoutData((Object)fdTransformName);
        this.control = this.inputField;
    }

    public Label getLabel() {
        return this.label;
    }

    public Text getInputField() {
        return this.inputField;
    }

    @Override
    public boolean validateInputs() {
        return true;
    }

    @Override
    public Control control() {
        return this.control;
    }

    @Override
    public void populateInputs() {
        this.inputField.selectAll();
        this.inputField.setFocus();
    }

    @Override
    public boolean ok() {
        if (StringUtils.isBlank((CharSequence)this.inputField.getText())) {
            return false;
        }
        this.parameters.dialog().setTransformName(this.inputField.getText());
        return true;
    }
}

