/*
 * Decompiled with CFR 0.152.
 */
package com.sforce.ws.wsdl;

import com.sforce.ws.wsdl.Definitions;
import com.sforce.ws.wsdl.SoapBody;
import com.sforce.ws.wsdl.SoapHeader;
import com.sforce.ws.wsdl.WsdlNode;
import com.sforce.ws.wsdl.WsdlParseException;
import com.sforce.ws.wsdl.WsdlParser;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.namespace.QName;

public class BindingMessage
extends WsdlNode {
    private QName name;
    private Definitions definitions;
    private String type;
    private ArrayList<SoapHeader> headers = new ArrayList();
    private SoapBody body;

    public BindingMessage(Definitions definitions, String type) {
        this.definitions = definitions;
        this.type = type;
    }

    public QName getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public Iterator<SoapHeader> getHeaders() {
        return this.headers.iterator();
    }

    public SoapBody getBody() {
        return this.body;
    }

    void read(WsdlParser parser) throws WsdlParseException {
        String na = parser.getAttributeValue(null, "name");
        if (na != null) {
            this.name = new QName(this.definitions.getTargetNamespace(), na);
        }
        int eventType = parser.getEventType();
        while (true) {
            if (eventType == 2) {
                String n = parser.getName();
                String ns = parser.getNamespace();
                if (n != null && ns != null) {
                    this.parse(n, ns, parser);
                }
            } else if (eventType == 3) {
                String name = parser.getName();
                String namespace = parser.getNamespace();
                if (this.type.equals(name) && "http://schemas.xmlsoap.org/wsdl/".equals(namespace)) {
                    return;
                }
            }
            eventType = parser.next();
        }
    }

    private void parse(String name, String namespace, WsdlParser parser) throws WsdlParseException {
        if ("http://schemas.xmlsoap.org/wsdl/soap/".equals(namespace)) {
            if ("header".equals(name)) {
                SoapHeader header = new SoapHeader();
                header.read(parser);
                this.headers.add(header);
            } else if ("body".equals(name)) {
                if (this.body != null) {
                    throw new WsdlParseException("can not have more than one soap:body");
                }
                this.body = new SoapBody();
                this.body.read(parser);
            } else {
                "fault".equals(name);
            }
        }
    }
}

