/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.util.CoderUtils;
import org.apache.beam.sdk.util.common.ReflectHelpers;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.xerial.snappy.SnappyInputStream;
import org.xerial.snappy.SnappyOutputStream;

public class SerializableUtils {
    public static @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] serializeToByteArray(@UnknownKeyFor @NonNull @Initialized Serializable value) {
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            try (ObjectOutputStream oos = new ObjectOutputStream((OutputStream)new SnappyOutputStream((OutputStream)buffer));){
                oos.writeObject(value);
            }
            return buffer.toByteArray();
        }
        catch (IOException exn) {
            throw new IllegalArgumentException("unable to serialize " + value, exn);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static @UnknownKeyFor @NonNull @Initialized Object deserializeFromByteArray(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] encodedValue, @UnknownKeyFor @NonNull @Initialized String description) {
        try (ContextualObjectInputStream ois = new ContextualObjectInputStream((InputStream)new SnappyInputStream((InputStream)new ByteArrayInputStream(encodedValue)));){
            Object object = ois.readObject();
            return object;
        }
        catch (IOException | ClassNotFoundException exn) {
            throw new IllegalArgumentException("unable to deserialize " + description, exn);
        }
    }

    public static <T extends Serializable> T ensureSerializableRoundTrip(T value) {
        T copy = SerializableUtils.ensureSerializable(value);
        Preconditions.checkState((boolean)value.equals(copy), (String)"Value not equal to original after serialization, indicating that its type may not implement serialization or equals correctly.  Before: %s, after: %s", value, copy);
        return copy;
    }

    public static <T extends Serializable> T ensureSerializable(T value) {
        return SerializableUtils.clone(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends Serializable> T clone(T value) {
        Serializable copy;
        ClassLoader tccl;
        Thread thread = Thread.currentThread();
        ClassLoader loader = tccl = thread.getContextClassLoader();
        try {
            if (tccl.loadClass(value.getClass().getName()) != value.getClass()) {
                loader = value.getClass().getClassLoader();
            }
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            loader = value.getClass().getClassLoader();
        }
        if (loader == null) {
            loader = tccl;
        }
        thread.setContextClassLoader(loader);
        try {
            copy = (Serializable)SerializableUtils.deserializeFromByteArray(SerializableUtils.serializeToByteArray(value), value.toString());
        }
        finally {
            thread.setContextClassLoader(tccl);
        }
        return (T)copy;
    }

    public static /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> ensureSerializable(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> coder) {
        Coder<?> copy = SerializableUtils.ensureSerializable(coder);
        Preconditions.checkState((boolean)coder.equals(copy), (String)"Coder not equal to original after serialization, indicating that the Coder may not implement serialization correctly.  Before: %s, after: %s", coder, copy);
        return copy;
    }

    public static <T> T ensureSerializableByCoder(@UnknownKeyFor @NonNull @Initialized Coder<T> coder, T value, @UnknownKeyFor @NonNull @Initialized String errorContext) {
        byte[] encodedValue;
        try {
            encodedValue = CoderUtils.encodeToByteArray(coder, value);
        }
        catch (CoderException exn) {
            throw new IllegalArgumentException(errorContext + ": unable to encode value " + value + " using " + coder, exn);
        }
        try {
            return CoderUtils.decodeFromByteArray(coder, encodedValue);
        }
        catch (CoderException exn) {
            throw new IllegalArgumentException(errorContext + ": unable to decode " + Arrays.toString(encodedValue) + ", encoding of value " + value + ", using " + coder, exn);
        }
    }

    private static final class ContextualObjectInputStream
    extends ObjectInputStream {
        private ContextualObjectInputStream(@UnknownKeyFor @NonNull @Initialized InputStream in) throws @UnknownKeyFor @NonNull @Initialized IOException {
            super(in);
        }

        @Override
        protected /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> resolveClass(@UnknownKeyFor @NonNull @Initialized ObjectStreamClass classDesc) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized ClassNotFoundException {
            String n = classDesc.getName();
            ClassLoader classloader = ReflectHelpers.findClassLoader();
            try {
                return Class.forName(n, false, classloader);
            }
            catch (ClassNotFoundException e) {
                return super.resolveClass(classDesc);
            }
        }

        protected @UnknownKeyFor @NonNull @Initialized Class resolveProxyClass(@UnknownKeyFor @NonNull @Initialized String @UnknownKeyFor @NonNull @Initialized [] interfaces) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized ClassNotFoundException {
            ClassLoader classloader = ReflectHelpers.findClassLoader();
            Class[] cinterfaces = new Class[interfaces.length];
            for (int i = 0; i < interfaces.length; ++i) {
                cinterfaces[i] = classloader.loadClass(interfaces[i]);
            }
            try {
                return Proxy.getProxyClass(classloader, cinterfaces);
            }
            catch (IllegalArgumentException e) {
                throw new ClassNotFoundException(null, e);
            }
        }
    }
}

