/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.coders.CannotProvideCoderException;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.CoderRegistry;
import org.apache.beam.sdk.coders.CollectionCoder;
import org.apache.beam.sdk.coders.DequeCoder;
import org.apache.beam.sdk.coders.IterableCoder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.coders.ListCoder;
import org.apache.beam.sdk.coders.MapCoder;
import org.apache.beam.sdk.coders.SetCoder;
import org.apache.beam.sdk.coders.VoidCoder;
import org.apache.beam.sdk.io.BoundedSource;
import org.apache.beam.sdk.io.OffsetBasedSource;
import org.apache.beam.sdk.io.Read;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.schemas.NoSuchSchemaException;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.SchemaCoder;
import org.apache.beam.sdk.schemas.SchemaRegistry;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.FlatMapElements;
import org.apache.beam.sdk.transforms.Impulse;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.GlobalWindow;
import org.apache.beam.sdk.util.CoderUtils;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TimestampedValue;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Optional;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Iterables;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Instant;

public class Create<@UnknownKeyFor T> {
    public static <T> @UnknownKeyFor @NonNull @Initialized Values<T> of(@UnknownKeyFor @NonNull @Initialized Iterable<T> elems) {
        return new Values(elems, Optional.absent(), Optional.absent(), false);
    }

    @SafeVarargs
    public static <T> @UnknownKeyFor @NonNull @Initialized Values<T> of(@Nullable T elem, T ... elems) {
        ArrayList<T> input = new ArrayList<T>(elems.length + 1);
        input.add(elem);
        input.addAll(Arrays.asList(elems));
        return Create.of(input);
    }

    public static @UnknownKeyFor @NonNull @Initialized Values<@UnknownKeyFor @NonNull @Initialized Row> empty(@UnknownKeyFor @NonNull @Initialized Schema schema) {
        return new Values<Row>(new ArrayList(), Optional.of(SchemaCoder.of(schema)), Optional.absent(), false);
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized Values<T> empty(@UnknownKeyFor @NonNull @Initialized Coder<T> coder) {
        return new Values(new ArrayList(), Optional.of(coder), Optional.absent(), false);
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized Values<T> empty(@UnknownKeyFor @NonNull @Initialized TypeDescriptor<T> type) {
        return new Values(new ArrayList(), Optional.absent(), Optional.of(type), false);
    }

    public static <K, V> @UnknownKeyFor @NonNull @Initialized Values<@UnknownKeyFor @NonNull @Initialized KV<K, V>> of(@UnknownKeyFor @NonNull @Initialized Map<K, V> elems) {
        ArrayList<KV<K, V>> kvs = new ArrayList<KV<K, V>>(elems.size());
        for (Map.Entry<K, V> entry : elems.entrySet()) {
            kvs.add(KV.of(entry.getKey(), entry.getValue()));
        }
        return Create.of(kvs);
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized OfValueProvider<T> ofProvider(@UnknownKeyFor @NonNull @Initialized ValueProvider<T> provider, @UnknownKeyFor @NonNull @Initialized Coder<T> coder) {
        return new OfValueProvider(provider, coder);
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized TimestampedValues<T> timestamped(@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized TimestampedValue<T>> elems) {
        return new TimestampedValues(elems, Optional.absent(), Optional.absent());
    }

    @SafeVarargs
    public static <T> @UnknownKeyFor @NonNull @Initialized TimestampedValues<T> timestamped(@UnknownKeyFor @NonNull @Initialized TimestampedValue<T> elem, TimestampedValue<T> ... elems) {
        return Create.timestamped(ImmutableList.builder().add(elem).add((Object[])elems).build());
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized WindowedValues<T> windowedValues(@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized WindowedValue<T>> elems) {
        return new WindowedValues(elems, Optional.absent(), Optional.absent(), Optional.absent());
    }

    @SafeVarargs
    public static <T> @UnknownKeyFor @NonNull @Initialized WindowedValues<T> windowedValues(@UnknownKeyFor @NonNull @Initialized WindowedValue<T> elem, WindowedValue<T> ... elems) {
        return Create.windowedValues(ImmutableList.builder().add(elem).add((Object[])elems).build());
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized TimestampedValues<T> timestamped(@UnknownKeyFor @NonNull @Initialized Iterable<T> values, @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized Long> timestamps) {
        ArrayList<TimestampedValue<T>> elems = new ArrayList<TimestampedValue<T>>();
        Iterator<T> valueIter = values.iterator();
        Iterator<Long> timestampIter = timestamps.iterator();
        while (valueIter.hasNext() && timestampIter.hasNext()) {
            elems.add(TimestampedValue.of(valueIter.next(), new Instant((Object)timestampIter.next())));
        }
        Preconditions.checkArgument((!valueIter.hasNext() && !timestampIter.hasNext() ? 1 : 0) != 0, (Object)"Expect sizes of values and timestamps are same.");
        return Create.timestamped(elems);
    }

    private static <T> @UnknownKeyFor @NonNull @Initialized Coder<T> getDefaultCreateCoder(@UnknownKeyFor @NonNull @Initialized CoderRegistry coderRegistry, @UnknownKeyFor @NonNull @Initialized SchemaRegistry schemaRegistry, @UnknownKeyFor @NonNull @Initialized Iterable<T> elems) throws @UnknownKeyFor @NonNull @Initialized CannotProvideCoderException {
        Preconditions.checkArgument((!Iterables.isEmpty(elems) ? 1 : 0) != 0, (Object)"Can not determine a default Coder for a 'Create' PTransform that has no elements.  Either add elements, call Create.empty(Coder), Create.empty(TypeDescriptor), or call 'withCoder(Coder)' or 'withType(TypeDescriptor)' on the PTransform.");
        Class elementClazz = Void.class;
        for (T elem : elems) {
            if (elem == null) continue;
            Class<?> clazz = elem.getClass();
            if (elementClazz.equals(Void.class)) {
                elementClazz = clazz;
                continue;
            }
            if (elementClazz.equals(clazz)) continue;
            throw new CannotProvideCoderException(String.format("Cannot provide coder for %s: The elements are not all of the same class.", Create.class.getSimpleName()));
        }
        TypeDescriptor<Void> typeDescriptor = TypeDescriptor.of(elementClazz);
        if (elementClazz.getTypeParameters().length == 0) {
            try {
                SchemaCoder<Void> coder = SchemaCoder.of(schemaRegistry.getSchema(typeDescriptor), typeDescriptor, schemaRegistry.getToRowFunction(typeDescriptor), schemaRegistry.getFromRowFunction(typeDescriptor));
                return coder;
            }
            catch (NoSuchSchemaException coder) {
                try {
                    Coder<Void> coder2 = coderRegistry.getCoder(typeDescriptor);
                    return coder2;
                }
                catch (CannotProvideCoderException cannotProvideCoderException) {
                    // empty catch block
                }
            }
        }
        return Create.inferCoderFromObjects(coderRegistry, schemaRegistry, elems);
    }

    private static /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> inferCoderFromObjects(@UnknownKeyFor @NonNull @Initialized CoderRegistry coderRegistry, @UnknownKeyFor @NonNull @Initialized SchemaRegistry schemaRegistry, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @KeyForBottom @Nullable @Initialized @NonNull @Initialized ?> elems) throws @UnknownKeyFor @NonNull @Initialized CannotProvideCoderException {
        Optional coder = Optional.absent();
        for (Object elem : elems) {
            Coder<?> c = Create.inferCoderFromObject(coderRegistry, schemaRegistry, elem);
            if (!coder.isPresent()) {
                coder = Optional.of(c);
                continue;
            }
            if (Objects.equals(c, coder.get())) continue;
            throw new CannotProvideCoderException("Cannot provide coder for elements of " + Create.class.getSimpleName() + ": For their common class, no coder could be provided. Based on their values, they do not all default to the same Coder.");
        }
        if (coder.isPresent()) {
            return (Coder)coder.get();
        }
        throw new CannotProvideCoderException("Cannot provide coder for elements of " + Create.class.getSimpleName() + ": For their common class, no coder could be provided. Based on their values, no coder could be inferred.");
    }

    private static /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> inferCoderFromObject(@UnknownKeyFor @NonNull @Initialized CoderRegistry coderRegistry, @UnknownKeyFor @NonNull @Initialized SchemaRegistry schemaRegistry, @UnknownKeyFor @NonNull @Initialized Object o) throws @UnknownKeyFor @NonNull @Initialized CannotProvideCoderException {
        if (o == null) {
            return VoidCoder.of();
        }
        try {
            return SchemaCoder.of(schemaRegistry.getSchema(o.getClass()), TypeDescriptor.of(o.getClass()), schemaRegistry.getToRowFunction(o.getClass()), schemaRegistry.getFromRowFunction(o.getClass()));
        }
        catch (NoSuchSchemaException noSuchSchemaException) {
            if (o instanceof TimestampedValue) {
                return TimestampedValue.TimestampedValueCoder.of(Create.inferCoderFromObject(coderRegistry, schemaRegistry, ((TimestampedValue)o).getValue()));
            }
            if (o instanceof List) {
                return ListCoder.of(Create.inferCoderFromObjects(coderRegistry, schemaRegistry, (Iterable)o));
            }
            if (o instanceof Set) {
                return SetCoder.of(Create.inferCoderFromObjects(coderRegistry, schemaRegistry, (Iterable)o));
            }
            if (o instanceof Deque) {
                return DequeCoder.of(Create.inferCoderFromObjects(coderRegistry, schemaRegistry, (Iterable)o));
            }
            if (o instanceof Collection) {
                return CollectionCoder.of(Create.inferCoderFromObjects(coderRegistry, schemaRegistry, (Iterable)o));
            }
            if (o instanceof Iterable) {
                return IterableCoder.of(Create.inferCoderFromObjects(coderRegistry, schemaRegistry, (Iterable)o));
            }
            if (o instanceof Map) {
                return MapCoder.of(Create.inferCoderFromObjects(coderRegistry, schemaRegistry, ((Map)o).keySet()), Create.inferCoderFromObjects(coderRegistry, schemaRegistry, ((Map)o).entrySet()));
            }
            if (o instanceof KV) {
                return KvCoder.of(Create.inferCoderFromObject(coderRegistry, schemaRegistry, ((KV)o).getKey()), Create.inferCoderFromObject(coderRegistry, schemaRegistry, ((KV)o).getValue()));
            }
            return coderRegistry.getCoder(o.getClass());
        }
    }

    public static class WindowedValues<@UnknownKeyFor T>
    extends PTransform<PBegin, PCollection<T>> {
        private final transient @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized WindowedValue<T>> windowedValues;
        private final transient @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized Coder<T>> elementCoder;
        private final @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized BoundedWindow>> windowCoder;
        private final transient @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized TypeDescriptor<T>> typeDescriptor;

        public @UnknownKeyFor @NonNull @Initialized WindowedValues<T> withCoder(@UnknownKeyFor @NonNull @Initialized Coder<T> coder) {
            return new WindowedValues<T>(this.windowedValues, Optional.of(coder), this.windowCoder, this.typeDescriptor);
        }

        public @UnknownKeyFor @NonNull @Initialized WindowedValues<T> withWindowCoder(@UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized BoundedWindow> windowCoder) {
            return new WindowedValues<T>(this.windowedValues, this.elementCoder, (Optional<Coder<? extends BoundedWindow>>)Optional.of(windowCoder), this.typeDescriptor);
        }

        public @UnknownKeyFor @NonNull @Initialized WindowedValues<T> withSchema(@UnknownKeyFor @NonNull @Initialized Schema schema, @UnknownKeyFor @NonNull @Initialized TypeDescriptor<T> typeDescriptor, @UnknownKeyFor @NonNull @Initialized SerializableFunction<T, @UnknownKeyFor @NonNull @Initialized Row> toRowFunction, @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized Row, T> fromRowFunction) {
            return this.withCoder(SchemaCoder.of(schema, typeDescriptor, toRowFunction, fromRowFunction));
        }

        public @UnknownKeyFor @NonNull @Initialized WindowedValues<T> withType(@UnknownKeyFor @NonNull @Initialized TypeDescriptor<T> type) {
            return new WindowedValues<T>(this.windowedValues, this.elementCoder, this.windowCoder, Optional.of(type));
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollection<T> expand(@UnknownKeyFor @NonNull @Initialized PBegin input) {
            try {
                Coder windowCoder;
                Coder coder = null;
                CoderRegistry coderRegistry = input.getPipeline().getCoderRegistry();
                SchemaRegistry schemaRegistry = input.getPipeline().getSchemaRegistry();
                if (this.elementCoder.isPresent()) {
                    coder = (Coder)this.elementCoder.get();
                } else if (this.typeDescriptor.isPresent()) {
                    try {
                        coder = SchemaCoder.of(schemaRegistry.getSchema((TypeDescriptor)this.typeDescriptor.get()), (TypeDescriptor)this.typeDescriptor.get(), schemaRegistry.getToRowFunction((TypeDescriptor)this.typeDescriptor.get()), schemaRegistry.getFromRowFunction((TypeDescriptor)this.typeDescriptor.get()));
                    }
                    catch (NoSuchSchemaException noSuchSchemaException) {
                        // empty catch block
                    }
                    if (coder == null) {
                        coder = coderRegistry.getCoder((TypeDescriptor)this.typeDescriptor.get());
                    }
                } else {
                    Iterable rawElements = Iterables.transform(this.windowedValues, WindowedValue::getValue);
                    coder = Create.getDefaultCreateCoder(coderRegistry, schemaRegistry, rawElements);
                }
                if (this.windowCoder.isPresent()) {
                    windowCoder = (Coder)this.windowCoder.get();
                } else if (Iterables.isEmpty(this.windowedValues)) {
                    windowCoder = GlobalWindow.Coder.INSTANCE;
                } else {
                    Iterable rawWindows = Iterables.concat((Iterable)Iterables.transform(this.windowedValues, WindowedValue::getWindows));
                    windowCoder = Create.getDefaultCreateCoder(coderRegistry, schemaRegistry, rawWindows);
                }
                PCollection intermediate = (PCollection)Pipeline.applyTransform(input, Create.of(this.windowedValues).withCoder(WindowedValue.getFullCoder(coder, windowCoder)));
                PCollection output = (PCollection)intermediate.apply(ParDo.of(new ConvertWindowedValues()));
                output.setCoder(coder);
                return output;
            }
            catch (CannotProvideCoderException e) {
                throw new IllegalArgumentException("Unable to infer a coder and no Coder was specified. Please set a coder by invoking CreateTimestamped.withCoder() explicitly.", e);
            }
        }

        private WindowedValues(@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized WindowedValue<T>> windowedValues, @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized Coder<T>> elementCoder, @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized BoundedWindow>> windowCoder, @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized TypeDescriptor<T>> typeDescriptor) {
            this.windowedValues = windowedValues;
            this.elementCoder = elementCoder;
            this.windowCoder = windowCoder;
            this.typeDescriptor = typeDescriptor;
        }

        private static class ConvertWindowedValues<@UnknownKeyFor T>
        extends DoFn<WindowedValue<T>, T> {
            private ConvertWindowedValues() {
            }

            @DoFn.ProcessElement
            public void processElement(@DoFn.Element @UnknownKeyFor @NonNull @Initialized WindowedValue<T> element, @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<T> r) {
                r.outputWindowedValue(element.getValue(), element.getTimestamp(), element.getWindows(), element.getPane());
            }
        }
    }

    public static class TimestampedValues<@UnknownKeyFor T>
    extends PTransform<PBegin, PCollection<T>> {
        private final transient @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized TimestampedValue<T>> timestampedElements;
        private final transient @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized Coder<T>> elementCoder;
        private final transient @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized TypeDescriptor<T>> typeDescriptor;

        public @UnknownKeyFor @NonNull @Initialized TimestampedValues<T> withCoder(@UnknownKeyFor @NonNull @Initialized Coder<T> coder) {
            return new TimestampedValues<T>(this.timestampedElements, Optional.of(coder), this.typeDescriptor);
        }

        public @UnknownKeyFor @NonNull @Initialized TimestampedValues<T> withSchema(@UnknownKeyFor @NonNull @Initialized Schema schema, @UnknownKeyFor @NonNull @Initialized TypeDescriptor<T> typeDescriptor, @UnknownKeyFor @NonNull @Initialized SerializableFunction<T, @UnknownKeyFor @NonNull @Initialized Row> toRowFunction, @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized Row, T> fromRowFunction) {
            return this.withCoder(SchemaCoder.of(schema, typeDescriptor, toRowFunction, fromRowFunction));
        }

        public @UnknownKeyFor @NonNull @Initialized TimestampedValues<T> withType(@UnknownKeyFor @NonNull @Initialized TypeDescriptor<T> type) {
            return new TimestampedValues<T>(this.timestampedElements, this.elementCoder, Optional.of(type));
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollection<T> expand(@UnknownKeyFor @NonNull @Initialized PBegin input) {
            try {
                Coder coder = null;
                CoderRegistry coderRegistry = input.getPipeline().getCoderRegistry();
                SchemaRegistry schemaRegistry = input.getPipeline().getSchemaRegistry();
                if (this.elementCoder.isPresent()) {
                    coder = (Coder)this.elementCoder.get();
                } else if (this.typeDescriptor.isPresent()) {
                    try {
                        coder = SchemaCoder.of(schemaRegistry.getSchema((TypeDescriptor)this.typeDescriptor.get()), (TypeDescriptor)this.typeDescriptor.get(), schemaRegistry.getToRowFunction((TypeDescriptor)this.typeDescriptor.get()), schemaRegistry.getFromRowFunction((TypeDescriptor)this.typeDescriptor.get()));
                    }
                    catch (NoSuchSchemaException noSuchSchemaException) {
                        // empty catch block
                    }
                    if (coder == null) {
                        coder = coderRegistry.getCoder((TypeDescriptor)this.typeDescriptor.get());
                    }
                } else {
                    Iterable rawElements = Iterables.transform(this.timestampedElements, TimestampedValue::getValue);
                    coder = Create.getDefaultCreateCoder(coderRegistry, schemaRegistry, rawElements);
                }
                PCollection intermediate = (PCollection)Pipeline.applyTransform(input, Create.of(this.timestampedElements).withCoder(TimestampedValue.TimestampedValueCoder.of(coder)));
                PCollection output = (PCollection)intermediate.apply(ParDo.of(new ConvertTimestamps()));
                output.setCoder(coder);
                return output;
            }
            catch (CannotProvideCoderException e) {
                throw new IllegalArgumentException("Unable to infer a coder and no Coder was specified. Please set a coder by invoking CreateTimestamped.withCoder() explicitly.", e);
            }
        }

        private TimestampedValues(@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized TimestampedValue<T>> timestampedElements, @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized Coder<T>> elementCoder, @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized TypeDescriptor<T>> typeDescriptor) {
            this.timestampedElements = timestampedElements;
            this.elementCoder = elementCoder;
            this.typeDescriptor = typeDescriptor;
        }

        private static class ConvertTimestamps<@UnknownKeyFor T>
        extends DoFn<TimestampedValue<T>, T> {
            private ConvertTimestamps() {
            }

            @DoFn.ProcessElement
            public void processElement(@DoFn.Element @UnknownKeyFor @NonNull @Initialized TimestampedValue<T> element, @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<T> r) {
                r.outputWithTimestamp(element.getValue(), element.getTimestamp());
            }
        }
    }

    public static class OfValueProvider<@UnknownKeyFor T>
    extends PTransform<PBegin, PCollection<T>> {
        private final @UnknownKeyFor @NonNull @Initialized ValueProvider<T> provider;
        private final @UnknownKeyFor @NonNull @Initialized Coder<T> coder;

        private OfValueProvider(@UnknownKeyFor @NonNull @Initialized ValueProvider<T> provider, @UnknownKeyFor @NonNull @Initialized Coder<T> coder) {
            this.provider = (ValueProvider)Preconditions.checkNotNull(provider, (Object)"provider");
            this.coder = (Coder)Preconditions.checkNotNull(coder, (Object)"coder");
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollection<T> expand(@UnknownKeyFor @NonNull @Initialized PBegin input) {
            if (this.provider.isAccessible()) {
                Values<Object> values = Create.of(this.provider.get(), new Object[0]);
                return (PCollection)input.apply(values.withCoder(this.coder));
            }
            return ((PCollection)((PCollection)input.apply(Create.of(null, new Void[0]))).apply(MapElements.via(new SimpleFunction<Void, T>(){

                @Override
                public T apply(@UnknownKeyFor @Nullable @Initialized Void input) {
                    return provider.get();
                }
            }))).setCoder(this.coder);
        }
    }

    public static class Values<@UnknownKeyFor T>
    extends PTransform<PBegin, PCollection<T>> {
        private final transient @UnknownKeyFor @NonNull @Initialized Iterable<T> elems;
        private final transient @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized Coder<T>> coder;
        private final transient @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized TypeDescriptor<T>> typeDescriptor;
        private final transient @UnknownKeyFor @NonNull @Initialized boolean alwaysUseRead;

        public @UnknownKeyFor @NonNull @Initialized Values<T> withCoder(@UnknownKeyFor @NonNull @Initialized Coder<T> coder) {
            return new Values<T>(this.elems, Optional.of(coder), this.typeDescriptor, this.alwaysUseRead);
        }

        public @UnknownKeyFor @NonNull @Initialized Values<T> withSchema(@UnknownKeyFor @NonNull @Initialized Schema schema, @UnknownKeyFor @NonNull @Initialized TypeDescriptor<T> typeDescriptor, @UnknownKeyFor @NonNull @Initialized SerializableFunction<T, @UnknownKeyFor @NonNull @Initialized Row> toRowFunction, @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized Row, T> fromRowFunction) {
            return this.withCoder(SchemaCoder.of(schema, typeDescriptor, toRowFunction, fromRowFunction));
        }

        public @UnknownKeyFor @NonNull @Initialized Values<T> withRowSchema(@UnknownKeyFor @NonNull @Initialized Schema schema) {
            return this.withCoder(SchemaCoder.of(schema));
        }

        public @UnknownKeyFor @NonNull @Initialized Values<T> withType(@UnknownKeyFor @NonNull @Initialized TypeDescriptor<T> type) {
            return new Values<T>(this.elems, this.coder, Optional.of(type), this.alwaysUseRead);
        }

        public @UnknownKeyFor @NonNull @Initialized Values<T> alwaysUseRead() {
            return new AlwaysUseRead(this.elems, this.coder, this.typeDescriptor);
        }

        public @UnknownKeyFor @NonNull @Initialized Iterable<T> getElements() {
            return this.elems;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollection<T> expand(@UnknownKeyFor @NonNull @Initialized PBegin input) {
            Coder coder;
            block11: {
                try {
                    CoderRegistry coderRegistry = input.getPipeline().getCoderRegistry();
                    SchemaRegistry schemaRegistry = input.getPipeline().getSchemaRegistry();
                    Coder coder2 = coder = this.coder.isPresent() ? (Coder)this.coder.get() : null;
                    if (coder != null) break block11;
                    if (this.typeDescriptor.isPresent()) {
                        try {
                            coder = SchemaCoder.of(schemaRegistry.getSchema((TypeDescriptor)this.typeDescriptor.get()), (TypeDescriptor)this.typeDescriptor.get(), schemaRegistry.getToRowFunction((TypeDescriptor)this.typeDescriptor.get()), schemaRegistry.getFromRowFunction((TypeDescriptor)this.typeDescriptor.get()));
                        }
                        catch (NoSuchSchemaException noSuchSchemaException) {
                            // empty catch block
                        }
                        if (coder == null) {
                            coder = coderRegistry.getCoder((TypeDescriptor)this.typeDescriptor.get());
                        }
                        break block11;
                    }
                    coder = Create.getDefaultCreateCoder(coderRegistry, schemaRegistry, this.elems);
                }
                catch (CannotProvideCoderException e) {
                    throw new IllegalArgumentException("Unable to infer a coder and no Coder was specified. Please set a coder by invoking Create.withCoder() explicitly  or a schema by invoking Create.withSchema().", e);
                }
            }
            try {
                if (!this.alwaysUseRead) {
                    int numElements = Iterables.size(this.elems);
                    if (numElements == 0) {
                        return ((PCollection)input.apply(Impulse.create()).apply(FlatMapElements.via(new SimpleFunction<byte[], Iterable<T>>(){

                            @Override
                            public @UnknownKeyFor @NonNull @Initialized Iterable<T> apply(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] input) {
                                return Collections.emptyList();
                            }
                        }))).setCoder(coder);
                    }
                    if (numElements == 1) {
                        final byte[] encodedElement = CoderUtils.encodeToByteArray(coder, Iterables.getOnlyElement(this.elems));
                        final Coder capturedCoder = coder;
                        return ((PCollection)input.apply(Impulse.create()).apply(MapElements.via(new SimpleFunction<byte[], T>(){

                            @Override
                            public T apply(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] input) {
                                try {
                                    return CoderUtils.decodeFromByteArray(capturedCoder, encodedElement);
                                }
                                catch (CoderException exn) {
                                    throw new RuntimeException(exn);
                                }
                            }
                        }))).setCoder(coder);
                    }
                }
                CreateSource<T> source = CreateSource.fromIterable(this.elems, coder);
                return (PCollection)input.getPipeline().apply(Read.from(source));
            }
            catch (IOException e) {
                throw new RuntimeException(String.format("Unable to apply Create %s using Coder %s.", this, coder), e);
            }
        }

        private Values(@UnknownKeyFor @NonNull @Initialized Iterable<T> elems, @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized Coder<T>> coder, @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized TypeDescriptor<T>> typeDescriptor, @UnknownKeyFor @NonNull @Initialized boolean alwaysUseRead) {
            this.elems = elems;
            this.coder = coder;
            this.typeDescriptor = typeDescriptor;
            this.alwaysUseRead = alwaysUseRead;
        }

        private static class AlwaysUseRead<@UnknownKeyFor T>
        extends Values<T> {
            private AlwaysUseRead(@UnknownKeyFor @NonNull @Initialized Iterable<T> elems, @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized Coder<T>> coder, @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized TypeDescriptor<T>> typeDescriptor) {
                super(elems, coder, typeDescriptor, true);
            }
        }

        private static class BytesReader<@UnknownKeyFor T>
        extends OffsetBasedSource.OffsetBasedReader<T> {
            private @UnknownKeyFor @NonNull @Initialized int index = -1;
            private @Nullable @UnknownKeyFor @Initialized Optional<T> next;

            public BytesReader(@UnknownKeyFor @NonNull @Initialized CreateSource<T> source) {
                super(source);
            }

            @Override
            public @Nullable T getCurrent() throws @UnknownKeyFor @NonNull @Initialized NoSuchElementException {
                if (this.next == null) {
                    throw new NoSuchElementException();
                }
                return (T)this.next.orNull();
            }

            @Override
            public void close() throws @UnknownKeyFor @NonNull @Initialized IOException {
            }

            @Override
            protected @UnknownKeyFor @NonNull @Initialized long getCurrentOffset() {
                return this.index;
            }

            @Override
            protected @UnknownKeyFor @NonNull @Initialized boolean startImpl() throws @UnknownKeyFor @NonNull @Initialized IOException {
                return this.advanceImpl();
            }

            @Override
            public synchronized @UnknownKeyFor @NonNull @Initialized CreateSource<T> getCurrentSource() {
                return (CreateSource)super.getCurrentSource();
            }

            @Override
            protected @UnknownKeyFor @NonNull @Initialized boolean advanceImpl() throws @UnknownKeyFor @NonNull @Initialized IOException {
                OffsetBasedSource source = this.getCurrentSource();
                if (this.index + 1 >= ((CreateSource)source).allElementsBytes.size()) {
                    this.next = null;
                    return false;
                }
                ++this.index;
                this.next = Optional.fromNullable(CoderUtils.decodeFromByteArray(((CreateSource)source).coder, (byte[])((CreateSource)source).allElementsBytes.get(this.index)));
                return true;
            }
        }

        @VisibleForTesting
        static class CreateSource<@UnknownKeyFor T>
        extends OffsetBasedSource<T> {
            private final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []> allElementsBytes;
            private final @UnknownKeyFor @NonNull @Initialized long totalSize;
            private final @UnknownKeyFor @NonNull @Initialized Coder<T> coder;

            public static <T> @UnknownKeyFor @NonNull @Initialized CreateSource<T> fromIterable(@UnknownKeyFor @NonNull @Initialized Iterable<T> elements, @UnknownKeyFor @NonNull @Initialized Coder<T> elemCoder) throws @UnknownKeyFor @NonNull @Initialized CoderException, @UnknownKeyFor @NonNull @Initialized IOException {
                ImmutableList.Builder allElementsBytes = ImmutableList.builder();
                long totalSize = 0L;
                for (T element : elements) {
                    byte[] bytes = CoderUtils.encodeToByteArray(elemCoder, element);
                    allElementsBytes.add((Object)bytes);
                    totalSize += (long)bytes.length;
                }
                return new CreateSource<T>((List<byte[]>)allElementsBytes.build(), totalSize, elemCoder);
            }

            private CreateSource(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []> elementBytes, @UnknownKeyFor @NonNull @Initialized long totalSize, @UnknownKeyFor @NonNull @Initialized Coder<T> coder) {
                super(0L, elementBytes.size(), 1L);
                this.allElementsBytes = ImmutableList.copyOf(elementBytes);
                this.totalSize = totalSize;
                this.coder = coder;
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized long getEstimatedSizeBytes(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) throws @UnknownKeyFor @NonNull @Initialized Exception {
                return this.totalSize;
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized BoundedSource.BoundedReader<T> createReader(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) throws @UnknownKeyFor @NonNull @Initialized IOException {
                return new BytesReader(this);
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized Coder<T> getOutputCoder() {
                return this.coder;
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized long getMaxEndOffset(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) throws @UnknownKeyFor @NonNull @Initialized Exception {
                return this.allElementsBytes.size();
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized OffsetBasedSource<T> createSourceForSubrange(@UnknownKeyFor @NonNull @Initialized long start, @UnknownKeyFor @NonNull @Initialized long end) {
                List<byte[]> primaryElems = this.allElementsBytes.subList((int)start, (int)end);
                long primarySizeEstimate = (long)((double)(this.totalSize * (long)primaryElems.size()) / (double)this.allElementsBytes.size());
                return new CreateSource<T>(primaryElems, primarySizeEstimate, this.coder);
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized long getBytesPerOffset() {
                if (this.allElementsBytes.isEmpty()) {
                    return 1L;
                }
                return Math.max(1L, this.totalSize / (long)this.allElementsBytes.size());
            }
        }
    }
}

