/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.core.metrics;

import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.beam.runners.core.metrics.DirtyState;
import org.apache.beam.runners.core.metrics.MetricCell;
import org.apache.beam.runners.core.metrics.StringSetData;
import org.apache.beam.sdk.metrics.MetricName;
import org.apache.beam.sdk.metrics.StringSet;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableSet;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;

public class StringSetCell
implements StringSet,
MetricCell<StringSetData> {
    private final @UnknownKeyFor @NonNull @Initialized DirtyState dirty = new DirtyState();
    private final @UnknownKeyFor @NonNull @Initialized AtomicReference<@UnknownKeyFor @NonNull @Initialized StringSetData> setValue = new AtomicReference<StringSetData>(StringSetData.empty());
    private final @UnknownKeyFor @NonNull @Initialized MetricName name;

    public StringSetCell(@UnknownKeyFor @NonNull @Initialized MetricName name) {
        this.name = name;
    }

    @Override
    public void reset() {
        this.setValue.set(StringSetData.empty());
        this.dirty.reset();
    }

    void update(@UnknownKeyFor @NonNull @Initialized StringSetData data) {
        StringSetData original;
        while (!this.setValue.compareAndSet(original = this.setValue.get(), original.combine(data))) {
        }
        this.dirty.afterModification();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized DirtyState getDirty() {
        return this.dirty;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized StringSetData getCumulative() {
        return this.setValue.get();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized MetricName getName() {
        return this.name;
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object object) {
        if (object instanceof StringSetCell) {
            StringSetCell stringSetCell = (StringSetCell)object;
            return Objects.equals(this.dirty, stringSetCell.dirty) && Objects.equals(this.setValue.get(), stringSetCell.setValue.get()) && Objects.equals(this.name, stringSetCell.name);
        }
        return false;
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        return Objects.hash(this.dirty, this.setValue.get(), this.name);
    }

    @Override
    public void add(@UnknownKeyFor @NonNull @Initialized String value) {
        if (this.setValue.get().stringSet().contains(value)) {
            return;
        }
        this.update(StringSetData.create((Set<String>)ImmutableSet.of((Object)value)));
    }

    @Override
    public void add(String ... values) {
        this.update(StringSetData.create((Set<String>)ImmutableSet.copyOf((Object[])values)));
    }
}

