/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.actions.xml.xmlwellformed;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.commons.vfs2.AllFileSelector;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSelectInfo;
import org.apache.commons.vfs2.FileSelector;
import org.apache.commons.vfs2.FileType;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.Result;
import org.apache.hop.core.ResultFile;
import org.apache.hop.core.RowMetaAndData;
import org.apache.hop.core.annotations.Action;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.core.xml.XmlCheck;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.ActionBase;
import org.apache.hop.workflow.action.IAction;
import org.apache.hop.workflow.action.validator.AbstractFileValidator;
import org.apache.hop.workflow.action.validator.ActionValidatorUtils;
import org.apache.hop.workflow.action.validator.AndValidator;
import org.apache.hop.workflow.action.validator.IActionValidator;
import org.apache.hop.workflow.action.validator.ValidatorContext;
import org.apache.hop.workflow.actions.xml.xmlwellformed.XmlWellFormedField;
import org.apache.hop.workflow.engine.IWorkflowEngine;
import org.xml.sax.helpers.DefaultHandler;

@Action(id="XML_WELL_FORMED", name="i18n::XML_WELL_FORMED.Name", description="i18n::XML_WELL_FORMED.Description", image="XFC.svg", categoryDescription="i18n::XML_WELL_FORMED.Category", keywords={"i18n::XmlWellFormed.keyword"}, documentationUrl="/workflow/actions/xmlwellformed.html")
public class XmlWellFormed
extends ActionBase
implements Cloneable,
IAction {
    private static final Class<?> PKG = XmlWellFormed.class;
    public static final String SUCCESS_IF_AT_LEAST_X_FILES_WELL_FORMED = "success_when_at_least";
    public static final String SUCCESS_IF_BAD_FORMED_FILES_LESS = "success_if_bad_formed_files_less";
    public static final String SUCCESS_IF_NO_ERRORS = "success_if_no_errors";
    public static final String ADD_ALL_FILENAMES = "all_filenames";
    public static final String ADD_WELL_FORMED_FILES_ONLY = "only_well_formed_filenames";
    public static final String ADD_BAD_FORMED_FILES_ONLY = "only_bad_formed_filenames";
    public static final String CONST_ACTION_XMLWELL_FORMED_ERROR_SUCCESS_CONDITIONBROKEN = "ActionXMLWellFormed.Error.SuccessConditionbroken";
    public static final String CONST_SPACES = "      ";
    public static final String CONST_FIELDS = "fields";
    public static final String CONST_FIELD = "field";
    @Deprecated(since="2.0")
    @HopMetadataProperty(key="arg_from_previous")
    public boolean argFromPrevious = false;
    @Deprecated(since="2.0")
    @HopMetadataProperty(key="include_subfolders")
    public boolean includeSubfolders = false;
    @Deprecated(since="2.0")
    @HopMetadataProperty(key="field", groupKey="fields")
    private List<XmlWellFormedField> sourceFileFolders = new ArrayList<XmlWellFormedField>();
    @Deprecated(since="2.0")
    public String[] wildcard = null;
    @HopMetadataProperty(key="nr_errors_less_than")
    private String nrErrorsLessThan = "10";
    @HopMetadataProperty(key="success_condition")
    private String successCondition = "success_if_no_errors";
    @HopMetadataProperty(key="resultfilenames")
    private String resultFilenames = "all_filenames";
    int nrAllErrors = 0;
    int nrBadFormed = 0;
    int nrWellFormed = 0;
    int limitFiles = 0;
    int nrErrors = 0;
    boolean successConditionBroken = false;
    boolean successConditionBrokenExit = false;

    public XmlWellFormed(String n) {
        super(n, "");
    }

    public XmlWellFormed() {
        this("");
    }

    public Object clone() {
        XmlWellFormed je = (XmlWellFormed)super.clone();
        return je;
    }

    public Result execute(Result previousResult, int nr) throws HopException {
        Result result = previousResult;
        result.setNrErrors(1L);
        result.setResult(false);
        List rows = result.getRows();
        RowMetaAndData resultRow = null;
        this.nrErrors = 0;
        this.nrWellFormed = 0;
        this.nrBadFormed = 0;
        this.limitFiles = Const.toInt((String)this.resolve(this.getNrErrorsLessThan()), (int)10);
        this.successConditionBroken = false;
        this.successConditionBrokenExit = false;
        List<XmlWellFormedField> vSourceFileFolder = this.sourceFileFolders;
        if (this.argFromPrevious && this.isDetailed()) {
            this.logDetailed(BaseMessages.getString(PKG, (String)"ActionXMLWellFormed.Log.ArgFromPrevious.Found", (String[])new String[]{"" + (rows != null ? rows.size() : 0)}));
        }
        if (this.argFromPrevious && rows != null) {
            for (int iteration = 0; iteration < rows.size() && !this.parentWorkflow.isStopped(); ++iteration) {
                if (this.successConditionBroken) {
                    if (!this.successConditionBrokenExit) {
                        this.logError(BaseMessages.getString(PKG, (String)CONST_ACTION_XMLWELL_FORMED_ERROR_SUCCESS_CONDITIONBROKEN, (String[])new String[]{"" + this.nrAllErrors}));
                        this.successConditionBrokenExit = true;
                    }
                    result.setEntryNr((long)this.nrAllErrors);
                    result.setNrLinesRejected((long)this.nrBadFormed);
                    result.setNrLinesWritten((long)this.nrWellFormed);
                    return result;
                }
                resultRow = (RowMetaAndData)rows.get(iteration);
                String vSourceFileFolderPrevious = resultRow.getString(0, null);
                String vWildcardPrevious = resultRow.getString(1, null);
                if (this.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"ActionXMLWellFormed.Log.ProcessingRow", (String[])new String[]{vSourceFileFolderPrevious, vWildcardPrevious}));
                }
                this.processFileFolder(vSourceFileFolderPrevious, vWildcardPrevious, this.parentWorkflow, result);
            }
        } else if (vSourceFileFolder != null) {
            for (int i = 0; i < vSourceFileFolder.size() && !this.parentWorkflow.isStopped(); ++i) {
                if (this.successConditionBroken) {
                    if (!this.successConditionBrokenExit) {
                        this.logError(BaseMessages.getString(PKG, (String)CONST_ACTION_XMLWELL_FORMED_ERROR_SUCCESS_CONDITIONBROKEN, (String[])new String[]{"" + this.nrAllErrors}));
                        this.successConditionBrokenExit = true;
                    }
                    result.setEntryNr((long)this.nrAllErrors);
                    result.setNrLinesRejected((long)this.nrBadFormed);
                    result.setNrLinesWritten((long)this.nrWellFormed);
                    return result;
                }
                if (this.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"ActionXMLWellFormed.Log.ProcessingRow", (Object[])new Object[]{vSourceFileFolder.get(i), vSourceFileFolder.get(i).getWildcard()}));
                }
                this.processFileFolder(vSourceFileFolder.get(i).getSourceFilefolder(), vSourceFileFolder.get(i).getWildcard(), this.parentWorkflow, result);
            }
        }
        result.setNrErrors((long)this.nrAllErrors);
        result.setNrLinesRejected((long)this.nrBadFormed);
        result.setNrLinesWritten((long)this.nrWellFormed);
        if (this.getSuccessStatus()) {
            result.setNrErrors(0L);
            result.setResult(true);
        }
        this.displayResults();
        return result;
    }

    private void displayResults() {
        if (this.isDetailed()) {
            this.logDetailed("=======================================");
            this.logDetailed(BaseMessages.getString(PKG, (String)"ActionXMLWellFormed.Log.Info.FilesInError", (String[])new String[]{"" + this.nrErrors}));
            this.logDetailed(BaseMessages.getString(PKG, (String)"ActionXMLWellFormed.Log.Info.FilesInBadFormed", (String[])new String[]{"" + this.nrBadFormed}));
            this.logDetailed(BaseMessages.getString(PKG, (String)"ActionXMLWellFormed.Log.Info.FilesInWellFormed", (String[])new String[]{"" + this.nrWellFormed}));
            this.logDetailed("=======================================");
        }
    }

    private boolean checkIfSuccessConditionBroken() {
        boolean retval = false;
        if (this.nrAllErrors > 0 && this.getSuccessCondition().equals(SUCCESS_IF_NO_ERRORS) || this.nrBadFormed >= this.limitFiles && this.getSuccessCondition().equals(SUCCESS_IF_BAD_FORMED_FILES_LESS)) {
            retval = true;
        }
        return retval;
    }

    private boolean getSuccessStatus() {
        boolean retval = false;
        if (this.nrAllErrors == 0 && this.getSuccessCondition().equals(SUCCESS_IF_NO_ERRORS) || this.nrWellFormed >= this.limitFiles && this.getSuccessCondition().equals(SUCCESS_IF_AT_LEAST_X_FILES_WELL_FORMED) || this.nrBadFormed < this.limitFiles && this.getSuccessCondition().equals(SUCCESS_IF_BAD_FORMED_FILES_LESS)) {
            retval = true;
        }
        return retval;
    }

    private void updateErrors() {
        ++this.nrErrors;
        this.updateAllErrors();
        if (this.checkIfSuccessConditionBroken()) {
            this.successConditionBroken = true;
        }
    }

    private void updateAllErrors() {
        this.nrAllErrors = this.nrErrors + this.nrBadFormed;
    }

    private boolean CheckFile(FileObject file) {
        boolean retval = false;
        try {
            retval = XmlCheck.isXmlFileWellFormed((FileObject)file);
        }
        catch (Exception e) {
            this.logError(BaseMessages.getString(PKG, (String)"ActionXMLWellFormed.Log.ErrorCheckingFile", (String[])new String[]{file.toString(), e.getMessage()}));
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processFileFolder(String sourcefilefoldername, String wildcard, IWorkflowEngine parentWorkflow, Result result) {
        boolean entrystatus;
        block37: {
            entrystatus = false;
            FileObject sourcefilefolder = null;
            FileObject currentFile = null;
            String realSourceFilefoldername = this.resolve(sourcefilefoldername);
            if (Utils.isEmpty((CharSequence)realSourceFilefoldername)) {
                this.logError(BaseMessages.getString(PKG, (String)"ActionXMLWellFormed.log.FileFolderEmpty", (String[])new String[]{sourcefilefoldername}));
                this.updateErrors();
                return entrystatus;
            }
            String realWildcard = this.resolve(wildcard);
            try {
                sourcefilefolder = HopVfs.getFileObject((String)realSourceFilefoldername);
                if (sourcefilefolder.exists()) {
                    if (this.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"ActionXMLWellFormed.Log.FileExists", (String[])new String[]{sourcefilefolder.toString()}));
                    }
                    if (sourcefilefolder.getType() == FileType.FILE) {
                        entrystatus = this.checkOneFile(sourcefilefolder, result, parentWorkflow);
                        break block37;
                    }
                    if (sourcefilefolder.getType() == FileType.FOLDER) {
                        FileObject[] fileObjects = sourcefilefolder.findFiles((FileSelector)new AllFileSelector(){

                            public boolean traverseDescendents(FileSelectInfo info) {
                                return true;
                            }

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public boolean includeFile(FileSelectInfo info) {
                                block18: {
                                    boolean bl;
                                    FileObject fileObject = info.getFile();
                                    try {
                                        if (fileObject == null) {
                                            boolean bl2 = false;
                                            return bl2;
                                        }
                                        if (fileObject.getType() == FileType.FILE) break block18;
                                        bl = false;
                                    }
                                    catch (Exception ex) {
                                        boolean bl3 = false;
                                        return bl3;
                                    }
                                    finally {
                                        if (fileObject != null) {
                                            try {
                                                fileObject.close();
                                            }
                                            catch (IOException iOException) {}
                                        }
                                    }
                                    return bl;
                                }
                                return true;
                            }
                        });
                        if (fileObjects == null) break block37;
                        int j = 0;
                        while (true) {
                            if (j < fileObjects.length && !parentWorkflow.isStopped()) {
                                if (this.successConditionBroken) {
                                    if (!this.successConditionBrokenExit) {
                                        this.logError(BaseMessages.getString(PKG, (String)CONST_ACTION_XMLWELL_FORMED_ERROR_SUCCESS_CONDITIONBROKEN, (String[])new String[]{"" + this.nrAllErrors}));
                                        this.successConditionBrokenExit = true;
                                    }
                                    boolean bl = false;
                                    return bl;
                                }
                                currentFile = fileObjects[j];
                                if (!currentFile.getParent().toString().equals(sourcefilefolder.toString())) {
                                    if (this.includeSubfolders && this.GetFileWildcard(currentFile.toString(), realWildcard)) {
                                        this.checkOneFile(currentFile, result, parentWorkflow);
                                    }
                                } else if (this.GetFileWildcard(currentFile.toString(), realWildcard)) {
                                    this.checkOneFile(currentFile, result, parentWorkflow);
                                }
                                ++j;
                                continue;
                            }
                            break block37;
                            break;
                        }
                    }
                    this.logError(BaseMessages.getString(PKG, (String)"ActionXMLWellFormed.Error.UnknowFileFormat", (String[])new String[]{sourcefilefolder.toString()}));
                    this.updateErrors();
                    break block37;
                }
                this.logError(BaseMessages.getString(PKG, (String)"ActionXMLWellFormed.Error.SourceFileNotExists", (String[])new String[]{realSourceFilefoldername}));
                this.updateErrors();
            }
            catch (Exception e) {
                this.logError(BaseMessages.getString(PKG, (String)"ActionXMLWellFormed.Error.Exception.Processing", (Object[])new Object[]{realSourceFilefoldername, e}));
                this.updateErrors();
            }
            finally {
                if (sourcefilefolder != null) {
                    try {
                        sourcefilefolder.close();
                    }
                    catch (IOException iOException) {}
                }
                if (currentFile != null) {
                    try {
                        currentFile.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return entrystatus;
    }

    private boolean checkOneFile(FileObject file, Result result, IWorkflowEngine parentWorkflow) throws HopException {
        boolean retval = false;
        try {
            boolean retformed = this.CheckFile(file);
            if (!retformed) {
                this.logError(BaseMessages.getString(PKG, (String)"ActionXMLWellFormed.Error.FileBadFormed", (String[])new String[]{file.toString()}));
                this.updateBadFormed();
                if (this.resultFilenames.equals(ADD_ALL_FILENAMES) || this.resultFilenames.equals(ADD_BAD_FORMED_FILES_ONLY)) {
                    this.addFileToResultFilenames(HopVfs.getFilename((FileObject)file), result, parentWorkflow);
                }
            } else {
                if (this.isDetailed()) {
                    this.logDetailed("---------------------------");
                    this.logDetailed(BaseMessages.getString(PKG, (String)"ActionXMLWellFormed.Error.FileWellFormed", (String[])new String[]{file.toString()}));
                }
                this.updateWellFormed();
                if (this.resultFilenames.equals(ADD_ALL_FILENAMES) || this.resultFilenames.equals(ADD_WELL_FORMED_FILES_ONLY)) {
                    this.addFileToResultFilenames(HopVfs.getFilename((FileObject)file), result, parentWorkflow);
                }
            }
        }
        catch (Exception e) {
            throw new HopException("Unable to verify file '" + file + "'", (Throwable)e);
        }
        return retval;
    }

    private void updateWellFormed() {
        ++this.nrWellFormed;
    }

    private void updateBadFormed() {
        ++this.nrBadFormed;
        this.updateAllErrors();
    }

    private void addFileToResultFilenames(String fileaddentry, Result result, IWorkflowEngine parentWorkflow) {
        try {
            ResultFile resultFile = new ResultFile(0, HopVfs.getFileObject((String)fileaddentry), parentWorkflow.getWorkflowName(), this.toString());
            result.getResultFiles().put(resultFile.getFile().toString(), resultFile);
            if (this.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"ActionXMLWellFormed.Log.FileAddedToResultFilesName", (String[])new String[]{fileaddentry}));
            }
        }
        catch (Exception e) {
            this.logError(BaseMessages.getString(PKG, (String)"ActionXMLWellFormed.Error.AddingToFilenameResult", (String[])new String[]{fileaddentry, e.getMessage()}));
        }
    }

    private boolean GetFileWildcard(String selectedfile, String wildcard) {
        Pattern pattern = null;
        boolean getIt = true;
        if (!Utils.isEmpty((CharSequence)wildcard) && (pattern = Pattern.compile(wildcard)) != null) {
            Matcher matcher = pattern.matcher(selectedfile);
            getIt = matcher.matches();
        }
        return getIt;
    }

    public boolean isEvaluation() {
        return true;
    }

    public void check(List<ICheckResult> remarks, WorkflowMeta jobMeta, IVariables variables, IHopMetadataProvider metadataProvider) {
        boolean res = ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, "arguments", remarks, AndValidator.putValidators((IActionValidator[])new IActionValidator[]{ActionValidatorUtils.notNullValidator()}));
        if (!res) {
            return;
        }
        ValidatorContext ctx = new ValidatorContext();
        AbstractFileValidator.putVariableSpace((ValidatorContext)ctx, (IVariables)this.getVariables());
        AndValidator.putValidators((ValidatorContext)ctx, (IActionValidator[])new IActionValidator[]{ActionValidatorUtils.notNullValidator(), ActionValidatorUtils.fileExistsValidator()});
        for (int i = 0; i < this.sourceFileFolders.size(); ++i) {
            ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, "arguments[" + i + "]", remarks, ctx);
        }
    }

    @Deprecated
    @Generated
    public boolean isArgFromPrevious() {
        return this.argFromPrevious;
    }

    @Deprecated
    @Generated
    public boolean isIncludeSubfolders() {
        return this.includeSubfolders;
    }

    @Deprecated
    @Generated
    public List<XmlWellFormedField> getSourceFileFolders() {
        return this.sourceFileFolders;
    }

    @Deprecated
    @Generated
    public String[] getWildcard() {
        return this.wildcard;
    }

    @Generated
    public String getNrErrorsLessThan() {
        return this.nrErrorsLessThan;
    }

    @Generated
    public String getSuccessCondition() {
        return this.successCondition;
    }

    @Generated
    public String getResultFilenames() {
        return this.resultFilenames;
    }

    @Generated
    public int getNrAllErrors() {
        return this.nrAllErrors;
    }

    @Generated
    public int getNrBadFormed() {
        return this.nrBadFormed;
    }

    @Generated
    public int getNrWellFormed() {
        return this.nrWellFormed;
    }

    @Generated
    public int getLimitFiles() {
        return this.limitFiles;
    }

    @Generated
    public int getNrErrors() {
        return this.nrErrors;
    }

    @Generated
    public boolean isSuccessConditionBroken() {
        return this.successConditionBroken;
    }

    @Generated
    public boolean isSuccessConditionBrokenExit() {
        return this.successConditionBrokenExit;
    }

    @Deprecated
    @Generated
    public void setArgFromPrevious(boolean argFromPrevious) {
        this.argFromPrevious = argFromPrevious;
    }

    @Deprecated
    @Generated
    public void setIncludeSubfolders(boolean includeSubfolders) {
        this.includeSubfolders = includeSubfolders;
    }

    @Deprecated
    @Generated
    public void setSourceFileFolders(List<XmlWellFormedField> sourceFileFolders) {
        this.sourceFileFolders = sourceFileFolders;
    }

    @Deprecated
    @Generated
    public void setWildcard(String[] wildcard) {
        this.wildcard = wildcard;
    }

    @Generated
    public void setNrErrorsLessThan(String nrErrorsLessThan) {
        this.nrErrorsLessThan = nrErrorsLessThan;
    }

    @Generated
    public void setSuccessCondition(String successCondition) {
        this.successCondition = successCondition;
    }

    @Generated
    public void setResultFilenames(String resultFilenames) {
        this.resultFilenames = resultFilenames;
    }

    @Generated
    public void setNrAllErrors(int nrAllErrors) {
        this.nrAllErrors = nrAllErrors;
    }

    @Generated
    public void setNrBadFormed(int nrBadFormed) {
        this.nrBadFormed = nrBadFormed;
    }

    @Generated
    public void setNrWellFormed(int nrWellFormed) {
        this.nrWellFormed = nrWellFormed;
    }

    @Generated
    public void setLimitFiles(int limitFiles) {
        this.limitFiles = limitFiles;
    }

    @Generated
    public void setNrErrors(int nrErrors) {
        this.nrErrors = nrErrors;
    }

    @Generated
    public void setSuccessConditionBroken(boolean successConditionBroken) {
        this.successConditionBroken = successConditionBroken;
    }

    @Generated
    public void setSuccessConditionBrokenExit(boolean successConditionBrokenExit) {
        this.successConditionBrokenExit = successConditionBrokenExit;
    }

    public static class XMLTreeHandler
    extends DefaultHandler {
    }
}

