/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.lib;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.lib.DelegatingInputFormat;
import org.apache.hadoop.mapred.lib.DelegatingMapper;
import org.apache.hadoop.util.ReflectionUtils;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class MultipleInputs {
    public static void addInputPath(JobConf conf, Path path, Class<? extends InputFormat> inputFormatClass) {
        String inputFormatMapping = path.toString() + ";" + inputFormatClass.getName();
        String inputFormats = conf.get("mapreduce.input.multipleinputs.dir.formats");
        conf.set("mapreduce.input.multipleinputs.dir.formats", inputFormats == null ? inputFormatMapping : inputFormats + "," + inputFormatMapping);
        conf.setInputFormat(DelegatingInputFormat.class);
    }

    public static void addInputPath(JobConf conf, Path path, Class<? extends InputFormat> inputFormatClass, Class<? extends Mapper> mapperClass) {
        MultipleInputs.addInputPath(conf, path, inputFormatClass);
        String mapperMapping = path.toString() + ";" + mapperClass.getName();
        String mappers = conf.get("mapreduce.input.multipleinputs.dir.mappers");
        conf.set("mapreduce.input.multipleinputs.dir.mappers", mappers == null ? mapperMapping : mappers + "," + mapperMapping);
        conf.setMapperClass(DelegatingMapper.class);
    }

    static Map<Path, InputFormat> getInputFormatMap(JobConf conf) {
        String[] pathMappings;
        HashMap<Path, InputFormat> m = new HashMap<Path, InputFormat>();
        for (String pathMapping : pathMappings = conf.get("mapreduce.input.multipleinputs.dir.formats").split(",")) {
            InputFormat inputFormat;
            String[] split = pathMapping.split(";");
            try {
                inputFormat = (InputFormat)ReflectionUtils.newInstance((Class)conf.getClassByName(split[1]), (Configuration)conf);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            m.put(new Path(split[0]), inputFormat);
        }
        return m;
    }

    static Map<Path, Class<? extends Mapper>> getMapperTypeMap(JobConf conf) {
        String[] pathMappings;
        if (conf.get("mapreduce.input.multipleinputs.dir.mappers") == null) {
            return Collections.emptyMap();
        }
        HashMap<Path, Class<? extends Mapper>> m = new HashMap<Path, Class<? extends Mapper>>();
        for (String pathMapping : pathMappings = conf.get("mapreduce.input.multipleinputs.dir.mappers").split(",")) {
            Class mapClass;
            String[] split = pathMapping.split(";");
            try {
                mapClass = conf.getClassByName(split[1]);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            m.put(new Path(split[0]), mapClass);
        }
        return m;
    }
}

