/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.actions.deletefolders;

import java.io.IOException;
import java.util.List;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSelectInfo;
import org.apache.commons.vfs2.FileSelector;
import org.apache.commons.vfs2.FileType;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.Result;
import org.apache.hop.core.RowMetaAndData;
import org.apache.hop.core.annotations.Action;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.resource.IResourceHolder;
import org.apache.hop.resource.ResourceEntry;
import org.apache.hop.resource.ResourceReference;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.ActionBase;
import org.apache.hop.workflow.action.IAction;
import org.apache.hop.workflow.action.validator.AbstractFileValidator;
import org.apache.hop.workflow.action.validator.ActionValidatorUtils;
import org.apache.hop.workflow.action.validator.AndValidator;
import org.apache.hop.workflow.action.validator.IActionValidator;
import org.apache.hop.workflow.action.validator.ValidatorContext;
import org.w3c.dom.Node;

@Action(id="DELETE_FOLDERS", name="i18n::ActionDeleteFolders.Name", description="i18n::ActionDeleteFolders.Description", image="DeleteFolders.svg", categoryDescription="i18n:org.apache.hop.workflow:ActionCategory.Category.FileManagement", keywords={"i18n::ActionDeleteFolders.keyword"}, documentationUrl="/workflow/actions/deletefolders.html")
public class ActionDeleteFolders
extends ActionBase
implements Cloneable,
IAction {
    private static final Class<?> PKG = ActionDeleteFolders.class;
    private static final String CONST_SPACE_SHORT = "      ";
    public boolean argFromPrevious = false;
    public String[] arguments = null;
    private String successCondition = "success_if_no_errors";
    public static final String SUCCESS_IF_AT_LEAST_X_FOLDERS_DELETED = "success_when_at_least";
    public static final String SUCCESS_IF_ERRORS_LESS = "success_if_errors_less";
    public static final String SUCCESS_IF_NO_ERRORS = "success_if_no_errors";
    private String limitFolders = "10";
    int nrErrors = 0;
    int nrSuccess = 0;
    boolean successConditionBroken = false;
    boolean successConditionBrokenExit = false;
    int nrLimitFolders = 0;

    public ActionDeleteFolders(String name) {
        super(name, "");
    }

    public ActionDeleteFolders() {
        this("");
    }

    public void allocate(int nrFields) {
        this.arguments = new String[nrFields];
    }

    public Object clone() {
        ActionDeleteFolders je = (ActionDeleteFolders)super.clone();
        if (this.arguments != null) {
            int nrFields = this.arguments.length;
            je.allocate(nrFields);
            System.arraycopy(this.arguments, 0, je.arguments, 0, nrFields);
        }
        return je;
    }

    public String getXml() {
        StringBuilder retval = new StringBuilder(300);
        retval.append(super.getXml());
        retval.append(CONST_SPACE_SHORT).append(XmlHandler.addTagValue((String)"arg_from_previous", (boolean)this.argFromPrevious));
        retval.append(CONST_SPACE_SHORT).append(XmlHandler.addTagValue((String)"success_condition", (String)this.successCondition));
        retval.append(CONST_SPACE_SHORT).append(XmlHandler.addTagValue((String)"limit_folders", (String)this.limitFolders));
        retval.append("      <fields>").append(Const.CR);
        if (this.arguments != null) {
            for (int i = 0; i < this.arguments.length; ++i) {
                retval.append("        <field>").append(Const.CR);
                retval.append("          ").append(XmlHandler.addTagValue((String)"name", (String)this.arguments[i]));
                retval.append("        </field>").append(Const.CR);
            }
        }
        retval.append("      </fields>").append(Const.CR);
        return retval.toString();
    }

    public void loadXml(Node entrynode, IHopMetadataProvider metadataProvider, IVariables variables) throws HopXmlException {
        try {
            super.loadXml(entrynode);
            this.argFromPrevious = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"arg_from_previous"));
            this.successCondition = XmlHandler.getTagValue((Node)entrynode, (String)"success_condition");
            this.limitFolders = XmlHandler.getTagValue((Node)entrynode, (String)"limit_folders");
            Node fields = XmlHandler.getSubNode((Node)entrynode, (String)"fields");
            int nrFields = XmlHandler.countNodes((Node)fields, (String)"field");
            this.allocate(nrFields);
            for (int i = 0; i < nrFields; ++i) {
                Node fnode = XmlHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                this.arguments[i] = XmlHandler.getTagValue((Node)fnode, (String)"name");
            }
        }
        catch (HopXmlException xe) {
            throw new HopXmlException(BaseMessages.getString(PKG, (String)"ActionDeleteFolders.UnableToLoadFromXml", (String[])new String[0]), (Throwable)xe);
        }
    }

    public Result execute(Result result, int nr) throws HopException {
        List rows = result.getRows();
        result.setNrErrors(1L);
        result.setResult(false);
        this.nrErrors = 0;
        this.nrSuccess = 0;
        this.successConditionBroken = false;
        this.successConditionBrokenExit = false;
        this.nrLimitFolders = Const.toInt((String)this.resolve(this.getLimitFolders()), (int)10);
        if (this.argFromPrevious && this.isDetailed()) {
            this.logDetailed(BaseMessages.getString(PKG, (String)"ActionDeleteFolders.FoundPreviousRows", (String[])new String[]{String.valueOf(rows != null ? rows.size() : 0)}));
        }
        if (this.argFromPrevious && rows != null) {
            for (int iteration = 0; iteration < rows.size() && !this.parentWorkflow.isStopped(); ++iteration) {
                if (this.successConditionBroken) {
                    this.logError(BaseMessages.getString(PKG, (String)"ActionDeleteFolders.Error.SuccessConditionbroken", (String[])new String[]{"" + this.nrErrors}));
                    result.setNrErrors((long)this.nrErrors);
                    result.setNrLinesDeleted((long)this.nrSuccess);
                    return result;
                }
                RowMetaAndData resultRow = (RowMetaAndData)rows.get(iteration);
                String argsPrevious = resultRow.getString(0, null);
                if (!Utils.isEmpty((CharSequence)argsPrevious)) {
                    if (this.deleteFolder(argsPrevious)) {
                        this.updateSuccess();
                        continue;
                    }
                    this.updateErrors();
                    continue;
                }
                this.logError(BaseMessages.getString(PKG, (String)"ActionDeleteFolders.Error.EmptyLine", (String[])new String[0]));
            }
        } else if (this.arguments != null) {
            for (int i = 0; i < this.arguments.length && !this.parentWorkflow.isStopped(); ++i) {
                if (this.successConditionBroken) {
                    this.logError(BaseMessages.getString(PKG, (String)"ActionDeleteFolders.Error.SuccessConditionbroken", (String[])new String[]{"" + this.nrErrors}));
                    result.setNrErrors((long)this.nrErrors);
                    result.setNrLinesDeleted((long)this.nrSuccess);
                    return result;
                }
                String realfilename = this.resolve(this.arguments[i]);
                if (!Utils.isEmpty((CharSequence)realfilename)) {
                    if (this.deleteFolder(realfilename)) {
                        this.updateSuccess();
                        continue;
                    }
                    this.updateErrors();
                    continue;
                }
                this.logError(BaseMessages.getString(PKG, (String)"ActionDeleteFolders.Error.EmptyLine", (String[])new String[0]));
            }
        }
        if (this.isDetailed()) {
            this.logDetailed("=======================================");
            this.logDetailed(BaseMessages.getString(PKG, (String)"ActionDeleteFolders.Log.Info.NrError", (String[])new String[]{"" + this.nrErrors}));
            this.logDetailed(BaseMessages.getString(PKG, (String)"ActionDeleteFolders.Log.Info.NrDeletedFolders", (String[])new String[]{"" + this.nrSuccess}));
            this.logDetailed("=======================================");
        }
        result.setNrErrors((long)this.nrErrors);
        result.setNrLinesDeleted((long)this.nrSuccess);
        if (this.getSuccessStatus()) {
            result.setResult(true);
        }
        return result;
    }

    private void updateErrors() {
        ++this.nrErrors;
        if (this.checkIfSuccessConditionBroken()) {
            this.successConditionBroken = true;
        }
    }

    private boolean checkIfSuccessConditionBroken() {
        return this.nrErrors > 0 && this.getSuccessCondition().equals(SUCCESS_IF_NO_ERRORS) || this.nrErrors >= this.nrLimitFolders && this.getSuccessCondition().equals(SUCCESS_IF_ERRORS_LESS);
    }

    private void updateSuccess() {
        ++this.nrSuccess;
    }

    private boolean getSuccessStatus() {
        return this.nrErrors == 0 && this.getSuccessCondition().equals(SUCCESS_IF_NO_ERRORS) || this.nrSuccess >= this.nrLimitFolders && this.getSuccessCondition().equals(SUCCESS_IF_AT_LEAST_X_FOLDERS_DELETED) || this.nrErrors <= this.nrLimitFolders && this.getSuccessCondition().equals(SUCCESS_IF_ERRORS_LESS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean deleteFolder(String folderName) {
        boolean rcode = false;
        FileObject filefolder = null;
        try {
            filefolder = HopVfs.getFileObject((String)folderName, (IVariables)this.getVariables());
            if (filefolder.exists()) {
                if (filefolder.getType() == FileType.FOLDER) {
                    if (this.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"ActionDeleteFolders.ProcessingFolder", (String[])new String[]{folderName}));
                    }
                    int count = filefolder.delete((FileSelector)new TextFileSelector());
                    if (this.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"ActionDeleteFolders.TotalDeleted", (String[])new String[]{folderName, String.valueOf(count)}));
                    }
                    rcode = true;
                } else {
                    this.logError(BaseMessages.getString(PKG, (String)"ActionDeleteFolders.Error.NotFolder", (String[])new String[0]));
                }
            } else {
                if (this.isBasic()) {
                    this.logBasic(BaseMessages.getString(PKG, (String)"ActionDeleteFolders.FolderAlreadyDeleted", (String[])new String[]{folderName}));
                }
                rcode = true;
            }
        }
        catch (Exception e) {
            this.logError(BaseMessages.getString(PKG, (String)"ActionDeleteFolders.CouldNotDelete", (String[])new String[]{folderName, e.getMessage()}), e);
        }
        finally {
            if (filefolder != null) {
                try {
                    filefolder.close();
                }
                catch (IOException iOException) {}
            }
        }
        return rcode;
    }

    public void setPrevious(boolean argFromPrevious) {
        this.argFromPrevious = argFromPrevious;
    }

    public boolean isEvaluation() {
        return true;
    }

    public void check(List<ICheckResult> remarks, WorkflowMeta workflowMeta, IVariables variables, IHopMetadataProvider metadataProvider) {
        boolean res = ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, "arguments", remarks, AndValidator.putValidators((IActionValidator[])new IActionValidator[]{ActionValidatorUtils.notNullValidator()}));
        if (!res) {
            return;
        }
        ValidatorContext ctx = new ValidatorContext();
        AbstractFileValidator.putVariableSpace((ValidatorContext)ctx, (IVariables)this.getVariables());
        AndValidator.putValidators((ValidatorContext)ctx, (IActionValidator[])new IActionValidator[]{ActionValidatorUtils.notNullValidator(), ActionValidatorUtils.fileExistsValidator()});
        for (int i = 0; i < this.arguments.length; ++i) {
            ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, "arguments[" + i + "]", remarks, ctx);
        }
    }

    public List<ResourceReference> getResourceDependencies(IVariables variables, WorkflowMeta workflowMeta) {
        List references = super.getResourceDependencies(variables, workflowMeta);
        if (this.arguments != null) {
            ResourceReference reference = null;
            for (int i = 0; i < this.arguments.length; ++i) {
                String filename = this.resolve(this.arguments[i]);
                if (reference == null) {
                    reference = new ResourceReference((IResourceHolder)this);
                    references.add(reference);
                }
                reference.getEntries().add(new ResourceEntry(filename, ResourceEntry.ResourceType.FILE));
            }
        }
        return references;
    }

    public boolean isArgFromPrevious() {
        return this.argFromPrevious;
    }

    public String[] getArguments() {
        return this.arguments;
    }

    public void setSuccessCondition(String successCondition) {
        this.successCondition = successCondition;
    }

    public String getSuccessCondition() {
        return this.successCondition;
    }

    public void setLimitFolders(String limitFolders) {
        this.limitFolders = limitFolders;
    }

    public String getLimitFolders() {
        return this.limitFolders;
    }

    private class TextFileSelector
    implements FileSelector {
        private TextFileSelector() {
        }

        public boolean includeFile(FileSelectInfo info) {
            return true;
        }

        public boolean traverseDescendents(FileSelectInfo info) {
            return true;
        }
    }
}

