/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.structuredstreaming.translation.helpers;

import java.util.function.Function;
import org.apache.beam.runners.spark.structuredstreaming.translation.helpers.EncoderHelpers;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.values.KV;
import org.apache.spark.sql.Encoder;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@Internal
public interface EncoderProvider {
    public <T> @UnknownKeyFor @NonNull @Initialized Encoder<T> encoderOf(@UnknownKeyFor @NonNull @Initialized Coder<T> var1, @UnknownKeyFor @NonNull @Initialized Factory<T> var2);

    default public <T> @UnknownKeyFor @NonNull @Initialized Encoder<T> encoderOf(@UnknownKeyFor @NonNull @Initialized Coder<T> coder) {
        return coder instanceof KvCoder ? this.kvEncoderOf((KvCoder)coder) : this.encoderOf(coder, this.encoderFactory());
    }

    default public <K, V> @UnknownKeyFor @NonNull @Initialized Encoder<@UnknownKeyFor @NonNull @Initialized KV<K, V>> kvEncoderOf(@UnknownKeyFor @NonNull @Initialized KvCoder<K, V> coder) {
        return this.encoderOf((Coder)coder, c -> EncoderHelpers.kvEncoder(this.keyEncoderOf(coder), this.valueEncoderOf(coder)));
    }

    default public <K, V> @UnknownKeyFor @NonNull @Initialized Encoder<K> keyEncoderOf(@UnknownKeyFor @NonNull @Initialized KvCoder<K, V> coder) {
        return this.encoderOf(coder.getKeyCoder(), this.encoderFactory());
    }

    default public <K, V> @UnknownKeyFor @NonNull @Initialized Encoder<V> valueEncoderOf(@UnknownKeyFor @NonNull @Initialized KvCoder<K, V> coder) {
        return this.encoderOf(coder.getValueCoder(), this.encoderFactory());
    }

    default public <T> @UnknownKeyFor @NonNull @Initialized Factory<T> encoderFactory() {
        return Factory.INSTANCE;
    }

    public static interface Factory<@UnknownKeyFor T>
    extends Function<Coder<T>, Encoder<T>> {
        public static final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Factory<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> INSTANCE = EncoderHelpers::encoderFor;
    }
}

