/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.repair.state;

import java.util.concurrent.TimeUnit;
import org.apache.cassandra.utils.Clock;

public interface Completable<I> {
    public I getId();

    public long getInitializedAtMillis();

    public long getInitializedAtNanos();

    public long getLastUpdatedAtMillis();

    public long getLastUpdatedAtNanos();

    default public long getDurationMillis() {
        long endNanos = this.getLastUpdatedAtNanos();
        if (!this.isComplete()) {
            endNanos = Clock.Global.nanoTime();
        }
        return TimeUnit.NANOSECONDS.toMillis(endNanos - this.getInitializedAtNanos());
    }

    public Result getResult();

    default public boolean isComplete() {
        return this.getResult() != null;
    }

    default public String getFailureCause() {
        Result r = this.getResult();
        if (r == null || r.kind == Result.Kind.SUCCESS) {
            return null;
        }
        return r.message;
    }

    default public String getSuccessMessage() {
        Result r = this.getResult();
        if (r == null || r.kind != Result.Kind.SUCCESS) {
            return null;
        }
        return r.message;
    }

    public static class Result {
        public final Kind kind;
        public final String message;

        private Result(Kind kind, String message) {
            this.kind = kind;
            this.message = message;
        }

        protected static Result success() {
            return new Result(Kind.SUCCESS, null);
        }

        protected static Result success(String msg) {
            return new Result(Kind.SUCCESS, msg);
        }

        protected static Result skip(String msg) {
            return new Result(Kind.SKIPPED, msg);
        }

        protected static Result fail(String msg) {
            return new Result(Kind.FAILURE, msg);
        }

        public static enum Kind {
            SUCCESS,
            SKIPPED,
            FAILURE;

        }
    }
}

