/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.xml.xslt;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.xml.xslt.XsltMeta;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.LabelTextVar;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class XsltDialog
extends BaseTransformDialog {
    private static final Class<?> PKG = XsltMeta.class;
    private LabelTextVar wResultField;
    private CCombo wField;
    private CCombo wXSLField;
    private Label wlFilename;
    private Label wlXSLField;
    private Button wbbFilename;
    private Button wXSLFileField;
    private final XsltMeta input;
    private TextVar wXSLFilename;
    private Label wlXSLFieldIsAFile;
    private Button wXSLFieldIsAFile;
    private CCombo wXSLTFactory;
    private TableView wFields;
    private TableView wOutputProperties;
    private ColumnInfo[] colinf;
    private final Map<String, Integer> inputFields;

    public XsltDialog(Shell parent, IVariables variables, XsltMeta transformMeta, PipelineMeta pipelineMeta) {
        super(parent, variables, (ITransformMeta)transformMeta, pipelineMeta);
        this.input = transformMeta;
        this.inputFields = new HashMap<String, Integer>();
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        PropsUi.setLook((Widget)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.input);
        ModifyListener lsMod = e -> this.input.setChanged();
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"XsltDialog.Shell.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = PropsUi.getMargin();
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wOk.addListener(13, e -> this.ok());
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.wCancel.addListener(13, e -> this.cancel());
        this.setButtonPositions(new Button[]{this.wOk, this.wCancel}, margin, null);
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"XsltDialog.TransformName.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.right = new FormAttachment(middle, -margin);
        this.fdlTransformName.top = new FormAttachment(0, margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        PropsUi.setLook((Widget)this.wTransformName);
        this.wTransformName.addModifyListener(lsMod);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(middle, 0);
        this.fdTransformName.top = new FormAttachment(0, margin);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        CTabFolder wTabFolder = new CTabFolder((Composite)this.shell, 2048);
        PropsUi.setLook((Widget)wTabFolder, (int)4);
        CTabItem wGeneralTab = new CTabItem(wTabFolder, 0);
        wGeneralTab.setFont(GuiResource.getInstance().getFontDefault());
        wGeneralTab.setText(BaseMessages.getString(PKG, (String)"XsltDialog.GeneralTab.TabTitle", (String[])new String[0]));
        Composite wGeneralComp = new Composite((Composite)wTabFolder, 0);
        PropsUi.setLook((Widget)wGeneralComp);
        FormLayout generalLayout = new FormLayout();
        generalLayout.marginWidth = 3;
        generalLayout.marginHeight = 3;
        wGeneralComp.setLayout((Layout)generalLayout);
        Label wlField = new Label(wGeneralComp, 131072);
        wlField.setText(BaseMessages.getString(PKG, (String)"XsltDialog.Field.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlField);
        FormData fdlField = new FormData();
        fdlField.left = new FormAttachment(0, 0);
        fdlField.top = new FormAttachment((Control)this.wTransformName, 2 * margin);
        fdlField.right = new FormAttachment(middle, -margin);
        wlField.setLayoutData((Object)fdlField);
        this.wField = new CCombo(wGeneralComp, 2056);
        this.wField.setEditable(true);
        PropsUi.setLook((Widget)this.wField);
        this.wField.addModifyListener(lsMod);
        FormData fdField = new FormData();
        fdField.left = new FormAttachment(middle, margin);
        fdField.top = new FormAttachment((Control)this.wTransformName, 2 * margin);
        fdField.right = new FormAttachment(100, -margin);
        this.wField.setLayoutData((Object)fdField);
        this.wField.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                Cursor busy = new Cursor((Device)XsltDialog.this.shell.getDisplay(), 1);
                XsltDialog.this.shell.setCursor(busy);
                XsltDialog.this.populateFields(XsltDialog.this.wField);
                XsltDialog.this.shell.setCursor(null);
                busy.dispose();
            }
        });
        Group wOutputField = new Group(wGeneralComp, 32);
        PropsUi.setLook((Widget)wOutputField);
        wOutputField.setText(BaseMessages.getString(PKG, (String)"XsltDialog.ResultField.Group.Label", (String[])new String[0]));
        FormLayout outputfieldgroupLayout = new FormLayout();
        outputfieldgroupLayout.marginWidth = 10;
        outputfieldgroupLayout.marginHeight = 10;
        wOutputField.setLayout((Layout)outputfieldgroupLayout);
        this.wResultField = new LabelTextVar(this.variables, (Composite)wOutputField, BaseMessages.getString(PKG, (String)"XsltDialog.ResultField.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"XsltDialog.ResultField.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wResultField);
        this.wResultField.addModifyListener(lsMod);
        FormData fdResultField = new FormData();
        fdResultField.left = new FormAttachment(0, 0);
        fdResultField.top = new FormAttachment((Control)this.wField, margin);
        fdResultField.right = new FormAttachment(100, 0);
        this.wResultField.setLayoutData((Object)fdResultField);
        FormData fdOutputField = new FormData();
        fdOutputField.left = new FormAttachment(0, margin);
        fdOutputField.top = new FormAttachment((Control)this.wField, margin);
        fdOutputField.right = new FormAttachment(100, -margin);
        wOutputField.setLayoutData((Object)fdOutputField);
        Group wXSLFileGroup = new Group(wGeneralComp, 32);
        PropsUi.setLook((Widget)wXSLFileGroup);
        wXSLFileGroup.setText(BaseMessages.getString(PKG, (String)"XsltDialog.XSL.Group.Label", (String[])new String[0]));
        FormLayout xslFileGroupLayout = new FormLayout();
        xslFileGroupLayout.marginWidth = 10;
        xslFileGroupLayout.marginHeight = 10;
        wXSLFileGroup.setLayout((Layout)xslFileGroupLayout);
        Label wlXSLFileField = new Label((Composite)wXSLFileGroup, 131072);
        wlXSLFileField.setText(BaseMessages.getString(PKG, (String)"XsltDialog.XSLFilenameFileField.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlXSLFileField);
        FormData fdlXSLFileField = new FormData();
        fdlXSLFileField.left = new FormAttachment(0, 0);
        fdlXSLFileField.top = new FormAttachment(0, 0);
        fdlXSLFileField.right = new FormAttachment(middle, -margin);
        wlXSLFileField.setLayoutData((Object)fdlXSLFileField);
        this.wXSLFileField = new Button((Composite)wXSLFileGroup, 32);
        PropsUi.setLook((Widget)this.wXSLFileField);
        this.wXSLFileField.setToolTipText(BaseMessages.getString(PKG, (String)"XsltDialog.XSLFilenameFileField.Tooltip", (String[])new String[0]));
        FormData fdXSLFileField = new FormData();
        fdXSLFileField.left = new FormAttachment(middle, margin);
        fdXSLFileField.top = new FormAttachment((Control)wlXSLFileField, 0, 0x1000000);
        this.wXSLFileField.setLayoutData((Object)fdXSLFileField);
        SelectionAdapter lsXslFile = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                XsltDialog.this.activateWlXSLField();
                XsltDialog.this.input.setChanged();
            }
        };
        this.wXSLFileField.addSelectionListener((SelectionListener)lsXslFile);
        this.wlXSLField = new Label((Composite)wXSLFileGroup, 131072);
        this.wlXSLField.setText(BaseMessages.getString(PKG, (String)"XsltDialog.XSLFilenameField.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlXSLField);
        FormData fdlXSLField = new FormData();
        fdlXSLField.left = new FormAttachment(0, 0);
        fdlXSLField.top = new FormAttachment((Control)this.wXSLFileField, margin);
        fdlXSLField.right = new FormAttachment(middle, -margin);
        this.wlXSLField.setLayoutData((Object)fdlXSLField);
        this.wXSLField = new CCombo((Composite)wXSLFileGroup, 2056);
        this.wXSLField.setEditable(true);
        PropsUi.setLook((Widget)this.wXSLField);
        this.wXSLField.addModifyListener(lsMod);
        FormData fdXSLField = new FormData();
        fdXSLField.left = new FormAttachment(middle, margin);
        fdXSLField.top = new FormAttachment((Control)this.wXSLFileField, margin);
        fdXSLField.right = new FormAttachment(100, -margin);
        this.wXSLField.setLayoutData((Object)fdXSLField);
        this.wXSLField.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                Cursor busy = new Cursor((Device)XsltDialog.this.shell.getDisplay(), 1);
                XsltDialog.this.shell.setCursor(busy);
                XsltDialog.this.populateFields(XsltDialog.this.wXSLField);
                XsltDialog.this.shell.setCursor(null);
                busy.dispose();
            }
        });
        this.wlXSLFieldIsAFile = new Label((Composite)wXSLFileGroup, 131072);
        this.wlXSLFieldIsAFile.setText(BaseMessages.getString(PKG, (String)"XsltDialog.XSLFieldIsAFile.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlXSLFieldIsAFile);
        FormData fdlXSLFieldIsAFile = new FormData();
        fdlXSLFieldIsAFile.left = new FormAttachment(0, 0);
        fdlXSLFieldIsAFile.top = new FormAttachment((Control)this.wXSLField, margin);
        fdlXSLFieldIsAFile.right = new FormAttachment(middle, -margin);
        this.wlXSLFieldIsAFile.setLayoutData((Object)fdlXSLFieldIsAFile);
        this.wXSLFieldIsAFile = new Button((Composite)wXSLFileGroup, 32);
        PropsUi.setLook((Widget)this.wXSLFieldIsAFile);
        this.wXSLFieldIsAFile.setToolTipText(BaseMessages.getString(PKG, (String)"XsltDialog.XSLFieldIsAFile.Tooltip", (String[])new String[0]));
        FormData fdXSLFieldIsAFile = new FormData();
        fdXSLFieldIsAFile.left = new FormAttachment(middle, margin);
        fdXSLFieldIsAFile.top = new FormAttachment((Control)this.wlXSLFieldIsAFile, 0, 0x1000000);
        this.wXSLFieldIsAFile.setLayoutData((Object)fdXSLFieldIsAFile);
        this.wXSLFieldIsAFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                XsltDialog.this.input.setChanged();
            }
        });
        this.wlFilename = new Label((Composite)wXSLFileGroup, 131072);
        this.wlFilename.setText(BaseMessages.getString(PKG, (String)"XsltDialog.XSLFilename.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlFilename);
        FormData fdlXSLFilename = new FormData();
        fdlXSLFilename.left = new FormAttachment(0, 0);
        fdlXSLFilename.top = new FormAttachment((Control)this.wXSLFieldIsAFile, 2 * margin);
        fdlXSLFilename.right = new FormAttachment(middle, -margin);
        this.wlFilename.setLayoutData((Object)fdlXSLFilename);
        this.wbbFilename = new Button((Composite)wXSLFileGroup, 0x1000008);
        PropsUi.setLook((Widget)this.wbbFilename);
        this.wbbFilename.setText(BaseMessages.getString(PKG, (String)"XsltDialog.FilenameBrowse.Button", (String[])new String[0]));
        this.wbbFilename.setToolTipText(BaseMessages.getString(PKG, (String)"System.Tooltip.BrowseForFileOrDirAndAdd", (String[])new String[0]));
        FormData fdbXSLFilename = new FormData();
        fdbXSLFilename.right = new FormAttachment(100, 0);
        fdbXSLFilename.top = new FormAttachment((Control)this.wXSLFieldIsAFile, 2 * margin);
        this.wbbFilename.setLayoutData((Object)fdbXSLFilename);
        this.wXSLFilename = new TextVar(this.variables, (Composite)wXSLFileGroup, 18436);
        PropsUi.setLook((Widget)this.wXSLFilename);
        this.wXSLFilename.addModifyListener(lsMod);
        FormData fdXSLFilename = new FormData();
        fdXSLFilename.left = new FormAttachment(middle, margin);
        fdXSLFilename.right = new FormAttachment((Control)this.wbbFilename, -margin);
        fdXSLFilename.top = new FormAttachment((Control)this.wXSLFieldIsAFile, 2 * margin);
        this.wXSLFilename.setLayoutData((Object)fdXSLFilename);
        Label wlXSLTFactory = new Label((Composite)wXSLFileGroup, 131072);
        wlXSLTFactory.setText(BaseMessages.getString(PKG, (String)"XsltDialog.XSLTFactory.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlXSLTFactory);
        FormData fdlXSLTFactory = new FormData();
        fdlXSLTFactory.left = new FormAttachment(0, 0);
        fdlXSLTFactory.top = new FormAttachment((Control)this.wXSLFilename, 2 * margin);
        fdlXSLTFactory.right = new FormAttachment(middle, -margin);
        wlXSLTFactory.setLayoutData((Object)fdlXSLTFactory);
        this.wXSLTFactory = new CCombo((Composite)wXSLFileGroup, 2056);
        this.wXSLTFactory.setEditable(true);
        PropsUi.setLook((Widget)this.wXSLTFactory);
        this.wXSLTFactory.addModifyListener(lsMod);
        FormData fdXSLTFactory = new FormData();
        fdXSLTFactory.left = new FormAttachment(middle, margin);
        fdXSLTFactory.top = new FormAttachment((Control)this.wXSLFilename, 2 * margin);
        fdXSLTFactory.right = new FormAttachment(100, 0);
        this.wXSLTFactory.setLayoutData((Object)fdXSLTFactory);
        this.wXSLTFactory.add("JAXP");
        this.wXSLTFactory.add("SAXON");
        FormData fdXSLFileGroup = new FormData();
        fdXSLFileGroup.left = new FormAttachment(0, margin);
        fdXSLFileGroup.top = new FormAttachment((Control)wOutputField, margin);
        fdXSLFileGroup.right = new FormAttachment(100, -margin);
        wXSLFileGroup.setLayoutData((Object)fdXSLFileGroup);
        FormData fdGeneralComp = new FormData();
        fdGeneralComp.left = new FormAttachment(0, 0);
        fdGeneralComp.top = new FormAttachment((Control)this.wField, 0);
        fdGeneralComp.right = new FormAttachment(100, 0);
        fdGeneralComp.bottom = new FormAttachment(100, 0);
        wGeneralComp.setLayoutData((Object)fdGeneralComp);
        wGeneralComp.layout();
        wGeneralTab.setControl((Control)wGeneralComp);
        PropsUi.setLook((Widget)wGeneralComp);
        CTabItem wAdditionalTab = new CTabItem(wTabFolder, 0);
        wAdditionalTab.setFont(GuiResource.getInstance().getFontDefault());
        wAdditionalTab.setText(BaseMessages.getString(PKG, (String)"XsltDialog.AdvancedTab.Title", (String[])new String[0]));
        FormLayout addLayout = new FormLayout();
        addLayout.marginWidth = PropsUi.getFormMargin();
        addLayout.marginHeight = PropsUi.getFormMargin();
        Composite wAdditionalComp = new Composite((Composite)wTabFolder, 0);
        wAdditionalComp.setLayout((Layout)addLayout);
        PropsUi.setLook((Widget)wAdditionalComp);
        Label wlOutputProperties = new Label(wAdditionalComp, 0);
        wlOutputProperties.setText(BaseMessages.getString(PKG, (String)"XsltDialog.OutputProperties.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlOutputProperties);
        FormData fdlOutputProperties = new FormData();
        fdlOutputProperties.left = new FormAttachment(0, 0);
        fdlOutputProperties.top = new FormAttachment(0, margin);
        wlOutputProperties.setLayoutData((Object)fdlOutputProperties);
        int OutputPropertiesRows = this.input.getOutputPropertyName().length;
        this.colinf = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"XsltDialog.ColumnInfo.OutputProperties.Name", (String[])new String[0]), 2, new String[]{""}, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"XsltDialog.ColumnInfo.OutputProperties.Value", (String[])new String[0]), 1, false)};
        this.colinf[0].setComboValues(XsltMeta.outputProperties);
        this.colinf[1].setUsingVariables(true);
        this.wOutputProperties = new TableView(this.variables, wAdditionalComp, 67586, this.colinf, OutputPropertiesRows, lsMod, this.props);
        FormData fdOutputProperties = new FormData();
        fdOutputProperties.left = new FormAttachment(0, 0);
        fdOutputProperties.top = new FormAttachment((Control)wlOutputProperties, margin);
        fdOutputProperties.right = new FormAttachment(100, -margin);
        fdOutputProperties.bottom = new FormAttachment((Control)wlOutputProperties, 200);
        this.wOutputProperties.setLayoutData((Object)fdOutputProperties);
        Label wlFields = new Label(wAdditionalComp, 0);
        wlFields.setText(BaseMessages.getString(PKG, (String)"XsltDialog.Parameters.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlFields);
        FormData fdlFields = new FormData();
        fdlFields.left = new FormAttachment(0, 0);
        fdlFields.top = new FormAttachment((Control)this.wOutputProperties, 2 * margin);
        wlFields.setLayoutData((Object)fdlFields);
        this.wGet = new Button(wAdditionalComp, 8);
        this.wGet.setText(BaseMessages.getString(PKG, (String)"XsltDialog.GetFields.Button", (String[])new String[0]));
        FormData fdGet = new FormData();
        fdGet.top = new FormAttachment((Control)wlFields, margin);
        fdGet.right = new FormAttachment(100, 0);
        this.wGet.setLayoutData((Object)fdGet);
        int FieldsRows = this.input.getParameterField().length;
        this.colinf = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"XsltDialog.ColumnInfo.Name", (String[])new String[0]), 2, new String[]{""}, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"XsltDialog.ColumnInfo.Parameter", (String[])new String[0]), 1, false)};
        this.colinf[1].setUsingVariables(true);
        this.wFields = new TableView(this.variables, wAdditionalComp, 67586, this.colinf, FieldsRows, lsMod, this.props);
        FormData fdFields = new FormData();
        fdFields.left = new FormAttachment(0, 0);
        fdFields.top = new FormAttachment((Control)wlFields, margin);
        fdFields.right = new FormAttachment((Control)this.wGet, -margin);
        fdFields.bottom = new FormAttachment(100, -margin);
        this.wFields.setLayoutData((Object)fdFields);
        Runnable runnable = () -> {
            TransformMeta transformMeta = this.pipelineMeta.findTransform(this.transformName);
            if (transformMeta != null) {
                try {
                    IRowMeta row = this.pipelineMeta.getPrevTransformFields(this.variables, transformMeta);
                    for (int i = 0; i < row.size(); ++i) {
                        this.inputFields.put(row.getValueMeta(i).getName(), i);
                    }
                    this.setComboBoxes();
                }
                catch (HopException e) {
                    this.logError(BaseMessages.getString(PKG, (String)"System.Dialog.GetFieldsFailed.Message", (String[])new String[0]));
                }
            }
        };
        new Thread(runnable).start();
        FormData fdAdditionalComp = new FormData();
        fdAdditionalComp.left = new FormAttachment(0, 0);
        fdAdditionalComp.top = new FormAttachment((Control)this.wTransformName, margin);
        fdAdditionalComp.right = new FormAttachment(100, 0);
        fdAdditionalComp.bottom = new FormAttachment(100, 0);
        wAdditionalComp.setLayoutData((Object)fdAdditionalComp);
        wAdditionalComp.layout();
        wAdditionalTab.setControl((Control)wAdditionalComp);
        FormData fdTabFolder = new FormData();
        fdTabFolder.left = new FormAttachment(0, 0);
        fdTabFolder.top = new FormAttachment((Control)this.wTransformName, margin);
        fdTabFolder.right = new FormAttachment(100, 0);
        fdTabFolder.bottom = new FormAttachment((Control)this.wOk, -2 * margin);
        wTabFolder.setLayoutData((Object)fdTabFolder);
        this.wGet.addListener(13, e -> this.get());
        this.wXSLFilename.addModifyListener(e -> this.wXSLFilename.setToolTipText(this.variables.resolve(this.wXSLFilename.getText())));
        this.wbbFilename.addListener(13, e -> BaseDialog.presentFileDialog((Shell)this.shell, (TextVar)this.wXSLFilename, (IVariables)this.variables, (String[])new String[]{"*.xsl;*.XSL", "*.xslt;.*XSLT", "*"}, (String[])new String[]{BaseMessages.getString(PKG, (String)"XsltDialog.FileType", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.FileType.AllFiles", (String[])new String[0])}, (boolean)true));
        wTabFolder.setSelection(0);
        this.getData();
        this.activateWlXSLField();
        this.input.setChanged(this.changed);
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    private void activateWlXSLField() {
        this.wXSLField.setEnabled(this.wXSLFileField.getSelection());
        this.wlXSLField.setEnabled(this.wXSLFileField.getSelection());
        this.wXSLFilename.setEnabled(!this.wXSLFileField.getSelection());
        this.wlFilename.setEnabled(!this.wXSLFileField.getSelection());
        this.wbbFilename.setEnabled(!this.wXSLFileField.getSelection());
        this.wlXSLFieldIsAFile.setEnabled(this.wXSLFileField.getSelection());
        this.wXSLFieldIsAFile.setEnabled(this.wXSLFileField.getSelection());
        if (!this.wXSLFileField.getSelection()) {
            this.wXSLFieldIsAFile.setSelection(false);
        }
    }

    private void populateFields(CCombo cc) {
        if (cc.isDisposed()) {
            return;
        }
        try {
            String initValue = cc.getText();
            cc.removeAll();
            IRowMeta r = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName);
            if (r != null) {
                cc.setItems(r.getFieldNames());
            }
            if (!Utils.isEmpty((CharSequence)initValue)) {
                cc.setText(initValue);
            }
        }
        catch (HopException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"XsltDialog.FailedToGetFields.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"XsltDialog.FailedToGetFields.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
        }
    }

    public void getData() {
        TableItem item;
        int i;
        if (this.input.getXslFilename() != null) {
            this.wXSLFilename.setText(this.input.getXslFilename());
        }
        if (this.input.getResultfieldname() != null) {
            this.wResultField.setText(this.input.getResultfieldname());
        }
        if (this.input.getFieldname() != null) {
            this.wField.setText(this.input.getFieldname());
        }
        if (this.input.getXSLFileField() != null) {
            this.wXSLField.setText(this.input.getXSLFileField());
        }
        this.wXSLFileField.setSelection(this.input.useXSLField());
        this.wXSLFieldIsAFile.setSelection(this.input.isXSLFieldIsAFile());
        if (this.input.getXSLFactory() != null) {
            this.wXSLTFactory.setText(this.input.getXSLFactory());
        } else {
            this.wXSLTFactory.setText("JAXP");
        }
        if (this.input.getParameterName() != null) {
            for (i = 0; i < this.input.getParameterName().length; ++i) {
                item = this.wFields.table.getItem(i);
                item.setText(1, Const.NVL((String)this.input.getParameterField()[i], (String)""));
                item.setText(2, Const.NVL((String)this.input.getParameterName()[i], (String)""));
            }
        }
        if (this.input.getOutputPropertyName() != null) {
            for (i = 0; i < this.input.getOutputPropertyName().length; ++i) {
                item = this.wOutputProperties.table.getItem(i);
                item.setText(1, Const.NVL((String)this.input.getOutputPropertyName()[i], (String)""));
                item.setText(2, Const.NVL((String)this.input.getOutputPropertyValue()[i], (String)""));
            }
        }
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    private void cancel() {
        this.transformName = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        TableItem item;
        int i;
        this.transformName = this.wTransformName.getText();
        this.input.setXslFilename(this.wXSLFilename.getText());
        this.input.setResultfieldname(this.wResultField.getText());
        this.input.setFieldname(this.wField.getText());
        this.input.setXSLFileField(this.wXSLField.getText());
        this.input.setXSLFactory(this.wXSLTFactory.getText());
        this.input.setXSLField(this.wXSLFileField.getSelection());
        this.input.setXSLFieldIsAFile(this.wXSLFieldIsAFile.getSelection());
        int nrparams = this.wFields.nrNonEmpty();
        int nroutputprops = this.wOutputProperties.nrNonEmpty();
        this.input.allocate(nrparams, nroutputprops);
        if (this.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"HTTPDialog.Log.FoundArguments", (String[])new String[]{String.valueOf(nrparams)}));
        }
        for (i = 0; i < nrparams; ++i) {
            item = this.wFields.getNonEmpty(i);
            this.input.getParameterField()[i] = item.getText(1);
            this.input.getParameterName()[i] = item.getText(2);
        }
        for (i = 0; i < nroutputprops; ++i) {
            item = this.wOutputProperties.getNonEmpty(i);
            this.input.getOutputPropertyName()[i] = item.getText(1);
            this.input.getOutputPropertyValue()[i] = item.getText(2);
        }
        this.dispose();
    }

    protected void setComboBoxes() {
        HashMap<String, Integer> fields = new HashMap<String, Integer>();
        fields.putAll(this.inputFields);
        Set keySet = fields.keySet();
        ArrayList entries = new ArrayList(keySet);
        String[] fieldNames = entries.toArray(new String[entries.size()]);
        Const.sortStrings((String[])fieldNames);
        this.colinf[0].setComboValues(fieldNames);
    }

    private void get() {
        try {
            IRowMeta r = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName);
            if (r != null && !r.isEmpty()) {
                BaseTransformDialog.getFieldsFromPrevious((IRowMeta)r, (TableView)this.wFields, (int)1, (int[])new int[]{1, 2}, (int[])new int[]{3}, (int)-1, (int)-1, null);
            }
        }
        catch (HopException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"XsltDialog.FailedToGetFields.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"XsltDialog.FailedToGetFields.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
        }
    }
}

