/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.dimensionlookup;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.RowMetaAndData;
import org.apache.hop.core.database.Database;
import org.apache.hop.core.exception.HopDatabaseException;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.exception.HopValueException;
import org.apache.hop.core.hash.ByteArrayHashMap;
import org.apache.hop.core.logging.ILoggingObject;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowDataUtil;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.row.value.ValueMetaBoolean;
import org.apache.hop.core.row.value.ValueMetaDate;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.row.value.ValueMetaInteger;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.dimensionlookup.DimensionCache;
import org.apache.hop.pipeline.transforms.dimensionlookup.DimensionLookupData;
import org.apache.hop.pipeline.transforms.dimensionlookup.DimensionLookupMeta;

public class DimensionLookup
extends BaseTransform<DimensionLookupMeta, DimensionLookupData> {
    private static final Class<?> PKG = DimensionLookupMeta.class;
    public static final String CONST_DIMENSION_LOOKUP_EXCEPTION_KEY_FIELD_NOT_FOUND = "DimensionLookup.Exception.KeyFieldNotFound";
    public static final String CONST_UPDATE = "UPDATE ";
    public static final String CONST_AND = "AND   ";
    public static final String CONST_WHERE = " WHERE ";
    int[] columnLookupArray = null;

    public DimensionLookup(TransformMeta transformMeta, DimensionLookupMeta meta, DimensionLookupData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    public boolean processRow() throws HopException {
        block18: {
            Object f;
            boolean sendToErrorRow = false;
            String errorMessage = null;
            Object[] r = this.getRow();
            if (r == null) {
                this.setOutputDone();
                return false;
            }
            if (this.first) {
                DimensionLookupMeta.DLKey key;
                int i;
                this.first = false;
                ((DimensionLookupData)this.data).schemaTable = ((DimensionLookupData)this.data).databaseMeta.getQuotedSchemaTableCombination((IVariables)this, ((DimensionLookupData)this.data).realSchemaName, ((DimensionLookupData)this.data).realTableName);
                ((DimensionLookupData)this.data).inputRowMeta = this.getInputRowMeta().clone();
                ((DimensionLookupData)this.data).outputRowMeta = this.getInputRowMeta().clone();
                ((DimensionLookupMeta)this.meta).getFields(((DimensionLookupData)this.data).outputRowMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
                ((DimensionLookupData)this.data).lazyList = new ArrayList<Integer>();
                for (int i2 = 0; i2 < ((DimensionLookupData)this.data).inputRowMeta.size(); ++i2) {
                    IValueMeta valueMeta = ((DimensionLookupData)this.data).inputRowMeta.getValueMeta(i2);
                    if (!valueMeta.isStorageBinaryString()) continue;
                    ((DimensionLookupData)this.data).lazyList.add(i2);
                    valueMeta.setStorageType(0);
                }
                ((DimensionLookupData)this.data).startDateFieldIndex = -1;
                if (((DimensionLookupData)this.data).startDateAlternative == DimensionLookupMeta.StartDateAlternative.COLUMN_VALUE) {
                    ((DimensionLookupData)this.data).startDateFieldIndex = ((DimensionLookupData)this.data).inputRowMeta.indexOfValue(((DimensionLookupMeta)this.meta).getStartDateFieldName());
                    if (((DimensionLookupData)this.data).startDateFieldIndex < 0) {
                        throw new HopTransformException(BaseMessages.getString(PKG, (String)"DimensionLookup.Exception.StartDateValueColumnNotFound", (String[])new String[]{((DimensionLookupMeta)this.meta).getStartDateFieldName()}));
                    }
                }
                f = ((DimensionLookupMeta)this.meta).getFields();
                ((DimensionLookupData)this.data).keynrs = new int[((DimensionLookupMeta.DLFields)f).getKeys().size()];
                for (i = 0; i < ((DimensionLookupData)this.data).keynrs.length; ++i) {
                    key = ((DimensionLookupMeta.DLFields)f).getKeys().get(i);
                    ((DimensionLookupData)this.data).keynrs[i] = ((DimensionLookupData)this.data).inputRowMeta.indexOfValue(key.getName());
                    if (((DimensionLookupData)this.data).keynrs[i] >= 0) continue;
                    throw new HopTransformException(BaseMessages.getString(PKG, (String)CONST_DIMENSION_LOOKUP_EXCEPTION_KEY_FIELD_NOT_FOUND, (String[])new String[]{key.getName()}));
                }
                ((DimensionLookupData)this.data).fieldnrs = new int[((DimensionLookupMeta.DLFields)f).getFields().size()];
                for (i = 0; i < ((DimensionLookupData)this.data).fieldnrs.length; ++i) {
                    DimensionLookupMeta.DLField field = ((DimensionLookupMeta.DLFields)f).getFields().get(i);
                    if (this.isLookupOrUpdateTypeWithArgument(((DimensionLookupMeta)this.meta).isUpdate(), field)) {
                        ((DimensionLookupData)this.data).fieldnrs[i] = ((DimensionLookupData)this.data).outputRowMeta.indexOfValue(field.getName());
                        if (((DimensionLookupData)this.data).fieldnrs[i] >= 0) continue;
                        throw new HopTransformException(BaseMessages.getString(PKG, (String)CONST_DIMENSION_LOOKUP_EXCEPTION_KEY_FIELD_NOT_FOUND, (String[])new String[]{field.getName()}));
                    }
                    ((DimensionLookupData)this.data).fieldnrs[i] = -1;
                }
                if (!((DimensionLookupMeta)this.meta).isUpdate() && ((DimensionLookupMeta)this.meta).isPreloadingCache()) {
                    this.preloadCache();
                } else if (((DimensionLookupData)this.data).cacheKeyRowMeta == null) {
                    ((DimensionLookupData)this.data).cacheKeyRowMeta = new RowMeta();
                    for (i = 0; i < ((DimensionLookupData)this.data).keynrs.length; ++i) {
                        key = ((DimensionLookupData)this.data).inputRowMeta.getValueMeta(((DimensionLookupData)this.data).keynrs[i]);
                        ((DimensionLookupData)this.data).cacheKeyRowMeta.addValueMeta(key.clone());
                    }
                    ((DimensionLookupData)this.data).cache = new ByteArrayHashMap(((DimensionLookupMeta)this.meta).getCacheSize() > 0 ? ((DimensionLookupMeta)this.meta).getCacheSize() : 5000, ((DimensionLookupData)this.data).cacheKeyRowMeta);
                }
                ((DimensionLookupData)this.data).datefieldnr = StringUtils.isNotEmpty((String)((DimensionLookupMeta.DLFields)f).getDate().getName()) ? ((DimensionLookupData)this.data).inputRowMeta.indexOfValue(((DimensionLookupMeta.DLFields)f).getDate().getName()) : -1;
                ((DimensionLookupData)this.data).valueDateNow = this.determineDimensionUpdatedDate(r);
                ((DimensionLookupData)this.data).notFoundTk = ((DimensionLookupData)this.data).databaseMeta.getNotFoundTK(this.isAutoIncrement());
                if (this.getCopy() == 0) {
                    this.checkDimZero();
                }
                this.setDimLookup(((DimensionLookupData)this.data).outputRowMeta);
            }
            f = ((DimensionLookupData)this.data).lazyList.iterator();
            while (f.hasNext()) {
                int lazyFieldIndex = f.next();
                IValueMeta valueMeta = this.getInputRowMeta().getValueMeta(lazyFieldIndex);
                r[lazyFieldIndex] = valueMeta.convertToNormalStorageType(r[lazyFieldIndex]);
            }
            try {
                Object[] outputRow = this.lookupValues(((DimensionLookupData)this.data).inputRowMeta, r);
                this.putRow(((DimensionLookupData)this.data).outputRowMeta, outputRow);
                if (this.checkFeedback(this.getLinesRead()) && this.log.isBasic()) {
                    this.logBasic(BaseMessages.getString(PKG, (String)"DimensionLookup.Log.LineNumber", (String[])new String[0]) + this.getLinesRead());
                }
            }
            catch (HopException e) {
                if (!this.getTransformMeta().isDoingErrorHandling()) {
                    this.logError(BaseMessages.getString(PKG, (String)"DimensionLookup.Log.TransformCanNotContinueForErrors", (String[])new String[]{e.getMessage()}));
                    this.logError(Const.getStackTracker((Throwable)e));
                    this.setErrors(1L);
                    this.stopAll();
                    this.setOutputDone();
                    return false;
                }
                sendToErrorRow = true;
                errorMessage = e.toString();
                if (!sendToErrorRow) break block18;
                this.putError(this.getInputRowMeta(), r, 1L, errorMessage, null, "ISU001");
            }
        }
        return true;
    }

    public boolean isLookupOrUpdateTypeWithArgument(boolean update, DimensionLookupMeta.DLField field) throws HopTransformException {
        if (!update) {
            return true;
        }
        DimensionLookupMeta.DimensionUpdateType updateType = field.getUpdateType();
        if (updateType == null) {
            throw new HopTransformException(BaseMessages.getString(PKG, (String)"DimensionLookup.Exception.MissingUpdateTypeField ", (String[])new String[]{field.getName()}));
        }
        return updateType.isWithArgument();
    }

    private Date determineDimensionUpdatedDate(Object[] row) throws HopException {
        String inputRowMetaStringMeta;
        if (((DimensionLookupData)this.data).datefieldnr < 0) {
            return this.getPipeline().getExecutionStartDate();
        }
        Date rtn = ((DimensionLookupData)this.data).inputRowMeta.getDate(row, ((DimensionLookupData)this.data).datefieldnr);
        if (rtn != null) {
            return rtn;
        }
        try {
            inputRowMetaStringMeta = ((DimensionLookupData)this.data).inputRowMeta.toStringMeta();
        }
        catch (Exception ex) {
            inputRowMetaStringMeta = "No row input meta";
        }
        throw new HopTransformException(BaseMessages.getString(PKG, (String)"DimensionLookup.Exception.NullDimensionUpdatedDate", (String[])new String[]{inputRowMetaStringMeta}));
    }

    private void preloadCache() throws HopException {
        try {
            DimensionLookupMeta.DLKey key;
            int i;
            DimensionLookupMeta.DLFields f = ((DimensionLookupMeta)this.meta).getFields();
            String sql = "SELECT " + ((DimensionLookupData)this.data).databaseMeta.quoteField(f.getReturns().getKeyField());
            for (DimensionLookupMeta.DLKey key2 : f.getKeys()) {
                sql = sql + ", " + ((DimensionLookupData)this.data).databaseMeta.quoteField(key2.getLookup());
            }
            for (DimensionLookupMeta.DLField field : f.getFields()) {
                sql = sql + ", " + ((DimensionLookupData)this.data).databaseMeta.quoteField(field.getLookup());
            }
            sql = sql + ", " + ((DimensionLookupData)this.data).databaseMeta.quoteField(f.getDate().getFrom());
            sql = sql + ", " + ((DimensionLookupData)this.data).databaseMeta.quoteField(f.getDate().getTo());
            sql = sql + " FROM " + ((DimensionLookupData)this.data).schemaTable;
            if (this.log.isDetailed()) {
                this.logDetailed("Pre-loading cache by reading from database with: " + Const.CR + sql + Const.CR);
            }
            List rows = ((DimensionLookupData)this.data).db.getRows(sql, -1);
            IRowMeta rowMeta = ((DimensionLookupData)this.data).db.getReturnRowMeta();
            ((DimensionLookupData)this.data).preloadKeyIndexes = new int[f.getKeys().size()];
            for (i = 0; i < ((DimensionLookupData)this.data).preloadKeyIndexes.length; ++i) {
                key = f.getKeys().get(i);
                ((DimensionLookupData)this.data).preloadKeyIndexes[i] = rowMeta.indexOfValue(key.getLookup());
            }
            ((DimensionLookupData)this.data).preloadFromDateIndex = rowMeta.indexOfValue(f.getDate().getFrom());
            ((DimensionLookupData)this.data).preloadToDateIndex = rowMeta.indexOfValue(f.getDate().getTo());
            ((DimensionLookupData)this.data).preloadCache = new DimensionCache(rowMeta, ((DimensionLookupData)this.data).preloadKeyIndexes, ((DimensionLookupData)this.data).preloadFromDateIndex, ((DimensionLookupData)this.data).preloadToDateIndex);
            ((DimensionLookupData)this.data).preloadCache.setRowCache(rows);
            this.logDetailed("Sorting the cache rows...");
            ((DimensionLookupData)this.data).preloadCache.sortRows();
            this.logDetailed("Sorting of cached rows finished.");
            ((DimensionLookupData)this.data).preloadIndexes = new ArrayList<Integer>();
            for (i = 0; i < f.getKeys().size(); ++i) {
                key = f.getKeys().get(i);
                int index = ((DimensionLookupData)this.data).inputRowMeta.indexOfValue(key.getName());
                if (index < 0) {
                    throw new HopTransformException(BaseMessages.getString(PKG, (String)CONST_DIMENSION_LOOKUP_EXCEPTION_KEY_FIELD_NOT_FOUND, (String[])new String[]{key.getName()}));
                }
                ((DimensionLookupData)this.data).preloadIndexes.add(index);
            }
        }
        catch (Exception e) {
            throw new HopException("Error encountered during cache pre-load", (Throwable)e);
        }
    }

    private synchronized Object[] lookupValues(IRowMeta rowMeta, Object[] row) throws HopException {
        Object[] lookupRow;
        IRowMeta lookupRowMeta;
        DimensionLookupMeta.DLFields f = ((DimensionLookupMeta)this.meta).getFields();
        Date valueDate = this.determineDimensionUpdatedDate(row);
        Object[] returnRow = null;
        if (!((DimensionLookupMeta)this.meta).isUpdate() && ((DimensionLookupMeta)this.meta).isPreloadingCache()) {
            IRowMeta preloadRowMeta = ((DimensionLookupData)this.data).preloadCache.getRowMeta();
            ((DimensionLookupData)this.data).returnRowMeta = ((DimensionLookupData)this.data).preloadCache.getRowMeta();
            lookupRowMeta = preloadRowMeta;
            lookupRow = new Object[preloadRowMeta.size()];
            for (i = 0; i < ((DimensionLookupData)this.data).preloadIndexes.size(); ++i) {
                Object toData;
                int from = ((DimensionLookupData)this.data).preloadIndexes.get(i);
                int to = ((DimensionLookupData)this.data).preloadCache.getKeyIndexes()[i];
                IValueMeta fromValueMeta = rowMeta.getValueMeta(from);
                IValueMeta toValueMeta = ((DimensionLookupData)this.data).preloadCache.getRowMeta().getValueMeta(to);
                Object fromData = row[from];
                lookupRow[to] = toData = toValueMeta.convertData(fromValueMeta, fromData);
            }
            lookupRow[((DimensionLookupData)this.data).preloadFromDateIndex] = valueDate;
            int index = ((DimensionLookupData)this.data).preloadCache.lookupRow(lookupRow);
            if (index >= 0) {
                returnRow = ((DimensionLookupData)this.data).preloadCache.getRow(index);
            }
        } else {
            lookupRow = new Object[((DimensionLookupData)this.data).lookupRowMeta.size()];
            lookupRowMeta = ((DimensionLookupData)this.data).lookupRowMeta;
            int outputIndex = 0;
            for (i = 0; i < f.getKeys().size(); ++i) {
                lookupRow[outputIndex++] = row[((DimensionLookupData)this.data).keynrs[i]];
            }
            lookupRow[outputIndex++] = valueDate;
            lookupRow[outputIndex] = valueDate;
            if (this.isDebug()) {
                this.logDebug(BaseMessages.getString(PKG, (String)"DimensionLookup.Log.LookupRow", (String[])new String[0]) + ((DimensionLookupData)this.data).lookupRowMeta.getString(lookupRow));
            }
            if (((DimensionLookupMeta)this.meta).getCacheSize() >= 0) {
                returnRow = this.getFromCache(lookupRow, valueDate);
            }
            if (returnRow == null) {
                ((DimensionLookupData)this.data).db.setValues(((DimensionLookupData)this.data).lookupRowMeta, lookupRow, ((DimensionLookupData)this.data).prepStatementLookup);
                returnRow = ((DimensionLookupData)this.data).db.getLookup(((DimensionLookupData)this.data).prepStatementLookup);
                ((DimensionLookupData)this.data).returnRowMeta = ((DimensionLookupData)this.data).db.getReturnRowMeta();
                this.incrementLinesInput();
                if (returnRow != null && ((DimensionLookupMeta)this.meta).getCacheSize() >= 0) {
                    this.addToCache(lookupRow, returnRow);
                }
            }
        }
        if (!((DimensionLookupMeta)this.meta).isUpdate()) {
            if (returnRow == null) {
                returnRow = new Object[((DimensionLookupData)this.data).returnRowMeta.size()];
                returnRow[0] = ((DimensionLookupData)this.data).notFoundTk;
                if (((DimensionLookupMeta)this.meta).getCacheSize() >= 0) {
                    returnRow[returnRow.length - 2] = ((DimensionLookupData)this.data).minDate;
                    returnRow[returnRow.length - 1] = ((DimensionLookupData)this.data).maxDate;
                }
            }
        } else {
            Date valueDateFrom = null;
            Date valueDateTo = null;
            if (returnRow == null) {
                Long technicalKey;
                if (this.isRowLevel()) {
                    this.logRowlevel(BaseMessages.getString(PKG, (String)"DimensionLookup.Log.NoDimensionEntryFound", (String[])new String[0]) + lookupRowMeta.getString(lookupRow) + ")");
                }
                valueDateFrom = ((DimensionLookupData)this.data).startDateAlternative == DimensionLookupMeta.StartDateAlternative.SYSTEM_DATE ? valueDate : ((DimensionLookupData)this.data).minDate;
                valueDateTo = ((DimensionLookupData)this.data).maxDate;
                valueVersion = 1L;
                DimensionLookupMeta.TechnicalKeyCreationMethod creationMethod = f.getReturns().getCreationMethod();
                if (creationMethod == null) {
                    throw new HopTransformException("Please specify a valid method for creating new technical (surrogate) keys");
                }
                switch (creationMethod) {
                    case TABLE_MAXIMUM: {
                        technicalKey = ((DimensionLookupData)this.data).db.getNextValue(((DimensionLookupData)this.data).realSchemaName, ((DimensionLookupData)this.data).realTableName, f.getReturns().getKeyField());
                        break;
                    }
                    case AUTO_INCREMENT: {
                        technicalKey = null;
                        break;
                    }
                    case SEQUENCE: {
                        technicalKey = ((DimensionLookupData)this.data).db.getNextSequenceValue(((DimensionLookupData)this.data).realSchemaName, ((DimensionLookupMeta)this.meta).getSequenceName(), f.getReturns().getKeyField());
                        if (technicalKey == null || !this.isRowLevel()) break;
                        this.logRowlevel(BaseMessages.getString(PKG, (String)"DimensionLookup.Log.FoundNextSequence", (String[])new String[0]) + technicalKey.toString());
                        break;
                    }
                    default: {
                        throw new HopTransformException("Unknown technical key creation method encountered: " + creationMethod);
                    }
                }
                technicalKey = this.dimInsert(((DimensionLookupData)this.data).inputRowMeta, row, technicalKey, true, valueVersion, valueDateFrom, valueDateTo);
                this.incrementLinesOutput();
                returnRow = new Object[((DimensionLookupData)this.data).returnRowMeta.size()];
                int returnIndex = 0;
                returnRow[returnIndex] = technicalKey;
                if (this.isRowLevel()) {
                    this.logRowlevel(BaseMessages.getString(PKG, (String)"DimensionLookup.Log.AddedDimensionEntry", (String[])new String[0]) + ((DimensionLookupData)this.data).returnRowMeta.getString(returnRow));
                }
            } else {
                if (this.isRowLevel()) {
                    this.logRowlevel(BaseMessages.getString(PKG, (String)"DimensionLookup.Log.DimensionEntryFound", (String[])new String[0]) + ((DimensionLookupData)this.data).returnRowMeta.getString(returnRow));
                }
                Long technicalKey = ((DimensionLookupData)this.data).returnRowMeta.getInteger(returnRow, 0);
                valueVersion = ((DimensionLookupData)this.data).returnRowMeta.getInteger(returnRow, 1);
                valueDateFrom = ((DimensionLookupMeta)this.meta).getMinDate();
                valueDateTo = ((DimensionLookupMeta)this.meta).getMaxDate();
                boolean insert = false;
                boolean identical = true;
                boolean punch = false;
                if (this.columnLookupArray == null) {
                    this.columnLookupArray = new int[f.getFields().size()];
                    Arrays.fill(this.columnLookupArray, -1);
                }
                int returnRowColNum = -1;
                String findColumn = null;
                for (int i = 0; i < f.getFields().size(); ++i) {
                    int cmp;
                    DimensionLookupMeta.DLField field = f.getFields().get(i);
                    if (((DimensionLookupData)this.data).fieldnrs[i] < 0) continue;
                    IValueMeta v1 = ((DimensionLookupData)this.data).outputRowMeta.getValueMeta(((DimensionLookupData)this.data).fieldnrs[i]);
                    Object valueData1 = row[((DimensionLookupData)this.data).fieldnrs[i]];
                    findColumn = field.getName();
                    IValueMeta v2 = null;
                    Object valueData2 = null;
                    returnRowColNum = this.columnLookupArray[i];
                    if (returnRowColNum == -1) {
                        for (int j = 2; j < ((DimensionLookupData)this.data).returnRowMeta.size(); ++j) {
                            v2 = ((DimensionLookupData)this.data).returnRowMeta.getValueMeta(j);
                            if (v2.getName() != null && v2.getName().equalsIgnoreCase(findColumn)) {
                                this.columnLookupArray[i] = j;
                                valueData2 = returnRow[j];
                                break;
                            }
                            v2 = null;
                        }
                    } else {
                        v2 = ((DimensionLookupData)this.data).returnRowMeta.getValueMeta(returnRowColNum);
                        valueData2 = returnRow[returnRowColNum];
                    }
                    if (v2 == null) {
                        throw new HopTransformException(BaseMessages.getString(PKG, (String)"DimensionLookup.Exception.ErrorDetectedInComparingFields", (String[])new String[]{field.getName()}));
                    }
                    try {
                        cmp = v1.compare(valueData1, v2, valueData2);
                    }
                    catch (ClassCastException e) {
                        throw new HopTransformException("Error comparing values", (Throwable)e);
                    }
                    if (cmp != 0) {
                        identical = false;
                    }
                    if (cmp != 0 && field.getUpdateType() == DimensionLookupMeta.DimensionUpdateType.INSERT) {
                        insert = true;
                    }
                    if (cmp != 0 && field.getUpdateType() == DimensionLookupMeta.DimensionUpdateType.PUNCH_THROUGH) {
                        punch = true;
                    }
                    if (!this.isRowLevel()) continue;
                    this.logRowlevel(BaseMessages.getString(PKG, (String)"DimensionLookup.Log.ComparingValues", (String[])new String[]{"" + v1, "" + v2, String.valueOf(cmp), String.valueOf(identical), String.valueOf(insert), String.valueOf(punch)}));
                }
                if (!insert) {
                    if (!identical) {
                        if (this.isRowLevel()) {
                            this.logRowlevel(BaseMessages.getString(PKG, (String)"DimensionLookup.Log.UpdateRowWithValues", (String[])new String[0]) + ((DimensionLookupData)this.data).inputRowMeta.getString(row));
                        }
                        this.dimUpdate(rowMeta, row, technicalKey, valueDate);
                        this.incrementLinesUpdated();
                        if (((DimensionLookupMeta)this.meta).getCacheSize() >= 0) {
                            Object[] values = this.getCacheValues(rowMeta, row, technicalKey, valueVersion, valueDateFrom, valueDateTo);
                            this.addToCache(lookupRow, values);
                        }
                    } else {
                        if (this.isRowLevel()) {
                            this.logRowlevel(BaseMessages.getString(PKG, (String)"DimensionLookup.Log.SkipLine", (String[])new String[0]));
                        }
                        this.incrementLinesSkipped();
                    }
                } else {
                    if (this.isRowLevel()) {
                        this.logRowlevel(BaseMessages.getString(PKG, (String)"DimensionLookup.Log.InsertNewVersion", (String[])new String[0]) + technicalKey.toString());
                    }
                    Long valueNewVersion = valueVersion + 1L;
                    valueDateFrom = valueDate;
                    valueDateTo = ((DimensionLookupData)this.data).maxDate;
                    if (((DimensionLookupData)this.data).databaseMeta.supportsAutoinc() && this.isAutoIncrement()) {
                        technicalKey = null;
                    } else if (((DimensionLookupData)this.data).databaseMeta.supportsSequences() && ((DimensionLookupMeta)this.meta).getSequenceName() != null && ((DimensionLookupMeta)this.meta).getSequenceName().length() > 0) {
                        technicalKey = ((DimensionLookupData)this.data).db.getNextSequenceValue(((DimensionLookupData)this.data).realSchemaName, ((DimensionLookupMeta)this.meta).getSequenceName(), f.getReturns().getKeyField());
                        if (technicalKey != null && this.isRowLevel()) {
                            this.logRowlevel(BaseMessages.getString(PKG, (String)"DimensionLookup.Log.FoundNextSequence2", (String[])new String[0]) + technicalKey.toString());
                        }
                    } else {
                        technicalKey = ((DimensionLookupData)this.data).db.getNextValue(((DimensionLookupData)this.data).realSchemaName, ((DimensionLookupData)this.data).realTableName, f.getReturns().getKeyField());
                    }
                    technicalKey = this.dimInsert(rowMeta, row, technicalKey, false, valueNewVersion, valueDateFrom, valueDateTo);
                    this.incrementLinesOutput();
                    if (((DimensionLookupMeta)this.meta).getCacheSize() >= 0) {
                        Object[] values = this.getCacheValues(rowMeta, row, technicalKey, valueNewVersion, valueDateFrom, valueDateTo);
                        this.addToCache(lookupRow, values);
                    }
                }
                if (punch) {
                    this.dimPunchThrough(rowMeta, row);
                    this.incrementLinesUpdated();
                }
                returnRow = new Object[((DimensionLookupData)this.data).returnRowMeta.size()];
                returnRow[0] = technicalKey;
                if (this.isRowLevel()) {
                    this.logRowlevel(BaseMessages.getString(PKG, (String)"DimensionLookup.Log.TechnicalKey", (String[])new String[0]) + technicalKey);
                }
            }
        }
        if (this.isRowLevel()) {
            this.logRowlevel(BaseMessages.getString(PKG, (String)"DimensionLookup.Log.AddValuesToRow", (String[])new String[0]) + ((DimensionLookupData)this.data).returnRowMeta.getString(returnRow));
        }
        Object[] outputRow = RowDataUtil.createResizedCopy((Object[])row, (int)((DimensionLookupData)this.data).outputRowMeta.size());
        int outputIndex = rowMeta.size();
        int inputIndex = 0;
        if (((DimensionLookupData)this.data).returnRowMeta.getValueMeta(0).isBigNumber() && returnRow[0] instanceof Long) {
            if (this.isDebug()) {
                this.log.logDebug("Changing the type of the technical key from TYPE_BIGNUMBER to an TYPE_INTEGER");
            }
            IValueMeta tkValueMeta = ((DimensionLookupData)this.data).returnRowMeta.getValueMeta(0);
            ((DimensionLookupData)this.data).returnRowMeta.setValueMeta(0, ValueMetaFactory.cloneValueMeta((IValueMeta)tkValueMeta, (int)5));
        }
        outputRow[outputIndex++] = ((DimensionLookupData)this.data).returnRowMeta.getInteger(returnRow, inputIndex++);
        ++inputIndex;
        while (inputIndex < returnRow.length && outputIndex < outputRow.length) {
            outputRow[outputIndex] = returnRow[inputIndex];
            ++outputIndex;
            ++inputIndex;
        }
        return outputRow;
    }

    private void setDimLookup(IRowMeta rowMeta) throws HopException {
        DimensionLookupMeta.DLFields f = ((DimensionLookupMeta)this.meta).getFields();
        ((DimensionLookupData)this.data).lookupRowMeta = new RowMeta();
        String sql = "SELECT " + ((DimensionLookupData)this.data).databaseMeta.quoteField(f.getReturns().getKeyField()) + ", " + ((DimensionLookupData)this.data).databaseMeta.quoteField(f.getReturns().getVersionField());
        for (DimensionLookupMeta.DLField field : f.getFields()) {
            if (!StringUtils.isNotEmpty((String)field.getLookup()) || !this.isLookupOrUpdateTypeWithArgument(((DimensionLookupMeta)this.meta).isUpdate(), field)) continue;
            sql = sql + ", " + ((DimensionLookupData)this.data).databaseMeta.quoteField(field.getLookup());
            if (!StringUtils.isNotEmpty((String)field.getName()) || field.getLookup().equals(field.getName())) continue;
            sql = sql + " AS " + ((DimensionLookupData)this.data).databaseMeta.quoteField(field.getName());
        }
        if (((DimensionLookupMeta)this.meta).getCacheSize() >= 0) {
            sql = sql + ", " + ((DimensionLookupData)this.data).databaseMeta.quoteField(f.getDate().getFrom()) + ", " + ((DimensionLookupData)this.data).databaseMeta.quoteField(f.getDate().getTo());
        }
        sql = sql + " FROM " + ((DimensionLookupData)this.data).schemaTable + CONST_WHERE;
        for (int i = 0; i < f.getKeys().size(); ++i) {
            DimensionLookupMeta.DLKey key = f.getKeys().get(i);
            if (i != 0) {
                sql = sql + " AND ";
            }
            sql = sql + ((DimensionLookupData)this.data).databaseMeta.quoteField(key.getLookup()) + " = ? ";
            ((DimensionLookupData)this.data).lookupRowMeta.addValueMeta(rowMeta.getValueMeta(((DimensionLookupData)this.data).keynrs[i]));
        }
        String dateFromField = ((DimensionLookupData)this.data).databaseMeta.quoteField(f.getDate().getFrom());
        String dateToField = ((DimensionLookupData)this.data).databaseMeta.quoteField(f.getDate().getTo());
        if (((DimensionLookupMeta)this.meta).isUsingStartDateAlternative() && ((DimensionLookupMeta)this.meta).getStartDateAlternative() == DimensionLookupMeta.StartDateAlternative.NULL || ((DimensionLookupMeta)this.meta).getStartDateAlternative() == DimensionLookupMeta.StartDateAlternative.COLUMN_VALUE) {
            sql = sql + " AND ( " + dateFromField + " IS NULL OR " + dateFromField + " <= ? )" + Const.CR;
            sql = sql + " AND " + dateToField + " > ?" + Const.CR;
            ((DimensionLookupData)this.data).lookupRowMeta.addValueMeta((IValueMeta)new ValueMetaDate(f.getDate().getFrom()));
            ((DimensionLookupData)this.data).lookupRowMeta.addValueMeta((IValueMeta)new ValueMetaDate(f.getDate().getTo()));
        } else {
            sql = sql + " AND ? >= " + dateFromField + Const.CR;
            sql = sql + " AND ? < " + dateToField + Const.CR;
            ((DimensionLookupData)this.data).lookupRowMeta.addValueMeta((IValueMeta)new ValueMetaDate(f.getDate().getFrom()));
            ((DimensionLookupData)this.data).lookupRowMeta.addValueMeta((IValueMeta)new ValueMetaDate(f.getDate().getTo()));
        }
        try {
            this.logDetailed("Dimension Lookup setting preparedStatement to [" + sql + "]");
            ((DimensionLookupData)this.data).prepStatementLookup = ((DimensionLookupData)this.data).db.getConnection().prepareStatement(((DimensionLookupData)this.data).databaseMeta.stripCR(sql));
            if (((DimensionLookupData)this.data).databaseMeta.supportsSetMaxRows()) {
                ((DimensionLookupData)this.data).prepStatementLookup.setMaxRows(1);
            }
            if (((DimensionLookupData)this.data).databaseMeta.getIDatabase().isMySqlVariant()) {
                ((DimensionLookupData)this.data).prepStatementLookup.setFetchSize(0);
            }
            this.logDetailed("Finished preparing dimension lookup statement.");
        }
        catch (SQLException ex) {
            throw new HopDatabaseException("Unable to prepare dimension lookup", (Throwable)ex);
        }
    }

    protected boolean isAutoIncrement() {
        return ((DimensionLookupMeta)this.meta).getFields().getReturns().getCreationMethod() == DimensionLookupMeta.TechnicalKeyCreationMethod.AUTO_INCREMENT;
    }

    public Long dimInsert(IRowMeta inputRowMeta, Object[] row, Long technicalKey, boolean newEntry, Long versionNr, Date dateFrom, Date dateTo) throws HopException {
        int i;
        DimensionLookupMeta.DLFields f = ((DimensionLookupMeta)this.meta).getFields();
        if (((DimensionLookupData)this.data).prepStatementInsert == null && ((DimensionLookupData)this.data).prepStatementUpdate == null) {
            DimensionLookupMeta.DLField field2;
            int i2;
            RowMeta insertRowMeta = new RowMeta();
            String sql = "INSERT INTO " + ((DimensionLookupData)this.data).schemaTable + "( ";
            if (!this.isAutoIncrement()) {
                sql = sql + ((DimensionLookupData)this.data).databaseMeta.quoteField(f.getReturns().getKeyField()) + ", ";
                insertRowMeta.addValueMeta(((DimensionLookupData)this.data).outputRowMeta.getValueMeta(inputRowMeta.size()));
            } else if (((DimensionLookupData)this.data).databaseMeta.needsPlaceHolder()) {
                sql = sql + "0, ";
            }
            sql = sql + ((DimensionLookupData)this.data).databaseMeta.quoteField(f.getReturns().getVersionField()) + ", " + ((DimensionLookupData)this.data).databaseMeta.quoteField(f.getDate().getFrom()) + ", " + ((DimensionLookupData)this.data).databaseMeta.quoteField(f.getDate().getTo());
            insertRowMeta.addValueMeta((IValueMeta)new ValueMetaInteger(f.getReturns().getVersionField()));
            insertRowMeta.addValueMeta((IValueMeta)new ValueMetaDate(f.getDate().getFrom()));
            insertRowMeta.addValueMeta((IValueMeta)new ValueMetaDate(f.getDate().getTo()));
            for (i2 = 0; i2 < f.getKeys().size(); ++i2) {
                DimensionLookupMeta.DLKey key = f.getKeys().get(i2);
                sql = sql + ", " + ((DimensionLookupData)this.data).databaseMeta.quoteField(key.getLookup());
                insertRowMeta.addValueMeta(inputRowMeta.getValueMeta(((DimensionLookupData)this.data).keynrs[i2]));
            }
            for (i2 = 0; i2 < f.getFields().size(); ++i2) {
                field2 = f.getFields().get(i2);
                if (!((DimensionLookupMeta)this.meta).isUpdate() || !field2.getUpdateType().isWithArgument()) continue;
                sql = sql + ", " + ((DimensionLookupData)this.data).databaseMeta.quoteField(field2.getLookup());
                insertRowMeta.addValueMeta(inputRowMeta.getValueMeta(((DimensionLookupData)this.data).fieldnrs[i2]));
            }
            for (i2 = 0; i2 < f.getFields().size(); ++i2) {
                field2 = f.getFields().get(i2);
                Object valueMeta = null;
                switch (field2.getUpdateType()) {
                    case DATE_INSERTED_UPDATED: 
                    case DATE_INSERTED: {
                        valueMeta = new ValueMetaDate(field2.getLookup());
                        break;
                    }
                    case LAST_VERSION: {
                        valueMeta = new ValueMetaBoolean(field2.getLookup());
                        break;
                    }
                }
                if (valueMeta == null) continue;
                sql = sql + ", " + ((DimensionLookupData)this.data).databaseMeta.quoteField(valueMeta.getName());
                insertRowMeta.addValueMeta((IValueMeta)valueMeta);
            }
            sql = sql + ") VALUES (";
            if (!this.isAutoIncrement()) {
                sql = sql + "?, ";
            }
            sql = sql + "?, ?, ?";
            for (i2 = 0; i2 < ((DimensionLookupData)this.data).keynrs.length; ++i2) {
                sql = sql + ", ?";
            }
            for (DimensionLookupMeta.DLField field2 : f.getFields()) {
                if (!((DimensionLookupMeta)this.meta).isUpdate() || !field2.getUpdateType().isWithArgument()) continue;
                sql = sql + ", ?";
            }
            for (DimensionLookupMeta.DLField field2 : f.getFields()) {
                switch (field2.getUpdateType()) {
                    case DATE_INSERTED_UPDATED: 
                    case DATE_INSERTED: 
                    case LAST_VERSION: {
                        sql = sql + ", ?";
                        break;
                    }
                }
            }
            sql = sql + " )";
            try {
                if (technicalKey == null && ((DimensionLookupData)this.data).databaseMeta.supportsAutoGeneratedKeys()) {
                    this.logDetailed("SQL w/ return keys=[" + sql + "]");
                    ((DimensionLookupData)this.data).prepStatementInsert = ((DimensionLookupData)this.data).db.getConnection().prepareStatement(((DimensionLookupData)this.data).databaseMeta.stripCR(sql), 1);
                } else {
                    this.logDetailed("SQL=[" + sql + "]");
                    ((DimensionLookupData)this.data).prepStatementInsert = ((DimensionLookupData)this.data).db.getConnection().prepareStatement(((DimensionLookupData)this.data).databaseMeta.stripCR(sql));
                }
            }
            catch (SQLException ex) {
                throw new HopDatabaseException("Unable to prepare dimension insert :" + Const.CR + sql, (Throwable)ex);
            }
            RowMeta updateRowMeta = new RowMeta();
            String sqlUpdate = CONST_UPDATE + ((DimensionLookupData)this.data).schemaTable + Const.CR;
            sqlUpdate = sqlUpdate + "SET " + ((DimensionLookupData)this.data).databaseMeta.quoteField(f.getDate().getTo()) + " = ?" + Const.CR;
            updateRowMeta.addValueMeta((IValueMeta)new ValueMetaDate(f.getDate().getTo()));
            for (DimensionLookupMeta.DLField field3 : f.getFields()) {
                ValueMetaDate valueMeta = null;
                switch (field3.getUpdateType()) {
                    case DATE_INSERTED_UPDATED: 
                    case DATE_UPDATED: {
                        valueMeta = new ValueMetaDate(field3.getLookup());
                        break;
                    }
                    case LAST_VERSION: {
                        valueMeta = new ValueMetaBoolean(field3.getLookup());
                        break;
                    }
                }
                if (valueMeta == null) continue;
                sqlUpdate = sqlUpdate + ", " + ((DimensionLookupData)this.data).databaseMeta.quoteField(valueMeta.getName()) + " = ?" + Const.CR;
                updateRowMeta.addValueMeta((IValueMeta)valueMeta);
            }
            sqlUpdate = sqlUpdate + "WHERE ";
            for (int i3 = 0; i3 < f.getKeys().size(); ++i3) {
                DimensionLookupMeta.DLKey key = f.getKeys().get(i3);
                if (i3 > 0) {
                    sqlUpdate = sqlUpdate + CONST_AND;
                }
                sqlUpdate = sqlUpdate + ((DimensionLookupData)this.data).databaseMeta.quoteField(key.getLookup()) + " = ?" + Const.CR;
                updateRowMeta.addValueMeta(inputRowMeta.getValueMeta(((DimensionLookupData)this.data).keynrs[i3]));
            }
            sqlUpdate = sqlUpdate + CONST_AND + ((DimensionLookupData)this.data).databaseMeta.quoteField(f.getReturns().getVersionField()) + " = ? ";
            updateRowMeta.addValueMeta((IValueMeta)new ValueMetaInteger(f.getReturns().getVersionField()));
            try {
                this.logDetailed("Preparing update: " + Const.CR + sqlUpdate + Const.CR);
                ((DimensionLookupData)this.data).prepStatementUpdate = ((DimensionLookupData)this.data).db.getConnection().prepareStatement(((DimensionLookupData)this.data).databaseMeta.stripCR(sqlUpdate));
            }
            catch (SQLException ex) {
                throw new HopDatabaseException("Unable to prepare dimension update :" + Const.CR + sqlUpdate, (Throwable)ex);
            }
            ((DimensionLookupData)this.data).insertRowMeta = insertRowMeta;
            ((DimensionLookupData)this.data).updateRowMeta = updateRowMeta;
        }
        Object[] insertRow = new Object[((DimensionLookupData)this.data).insertRowMeta.size()];
        int insertIndex = 0;
        if (!this.isAutoIncrement()) {
            insertRow[insertIndex++] = technicalKey;
        }
        insertRow[insertIndex++] = versionNr;
        switch (((DimensionLookupData)this.data).startDateAlternative) {
            case NONE: {
                insertRow[insertIndex++] = dateFrom;
                break;
            }
            case SYSTEM_DATE: {
                insertRow[insertIndex++] = dateFrom;
                break;
            }
            case PIPELINE_START: {
                insertRow[insertIndex++] = this.getPipeline().getExecutionStartDate();
                break;
            }
            case NULL: {
                insertRow[insertIndex++] = null;
                break;
            }
            case COLUMN_VALUE: {
                insertRow[insertIndex++] = inputRowMeta.getDate(row, ((DimensionLookupData)this.data).startDateFieldIndex);
                break;
            }
            default: {
                throw new HopTransformException(BaseMessages.getString(PKG, (String)"DimensionLookup.Exception.IllegalStartDateSelection", (String[])new String[]{((DimensionLookupData)this.data).startDateAlternative.getDescription()}));
            }
        }
        insertRow[insertIndex++] = dateTo;
        for (i = 0; i < ((DimensionLookupData)this.data).keynrs.length; ++i) {
            insertRow[insertIndex++] = row[((DimensionLookupData)this.data).keynrs[i]];
        }
        for (i = 0; i < ((DimensionLookupData)this.data).fieldnrs.length; ++i) {
            if (((DimensionLookupData)this.data).fieldnrs[i] < 0) continue;
            insertRow[insertIndex++] = row[((DimensionLookupData)this.data).fieldnrs[i]];
        }
        for (DimensionLookupMeta.DLField field2 : f.getFields()) {
            switch (field2.getUpdateType()) {
                case DATE_INSERTED_UPDATED: 
                case DATE_INSERTED: {
                    insertRow[insertIndex++] = new Date();
                    break;
                }
                case LAST_VERSION: {
                    insertRow[insertIndex++] = Boolean.TRUE;
                    break;
                }
            }
        }
        if (this.isDebug()) {
            this.logDebug("rins, size=" + ((DimensionLookupData)this.data).insertRowMeta.size() + ", values=" + ((DimensionLookupData)this.data).insertRowMeta.getString(insertRow));
        }
        ((DimensionLookupData)this.data).db.setValues(((DimensionLookupData)this.data).insertRowMeta, insertRow, ((DimensionLookupData)this.data).prepStatementInsert);
        ((DimensionLookupData)this.data).db.insertRow(((DimensionLookupData)this.data).prepStatementInsert);
        if (this.isDebug()) {
            this.logDebug("Row inserted!");
        }
        if (technicalKey == null && ((DimensionLookupData)this.data).databaseMeta.supportsAutoGeneratedKeys()) {
            try {
                RowMetaAndData keys = ((DimensionLookupData)this.data).db.getGeneratedKeys(((DimensionLookupData)this.data).prepStatementInsert);
                if (keys.getRowMeta().size() <= 0) {
                    throw new HopDatabaseException("Unable to retrieve value of auto-generated technical key : no value found!");
                }
                technicalKey = keys.getRowMeta().getInteger(keys.getData(), 0);
            }
            catch (Exception e) {
                throw new HopDatabaseException("Unable to retrieve value of auto-generated technical key : unexpected error: ", (Throwable)e);
            }
        }
        if (!newEntry) {
            Object[] updateRow = new Object[((DimensionLookupData)this.data).updateRowMeta.size()];
            int updateIndex = 0;
            switch (((DimensionLookupData)this.data).startDateAlternative) {
                case NONE: {
                    updateRow[updateIndex++] = dateFrom;
                    break;
                }
                case SYSTEM_DATE: {
                    updateRow[updateIndex++] = new Date();
                    break;
                }
                case PIPELINE_START: {
                    updateRow[updateIndex++] = this.getPipeline().getExecutionStartDate();
                    break;
                }
                case NULL: {
                    updateRow[updateIndex++] = null;
                    break;
                }
                case COLUMN_VALUE: {
                    updateRow[updateIndex++] = inputRowMeta.getDate(row, ((DimensionLookupData)this.data).startDateFieldIndex);
                    break;
                }
                default: {
                    throw new HopTransformException(BaseMessages.getString((String)"DimensionLookup.Exception.IllegalStartDateSelection", (String)((DimensionLookupData)this.data).startDateAlternative.getDescription()));
                }
            }
            for (DimensionLookupMeta.DLField field3 : f.getFields()) {
                switch (field3.getUpdateType()) {
                    case DATE_INSERTED_UPDATED: 
                    case DATE_UPDATED: {
                        updateRow[updateIndex++] = new Date();
                        break;
                    }
                    case LAST_VERSION: {
                        updateRow[updateIndex++] = Boolean.FALSE;
                        break;
                    }
                }
            }
            for (int i4 = 0; i4 < ((DimensionLookupData)this.data).keynrs.length; ++i4) {
                updateRow[updateIndex++] = row[((DimensionLookupData)this.data).keynrs[i4]];
            }
            updateRow[updateIndex] = versionNr - 1L;
            if (this.isRowLevel()) {
                this.logRowlevel("UPDATE using rupd=" + ((DimensionLookupData)this.data).updateRowMeta.getString(updateRow));
            }
            ((DimensionLookupData)this.data).db.setValues(((DimensionLookupData)this.data).updateRowMeta, updateRow, ((DimensionLookupData)this.data).prepStatementUpdate);
            if (this.isDebug()) {
                this.logDebug("Values set for update (" + ((DimensionLookupData)this.data).updateRowMeta.size() + ")");
            }
            ((DimensionLookupData)this.data).db.insertRow(((DimensionLookupData)this.data).prepStatementUpdate);
            if (this.isDebug()) {
                this.logDebug("Row updated!");
            }
        }
        return technicalKey;
    }

    public boolean isRowLevel() {
        return this.log.isRowLevel();
    }

    public boolean isDebug() {
        return this.log.isDebug();
    }

    public void dimUpdate(IRowMeta rowMeta, Object[] row, Long dimkey, Date valueDate) throws HopDatabaseException {
        DimensionLookupMeta.DLFields f = ((DimensionLookupMeta)this.meta).getFields();
        if (((DimensionLookupData)this.data).prepStatementDimensionUpdate == null) {
            ((DimensionLookupData)this.data).dimensionUpdateRowMeta = new RowMeta();
            String sql = CONST_UPDATE + ((DimensionLookupData)this.data).schemaTable + Const.CR + "SET ";
            boolean comma = false;
            for (int i = 0; i < f.getFields().size(); ++i) {
                DimensionLookupMeta.DLField field = f.getFields().get(i);
                if (!((DimensionLookupMeta)this.meta).isUpdate() || !field.getUpdateType().isWithArgument()) continue;
                sql = comma ? sql + ", " : sql + "  ";
                comma = true;
                sql = sql + ((DimensionLookupData)this.data).databaseMeta.quoteField(field.getLookup()) + " = ?" + Const.CR;
                ((DimensionLookupData)this.data).dimensionUpdateRowMeta.addValueMeta(rowMeta.getValueMeta(((DimensionLookupData)this.data).fieldnrs[i]));
            }
            for (DimensionLookupMeta.DLField field : f.getFields()) {
                ValueMetaDate valueMeta = null;
                switch (field.getUpdateType()) {
                    case DATE_INSERTED_UPDATED: 
                    case DATE_UPDATED: {
                        valueMeta = new ValueMetaDate(field.getLookup());
                        break;
                    }
                }
                if (valueMeta == null) continue;
                sql = comma ? sql + ", " : sql + "  ";
                comma = true;
                sql = sql + ((DimensionLookupData)this.data).databaseMeta.quoteField(valueMeta.getName()) + " = ?" + Const.CR;
                ((DimensionLookupData)this.data).dimensionUpdateRowMeta.addValueMeta((IValueMeta)valueMeta);
            }
            sql = sql + "WHERE  " + ((DimensionLookupData)this.data).databaseMeta.quoteField(f.getReturns().getKeyField()) + " = ?";
            ((DimensionLookupData)this.data).dimensionUpdateRowMeta.addValueMeta((IValueMeta)new ValueMetaInteger(f.getReturns().getKeyField()));
            try {
                if (this.isDebug()) {
                    this.logDebug("Preparing statement: [" + sql + "]");
                }
                ((DimensionLookupData)this.data).prepStatementDimensionUpdate = ((DimensionLookupData)this.data).db.getConnection().prepareStatement(((DimensionLookupData)this.data).databaseMeta.stripCR(sql));
            }
            catch (SQLException ex) {
                throw new HopDatabaseException("Couldn't prepare statement :" + Const.CR + sql, (Throwable)ex);
            }
        }
        Object[] dimensionUpdateRow = new Object[((DimensionLookupData)this.data).dimensionUpdateRowMeta.size()];
        int updateIndex = 0;
        for (int i = 0; i < ((DimensionLookupData)this.data).fieldnrs.length; ++i) {
            if (((DimensionLookupData)this.data).fieldnrs[i] < 0) continue;
            dimensionUpdateRow[updateIndex++] = row[((DimensionLookupData)this.data).fieldnrs[i]];
        }
        for (DimensionLookupMeta.DLField field : f.getFields()) {
            switch (field.getUpdateType()) {
                case DATE_INSERTED_UPDATED: 
                case DATE_UPDATED: {
                    dimensionUpdateRow[updateIndex++] = valueDate;
                    break;
                }
            }
        }
        dimensionUpdateRow[updateIndex] = dimkey;
        ((DimensionLookupData)this.data).db.setValues(((DimensionLookupData)this.data).dimensionUpdateRowMeta, dimensionUpdateRow, ((DimensionLookupData)this.data).prepStatementDimensionUpdate);
        ((DimensionLookupData)this.data).db.insertRow(((DimensionLookupData)this.data).prepStatementDimensionUpdate);
    }

    public void dimPunchThrough(IRowMeta rowMeta, Object[] row) throws HopDatabaseException {
        int i;
        DimensionLookupMeta.DLField field2;
        DimensionLookupMeta.DLFields f = ((DimensionLookupMeta)this.meta).getFields();
        if (((DimensionLookupData)this.data).prepStatementPunchThrough == null) {
            ((DimensionLookupData)this.data).punchThroughRowMeta = new RowMeta();
            String sqlUpdate = CONST_UPDATE + ((DimensionLookupData)this.data).schemaTable + Const.CR;
            sqlUpdate = sqlUpdate + "SET ";
            boolean first = true;
            for (int i2 = 0; i2 < f.getFields().size(); ++i2) {
                field2 = f.getFields().get(i2);
                if (field2.getUpdateType() != DimensionLookupMeta.DimensionUpdateType.PUNCH_THROUGH) continue;
                sqlUpdate = !first ? sqlUpdate + ", " : sqlUpdate + "  ";
                first = false;
                sqlUpdate = sqlUpdate + ((DimensionLookupData)this.data).databaseMeta.quoteField(field2.getLookup()) + " = ?" + Const.CR;
                ((DimensionLookupData)this.data).punchThroughRowMeta.addValueMeta(rowMeta.getValueMeta(((DimensionLookupData)this.data).fieldnrs[i2]));
            }
            for (DimensionLookupMeta.DLField field2 : f.getFields()) {
                ValueMetaDate valueMeta = null;
                switch (field2.getUpdateType()) {
                    case DATE_INSERTED_UPDATED: 
                    case DATE_UPDATED: {
                        valueMeta = new ValueMetaDate(field2.getLookup());
                        break;
                    }
                }
                if (valueMeta == null) continue;
                sqlUpdate = sqlUpdate + ", " + ((DimensionLookupData)this.data).databaseMeta.quoteField(valueMeta.getName()) + " = ?" + Const.CR;
                ((DimensionLookupData)this.data).punchThroughRowMeta.addValueMeta((IValueMeta)valueMeta);
            }
            sqlUpdate = sqlUpdate + "WHERE ";
            for (i = 0; i < f.getKeys().size(); ++i) {
                DimensionLookupMeta.DLKey key = f.getKeys().get(i);
                if (i > 0) {
                    sqlUpdate = sqlUpdate + CONST_AND;
                }
                sqlUpdate = sqlUpdate + ((DimensionLookupData)this.data).databaseMeta.quoteField(key.getLookup()) + " = ?" + Const.CR;
                ((DimensionLookupData)this.data).punchThroughRowMeta.addValueMeta(rowMeta.getValueMeta(((DimensionLookupData)this.data).keynrs[i]));
            }
            try {
                ((DimensionLookupData)this.data).prepStatementPunchThrough = ((DimensionLookupData)this.data).db.getConnection().prepareStatement(((DimensionLookupData)this.data).databaseMeta.stripCR(sqlUpdate));
            }
            catch (SQLException ex) {
                throw new HopDatabaseException("Unable to prepare dimension punchThrough update statement : " + Const.CR + sqlUpdate, (Throwable)ex);
            }
        }
        Object[] punchThroughRow = new Object[((DimensionLookupData)this.data).punchThroughRowMeta.size()];
        int punchIndex = 0;
        block12: for (i = 0; i < f.getFields().size(); ++i) {
            field2 = f.getFields().get(i);
            switch (field2.getUpdateType()) {
                case DATE_INSERTED_UPDATED: 
                case DATE_UPDATED: {
                    punchThroughRow[punchIndex++] = new Date();
                    continue block12;
                }
                case PUNCH_THROUGH: {
                    punchThroughRow[punchIndex++] = row[((DimensionLookupData)this.data).fieldnrs[i]];
                    continue block12;
                }
            }
        }
        for (i = 0; i < ((DimensionLookupData)this.data).keynrs.length; ++i) {
            punchThroughRow[punchIndex++] = row[((DimensionLookupData)this.data).keynrs[i]];
        }
        ((DimensionLookupData)this.data).db.setValues(((DimensionLookupData)this.data).punchThroughRowMeta, punchThroughRow, ((DimensionLookupData)this.data).prepStatementPunchThrough);
        ((DimensionLookupData)this.data).db.insertRow(((DimensionLookupData)this.data).prepStatementPunchThrough);
    }

    private Object[] getCacheValues(IRowMeta rowMeta, Object[] row, Long technicalKey, Long valueVersion, Date valueDateFrom, Date valueDateTo) {
        if (((DimensionLookupData)this.data).cacheValueRowMeta == null) {
            return null;
        }
        Object[] cacheValues = new Object[((DimensionLookupData)this.data).cacheValueRowMeta.size()];
        int cacheIndex = 0;
        cacheValues[cacheIndex++] = technicalKey;
        cacheValues[cacheIndex++] = valueVersion;
        for (int i = 0; i < ((DimensionLookupData)this.data).fieldnrs.length; ++i) {
            if (((DimensionLookupData)this.data).fieldnrs[i] < 0) continue;
            cacheValues[cacheIndex++] = row[((DimensionLookupData)this.data).fieldnrs[i]];
        }
        cacheValues[cacheIndex++] = valueDateFrom;
        cacheValues[cacheIndex] = valueDateTo;
        return cacheValues;
    }

    private void addToCache(Object[] keyValues, Object[] returnValues) throws HopValueException {
        if (((DimensionLookupData)this.data).cacheValueRowMeta == null) {
            ((DimensionLookupData)this.data).cacheValueRowMeta = this.assembleCacheValueRowMeta();
        }
        byte[] keyPart = RowMeta.extractData((IRowMeta)((DimensionLookupData)this.data).cacheKeyRowMeta, (Object[])keyValues);
        byte[] valuePart = RowMeta.extractData((IRowMeta)((DimensionLookupData)this.data).cacheValueRowMeta, (Object[])returnValues);
        ((DimensionLookupData)this.data).cache.put(keyPart, valuePart);
        int tenPercent = ((DimensionLookupMeta)this.meta).getCacheSize() / 10;
        if (((DimensionLookupMeta)this.meta).getCacheSize() > 0 && ((DimensionLookupData)this.data).cache.size() > ((DimensionLookupMeta)this.meta).getCacheSize() + tenPercent) {
            Object[] values;
            byte[] value;
            byte[] key;
            int i;
            List keys = ((DimensionLookupData)this.data).cache.getKeys();
            int sizeBefore = keys.size();
            ArrayList<Long> samples = new ArrayList<Long>();
            int transformsize = keys.size() / 5;
            if (transformsize < 1) {
                transformsize = 1;
            }
            for (i = 0; i < keys.size(); i += transformsize) {
                key = (byte[])keys.get(i);
                value = ((DimensionLookupData)this.data).cache.get(key);
                if (value == null) continue;
                values = RowMeta.getRow((IRowMeta)((DimensionLookupData)this.data).cacheValueRowMeta, (byte[])value);
                Long tk = ((DimensionLookupData)this.data).cacheValueRowMeta.getInteger(values, 0);
                samples.add(tk);
            }
            Collections.sort(samples);
            if (samples.size() > 1) {
                ((DimensionLookupData)this.data).smallestCacheKey = (Long)samples.get(1);
            } else if (!samples.isEmpty()) {
                ((DimensionLookupData)this.data).smallestCacheKey = (Long)samples.get(0);
            } else {
                return;
            }
            for (i = 0; i < keys.size(); ++i) {
                long tk;
                key = (byte[])keys.get(i);
                value = ((DimensionLookupData)this.data).cache.get(key);
                if (value == null || (tk = ((DimensionLookupData)this.data).cacheValueRowMeta.getInteger(values = RowMeta.getRow((IRowMeta)((DimensionLookupData)this.data).cacheValueRowMeta, (byte[])value), 0).longValue()) > ((DimensionLookupData)this.data).smallestCacheKey) continue;
                ((DimensionLookupData)this.data).cache.remove((Object)key);
            }
            int sizeAfter = ((DimensionLookupData)this.data).cache.size();
            this.logDetailed("Reduced the lookup cache from " + sizeBefore + " to " + sizeAfter + " rows.");
        }
        if (this.isRowLevel()) {
            this.logRowlevel("Cache store: key=" + Arrays.toString(keyValues) + "    values=" + Arrays.toString(returnValues));
        }
    }

    private IRowMeta assembleCacheValueRowMeta() {
        return ((DimensionLookupData)this.data).returnRowMeta.clone();
    }

    private Object[] getFromCache(Object[] keyValues, Date dateValue) throws HopValueException {
        byte[] key;
        byte[] value;
        if (((DimensionLookupData)this.data).cacheValueRowMeta == null) {
            if (((DimensionLookupData)this.data).returnRowMeta == null) {
                return null;
            }
            ((DimensionLookupData)this.data).cacheValueRowMeta = this.assembleCacheValueRowMeta();
        }
        if ((value = ((DimensionLookupData)this.data).cache.get(key = RowMeta.extractData((IRowMeta)((DimensionLookupData)this.data).cacheKeyRowMeta, (Object[])keyValues))) != null) {
            Date dateTo;
            Object[] row = RowMeta.getRow((IRowMeta)((DimensionLookupData)this.data).cacheValueRowMeta, (byte[])value);
            long time = dateValue.getTime();
            long from = 0L;
            long to = 0L;
            Date dateFrom = (Date)row[row.length - 2];
            if (dateFrom != null) {
                from = dateFrom.getTime();
            }
            if ((dateTo = (Date)row[row.length - 1]) != null) {
                to = dateTo.getTime();
            }
            if (time >= from && time < to) {
                if (this.isRowLevel()) {
                    this.logRowlevel("Cache hit: key=" + ((DimensionLookupData)this.data).cacheKeyRowMeta.getString(keyValues) + "  values=" + ((DimensionLookupData)this.data).cacheValueRowMeta.getString(row));
                }
                return row;
            }
        }
        return null;
    }

    public void checkDimZero() throws HopException {
        String sql;
        RowMetaAndData r;
        Long count;
        if (!((DimensionLookupMeta)this.meta).isUpdate()) {
            return;
        }
        DimensionLookupMeta.DLFields f = ((DimensionLookupMeta)this.meta).getFields();
        int startTechnicalKey = ((DimensionLookupData)this.data).databaseMeta.getNotFoundTK(this.isAutoIncrement());
        if (this.isAutoIncrement() && (count = (r = ((DimensionLookupData)this.data).db.getOneRow(sql = "SELECT count(*) FROM " + ((DimensionLookupData)this.data).schemaTable + CONST_WHERE + ((DimensionLookupData)this.data).databaseMeta.quoteField(f.getReturns().getKeyField()) + " = " + startTechnicalKey)).getRowMeta().getInteger(r.getData(), 0)) != 0L) {
            return;
        }
        sql = "SELECT count(*) FROM " + ((DimensionLookupData)this.data).schemaTable + CONST_WHERE + ((DimensionLookupData)this.data).databaseMeta.quoteField(f.getReturns().getKeyField()) + " = " + startTechnicalKey;
        r = ((DimensionLookupData)this.data).db.getOneRow(sql);
        count = r.getRowMeta().getInteger(r.getData(), 0);
        if (count == 0L) {
            Object isql = null;
            try {
                isql = !((DimensionLookupData)this.data).databaseMeta.supportsAutoinc() || !this.isAutoIncrement() ? "insert into " + ((DimensionLookupData)this.data).schemaTable + "(" + ((DimensionLookupData)this.data).databaseMeta.quoteField(f.getReturns().getKeyField()) + ", " + ((DimensionLookupData)this.data).databaseMeta.quoteField(f.getReturns().getVersionField()) + ") values (0, 1)" : ((DimensionLookupData)this.data).databaseMeta.getSqlInsertAutoIncUnknownDimensionRow(((DimensionLookupData)this.data).schemaTable, ((DimensionLookupData)this.data).databaseMeta.quoteField(f.getReturns().getKeyField()), ((DimensionLookupData)this.data).databaseMeta.quoteField(f.getReturns().getVersionField()));
                ((DimensionLookupData)this.data).db.execStatement(((DimensionLookupData)this.data).databaseMeta.stripCR((String)isql));
            }
            catch (HopException e) {
                throw new HopDatabaseException("Error inserting 'unknown' row in dimension [" + ((DimensionLookupData)this.data).schemaTable + "] : " + isql, (Throwable)e);
            }
        }
    }

    public boolean init() {
        if (!super.init()) {
            return false;
        }
        ((DimensionLookupData)this.data).minDate = ((DimensionLookupMeta)this.meta).getMinDate();
        ((DimensionLookupData)this.data).maxDate = ((DimensionLookupMeta)this.meta).getMaxDate();
        ((DimensionLookupData)this.data).realSchemaName = this.resolve(((DimensionLookupMeta)this.meta).getSchemaName());
        ((DimensionLookupData)this.data).realTableName = this.resolve(((DimensionLookupMeta)this.meta).getTableName());
        if (((DimensionLookupMeta)this.meta).isUsingStartDateAlternative()) {
            ((DimensionLookupData)this.data).startDateAlternative = ((DimensionLookupMeta)this.meta).getStartDateAlternative();
        }
        if (((DimensionLookupData)this.data).startDateAlternative == null) {
            ((DimensionLookupData)this.data).startDateAlternative = DimensionLookupMeta.StartDateAlternative.NONE;
        }
        ((DimensionLookupData)this.data).databaseMeta = this.getPipelineMeta().findDatabase(((DimensionLookupMeta)this.meta).getConnection(), this.variables);
        if (((DimensionLookupData)this.data).databaseMeta == null) {
            this.logError(BaseMessages.getString(PKG, (String)"DimensionLookup.Init.ConnectionMissing", (String[])new String[]{this.getTransformName()}));
            return false;
        }
        ((DimensionLookupData)this.data).db = new Database((ILoggingObject)this, (IVariables)this, ((DimensionLookupData)this.data).databaseMeta);
        try {
            ((DimensionLookupData)this.data).db.connect();
            if (this.log.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"DimensionLookup.Log.ConnectedToDB", (String[])new String[0]));
            }
            ((DimensionLookupData)this.data).db.setCommit(((DimensionLookupMeta)this.meta).getCommitSize());
            return true;
        }
        catch (HopException ke) {
            this.logError(BaseMessages.getString(PKG, (String)"DimensionLookup.Log.ErrorOccurredInProcessing", (String[])new String[0]) + ke.getMessage());
            return false;
        }
    }

    public void dispose() {
        if (((DimensionLookupData)this.data).db != null) {
            try {
                if (!((DimensionLookupData)this.data).db.isAutoCommit()) {
                    if (this.getErrors() == 0L) {
                        ((DimensionLookupData)this.data).db.commit();
                    } else {
                        ((DimensionLookupData)this.data).db.rollback();
                    }
                }
            }
            catch (HopDatabaseException e) {
                this.logError(BaseMessages.getString(PKG, (String)"DimensionLookup.Log.ErrorOccurredInProcessing", (String[])new String[0]) + e.getMessage());
            }
            finally {
                ((DimensionLookupData)this.data).db.disconnect();
            }
        }
        super.dispose();
    }
}

