/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.cubeinput;

import org.apache.hop.core.Const;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transforms.cubeinput.CubeInputMeta;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.apache.hop.ui.pipeline.transform.ComponentSelectionListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class CubeInputDialog
extends BaseTransformDialog {
    private static final Class<?> PKG = CubeInputMeta.class;
    private TextVar wFilename;
    private Text wLimit;
    private Button wAddResult;
    private final CubeInputMeta input;

    public CubeInputDialog(Shell parent, IVariables variables, CubeInputMeta transformMeta, PipelineMeta pipelineMeta) {
        super(parent, variables, (ITransformMeta)transformMeta, pipelineMeta);
        this.input = transformMeta;
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        PropsUi.setLook((Widget)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.input);
        ModifyListener lsMod = e -> this.input.setChanged();
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"CubeInputDialog.Shell.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = PropsUi.getMargin();
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"CubeInputDialog.TransformName.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.right = new FormAttachment(middle, -margin);
        this.fdlTransformName.top = new FormAttachment(0, margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        PropsUi.setLook((Widget)this.wTransformName);
        this.wTransformName.addModifyListener(lsMod);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(middle, 0);
        this.fdTransformName.top = new FormAttachment(0, margin);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        Label wlFilename = new Label((Composite)this.shell, 131072);
        wlFilename.setText(BaseMessages.getString(PKG, (String)"CubeInputDialog.Filename.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlFilename);
        FormData fdlFilename = new FormData();
        fdlFilename.left = new FormAttachment(0, 0);
        fdlFilename.top = new FormAttachment((Control)this.wTransformName, margin + 5);
        fdlFilename.right = new FormAttachment(middle, -margin);
        wlFilename.setLayoutData((Object)fdlFilename);
        Button wbFilename = new Button((Composite)this.shell, 0x1000008);
        PropsUi.setLook((Widget)wbFilename);
        wbFilename.setText(BaseMessages.getString(PKG, (String)"CubeInputDialog.FilenameButton.Label", (String[])new String[0]));
        FormData fdbFilename = new FormData();
        fdbFilename.right = new FormAttachment(100, 0);
        fdbFilename.top = new FormAttachment((Control)this.wTransformName, margin + 5);
        wbFilename.setLayoutData((Object)fdbFilename);
        this.wFilename = new TextVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wFilename);
        this.wFilename.addModifyListener(lsMod);
        FormData fdFilename = new FormData();
        fdFilename.left = new FormAttachment(middle, 0);
        fdFilename.top = new FormAttachment((Control)this.wTransformName, margin + 5);
        fdFilename.right = new FormAttachment((Control)wbFilename, -margin);
        this.wFilename.setLayoutData((Object)fdFilename);
        Label wlLimit = new Label((Composite)this.shell, 131072);
        wlLimit.setText(BaseMessages.getString(PKG, (String)"CubeInputDialog.Limit.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlLimit);
        FormData fdlLimit = new FormData();
        fdlLimit.left = new FormAttachment(0, 0);
        fdlLimit.right = new FormAttachment(middle, -margin);
        fdlLimit.top = new FormAttachment((Control)this.wFilename, margin);
        wlLimit.setLayoutData((Object)fdlLimit);
        this.wLimit = new Text((Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wLimit);
        this.wLimit.addModifyListener(lsMod);
        FormData fdLimit = new FormData();
        fdLimit.left = new FormAttachment(middle, 0);
        fdLimit.top = new FormAttachment((Control)this.wFilename, margin);
        fdLimit.right = new FormAttachment(100, 0);
        this.wLimit.setLayoutData((Object)fdLimit);
        Label wlAddResult = new Label((Composite)this.shell, 131072);
        wlAddResult.setText(BaseMessages.getString(PKG, (String)"CubeInputDialog.AddResult.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlAddResult);
        FormData fdlAddResult = new FormData();
        fdlAddResult.left = new FormAttachment(0, 0);
        fdlAddResult.top = new FormAttachment((Control)this.wLimit, 2 * margin);
        fdlAddResult.right = new FormAttachment(middle, -margin);
        wlAddResult.setLayoutData((Object)fdlAddResult);
        this.wAddResult = new Button((Composite)this.shell, 32);
        PropsUi.setLook((Widget)this.wAddResult);
        this.wAddResult.setToolTipText(BaseMessages.getString(PKG, (String)"CubeInputDialog.AddResult.Tooltip", (String[])new String[0]));
        FormData fdAddResult = new FormData();
        fdAddResult.left = new FormAttachment(middle, 0);
        fdAddResult.top = new FormAttachment((Control)wlAddResult, 0, 0x1000000);
        this.wAddResult.setLayoutData((Object)fdAddResult);
        this.wAddResult.addSelectionListener((SelectionListener)new ComponentSelectionListener((BaseTransformMeta)this.input));
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.setButtonPositions(new Button[]{this.wOk, this.wCancel}, margin, (Control)this.wAddResult);
        this.wCancel.addListener(13, e -> this.cancel());
        this.wOk.addListener(13, e -> this.ok());
        wbFilename.addListener(13, e -> BaseDialog.presentFileDialog((Shell)this.shell, (TextVar)this.wFilename, (IVariables)this.variables, (String[])new String[]{"*.cube", "*"}, (String[])new String[]{BaseMessages.getString(PKG, (String)"CubeInputDialog.FilterNames.CubeFiles", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CubeInputDialog.FilterNames.AllFiles", (String[])new String[0])}, (boolean)true));
        this.getData();
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    public void getData() {
        this.wFilename.setText(Const.NVL((String)this.input.getFile().getName(), (String)""));
        this.wLimit.setText(this.input.getRowLimit());
        this.wAddResult.setSelection(this.input.isAddFilenameResult());
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    private void cancel() {
        this.transformName = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wTransformName.getText())) {
            return;
        }
        this.transformName = this.wTransformName.getText();
        this.input.getFile().setName(this.wFilename.getText());
        this.input.setRowLimit(this.wLimit.getText());
        this.input.setAddFilenameResult(this.wAddResult.getSelection());
        this.dispose();
    }
}

