/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.config;

import org.apache.hop.core.exception.HopException;
import org.apache.hop.metadata.api.HopMetadata;
import org.apache.hop.metadata.api.HopMetadataBase;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadata;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.workflow.config.IWorkflowEngineRunConfiguration;

@HopMetadata(key="workflow-run-configuration", name="i18n::WorkflowRunConfiguration.name", description="i18n::WorkflowRunConfiguration.description", image="ui/images/workflow_run_config.svg", documentationUrl="/metadata-types/workflow-run-config.html")
public class WorkflowRunConfiguration
extends HopMetadataBase
implements Cloneable,
IHopMetadata {
    public static final String GUI_PLUGIN_ELEMENT_PARENT_ID = "WorkflowRunConfiguration-PluginSpecific-Options";
    @HopMetadataProperty
    private String description;
    @HopMetadataProperty
    private IWorkflowEngineRunConfiguration engineRunConfiguration;
    @HopMetadataProperty
    private String executionInfoLocationName;
    @HopMetadataProperty
    protected boolean defaultSelection;

    public WorkflowRunConfiguration() {
    }

    public WorkflowRunConfiguration(String name, String description, String executionInfoLocationName, IWorkflowEngineRunConfiguration engineRunConfiguration, boolean defaultSelection) {
        this();
        this.name = name;
        this.description = description;
        this.executionInfoLocationName = executionInfoLocationName;
        this.engineRunConfiguration = engineRunConfiguration;
        this.defaultSelection = defaultSelection;
    }

    public WorkflowRunConfiguration(WorkflowRunConfiguration c) {
        this.name = c.name;
        this.description = c.description;
        this.executionInfoLocationName = c.executionInfoLocationName;
        if (c.engineRunConfiguration != null) {
            this.engineRunConfiguration = c.engineRunConfiguration.clone();
        }
        this.defaultSelection = c.defaultSelection;
    }

    protected WorkflowRunConfiguration clone() {
        return new WorkflowRunConfiguration(this);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public IWorkflowEngineRunConfiguration getEngineRunConfiguration() {
        return this.engineRunConfiguration;
    }

    public void setEngineRunConfiguration(IWorkflowEngineRunConfiguration engineRunConfiguration) {
        this.engineRunConfiguration = engineRunConfiguration;
    }

    public String getExecutionInfoLocationName() {
        return this.executionInfoLocationName;
    }

    public void setExecutionInfoLocationName(String executionInfoLocationName) {
        this.executionInfoLocationName = executionInfoLocationName;
    }

    public boolean isDefaultSelection() {
        return this.defaultSelection;
    }

    public void setDefaultSelection(boolean defaultSelection) {
        this.defaultSelection = defaultSelection;
    }

    public static final WorkflowRunConfiguration findDefault(IHopMetadataProvider metadataProvider) throws HopException {
        for (WorkflowRunConfiguration runConfiguration : metadataProvider.getSerializer(WorkflowRunConfiguration.class).loadAll()) {
            if (!runConfiguration.isDefaultSelection()) continue;
            return runConfiguration;
        }
        return null;
    }
}

