/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.compress.zip;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipInputStream;
import org.apache.hop.core.compress.CompressionInputStream;
import org.apache.hop.core.compress.ICompressionProvider;

public class ZipCompressionInputStream
extends CompressionInputStream {
    private static final String CONST_NO_VALID_INPUT_STREAM = "Not a valid input stream!";

    public ZipCompressionInputStream(InputStream in, ICompressionProvider provider) throws IOException {
        super(ZipCompressionInputStream.getDelegate(in), provider);
    }

    protected static ZipInputStream getDelegate(InputStream in) {
        ZipInputStream delegate = null;
        delegate = in instanceof ZipInputStream ? (ZipInputStream)in : new ZipInputStream(in);
        return delegate;
    }

    @Override
    public void close() throws IOException {
        ZipInputStream zis = (ZipInputStream)this.delegate;
        if (zis == null) {
            throw new IOException(CONST_NO_VALID_INPUT_STREAM);
        }
        zis.close();
    }

    @Override
    public int read() throws IOException {
        ZipInputStream zis = (ZipInputStream)this.delegate;
        if (zis == null) {
            throw new IOException(CONST_NO_VALID_INPUT_STREAM);
        }
        return zis.read();
    }

    @Override
    public Object nextEntry() throws IOException {
        ZipInputStream zis = (ZipInputStream)this.delegate;
        if (zis == null) {
            throw new IOException(CONST_NO_VALID_INPUT_STREAM);
        }
        return zis.getNextEntry();
    }
}

