/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.actions.ftpdelete;

import java.net.InetAddress;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.hop.core.Const;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.MessageBox;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.widget.LabelText;
import org.apache.hop.ui.core.widget.LabelTextVar;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.apache.hop.ui.workflow.action.ActionDialog;
import org.apache.hop.ui.workflow.dialog.WorkflowDialog;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.IAction;
import org.apache.hop.workflow.actions.ftpdelete.ActionFtpDelete;
import org.apache.hop.workflow.actions.sftp.SftpClient;
import org.apache.hop.workflow.actions.util.FtpClientUtil;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class ActionFtpDeleteDialog
extends ActionDialog {
    private static final Class<?> PKG = ActionFtpDelete.class;
    private LabelText wName;
    private LabelTextVar wServerName;
    private LabelTextVar wUserName;
    private LabelTextVar wPassword;
    private TextVar wFtpDirectory;
    private Label wlFtpDirectory;
    private LabelTextVar wWildcard;
    private Button wUseProxy;
    private LabelTextVar wTimeout;
    private Button wActive;
    private ActionFtpDelete action;
    private Combo wProtocol;
    private Label wlUsePublicKey;
    private Button wUsePublicKey;
    private boolean changed;
    private Group wSocksProxy;
    private LabelTextVar wSocksProxyHost;
    private LabelTextVar wSocksProxyPort;
    private LabelTextVar wSocksProxyUsername;
    private LabelTextVar wSocksProxyPassword;
    private LabelTextVar wPort;
    private LabelTextVar wProxyHost;
    private LabelTextVar wProxyPort;
    private LabelTextVar wProxyUsername;
    private LabelTextVar wProxyPassword;
    private Button wbTestChangeFolderExists;
    private Label wlNrErrorsLessThan;
    private TextVar wNrErrorsLessThan;
    private CCombo wSuccessCondition;
    private LabelTextVar wKeyFilePass;
    private Label wlKeyFilename;
    private Button wbKeyFilename;
    private TextVar wKeyFilename;
    private Button wGetPrevious;
    private FTPClient ftpclient = null;
    private SftpClient sftpclient = null;
    private String pwdFolder = null;
    private static final String[] FILETYPES = new String[]{BaseMessages.getString(PKG, (String)"ActionFtpDelete.Filetype.Pem", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionFtpDelete.Filetype.All", (String[])new String[0])};

    public ActionFtpDeleteDialog(Shell parent, ActionFtpDelete action, WorkflowMeta workflowMeta, IVariables variables) {
        super(parent, workflowMeta, variables);
        this.action = action;
        if (this.action.getName() == null) {
            this.action.setName(BaseMessages.getString(PKG, (String)"ActionFtpDelete.Name.Default", (String[])new String[0]));
        }
    }

    public IAction open() {
        this.shell = new Shell(this.getParent(), 3312);
        PropsUi.setLook((Widget)this.shell);
        WorkflowDialog.setShellImage((Shell)this.shell, (IAction)this.action);
        ModifyListener lsMod = e -> {
            this.pwdFolder = null;
            this.ftpclient = null;
            this.sftpclient = null;
            this.action.setChanged();
        };
        this.changed = this.action.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"ActionFtpDelete.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = PropsUi.getMargin();
        this.wName = new LabelText((Composite)this.shell, BaseMessages.getString(PKG, (String)"ActionFtpDelete.Name.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionFtpDelete.Name.Tooltip", (String[])new String[0]));
        this.wName.addModifyListener(lsMod);
        FormData fdName = new FormData();
        fdName.top = new FormAttachment(0, 0);
        fdName.left = new FormAttachment(0, 0);
        fdName.right = new FormAttachment(100, 0);
        this.wName.setLayoutData((Object)fdName);
        Button wOk = new Button((Composite)this.shell, 8);
        wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        wOk.addListener(13, e -> this.ok());
        Button wCancel = new Button((Composite)this.shell, 8);
        wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        wCancel.addListener(13, e -> this.cancel());
        BaseTransformDialog.positionBottomButtons((Composite)this.shell, (Button[])new Button[]{wOk, wCancel}, (int)margin, null);
        CTabFolder wTabFolder = new CTabFolder((Composite)this.shell, 2048);
        PropsUi.setLook((Widget)wTabFolder, (int)4);
        CTabItem wGeneralTab = new CTabItem(wTabFolder, 0);
        wGeneralTab.setFont(GuiResource.getInstance().getFontDefault());
        wGeneralTab.setText(BaseMessages.getString(PKG, (String)"ActionFtpDelete.Tab.General.Label", (String[])new String[0]));
        Composite wGeneralComp = new Composite((Composite)wTabFolder, 0);
        PropsUi.setLook((Widget)wGeneralComp);
        FormLayout generalLayout = new FormLayout();
        generalLayout.marginWidth = 3;
        generalLayout.marginHeight = 3;
        wGeneralComp.setLayout((Layout)generalLayout);
        Group wServerSettings = new Group(wGeneralComp, 32);
        PropsUi.setLook((Widget)wServerSettings);
        wServerSettings.setText(BaseMessages.getString(PKG, (String)"ActionFtpDelete.ServerSettings.Group.Label", (String[])new String[0]));
        FormLayout serverSettingsgroupLayout = new FormLayout();
        serverSettingsgroupLayout.marginWidth = 10;
        serverSettingsgroupLayout.marginHeight = 10;
        wServerSettings.setLayout((Layout)serverSettingsgroupLayout);
        Label wlProtocol = new Label((Composite)wServerSettings, 131072);
        wlProtocol.setText(BaseMessages.getString(PKG, (String)"ActionFtpDelete.Protocol.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlProtocol);
        FormData fdlProtocol = new FormData();
        fdlProtocol.left = new FormAttachment(0, 0);
        fdlProtocol.top = new FormAttachment((Control)this.wName, margin);
        fdlProtocol.right = new FormAttachment(middle, 0);
        wlProtocol.setLayoutData((Object)fdlProtocol);
        this.wProtocol = new Combo((Composite)wServerSettings, 18436);
        this.wProtocol.setToolTipText(BaseMessages.getString(PKG, (String)"ActionFtpDelete.Protocol.Tooltip", (String[])new String[0]));
        this.wProtocol.add("FTP");
        this.wProtocol.add("SFTP");
        PropsUi.setLook((Widget)this.wProtocol);
        FormData fdProtocol = new FormData();
        fdProtocol.left = new FormAttachment(middle, margin);
        fdProtocol.top = new FormAttachment((Control)this.wName, margin);
        fdProtocol.right = new FormAttachment(100, 0);
        this.wProtocol.setLayoutData((Object)fdProtocol);
        this.wProtocol.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ActionFtpDeleteDialog.this.activeFtpProtocol();
                ActionFtpDeleteDialog.this.action.setChanged();
            }
        });
        this.wServerName = new LabelTextVar(this.variables, (Composite)wServerSettings, 0, BaseMessages.getString(PKG, (String)"ActionFtpDelete.Server.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionFtpDelete.Server.Tooltip", (String[])new String[0]), false, false);
        PropsUi.setLook((Widget)this.wServerName);
        this.wServerName.addModifyListener(lsMod);
        FormData fdServerName = new FormData();
        fdServerName.left = new FormAttachment(0, 0);
        fdServerName.top = new FormAttachment((Control)this.wProtocol, margin);
        fdServerName.right = new FormAttachment(100, 0);
        this.wServerName.setLayoutData((Object)fdServerName);
        this.wPort = new LabelTextVar(this.variables, (Composite)wServerSettings, 0, BaseMessages.getString(PKG, (String)"ActionFtpDelete.Port.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionFtpDelete.Port.Tooltip", (String[])new String[0]), false, false);
        PropsUi.setLook((Widget)this.wPort);
        this.wPort.addModifyListener(lsMod);
        FormData fdPort = new FormData();
        fdPort.left = new FormAttachment(0, 0);
        fdPort.top = new FormAttachment((Control)this.wServerName, margin);
        fdPort.right = new FormAttachment(100, 0);
        this.wPort.setLayoutData((Object)fdPort);
        this.wUserName = new LabelTextVar(this.variables, (Composite)wServerSettings, 0, BaseMessages.getString(PKG, (String)"ActionFtpDelete.User.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionFtpDelete.User.Tooltip", (String[])new String[0]), false, false);
        PropsUi.setLook((Widget)this.wUserName);
        this.wUserName.addModifyListener(lsMod);
        FormData fdUserName = new FormData();
        fdUserName.left = new FormAttachment(0, 0);
        fdUserName.top = new FormAttachment((Control)this.wPort, margin);
        fdUserName.right = new FormAttachment(100, 0);
        this.wUserName.setLayoutData((Object)fdUserName);
        this.wPassword = new LabelTextVar(this.variables, (Composite)wServerSettings, 0, BaseMessages.getString(PKG, (String)"ActionFtpDelete.Password.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionFtpDelete.Password.Tooltip", (String[])new String[0]), true, false);
        PropsUi.setLook((Widget)this.wPassword);
        this.wPassword.addModifyListener(lsMod);
        FormData fdPassword = new FormData();
        fdPassword.left = new FormAttachment(0, 0);
        fdPassword.top = new FormAttachment((Control)this.wUserName, margin);
        fdPassword.right = new FormAttachment(100, 0);
        this.wPassword.setLayoutData((Object)fdPassword);
        Label wlUseProxy = new Label((Composite)wServerSettings, 131072);
        wlUseProxy.setText(BaseMessages.getString(PKG, (String)"ActionFtpDelete.useProxy.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlUseProxy);
        FormData fdlUseProxy = new FormData();
        fdlUseProxy.left = new FormAttachment(0, 0);
        fdlUseProxy.top = new FormAttachment((Control)this.wPassword, margin);
        fdlUseProxy.right = new FormAttachment(middle, 0);
        wlUseProxy.setLayoutData((Object)fdlUseProxy);
        this.wUseProxy = new Button((Composite)wServerSettings, 32);
        PropsUi.setLook((Widget)this.wUseProxy);
        this.wUseProxy.setToolTipText(BaseMessages.getString(PKG, (String)"ActionFtpDelete.useProxy.Tooltip", (String[])new String[0]));
        FormData fdUseProxy = new FormData();
        fdUseProxy.left = new FormAttachment(middle, margin);
        fdUseProxy.top = new FormAttachment((Control)wlUseProxy, 0, 0x1000000);
        fdUseProxy.right = new FormAttachment(100, 0);
        this.wUseProxy.setLayoutData((Object)fdUseProxy);
        this.wUseProxy.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ActionFtpDeleteDialog.this.activeProxy();
                ActionFtpDeleteDialog.this.action.setChanged();
            }
        });
        this.wProxyHost = new LabelTextVar(this.variables, (Composite)wServerSettings, 0, BaseMessages.getString(PKG, (String)"ActionFtpDelete.ProxyHost.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionFtpDelete.ProxyHost.Tooltip", (String[])new String[0]), false, false);
        PropsUi.setLook((Widget)this.wProxyHost);
        this.wProxyHost.addModifyListener(lsMod);
        FormData fdProxyHost = new FormData();
        fdProxyHost.left = new FormAttachment(0, 0);
        fdProxyHost.top = new FormAttachment((Control)wlUseProxy, 2 * margin);
        fdProxyHost.right = new FormAttachment(100, 0);
        this.wProxyHost.setLayoutData((Object)fdProxyHost);
        this.wProxyPort = new LabelTextVar(this.variables, (Composite)wServerSettings, 0, BaseMessages.getString(PKG, (String)"ActionFtpDelete.ProxyPort.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionFtpDelete.ProxyPort.Tooltip", (String[])new String[0]), false, false);
        PropsUi.setLook((Widget)this.wProxyPort);
        this.wProxyPort.addModifyListener(lsMod);
        FormData fdProxyPort = new FormData();
        fdProxyPort.left = new FormAttachment(0, 0);
        fdProxyPort.top = new FormAttachment((Control)this.wProxyHost, margin);
        fdProxyPort.right = new FormAttachment(100, 0);
        this.wProxyPort.setLayoutData((Object)fdProxyPort);
        this.wProxyUsername = new LabelTextVar(this.variables, (Composite)wServerSettings, 0, BaseMessages.getString(PKG, (String)"ActionFtpDelete.ProxyUsername.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionFtpDelete.ProxyUsername.Tooltip", (String[])new String[0]), false, false);
        PropsUi.setLook((Widget)this.wProxyUsername);
        this.wProxyUsername.addModifyListener(lsMod);
        FormData fdProxyUsername = new FormData();
        fdProxyUsername.left = new FormAttachment(0, 0);
        fdProxyUsername.top = new FormAttachment((Control)this.wProxyPort, margin);
        fdProxyUsername.right = new FormAttachment(100, 0);
        this.wProxyUsername.setLayoutData((Object)fdProxyUsername);
        this.wProxyPassword = new LabelTextVar(this.variables, (Composite)wServerSettings, 0, BaseMessages.getString(PKG, (String)"ActionFtpDelete.ProxyPassword.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionFtpDelete.ProxyPassword.Tooltip", (String[])new String[0]), true, false);
        PropsUi.setLook((Widget)this.wProxyPassword);
        this.wProxyPassword.addModifyListener(lsMod);
        FormData fdProxyPasswd = new FormData();
        fdProxyPasswd.left = new FormAttachment(0, 0);
        fdProxyPasswd.top = new FormAttachment((Control)this.wProxyUsername, margin);
        fdProxyPasswd.right = new FormAttachment(100, 0);
        this.wProxyPassword.setLayoutData((Object)fdProxyPasswd);
        this.wlUsePublicKey = new Label((Composite)wServerSettings, 131072);
        this.wlUsePublicKey.setText(BaseMessages.getString(PKG, (String)"ActionFtpDelete.usePublicKeyFiles.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlUsePublicKey);
        FormData fdlusePublicKey = new FormData();
        fdlusePublicKey.left = new FormAttachment(0, 0);
        fdlusePublicKey.top = new FormAttachment((Control)this.wProxyPassword, margin);
        fdlusePublicKey.right = new FormAttachment(middle, 0);
        this.wlUsePublicKey.setLayoutData((Object)fdlusePublicKey);
        this.wUsePublicKey = new Button((Composite)wServerSettings, 32);
        this.wUsePublicKey.setToolTipText(BaseMessages.getString(PKG, (String)"ActionFtpDelete.usePublicKeyFiles.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wUsePublicKey);
        FormData fdusePublicKey = new FormData();
        fdusePublicKey.left = new FormAttachment(middle, margin);
        fdusePublicKey.top = new FormAttachment((Control)this.wlUsePublicKey, 0, 0x1000000);
        fdusePublicKey.right = new FormAttachment(100, 0);
        this.wUsePublicKey.setLayoutData((Object)fdusePublicKey);
        this.wUsePublicKey.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ActionFtpDeleteDialog.this.activeUsePublicKey();
                ActionFtpDeleteDialog.this.action.setChanged();
            }
        });
        this.wlKeyFilename = new Label((Composite)wServerSettings, 131072);
        this.wlKeyFilename.setText(BaseMessages.getString(PKG, (String)"ActionFtpDelete.KeyFilename.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlKeyFilename);
        FormData fdlKeyFilename = new FormData();
        fdlKeyFilename.left = new FormAttachment(0, 0);
        fdlKeyFilename.top = new FormAttachment((Control)this.wlUsePublicKey, 2 * margin);
        fdlKeyFilename.right = new FormAttachment(middle, -margin);
        this.wlKeyFilename.setLayoutData((Object)fdlKeyFilename);
        this.wbKeyFilename = new Button((Composite)wServerSettings, 0x1000008);
        PropsUi.setLook((Widget)this.wbKeyFilename);
        this.wbKeyFilename.setText(BaseMessages.getString(PKG, (String)"System.Button.Browse", (String[])new String[0]));
        FormData fdbKeyFilename = new FormData();
        fdbKeyFilename.right = new FormAttachment(100, 0);
        fdbKeyFilename.top = new FormAttachment((Control)this.wlKeyFilename, 0, 0x1000000);
        this.wbKeyFilename.setLayoutData((Object)fdbKeyFilename);
        this.wKeyFilename = new TextVar(this.variables, (Composite)wServerSettings, 18436);
        this.wKeyFilename.setToolTipText(BaseMessages.getString(PKG, (String)"ActionFtpDelete.KeyFilename.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wKeyFilename);
        this.wKeyFilename.addModifyListener(lsMod);
        FormData fdKeyFilename = new FormData();
        fdKeyFilename.left = new FormAttachment(middle, margin);
        fdKeyFilename.top = new FormAttachment((Control)this.wlKeyFilename, 0, 0x1000000);
        fdKeyFilename.right = new FormAttachment((Control)this.wbKeyFilename, -margin);
        this.wKeyFilename.setLayoutData((Object)fdKeyFilename);
        this.wKeyFilename.addModifyListener(e -> this.wKeyFilename.setToolTipText(this.variables.resolve(this.wKeyFilename.getText())));
        this.wbKeyFilename.addListener(13, e -> BaseDialog.presentFileDialog((Shell)this.shell, (TextVar)this.wKeyFilename, (IVariables)this.variables, (String[])new String[]{"*.pem", "*"}, (String[])FILETYPES, (boolean)true));
        this.wKeyFilePass = new LabelTextVar(this.variables, (Composite)wServerSettings, BaseMessages.getString(PKG, (String)"ActionFtpDelete.keyfilePass.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionFtpDelete.keyfilePass.Tooltip", (String[])new String[0]), true);
        PropsUi.setLook((Widget)this.wKeyFilePass);
        this.wKeyFilePass.addModifyListener(lsMod);
        FormData fdkeyfilePass = new FormData();
        fdkeyfilePass.left = new FormAttachment(0, 0);
        fdkeyfilePass.top = new FormAttachment((Control)this.wKeyFilename, margin);
        fdkeyfilePass.right = new FormAttachment(100, 0);
        this.wKeyFilePass.setLayoutData((Object)fdkeyfilePass);
        Button wTest = new Button((Composite)wServerSettings, 8);
        wTest.setText(BaseMessages.getString(PKG, (String)"ActionFtpDelete.TestConnection.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wTest);
        FormData fdTest = new FormData();
        wTest.setToolTipText(BaseMessages.getString(PKG, (String)"ActionFtpDelete.TestConnection.Tooltip", (String[])new String[0]));
        fdTest.top = new FormAttachment((Control)this.wKeyFilePass, margin);
        fdTest.right = new FormAttachment(100, 0);
        wTest.setLayoutData((Object)fdTest);
        wTest.addListener(13, e -> this.test());
        FormData fdServerSettings = new FormData();
        fdServerSettings.left = new FormAttachment(0, margin);
        fdServerSettings.top = new FormAttachment((Control)this.wName, margin);
        fdServerSettings.right = new FormAttachment(100, -margin);
        wServerSettings.setLayoutData((Object)fdServerSettings);
        FormData fdGeneralComp = new FormData();
        fdGeneralComp.left = new FormAttachment(0, 0);
        fdGeneralComp.top = new FormAttachment(0, 0);
        fdGeneralComp.right = new FormAttachment(100, 0);
        fdGeneralComp.bottom = new FormAttachment(100, 0);
        wGeneralComp.setLayoutData((Object)fdGeneralComp);
        wGeneralComp.layout();
        wGeneralTab.setControl((Control)wGeneralComp);
        PropsUi.setLook((Widget)wGeneralComp);
        CTabItem wFilesTab = new CTabItem(wTabFolder, 0);
        wFilesTab.setFont(GuiResource.getInstance().getFontDefault());
        wFilesTab.setText(BaseMessages.getString(PKG, (String)"ActionFtpDelete.Tab.Files.Label", (String[])new String[0]));
        Composite wFilesComp = new Composite((Composite)wTabFolder, 0);
        PropsUi.setLook((Widget)wFilesComp);
        FormLayout advancedLayout = new FormLayout();
        advancedLayout.marginWidth = 3;
        advancedLayout.marginHeight = 3;
        wFilesComp.setLayout((Layout)advancedLayout);
        Group wAdvancedSettings = new Group(wFilesComp, 32);
        PropsUi.setLook((Widget)wAdvancedSettings);
        wAdvancedSettings.setText(BaseMessages.getString(PKG, (String)"ActionFtpDelete.AdvancedSettings.Group.Label", (String[])new String[0]));
        FormLayout advancedSettingsgroupLayout = new FormLayout();
        advancedSettingsgroupLayout.marginWidth = 10;
        advancedSettingsgroupLayout.marginHeight = 10;
        wAdvancedSettings.setLayout((Layout)advancedSettingsgroupLayout);
        this.wTimeout = new LabelTextVar(this.variables, (Composite)wAdvancedSettings, 0, BaseMessages.getString(PKG, (String)"ActionFtpDelete.Timeout.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionFtpDelete.Timeout.Tooltip", (String[])new String[0]), false, false);
        PropsUi.setLook((Widget)this.wTimeout);
        this.wTimeout.addModifyListener(lsMod);
        FormData fdTimeout = new FormData();
        fdTimeout.left = new FormAttachment(0, 0);
        fdTimeout.top = new FormAttachment((Control)this.wActive, margin);
        fdTimeout.right = new FormAttachment(100, 0);
        this.wTimeout.setLayoutData((Object)fdTimeout);
        Label wlActive = new Label((Composite)wAdvancedSettings, 131072);
        wlActive.setText(BaseMessages.getString(PKG, (String)"ActionFtpDelete.ActiveConns.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlActive);
        FormData fdlActive = new FormData();
        fdlActive.left = new FormAttachment(0, 0);
        fdlActive.top = new FormAttachment((Control)this.wTimeout, margin);
        fdlActive.right = new FormAttachment(middle, 0);
        wlActive.setLayoutData((Object)fdlActive);
        this.wActive = new Button((Composite)wAdvancedSettings, 32);
        this.wActive.setToolTipText(BaseMessages.getString(PKG, (String)"ActionFtpDelete.ActiveConns.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wActive);
        FormData fdActive = new FormData();
        fdActive.left = new FormAttachment(middle, margin);
        fdActive.top = new FormAttachment((Control)wlActive, 0, 0x1000000);
        fdActive.right = new FormAttachment(100, 0);
        this.wActive.setLayoutData((Object)fdActive);
        FormData fdAdvancedSettings = new FormData();
        fdAdvancedSettings.left = new FormAttachment(0, margin);
        fdAdvancedSettings.top = new FormAttachment(0, margin);
        fdAdvancedSettings.right = new FormAttachment(100, -margin);
        wAdvancedSettings.setLayoutData((Object)fdAdvancedSettings);
        Group wRemoteSettings = new Group(wFilesComp, 32);
        PropsUi.setLook((Widget)wRemoteSettings);
        wRemoteSettings.setText(BaseMessages.getString(PKG, (String)"ActionFtpDelete.RemoteSettings.Group.Label", (String[])new String[0]));
        FormLayout remoteSettinsgroupLayout = new FormLayout();
        remoteSettinsgroupLayout.marginWidth = 10;
        remoteSettinsgroupLayout.marginHeight = 10;
        wRemoteSettings.setLayout((Layout)remoteSettinsgroupLayout);
        Label wlGetPrevious = new Label((Composite)wRemoteSettings, 131072);
        wlGetPrevious.setText(BaseMessages.getString(PKG, (String)"ActionFtpDelete.getPrevious.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlGetPrevious);
        FormData fdlGetPrevious = new FormData();
        fdlGetPrevious.left = new FormAttachment(0, 0);
        fdlGetPrevious.top = new FormAttachment((Control)wAdvancedSettings, margin);
        fdlGetPrevious.right = new FormAttachment(middle, 0);
        wlGetPrevious.setLayoutData((Object)fdlGetPrevious);
        this.wGetPrevious = new Button((Composite)wRemoteSettings, 32);
        PropsUi.setLook((Widget)this.wGetPrevious);
        this.wGetPrevious.setToolTipText(BaseMessages.getString(PKG, (String)"ActionFtpDelete.getPrevious.Tooltip", (String[])new String[0]));
        FormData fdGetPrevious = new FormData();
        fdGetPrevious.left = new FormAttachment(middle, margin);
        fdGetPrevious.top = new FormAttachment((Control)wlGetPrevious, 0, 0x1000000);
        fdGetPrevious.right = new FormAttachment(100, 0);
        this.wGetPrevious.setLayoutData((Object)fdGetPrevious);
        this.wGetPrevious.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ActionFtpDeleteDialog.this.activeCopyFromPrevious();
                ActionFtpDeleteDialog.this.action.setChanged();
            }
        });
        this.wlFtpDirectory = new Label((Composite)wRemoteSettings, 131072);
        this.wlFtpDirectory.setText(BaseMessages.getString(PKG, (String)"ActionFtpDelete.RemoteDir.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlFtpDirectory);
        FormData fdlFtpDirectory = new FormData();
        fdlFtpDirectory.left = new FormAttachment(0, 0);
        fdlFtpDirectory.top = new FormAttachment((Control)wlGetPrevious, 2 * margin);
        fdlFtpDirectory.right = new FormAttachment(middle, 0);
        this.wlFtpDirectory.setLayoutData((Object)fdlFtpDirectory);
        this.wbTestChangeFolderExists = new Button((Composite)wRemoteSettings, 0x1000008);
        PropsUi.setLook((Widget)this.wbTestChangeFolderExists);
        this.wbTestChangeFolderExists.setText(BaseMessages.getString(PKG, (String)"ActionFtpDelete.TestFolderExists.Label", (String[])new String[0]));
        FormData fdbTestChangeFolderExists = new FormData();
        fdbTestChangeFolderExists.right = new FormAttachment(100, 0);
        fdbTestChangeFolderExists.top = new FormAttachment((Control)this.wGetPrevious, margin);
        this.wbTestChangeFolderExists.setLayoutData((Object)fdbTestChangeFolderExists);
        this.wbTestChangeFolderExists.addListener(13, e -> this.checkFtpFolder());
        this.wFtpDirectory = new TextVar(this.variables, (Composite)wRemoteSettings, 18436, BaseMessages.getString(PKG, (String)"ActionFtpDelete.RemoteDir.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wFtpDirectory);
        this.wFtpDirectory.addModifyListener(lsMod);
        FormData fdFtpDirectory = new FormData();
        fdFtpDirectory.left = new FormAttachment(middle, margin);
        fdFtpDirectory.top = new FormAttachment((Control)this.wGetPrevious, margin);
        fdFtpDirectory.right = new FormAttachment((Control)this.wbTestChangeFolderExists, -margin);
        this.wFtpDirectory.setLayoutData((Object)fdFtpDirectory);
        this.wWildcard = new LabelTextVar(this.variables, (Composite)wRemoteSettings, 0, BaseMessages.getString(PKG, (String)"ActionFtpDelete.Wildcard.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionFtpDelete.Wildcard.Tooltip", (String[])new String[0]), false, false);
        PropsUi.setLook((Widget)this.wWildcard);
        this.wWildcard.addModifyListener(lsMod);
        FormData fdWildcard = new FormData();
        fdWildcard.left = new FormAttachment(0, 0);
        fdWildcard.top = new FormAttachment((Control)this.wFtpDirectory, margin);
        fdWildcard.right = new FormAttachment(100, 0);
        this.wWildcard.setLayoutData((Object)fdWildcard);
        FormData fdRemoteSettings = new FormData();
        fdRemoteSettings.left = new FormAttachment(0, margin);
        fdRemoteSettings.top = new FormAttachment((Control)wAdvancedSettings, margin);
        fdRemoteSettings.right = new FormAttachment(100, -margin);
        wRemoteSettings.setLayoutData((Object)fdRemoteSettings);
        Group wSuccessOn = new Group(wFilesComp, 32);
        PropsUi.setLook((Widget)wSuccessOn);
        wSuccessOn.setText(BaseMessages.getString(PKG, (String)"ActionFtpDelete.SuccessOn.Group.Label", (String[])new String[0]));
        FormLayout successongroupLayout = new FormLayout();
        successongroupLayout.marginWidth = 10;
        successongroupLayout.marginHeight = 10;
        wSuccessOn.setLayout((Layout)successongroupLayout);
        Label wlSuccessCondition = new Label((Composite)wSuccessOn, 131072);
        wlSuccessCondition.setText(BaseMessages.getString(PKG, (String)"ActionFtpDelete.SuccessCondition.Label", (String[])new String[0]) + " ");
        PropsUi.setLook((Widget)wlSuccessCondition);
        FormData fdlSuccessCondition = new FormData();
        fdlSuccessCondition.left = new FormAttachment(0, 0);
        fdlSuccessCondition.right = new FormAttachment(middle, 0);
        fdlSuccessCondition.top = new FormAttachment((Control)wRemoteSettings, margin);
        wlSuccessCondition.setLayoutData((Object)fdlSuccessCondition);
        this.wSuccessCondition = new CCombo((Composite)wSuccessOn, 2060);
        this.wSuccessCondition.add(BaseMessages.getString(PKG, (String)"ActionFtpDelete.SuccessWhenAllWorksFine.Label", (String[])new String[0]));
        this.wSuccessCondition.add(BaseMessages.getString(PKG, (String)"ActionFtpDelete.SuccessWhenAtLeat.Label", (String[])new String[0]));
        this.wSuccessCondition.add(BaseMessages.getString(PKG, (String)"ActionFtpDelete.SuccessWhenNrErrorsLessThan.Label", (String[])new String[0]));
        this.wSuccessCondition.select(0);
        PropsUi.setLook((Widget)this.wSuccessCondition);
        FormData fdSuccessCondition = new FormData();
        fdSuccessCondition.left = new FormAttachment(middle, 0);
        fdSuccessCondition.top = new FormAttachment((Control)wRemoteSettings, margin);
        fdSuccessCondition.right = new FormAttachment(100, 0);
        this.wSuccessCondition.setLayoutData((Object)fdSuccessCondition);
        this.wSuccessCondition.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ActionFtpDeleteDialog.this.activeSuccessCondition();
            }
        });
        this.wlNrErrorsLessThan = new Label((Composite)wSuccessOn, 131072);
        this.wlNrErrorsLessThan.setText(BaseMessages.getString(PKG, (String)"ActionFtpDelete.NrBadFormedLessThan.Label", (String[])new String[0]) + " ");
        PropsUi.setLook((Widget)this.wlNrErrorsLessThan);
        FormData fdlNrErrorsLessThan = new FormData();
        fdlNrErrorsLessThan.left = new FormAttachment(0, 0);
        fdlNrErrorsLessThan.top = new FormAttachment((Control)this.wSuccessCondition, margin);
        fdlNrErrorsLessThan.right = new FormAttachment(middle, -margin);
        this.wlNrErrorsLessThan.setLayoutData((Object)fdlNrErrorsLessThan);
        this.wNrErrorsLessThan = new TextVar(this.variables, (Composite)wSuccessOn, 18436, BaseMessages.getString(PKG, (String)"ActionFtpDelete.NrBadFormedLessThan.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wNrErrorsLessThan);
        this.wNrErrorsLessThan.addModifyListener(lsMod);
        FormData fdNrErrorsLessThan = new FormData();
        fdNrErrorsLessThan.left = new FormAttachment(middle, 0);
        fdNrErrorsLessThan.top = new FormAttachment((Control)this.wSuccessCondition, margin);
        fdNrErrorsLessThan.right = new FormAttachment(100, -margin);
        this.wNrErrorsLessThan.setLayoutData((Object)fdNrErrorsLessThan);
        FormData fdSuccessOn = new FormData();
        fdSuccessOn.left = new FormAttachment(0, margin);
        fdSuccessOn.top = new FormAttachment((Control)wRemoteSettings, margin);
        fdSuccessOn.right = new FormAttachment(100, -margin);
        wSuccessOn.setLayoutData((Object)fdSuccessOn);
        FormData fdFilesComp = new FormData();
        fdFilesComp.left = new FormAttachment(0, 0);
        fdFilesComp.top = new FormAttachment(0, 0);
        fdFilesComp.right = new FormAttachment(100, 0);
        fdFilesComp.bottom = new FormAttachment(100, 0);
        wFilesComp.setLayoutData((Object)fdFilesComp);
        wFilesComp.layout();
        wFilesTab.setControl((Control)wFilesComp);
        PropsUi.setLook((Widget)wFilesComp);
        CTabItem wSocksProxyTab = new CTabItem(wTabFolder, 0);
        wSocksProxyTab.setFont(GuiResource.getInstance().getFontDefault());
        wSocksProxyTab.setText(BaseMessages.getString(PKG, (String)"ActionFtpDelete.Tab.Socks.Label", (String[])new String[0]));
        Composite wSocksProxyComp = new Composite((Composite)wTabFolder, 0);
        PropsUi.setLook((Widget)wSocksProxyComp);
        FormLayout soxProxyLayout = new FormLayout();
        soxProxyLayout.marginWidth = 3;
        soxProxyLayout.marginHeight = 3;
        wSocksProxyComp.setLayout((Layout)soxProxyLayout);
        this.wSocksProxy = new Group(wSocksProxyComp, 32);
        PropsUi.setLook((Widget)this.wSocksProxy);
        this.wSocksProxy.setText(BaseMessages.getString(PKG, (String)"ActionFtpDelete.SocksProxy.Group.Label", (String[])new String[0]));
        FormLayout socksProxyGroupLayout = new FormLayout();
        socksProxyGroupLayout.marginWidth = 10;
        socksProxyGroupLayout.marginHeight = 10;
        this.wSocksProxy.setLayout((Layout)socksProxyGroupLayout);
        this.wSocksProxyHost = new LabelTextVar(this.variables, (Composite)this.wSocksProxy, 0, BaseMessages.getString(PKG, (String)"ActionFtpDelete.SocksProxyHost.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionFtpDelete.SocksProxyHost.Tooltip", (String[])new String[0]), false, false);
        PropsUi.setLook((Widget)this.wSocksProxyHost);
        this.wSocksProxyHost.addModifyListener(lsMod);
        FormData fdSocksProxyHost = new FormData();
        fdSocksProxyHost.left = new FormAttachment(0, 0);
        fdSocksProxyHost.top = new FormAttachment((Control)this.wName, margin);
        fdSocksProxyHost.right = new FormAttachment(100, margin);
        this.wSocksProxyHost.setLayoutData((Object)fdSocksProxyHost);
        this.wSocksProxyPort = new LabelTextVar(this.variables, (Composite)this.wSocksProxy, 0, BaseMessages.getString(PKG, (String)"ActionFtpDelete.SocksProxyPort.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionFtpDelete.SocksProxyPort.Tooltip", (String[])new String[0]), false, false);
        PropsUi.setLook((Widget)this.wSocksProxyPort);
        this.wSocksProxyPort.addModifyListener(lsMod);
        FormData fdSocksProxyPort = new FormData();
        fdSocksProxyPort.left = new FormAttachment(0, 0);
        fdSocksProxyPort.top = new FormAttachment((Control)this.wSocksProxyHost, margin);
        fdSocksProxyPort.right = new FormAttachment(100, margin);
        this.wSocksProxyPort.setLayoutData((Object)fdSocksProxyPort);
        this.wSocksProxyUsername = new LabelTextVar(this.variables, (Composite)this.wSocksProxy, 0, BaseMessages.getString(PKG, (String)"ActionFtpDelete.SocksProxyUsername.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionFtpDelete.SocksProxyPassword.Tooltip", (String[])new String[0]), false, false);
        PropsUi.setLook((Widget)this.wSocksProxyUsername);
        this.wSocksProxyUsername.addModifyListener(lsMod);
        FormData fdSocksProxyUsername = new FormData();
        fdSocksProxyUsername.left = new FormAttachment(0, 0);
        fdSocksProxyUsername.top = new FormAttachment((Control)this.wSocksProxyPort, margin);
        fdSocksProxyUsername.right = new FormAttachment(100, margin);
        this.wSocksProxyUsername.setLayoutData((Object)fdSocksProxyUsername);
        this.wSocksProxyPassword = new LabelTextVar(this.variables, (Composite)this.wSocksProxy, 0, BaseMessages.getString(PKG, (String)"ActionFtpDelete.SocksProxyPassword.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionFtpDelete.SocksProxyPassword.Tooltip", (String[])new String[0]), true, false);
        PropsUi.setLook((Widget)this.wSocksProxyPort);
        this.wSocksProxyPassword.addModifyListener(lsMod);
        FormData fdSocksProxyPassword = new FormData();
        fdSocksProxyPassword.left = new FormAttachment(0, 0);
        fdSocksProxyPassword.top = new FormAttachment((Control)this.wSocksProxyUsername, margin);
        fdSocksProxyPassword.right = new FormAttachment(100, margin);
        this.wSocksProxyPassword.setLayoutData((Object)fdSocksProxyPassword);
        FormData fdSocksProxyComp = new FormData();
        fdSocksProxyComp.left = new FormAttachment(0, margin);
        fdSocksProxyComp.top = new FormAttachment(0, margin);
        fdSocksProxyComp.right = new FormAttachment(100, -margin);
        this.wSocksProxy.setLayoutData((Object)fdSocksProxyComp);
        wSocksProxyComp.layout();
        wSocksProxyTab.setControl((Control)wSocksProxyComp);
        PropsUi.setLook((Widget)wSocksProxyComp);
        FormData fdTabFolder = new FormData();
        fdTabFolder.left = new FormAttachment(0, 0);
        fdTabFolder.top = new FormAttachment((Control)this.wName, margin);
        fdTabFolder.right = new FormAttachment(100, 0);
        fdTabFolder.bottom = new FormAttachment((Control)wOk, -2 * margin);
        wTabFolder.setLayoutData((Object)fdTabFolder);
        this.getData();
        this.activeSuccessCondition();
        this.activeUsePublicKey();
        this.activeProxy();
        this.activeFtpProtocol();
        this.activeCopyFromPrevious();
        wTabFolder.setSelection(0);
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.action;
    }

    private void activeCopyFromPrevious() {
        this.wFtpDirectory.setEnabled(!this.wGetPrevious.getSelection());
        this.wlFtpDirectory.setEnabled(!this.wGetPrevious.getSelection());
        this.wWildcard.setEnabled(!this.wGetPrevious.getSelection());
        this.wbTestChangeFolderExists.setEnabled(!this.wGetPrevious.getSelection());
    }

    private void activeUsePublicKey() {
        this.wlKeyFilename.setEnabled(this.wUsePublicKey.getSelection());
        this.wKeyFilename.setEnabled(this.wUsePublicKey.getSelection());
        this.wbKeyFilename.setEnabled(this.wUsePublicKey.getSelection());
        this.wKeyFilePass.setEnabled(this.wUsePublicKey.getSelection());
    }

    private void activeProxy() {
        this.wProxyHost.setEnabled(this.wUseProxy.getSelection());
        this.wProxyPassword.setEnabled(this.wUseProxy.getSelection());
        this.wProxyPort.setEnabled(this.wUseProxy.getSelection());
        this.wProxyUsername.setEnabled(this.wUseProxy.getSelection());
    }

    private void activeFtpProtocol() {
        if (this.wProtocol.getText().equals("FTP")) {
            this.wSocksProxy.setEnabled(true);
        } else {
            this.wUsePublicKey.setSelection(false);
            this.activeUsePublicKey();
            this.wlUsePublicKey.setEnabled(false);
            this.wUsePublicKey.setEnabled(false);
            this.wSocksProxy.setEnabled(false);
        }
    }

    private void checkFtpFolder() {
        boolean folderexists = false;
        String errmsg = "";
        try {
            String realfoldername = this.variables.resolve(this.wFtpDirectory.getText());
            if (!Utils.isEmpty((CharSequence)realfoldername) && this.connect()) {
                if (this.wProtocol.getText().equals("FTP")) {
                    this.ftpclient.changeWorkingDirectory(this.pwdFolder);
                    this.ftpclient.changeWorkingDirectory(realfoldername);
                    folderexists = true;
                } else if (this.wProtocol.getText().equals("SFTP")) {
                    this.sftpclient.chdir(this.pwdFolder);
                    this.sftpclient.chdir(realfoldername);
                    folderexists = true;
                }
            }
        }
        catch (Exception e) {
            errmsg = e.getMessage();
        }
        if (folderexists) {
            mb = new MessageBox(this.shell, 34);
            mb.setMessage(BaseMessages.getString(PKG, (String)"ActionFtpDelete.FolderExists.OK", (String[])new String[]{this.wFtpDirectory.getText()}) + Const.CR);
            mb.setText(BaseMessages.getString(PKG, (String)"ActionFtpDelete.FolderExists.Title.Ok", (String[])new String[0]));
            mb.open();
        } else {
            mb = new MessageBox(this.shell, 33);
            mb.setMessage(BaseMessages.getString(PKG, (String)"ActionFtpDelete.FolderExists.NOK", (String[])new String[]{this.wFtpDirectory.getText()}) + Const.CR + errmsg);
            mb.setText(BaseMessages.getString(PKG, (String)"ActionFtpDelete.FolderExists.Title.Bad", (String[])new String[0]));
            mb.open();
        }
    }

    private boolean connect() {
        boolean connexion = false;
        if (this.wProtocol.getText().equals("FTP")) {
            connexion = this.connectToFtp();
        } else if (this.wProtocol.getText().equals("SFTP")) {
            connexion = this.connectToSftp();
        }
        return connexion;
    }

    private void test() {
        if (this.connect()) {
            MessageBox mb = new MessageBox(this.shell, 34);
            mb.setMessage(BaseMessages.getString(PKG, (String)"ActionFtpDelete.Connected.OK", (String[])new String[]{this.wServerName.getText()}) + Const.CR);
            mb.setText(BaseMessages.getString(PKG, (String)"ActionFtpDelete.Connected.Title.Ok", (String[])new String[0]));
            mb.open();
        }
        this.closeFtpConnections();
    }

    private boolean connectToFtp() {
        boolean success = false;
        Object realServername = null;
        try {
            if (this.ftpclient == null || !this.ftpclient.isConnected()) {
                ActionFtpDelete actionFtpDelete = new ActionFtpDelete();
                this.getInfo(actionFtpDelete);
                this.ftpclient = FtpClientUtil.connectAndLogin(LogChannel.UI, this.variables, actionFtpDelete, actionFtpDelete.getName());
                this.pwdFolder = this.ftpclient.printWorkingDirectory();
            }
            success = true;
        }
        catch (Exception e) {
            if (this.ftpclient != null) {
                try {
                    this.ftpclient.quit();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.ftpclient = null;
                FtpClientUtil.clearSocksJvmSettings();
            }
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setMessage(BaseMessages.getString(PKG, (String)"ActionFtpDelete.ErrorConnect.NOK", (String[])new String[]{realServername, e.getMessage()}) + Const.CR);
            mb.setText(BaseMessages.getString(PKG, (String)"ActionFtpDelete.ErrorConnect.Title.Bad", (String[])new String[0]));
            mb.open();
        }
        return success;
    }

    private boolean connectToSftp() {
        boolean retval = false;
        try {
            if (this.sftpclient == null) {
                this.sftpclient = new SftpClient(InetAddress.getByName(this.variables.resolve(this.wServerName.getText())), Const.toInt((String)this.variables.resolve(this.wPort.getText()), (int)22), this.variables.resolve(this.wUserName.getText()));
                this.sftpclient.login(Utils.resolvePassword((IVariables)this.variables, (String)this.wPassword.getText()));
                this.pwdFolder = this.sftpclient.pwd();
            }
            retval = true;
        }
        catch (Exception e) {
            if (this.sftpclient != null) {
                try {
                    this.sftpclient.disconnect();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.sftpclient = null;
            }
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setMessage(BaseMessages.getString(PKG, (String)"ActionFtpDelete.ErrorConnect.NOK", (String[])new String[]{e.getMessage()}) + Const.CR);
            mb.setText(BaseMessages.getString(PKG, (String)"ActionFtpDelete.ErrorConnect.Title.Bad", (String[])new String[0]));
            mb.open();
        }
        return retval;
    }

    private void activeSuccessCondition() {
        this.wlNrErrorsLessThan.setEnabled(this.wSuccessCondition.getSelectionIndex() != 0);
        this.wNrErrorsLessThan.setEnabled(this.wSuccessCondition.getSelectionIndex() != 0);
    }

    public void dispose() {
        this.closeFtpConnections();
        super.dispose();
    }

    public void getData() {
        this.wName.setText(Const.nullToEmpty((String)this.action.getName()));
        this.wProtocol.setText(Const.NVL((String)this.action.getProtocol(), (String)"FTP"));
        this.wPort.setText(Const.NVL((String)this.action.getServerPort(), (String)""));
        this.wServerName.setText(Const.NVL((String)this.action.getServerName(), (String)""));
        this.wUserName.setText(Const.NVL((String)this.action.getUserName(), (String)""));
        this.wPassword.setText(Const.NVL((String)this.action.getPassword(), (String)""));
        this.wFtpDirectory.setText(Const.NVL((String)this.action.getRemoteDirectory(), (String)""));
        this.wWildcard.setText(Const.NVL((String)this.action.getWildcard(), (String)""));
        this.wTimeout.setText("" + this.action.getTimeout());
        this.wActive.setSelection(this.action.isActiveConnection());
        this.wUseProxy.setSelection(this.action.isUseProxy());
        this.wProxyHost.setText(Const.NVL((String)this.action.getProxyHost(), (String)""));
        this.wProxyPort.setText(Const.NVL((String)this.action.getProxyPort(), (String)""));
        this.wProxyUsername.setText(Const.NVL((String)this.action.getProxyUsername(), (String)""));
        this.wProxyPassword.setText(Const.NVL((String)this.action.getProxyPassword(), (String)""));
        this.wSocksProxyHost.setText(Const.NVL((String)this.action.getSocksProxyHost(), (String)""));
        this.wSocksProxyPort.setText(Const.NVL((String)this.action.getSocksProxyPort(), (String)""));
        this.wSocksProxyUsername.setText(Const.NVL((String)this.action.getSocksProxyUsername(), (String)""));
        this.wSocksProxyPassword.setText(Const.NVL((String)this.action.getSocksProxyPassword(), (String)""));
        this.wNrErrorsLessThan.setText(Const.NVL((String)this.action.getLimitSuccess(), (String)"10"));
        if (this.action.getSuccessCondition() != null) {
            if (this.action.getSuccessCondition().equals("success_when_at_least")) {
                this.wSuccessCondition.select(1);
            } else if (this.action.getSuccessCondition().equals("success_if_errors_less")) {
                this.wSuccessCondition.select(2);
            } else {
                this.wSuccessCondition.select(0);
            }
        } else {
            this.wSuccessCondition.select(0);
        }
        this.wUsePublicKey.setSelection(this.action.isUsePublicKey());
        this.wKeyFilename.setText(Const.nullToEmpty((String)this.action.getKeyFilename()));
        this.wKeyFilePass.setText(Const.nullToEmpty((String)this.action.getKeyFilePass()));
        this.wGetPrevious.setSelection(this.action.isCopyPrevious());
        this.wName.selectAll();
        this.wName.setFocus();
    }

    private void cancel() {
        this.action.setChanged(this.changed);
        this.action = null;
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wName.getText())) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setText(BaseMessages.getString(PKG, (String)"System.TransformActionNameMissing.Title", (String[])new String[0]));
            mb.setMessage(BaseMessages.getString(PKG, (String)"System.ActionNameMissing.Msg", (String[])new String[0]));
            mb.open();
            return;
        }
        this.getInfo(this.action);
        this.dispose();
    }

    private void getInfo(ActionFtpDelete actionFtpDelete) {
        actionFtpDelete.setName(this.wName.getText());
        actionFtpDelete.setProtocol(this.wProtocol.getText());
        actionFtpDelete.setServerPort(this.wPort.getText());
        actionFtpDelete.setServerName(this.wServerName.getText());
        actionFtpDelete.setUserName(this.wUserName.getText());
        actionFtpDelete.setPassword(this.wPassword.getText());
        actionFtpDelete.setRemoteDirectory(this.wFtpDirectory.getText());
        actionFtpDelete.setWildcard(this.wWildcard.getText());
        actionFtpDelete.setTimeout(Const.toInt((String)this.wTimeout.getText(), (int)10000));
        actionFtpDelete.setUseProxy(this.wUseProxy.getSelection());
        actionFtpDelete.setProxyHost(this.wProxyHost.getText());
        actionFtpDelete.setProxyPort(this.wProxyPort.getText());
        actionFtpDelete.setProxyUsername(this.wProxyUsername.getText());
        actionFtpDelete.setProxyPassword(this.wProxyPassword.getText());
        actionFtpDelete.setSocksProxyHost(this.wSocksProxyHost.getText());
        actionFtpDelete.setSocksProxyPort(this.wSocksProxyPort.getText());
        actionFtpDelete.setSocksProxyUsername(this.wSocksProxyUsername.getText());
        actionFtpDelete.setSocksProxyPassword(this.wSocksProxyPassword.getText());
        actionFtpDelete.setLimitSuccess(this.wNrErrorsLessThan.getText());
        if (this.wSuccessCondition.getSelectionIndex() == 1) {
            actionFtpDelete.setSuccessCondition("success_when_at_least");
        } else if (this.wSuccessCondition.getSelectionIndex() == 2) {
            actionFtpDelete.setSuccessCondition("success_if_errors_less");
        } else {
            actionFtpDelete.setSuccessCondition("success_is_all_files_downloaded");
        }
        actionFtpDelete.setUsePublicKey(this.wUsePublicKey.getSelection());
        actionFtpDelete.setKeyFilename(this.wKeyFilename.getText());
        actionFtpDelete.setKeyFilePass(this.wKeyFilePass.getText());
        actionFtpDelete.setCopyPrevious(this.wGetPrevious.getSelection());
    }

    private void closeFtpConnections() {
        if (this.ftpclient != null && this.ftpclient.isConnected()) {
            try {
                this.ftpclient.quit();
                this.ftpclient = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.sftpclient != null) {
            try {
                this.sftpclient.disconnect();
                this.sftpclient = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        FtpClientUtil.clearSocksJvmSettings();
    }
}

