/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.util;

import com.google.auto.value.AutoValue;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.apache.beam.sdk.util.AutoValue_MoreFutures_ExceptionOrResult;
import org.apache.beam.sdk.util.ThrowingRunnable;
import org.apache.beam.sdk.util.ThrowingSupplier;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class MoreFutures {
    public static <T> T get(@UnknownKeyFor @NonNull @Initialized CompletionStage<T> future) throws @UnknownKeyFor @NonNull @Initialized InterruptedException, @UnknownKeyFor @NonNull @Initialized ExecutionException {
        return future.toCompletableFuture().get();
    }

    public static <T> T get(@UnknownKeyFor @NonNull @Initialized CompletionStage<T> future, @UnknownKeyFor @NonNull @Initialized long duration, @UnknownKeyFor @NonNull @Initialized TimeUnit unit) throws @UnknownKeyFor @NonNull @Initialized InterruptedException, @UnknownKeyFor @NonNull @Initialized ExecutionException, @UnknownKeyFor @NonNull @Initialized TimeoutException {
        return future.toCompletableFuture().get(duration, unit);
    }

    public static @UnknownKeyFor @NonNull @Initialized boolean isDone(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized CompletionStage<@UnknownKeyFor @KeyForBottom @Nullable @Initialized @NonNull @Initialized ?> future) {
        return future.toCompletableFuture().isDone();
    }

    public static @UnknownKeyFor @NonNull @Initialized boolean isCancelled(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized CompletionStage<@UnknownKeyFor @KeyForBottom @Nullable @Initialized @NonNull @Initialized ?> future) {
        return future.toCompletableFuture().isCancelled();
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized CompletionStage<T> supplyAsync(@UnknownKeyFor @NonNull @Initialized ThrowingSupplier<T> supplier, @UnknownKeyFor @NonNull @Initialized ExecutorService executorService) {
        CompletableFuture result = new CompletableFuture();
        CompletableFuture<Void> wrapper = CompletableFuture.runAsync(() -> {
            try {
                result.complete(supplier.get());
            }
            catch (InterruptedException e) {
                result.completeExceptionally(e);
                Thread.currentThread().interrupt();
            }
            catch (Throwable t) {
                result.completeExceptionally(t);
            }
        }, executorService);
        return wrapper.thenCompose(nothing -> result);
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized CompletionStage<T> supplyAsync(@UnknownKeyFor @NonNull @Initialized ThrowingSupplier<T> supplier) {
        return MoreFutures.supplyAsync(supplier, ForkJoinPool.commonPool());
    }

    public static @UnknownKeyFor @NonNull @Initialized CompletionStage<@UnknownKeyFor @Nullable @Initialized Void> runAsync(@UnknownKeyFor @NonNull @Initialized ThrowingRunnable runnable, @UnknownKeyFor @NonNull @Initialized ExecutorService executorService) {
        CompletableFuture result = new CompletableFuture();
        CompletableFuture<Void> wrapper = CompletableFuture.runAsync(() -> {
            try {
                runnable.run();
                result.complete(null);
            }
            catch (InterruptedException e) {
                result.completeExceptionally(e);
                Thread.currentThread().interrupt();
            }
            catch (Throwable t) {
                result.completeExceptionally(t);
            }
        }, executorService);
        return wrapper.thenCompose(nothing -> result);
    }

    public static @UnknownKeyFor @NonNull @Initialized CompletionStage<@UnknownKeyFor @Nullable @Initialized Void> runAsync(@UnknownKeyFor @NonNull @Initialized ThrowingRunnable runnable) {
        return MoreFutures.runAsync(runnable, ForkJoinPool.commonPool());
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized CompletionStage<@UnknownKeyFor @NonNull @Initialized List<T>> allAsList(@UnknownKeyFor @NonNull @Initialized Collection<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized CompletionStage<@KeyForBottom @NonNull @Initialized ? extends T>> futures) {
        CompletableFuture[] f = MoreFutures.futuresToCompletableFutures(futures);
        CompletableFuture<Void> blockAndDiscard = CompletableFuture.allOf(f);
        return blockAndDiscard.thenApply(nothing -> Arrays.stream(f).map(CompletableFuture::join).collect(Collectors.toList()));
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized CompletionStage<@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized ExceptionOrResult<T>>> allAsListWithExceptions(@UnknownKeyFor @NonNull @Initialized Collection<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized CompletionStage<@KeyForBottom @NonNull @Initialized ? extends T>> futures) {
        CompletableFuture[] f = MoreFutures.futuresToCompletableFutures(futures);
        CompletableFuture<Void> blockAndDiscard = CompletableFuture.allOf(f);
        return blockAndDiscard.thenApply(nothing -> Arrays.stream(f).map(future -> {
            try {
                return ExceptionOrResult.result(future.join());
            }
            catch (CompletionException exc) {
                return ExceptionOrResult.exception(exc);
            }
        }).collect(Collectors.toList()));
    }

    private static <T> @UnknownKeyFor @NonNull @Initialized CompletableFuture<@KeyForBottom @NonNull @Initialized ? extends T> @UnknownKeyFor @NonNull @Initialized [] futuresToCompletableFutures(@UnknownKeyFor @NonNull @Initialized Collection<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized CompletionStage<@KeyForBottom @NonNull @Initialized ? extends T>> futures) {
        CompletableFuture[] completableFutures = new CompletableFuture[futures.size()];
        int i = 0;
        for (CompletionStage<T> future : futures) {
            completableFutures[i] = future.toCompletableFuture();
            ++i;
        }
        return completableFutures;
    }

    @SuppressFBWarnings(value={"NM_CLASS_NOT_EXCEPTION"}, justification="The class does hold an exception; its name is accurate.")
    @AutoValue
    public static abstract class ExceptionOrResult<@UnknownKeyFor T> {
        public abstract @UnknownKeyFor @NonNull @Initialized IsException isException();

        public abstract @Nullable T getResult();

        public abstract @Nullable @UnknownKeyFor @Initialized Throwable getException();

        public static <T> @UnknownKeyFor @NonNull @Initialized ExceptionOrResult<T> exception(@UnknownKeyFor @NonNull @Initialized Throwable throwable) {
            return new AutoValue_MoreFutures_ExceptionOrResult<Object>(IsException.EXCEPTION, null, throwable);
        }

        public static <T> @UnknownKeyFor @NonNull @Initialized ExceptionOrResult<T> result(T result) {
            return new AutoValue_MoreFutures_ExceptionOrResult<T>(IsException.EXCEPTION, result, null);
        }

        public static enum IsException {
            EXCEPTION,
            RESULT;

        }
    }
}

