/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.StructuredCoder;
import org.apache.beam.sdk.coders.VarIntCoder;
import org.apache.beam.sdk.io.Compression;
import org.apache.beam.sdk.io.FileIO;
import org.apache.beam.sdk.io.fs.MatchResult;
import org.apache.beam.sdk.io.fs.MetadataCoder;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class ReadableFileCoder
extends StructuredCoder<FileIO.ReadableFile> {
    private final @UnknownKeyFor @NonNull @Initialized Coder< @UnknownKeyFor @NonNull @Initialized MatchResult.Metadata> metadataCoder;

    public static @UnknownKeyFor @NonNull @Initialized ReadableFileCoder of(@UnknownKeyFor @NonNull @Initialized Coder< @UnknownKeyFor @NonNull @Initialized MatchResult.Metadata> metadataCoder) {
        return new ReadableFileCoder(metadataCoder);
    }

    public static @UnknownKeyFor @NonNull @Initialized ReadableFileCoder of() {
        return new ReadableFileCoder(MetadataCoder.of());
    }

    public @UnknownKeyFor @NonNull @Initialized Coder< @UnknownKeyFor @NonNull @Initialized MatchResult.Metadata> getMetadataCoder() {
        return this.metadataCoder;
    }

    private ReadableFileCoder(@UnknownKeyFor @NonNull @Initialized Coder< @UnknownKeyFor @NonNull @Initialized MatchResult.Metadata> metadataCoder) {
        this.metadataCoder = metadataCoder;
    }

    @Override
    public void encode(@UnknownKeyFor @NonNull @Initialized FileIO.ReadableFile value, @UnknownKeyFor @NonNull @Initialized OutputStream outStream) throws @UnknownKeyFor @NonNull @Initialized CoderException, @UnknownKeyFor @NonNull @Initialized IOException {
        this.getMetadataCoder().encode(value.getMetadata(), outStream);
        VarIntCoder.of().encode(value.getCompression().ordinal(), outStream);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized FileIO.ReadableFile decode(@UnknownKeyFor @NonNull @Initialized InputStream inStream) throws @UnknownKeyFor @NonNull @Initialized CoderException, @UnknownKeyFor @NonNull @Initialized IOException {
        MatchResult.Metadata metadata = this.getMetadataCoder().decode(inStream);
        Compression compression = Compression.values()[VarIntCoder.of().decode(inStream)];
        return new FileIO.ReadableFile(metadata, compression);
    }

    @Override
    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized List<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> getCoderArguments() {
        return Collections.singletonList(this.metadataCoder);
    }

    @Override
    public void verifyDeterministic() throws @UnknownKeyFor @NonNull @Initialized Coder.NonDeterministicException {
        if (!this.getMetadataCoder().equals(MetadataCoder.of())) {
            ReadableFileCoder.verifyDeterministic(this, "Metadata coder must be deterministic", this.getMetadataCoder());
        }
    }
}

