/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.zipfile;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileType;
import org.apache.hop.core.Const;
import org.apache.hop.core.ResultFile;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.zipfile.ZipFileData;
import org.apache.hop.pipeline.transforms.zipfile.ZipFileMeta;

public class ZipFile
extends BaseTransform<ZipFileMeta, ZipFileData> {
    private static final Class<?> PKG = ZipFileMeta.class;
    private static final String ZIP_COULD_NOT_FIND_FIELD = "ZipFile.Exception.CouldnotFindField";

    public ZipFile(TransformMeta transformMeta, ZipFileMeta meta, ZipFileData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean processRow() throws HopException {
        Object[] r = this.getRow();
        if (r == null) {
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            this.first = false;
            ((ZipFileData)this.data).outputRowMeta = this.getInputRowMeta().clone();
            ((ZipFileMeta)this.meta).getFields(((ZipFileData)this.data).outputRowMeta, this.getTransformName(), null, null, (IVariables)this, this.getPipeline().getMetadataProvider());
            if (Utils.isEmpty((CharSequence)((ZipFileMeta)this.meta).getSourceFilenameField())) {
                throw new HopException(BaseMessages.getString(PKG, (String)"ZipFile.Error.SourceFilenameFieldMissing", (String[])new String[0]));
            }
            if (Utils.isEmpty((CharSequence)((ZipFileMeta)this.meta).getTargetFilenameField())) {
                throw new HopException(BaseMessages.getString(PKG, (String)"ZipFile.Error.TargetFilenameFieldMissing", (String[])new String[0]));
            }
            if (((ZipFileData)this.data).indexOfSourceFilename < 0) {
                ((ZipFileData)this.data).indexOfSourceFilename = this.getInputRowMeta().indexOfValue(((ZipFileMeta)this.meta).getSourceFilenameField());
                if (((ZipFileData)this.data).indexOfSourceFilename < 0) {
                    throw new HopException(BaseMessages.getString(PKG, (String)ZIP_COULD_NOT_FIND_FIELD, (String[])new String[]{((ZipFileMeta)this.meta).getSourceFilenameField()}));
                }
            }
            ((ZipFileData)this.data).indexOfZipFilename = this.getInputRowMeta().indexOfValue(((ZipFileMeta)this.meta).getTargetFilenameField());
            if (((ZipFileData)this.data).indexOfZipFilename < 0) {
                throw new HopException(BaseMessages.getString(PKG, (String)ZIP_COULD_NOT_FIND_FIELD, (String[])new String[]{((ZipFileMeta)this.meta).getTargetFilenameField()}));
            }
            if (((ZipFileMeta)this.meta).isKeepSourceFolder() && !Utils.isEmpty((CharSequence)((ZipFileMeta)this.meta).getBaseFolderField())) {
                ((ZipFileData)this.data).indexOfBaseFolder = this.getInputRowMeta().indexOfValue(((ZipFileMeta)this.meta).getBaseFolderField());
                if (((ZipFileData)this.data).indexOfBaseFolder < 0) {
                    throw new HopException(BaseMessages.getString(PKG, (String)ZIP_COULD_NOT_FIND_FIELD, (String[])new String[]{((ZipFileMeta)this.meta).getBaseFolderField()}));
                }
            }
            if (((ZipFileMeta)this.meta).getOperationType() == 1) {
                if (Utils.isEmpty((CharSequence)((ZipFileMeta)this.meta).getMoveToFolderField())) {
                    throw new HopException(BaseMessages.getString(PKG, (String)"ZipFile.Exception.EmptyMovetoFolder", (String[])new String[0]));
                }
                ((ZipFileData)this.data).indexOfMoveToFolder = this.getInputRowMeta().indexOfValue(((ZipFileMeta)this.meta).getMoveToFolderField());
                if (((ZipFileData)this.data).indexOfMoveToFolder < 0) {
                    throw new HopException(BaseMessages.getString(PKG, (String)ZIP_COULD_NOT_FIND_FIELD, (String[])new String[]{((ZipFileMeta)this.meta).getMoveToFolderField()}));
                }
            }
        }
        boolean sendToErrorRow = false;
        String errorMessage = null;
        try {
            String sourceFilename = this.getInputRowMeta().getString(r, ((ZipFileData)this.data).indexOfSourceFilename);
            if (Utils.isEmpty((CharSequence)sourceFilename)) {
                this.log.logError(this.toString(), new Object[]{BaseMessages.getString(PKG, (String)"ZipFile.Error.SourceFileEmpty", (String[])new String[0])});
                throw new HopException(BaseMessages.getString(PKG, (String)"ZipFile.Error.SourceFileEmpty", (String[])new String[0]));
            }
            ((ZipFileData)this.data).sourceFile = HopVfs.getFileObject((String)sourceFilename, (IVariables)this.variables);
            boolean skip = false;
            if (!((ZipFileData)this.data).sourceFile.exists()) {
                this.log.logError(this.toString(), new Object[]{BaseMessages.getString(PKG, (String)"ZipFile.Error.SourceFileNotExist", (String[])new String[]{sourceFilename})});
                throw new HopException(BaseMessages.getString(PKG, (String)"ZipFile.Error.SourceFileNotExist", (String[])new String[]{sourceFilename}));
            }
            if (((ZipFileData)this.data).sourceFile.getType() != FileType.FILE) {
                this.log.logError(this.toString(), new Object[]{BaseMessages.getString(PKG, (String)"ZipFile.Error.SourceFileNotFile", (String[])new String[]{sourceFilename})});
                throw new HopException(BaseMessages.getString(PKG, (String)"ZipFile.Error.SourceFileNotFile", (String[])new String[]{sourceFilename}));
            }
            if (((ZipFileData)this.data).indexOfBaseFolder > -1) {
                ((ZipFileData)this.data).baseFolder = this.getInputRowMeta().getString(r, ((ZipFileData)this.data).indexOfBaseFolder);
            }
            String moveToFolder = null;
            if (((ZipFileData)this.data).indexOfMoveToFolder > -1 && Utils.isEmpty((CharSequence)(moveToFolder = this.getInputRowMeta().getString(r, ((ZipFileData)this.data).indexOfMoveToFolder)))) {
                throw new HopException(BaseMessages.getString(PKG, (String)"ZipFile.Error.EmptyMoveToFolder", (String[])new String[0]));
            }
            if (!skip) {
                String targetFilename = this.getInputRowMeta().getString(r, ((ZipFileData)this.data).indexOfZipFilename);
                if (Utils.isEmpty((CharSequence)targetFilename)) {
                    this.log.logError(this.toString(), new Object[]{BaseMessages.getString(PKG, (String)"ZipFile.Error.TargetFileEmpty", (String[])new String[0])});
                    throw new HopException(BaseMessages.getString(PKG, (String)"ZipFile.Error.TargetFileEmpty", (String[])new String[0]));
                }
                ((ZipFileData)this.data).zipFile = HopVfs.getFileObject((String)targetFilename, (IVariables)this.variables);
                if (((ZipFileData)this.data).zipFile.exists()) {
                    if (this.log.isDetailed()) {
                        this.log.logDetailed(this.toString(), new Object[]{BaseMessages.getString(PKG, (String)"ZipFile.Log.TargetFileExists", (String[])new String[]{targetFilename})});
                    }
                } else {
                    FileObject parentFolder = ((ZipFileData)this.data).zipFile.getParent();
                    if (!parentFolder.exists()) {
                        if (!((ZipFileMeta)this.meta).isCreateParentFolder()) {
                            throw new HopException(BaseMessages.getString(PKG, (String)"ZipFile.Error.TargetParentFolderNotExists", (String[])new String[]{parentFolder.toString()}));
                        }
                        parentFolder.createFolder();
                    }
                    if (parentFolder != null) {
                        parentFolder.close();
                    }
                }
                this.zipFile();
                this.processFile(moveToFolder);
                this.addFilenameToResult();
            }
            this.getLinesInput();
            this.putRow(((ZipFileData)this.data).outputRowMeta, r);
            if (this.checkFeedback(this.getLinesRead()) && this.log.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"ZipFile.LineNumber", (String[])new String[]{"" + this.getLinesRead()}));
            }
        }
        catch (Exception e) {
            if (!this.getTransformMeta().isDoingErrorHandling()) {
                this.logError(BaseMessages.getString(PKG, (String)"ZipFile.ErrorInTransformRunning", (String[])new String[0]) + e.getMessage());
                this.setErrors(1L);
                this.stopAll();
                this.setOutputDone();
                boolean bl = false;
                return bl;
            }
            sendToErrorRow = true;
            errorMessage = e.toString();
            if (sendToErrorRow) {
                this.putError(this.getInputRowMeta(), r, 1L, errorMessage, null, "ZipFile001");
            }
        }
        finally {
            try {
                if (((ZipFileData)this.data).sourceFile != null) {
                    ((ZipFileData)this.data).sourceFile.close();
                }
                if (((ZipFileData)this.data).zipFile != null) {
                    ((ZipFileData)this.data).zipFile.close();
                }
            }
            catch (Exception exception) {}
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void processFile(String folder) throws Exception {
        switch (((ZipFileMeta)this.meta).getOperationType()) {
            case 1: {
                file = null;
                moveToFolder = null;
                try {
                    moveToFolder = HopVfs.getFileObject((String)folder, (IVariables)this.variables);
                    if (moveToFolder.exists()) {
                        if (moveToFolder.getType() != FileType.FOLDER) {
                            throw new HopException(BaseMessages.getString(ZipFile.PKG, (String)"ZipFile.Error.NotAFolder", (String[])new String[]{folder}));
                        }
                    } else {
                        moveToFolder.createFolder();
                    }
                    targetfilename = HopVfs.getFilename((FileObject)moveToFolder) + Const.FILE_SEPARATOR + ((ZipFileData)this.data).sourceFile.getName().getBaseName();
                    file = HopVfs.getFileObject((String)targetfilename, (IVariables)this.variables);
                    ((ZipFileData)this.data).sourceFile.moveTo(file);
                    if (file == null) ** GOTO lbl35
                }
                catch (Throwable var5_7) {
                    if (file != null) {
                        try {
                            file.close();
                        }
                        catch (Exception var6_8) {
                            // empty catch block
                        }
                    }
                    if (moveToFolder != null) {
                        try {
                            moveToFolder.close();
                        }
                        catch (Exception var6_9) {
                            // empty catch block
                        }
                    }
                    throw var5_7;
                }
                try {
                    file.close();
                }
                catch (Exception var4_5) {
                    // empty catch block
                }
lbl35:
                // 3 sources

                if (moveToFolder == null) break;
                try {
                    moveToFolder.close();
                }
                catch (Exception var4_6) {}
                break;
            }
            case 2: {
                ((ZipFileData)this.data).sourceFile.delete();
                break;
            }
        }
    }

    private void addFilenameToResult() {
        if (((ZipFileMeta)this.meta).isAddResultFilenames()) {
            ResultFile resultFile = new ResultFile(0, ((ZipFileData)this.data).zipFile, this.getPipelineMeta().getName(), this.getTransformName());
            resultFile.setComment(BaseMessages.getString(PKG, (String)"ZipFile.Log.FileAddedResult", (String[])new String[0]));
            this.addResultFile(resultFile);
            if (this.log.isDetailed()) {
                this.log.logDetailed(this.toString(), new Object[]{BaseMessages.getString(PKG, (String)"ZipFile.Log.FilenameAddResult", (String[])new String[]{((ZipFileData)this.data).sourceFile.toString()})});
            }
        }
    }

    private File getFile(String filename) {
        try {
            URI uri = new URI(filename);
            return new File(uri);
        }
        catch (URISyntaxException uRISyntaxException) {
            return new File(filename);
        }
    }

    private void zipFile() throws HopException {
        String localrealZipfilename = HopVfs.getFilename((FileObject)((ZipFileData)this.data).zipFile);
        boolean updateZip = false;
        byte[] buffer = null;
        OutputStream dest = null;
        FilterOutputStream buff = null;
        DeflaterOutputStream out = null;
        InputStream in = null;
        ZipInputStream zin = null;
        ZipEntry entry = null;
        File tempFile = null;
        HashSet<String> fileSet = new HashSet<String>();
        try {
            int len;
            boolean bl = updateZip = ((ZipFileData)this.data).zipFile.exists() && ((ZipFileMeta)this.meta).isOverwriteZipEntry();
            if (updateZip) {
                File fileZip = this.getFile(localrealZipfilename);
                tempFile = File.createTempFile(fileZip.getName(), null);
                tempFile.delete();
                updateZip = fileZip.renameTo(tempFile);
            }
            buffer = new byte[18024];
            dest = HopVfs.getOutputStream((String)localrealZipfilename, (boolean)false, (IVariables)this.variables);
            buff = new BufferedOutputStream(dest);
            out = new ZipOutputStream(buff);
            if (updateZip) {
                zin = new ZipInputStream(new FileInputStream(tempFile));
                entry = zin.getNextEntry();
                while (entry != null) {
                    String name = entry.getName();
                    if (!fileSet.contains(name)) {
                        ((ZipOutputStream)out).putNextEntry(new ZipEntry(name));
                        while ((len = zin.read(buffer)) > 0) {
                            ((ZipOutputStream)out).write(buffer, 0, len);
                        }
                        fileSet.add(name);
                    }
                    entry = zin.getNextEntry();
                }
                zin.close();
            }
            ((ZipOutputStream)out).setMethod(8);
            ((ZipOutputStream)out).setLevel(9);
            in = HopVfs.getInputStream((FileObject)((ZipFileData)this.data).sourceFile);
            String relativeName = ((ZipFileData)this.data).sourceFile.getName().getBaseName();
            if (((ZipFileMeta)this.meta).isKeepSourceFolder()) {
                relativeName = HopVfs.getFilename((FileObject)((ZipFileData)this.data).sourceFile);
                if (((ZipFileData)this.data).baseFolder != null) {
                    ((ZipFileData)this.data).baseFolder = ((ZipFileData)this.data).baseFolder + Const.FILE_SEPARATOR;
                    relativeName = relativeName.replace(((ZipFileData)this.data).baseFolder, "");
                }
            }
            if (!fileSet.contains(relativeName)) {
                ((ZipOutputStream)out).putNextEntry(new ZipEntry(relativeName));
                while ((len = in.read(buffer)) > 0) {
                    ((ZipOutputStream)out).write(buffer, 0, len);
                }
            }
        }
        catch (Exception e) {
            throw new HopException(BaseMessages.getString(PKG, (String)"ZipFile.ErrorCreatingZip", (String[])new String[0]), (Throwable)e);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.flush();
                    ((ZipOutputStream)out).closeEntry();
                    ((ZipOutputStream)out).close();
                }
                if (buff != null) {
                    buff.close();
                }
                if (dest != null) {
                    dest.close();
                }
                if (tempFile != null) {
                    tempFile.delete();
                }
                if (zin != null) {
                    zin.close();
                }
                fileSet = null;
            }
            catch (Exception exception) {}
        }
    }

    public boolean init() {
        return super.init();
    }
}

