/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.drools;

import java.io.Reader;
import java.io.StringReader;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.transform.BaseTransformData;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transforms.drools.RuleValidationException;
import org.apache.hop.pipeline.transforms.drools.Rules;
import org.apache.hop.pipeline.transforms.drools.RulesExecutor;
import org.kie.api.builder.Message;
import org.kie.api.builder.Results;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.ObjectFilter;
import org.kie.internal.io.ResourceFactory;
import org.kie.internal.utils.KieHelper;

public class RulesExecutorData
extends BaseTransformData
implements ITransformData {
    private static final Class<?> PKG = RulesExecutor.class;
    private IRowMeta outputRowMeta;
    private KieHelper kieHelper;
    private Rules.Column[] columnList;
    private Map<String, Rules.Column> resultMap = new HashMap<String, Rules.Column>();
    private String ruleString;
    private String ruleFilePath;

    public String getRuleString() {
        return this.ruleString;
    }

    public void setRuleString(String ruleString) {
        this.ruleString = ruleString;
    }

    public String getRuleFilePath() {
        return this.ruleFilePath;
    }

    public void setRuleFilePath(String ruleFilePath) {
        this.ruleFilePath = ruleFilePath;
    }

    public void setOutputRowMeta(IRowMeta outputRowMeta) {
        this.outputRowMeta = outputRowMeta;
    }

    public IRowMeta getOutputRowMeta() {
        return this.outputRowMeta;
    }

    public void initializeRules() throws RuleValidationException {
        ClassLoader orig = Thread.currentThread().getContextClassLoader();
        ClassLoader loader = ((Object)((Object)this)).getClass().getClassLoader();
        Thread.currentThread().setContextClassLoader(loader);
        Resource ruleSet = null;
        ruleSet = this.ruleString != null ? ResourceFactory.newReaderResource((Reader)new StringReader(this.ruleString)) : ResourceFactory.newFileResource((String)this.ruleFilePath);
        this.kieHelper = new KieHelper();
        this.kieHelper.addResource(ruleSet, ResourceType.DRL);
        Results results1 = this.kieHelper.verify();
        if (results1.hasMessages(new Message.Level[]{Message.Level.ERROR})) {
            throw new RuleValidationException(results1.getMessages());
        }
        Thread.currentThread().setContextClassLoader(orig);
    }

    public void initializeColumns(IRowMeta inputRowMeta) {
        if (inputRowMeta == null) {
            BaseMessages.getString(PKG, (String)"RulesData.InitializeColumns.InputRowMetaIsNull", (String[])new String[0]);
            return;
        }
        List columns = inputRowMeta.getValueMetaList();
        this.columnList = new Rules.Column[columns.size()];
        for (int i = 0; i < columns.size(); ++i) {
            IValueMeta column = (IValueMeta)columns.get(i);
            Rules.Column c = new Rules.Column(true);
            c.setName(column.getName());
            c.setType(column.getTypeDesc());
            c.setPayload(null);
            this.columnList[i] = c;
        }
    }

    public void loadRow(Object[] r) {
        for (int i = 0; i < this.columnList.length; ++i) {
            this.columnList[i].setPayload(r[i]);
        }
        this.resultMap.clear();
    }

    public void execute() {
        ClassLoader orig = Thread.currentThread().getContextClassLoader();
        ClassLoader loader = ((Object)((Object)this)).getClass().getClassLoader();
        Thread.currentThread().setContextClassLoader(loader);
        if (this.kieHelper != null) {
            KieSession session = this.kieHelper.getKieContainer().newKieSession();
            for (int i = 0; i < this.columnList.length; ++i) {
                session.insert((Object)this.columnList[i]);
            }
            session.fireAllRules();
            Collection<Object> oList = this.fetchColumns(session);
            for (Object o : oList) {
                this.resultMap.put(((Rules.Column)o).getName(), (Rules.Column)o);
            }
            session.dispose();
        }
        Thread.currentThread().setContextClassLoader(orig);
    }

    protected Collection<Object> fetchColumns(KieSession session) {
        return session.getObjects(new ObjectFilter(){

            public boolean accept(Object o) {
                return o instanceof Rules.Column && !((Rules.Column)o).isExternalSource();
            }
        });
    }

    public Object fetchResult(String columnName) {
        return this.resultMap.get(columnName);
    }

    public void shutdown() {
    }
}

