/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.util.construction;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.beam.sdk.fn.splittabledofn.RestrictionTrackers;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.runners.PTransformOverrideFactory;
import org.apache.beam.sdk.state.State;
import org.apache.beam.sdk.state.TimeDomain;
import org.apache.beam.sdk.state.Timer;
import org.apache.beam.sdk.state.TimerMap;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.Reshuffle;
import org.apache.beam.sdk.transforms.Values;
import org.apache.beam.sdk.transforms.reflect.DoFnInvoker;
import org.apache.beam.sdk.transforms.reflect.DoFnInvokers;
import org.apache.beam.sdk.transforms.reflect.DoFnSignatures;
import org.apache.beam.sdk.transforms.splittabledofn.RestrictionTracker;
import org.apache.beam.sdk.transforms.splittabledofn.SplitResult;
import org.apache.beam.sdk.transforms.splittabledofn.WatermarkEstimator;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.PaneInfo;
import org.apache.beam.sdk.util.construction.PTransformReplacements;
import org.apache.beam.sdk.util.construction.ReplacementOutputs;
import org.apache.beam.sdk.util.construction.SplittableParDo;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.util.concurrent.Uninterruptibles;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.joda.time.Instant;

public class SplittableParDoNaiveBounded {

    public static class NaiveProcessFn<@UnknownKeyFor InputT, @UnknownKeyFor OutputT, @UnknownKeyFor RestrictionT, @UnknownKeyFor PositionT, @UnknownKeyFor WatermarkEstimatorStateT>
    extends DoFn<KV<InputT, RestrictionT>, OutputT> {
        private final @UnknownKeyFor @NonNull @Initialized DoFn<InputT, OutputT> fn;
        private final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> sideInputMapping;
        private transient @Nullable @UnknownKeyFor @Initialized DoFnInvoker<InputT, OutputT> invoker;

        NaiveProcessFn(@UnknownKeyFor @NonNull @Initialized DoFn<InputT, OutputT> fn, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> sideInputMapping) {
            this.fn = fn;
            this.sideInputMapping = sideInputMapping;
        }

        @DoFn.Setup
        public void setup(final @UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
            this.invoker = DoFnInvokers.invokerFor(this.fn);
            this.invoker.invokeSetup(new DoFnInvoker.BaseArgumentProvider<InputT, OutputT>(){

                @Override
                public @UnknownKeyFor @NonNull @Initialized PipelineOptions pipelineOptions() {
                    return options;
                }

                @Override
                public @UnknownKeyFor @NonNull @Initialized String getErrorContext() {
                    return "SplittableParDoNaiveBounded/Setup";
                }
            });
        }

        @DoFn.StartBundle
        public void startBundle(final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized StartBundleContext c) {
            this.invoker.invokeStartBundle(new DoFnInvoker.BaseArgumentProvider<InputT, OutputT>(){

                @Override
                public @UnknownKeyFor @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized StartBundleContext startBundleContext(@UnknownKeyFor @NonNull @Initialized DoFn<InputT, OutputT> doFn) {
                    return new DoFn.StartBundleContext(){

                        @Override
                        @Pure
                        public @UnknownKeyFor @NonNull @Initialized PipelineOptions getPipelineOptions() {
                            return c.getPipelineOptions();
                        }
                    };
                }

                @Override
                public @UnknownKeyFor @NonNull @Initialized PipelineOptions pipelineOptions() {
                    return c.getPipelineOptions();
                }

                @Override
                public @UnknownKeyFor @NonNull @Initialized String getErrorContext() {
                    return "SplittableParDoNaiveBounded/StartBundle";
                }
            });
        }

        @DoFn.ProcessElement
        public void process(final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c, final @UnknownKeyFor @NonNull @Initialized BoundedWindow w) {
            Object initialWatermarkEstimatorState = this.invoker.invokeGetInitialWatermarkEstimatorState(new DoFnInvoker.BaseArgumentProvider<InputT, OutputT>(){

                @Override
                public InputT element(@UnknownKeyFor @NonNull @Initialized DoFn<InputT, OutputT> doFn) {
                    return ((KV)c.element()).getKey();
                }

                @Override
                public @UnknownKeyFor @NonNull @Initialized Object restriction() {
                    return ((KV)c.element()).getValue();
                }

                @Override
                public @UnknownKeyFor @NonNull @Initialized Instant timestamp(@UnknownKeyFor @NonNull @Initialized DoFn<InputT, OutputT> doFn) {
                    return c.timestamp();
                }

                @Override
                public @UnknownKeyFor @NonNull @Initialized PipelineOptions pipelineOptions() {
                    return c.getPipelineOptions();
                }

                @Override
                public @UnknownKeyFor @NonNull @Initialized PaneInfo paneInfo(@UnknownKeyFor @NonNull @Initialized DoFn<InputT, OutputT> doFn) {
                    return c.pane();
                }

                @Override
                public @UnknownKeyFor @NonNull @Initialized BoundedWindow window() {
                    return w;
                }

                @Override
                public @UnknownKeyFor @NonNull @Initialized Object sideInput(@UnknownKeyFor @NonNull @Initialized String tagId) {
                    PCollectionView view = (PCollectionView)sideInputMapping.get(tagId);
                    if (view == null) {
                        throw new IllegalArgumentException("calling getSideInput() with unknown view");
                    }
                    return c.sideInput(view);
                }

                @Override
                public @UnknownKeyFor @NonNull @Initialized String getErrorContext() {
                    return NaiveProcessFn.class.getSimpleName() + ".invokeGetInitialWatermarkEstimatorState";
                }
            });
            Object restriction = ((KV)c.element()).getValue();
            Object watermarkEstimatorState = initialWatermarkEstimatorState;
            while (true) {
                final Object currentRestriction = restriction;
                final Object currentWatermarkEstimatorState = watermarkEstimatorState;
                RestrictionTracker tracker = RestrictionTrackers.observe(this.invoker.invokeNewTracker(new DoFnInvoker.BaseArgumentProvider<InputT, OutputT>(){

                    @Override
                    public InputT element(@UnknownKeyFor @NonNull @Initialized DoFn<InputT, OutputT> doFn) {
                        return ((KV)c.element()).getKey();
                    }

                    @Override
                    public RestrictionT restriction() {
                        return currentRestriction;
                    }

                    @Override
                    public @UnknownKeyFor @NonNull @Initialized Instant timestamp(@UnknownKeyFor @NonNull @Initialized DoFn<InputT, OutputT> doFn) {
                        return c.timestamp();
                    }

                    @Override
                    public @UnknownKeyFor @NonNull @Initialized PipelineOptions pipelineOptions() {
                        return c.getPipelineOptions();
                    }

                    @Override
                    public @UnknownKeyFor @NonNull @Initialized PaneInfo paneInfo(@UnknownKeyFor @NonNull @Initialized DoFn<InputT, OutputT> doFn) {
                        return c.pane();
                    }

                    @Override
                    public @UnknownKeyFor @NonNull @Initialized BoundedWindow window() {
                        return w;
                    }

                    @Override
                    public @UnknownKeyFor @NonNull @Initialized Object sideInput(@UnknownKeyFor @NonNull @Initialized String tagId) {
                        PCollectionView view = (PCollectionView)sideInputMapping.get(tagId);
                        if (view == null) {
                            throw new IllegalArgumentException("calling getSideInput() with unknown view");
                        }
                        return c.sideInput(view);
                    }

                    @Override
                    public @UnknownKeyFor @NonNull @Initialized String getErrorContext() {
                        return NaiveProcessFn.class.getSimpleName() + ".invokeNewTracker";
                    }
                }), new RestrictionTrackers.ClaimObserver<PositionT>(){

                    @Override
                    public void onClaimed(PositionT position) {
                    }

                    @Override
                    public void onClaimFailed(PositionT position) {
                    }
                });
                WatermarkEstimator watermarkEstimator = this.invoker.invokeNewWatermarkEstimator(new DoFnInvoker.BaseArgumentProvider<InputT, OutputT>(){

                    @Override
                    public InputT element(@UnknownKeyFor @NonNull @Initialized DoFn<InputT, OutputT> doFn) {
                        return ((KV)c.element()).getKey();
                    }

                    @Override
                    public RestrictionT restriction() {
                        return currentRestriction;
                    }

                    @Override
                    public WatermarkEstimatorStateT watermarkEstimatorState() {
                        return currentWatermarkEstimatorState;
                    }

                    @Override
                    public @UnknownKeyFor @NonNull @Initialized Instant timestamp(@UnknownKeyFor @NonNull @Initialized DoFn<InputT, OutputT> doFn) {
                        return c.timestamp();
                    }

                    @Override
                    public @UnknownKeyFor @NonNull @Initialized PipelineOptions pipelineOptions() {
                        return c.getPipelineOptions();
                    }

                    @Override
                    public @UnknownKeyFor @NonNull @Initialized PaneInfo paneInfo(@UnknownKeyFor @NonNull @Initialized DoFn<InputT, OutputT> doFn) {
                        return c.pane();
                    }

                    @Override
                    public @UnknownKeyFor @NonNull @Initialized BoundedWindow window() {
                        return w;
                    }

                    @Override
                    public @UnknownKeyFor @NonNull @Initialized Object sideInput(@UnknownKeyFor @NonNull @Initialized String tagId) {
                        PCollectionView view = (PCollectionView)sideInputMapping.get(tagId);
                        if (view == null) {
                            throw new IllegalArgumentException("calling getSideInput() with unknown view");
                        }
                        return c.sideInput(view);
                    }

                    @Override
                    public @UnknownKeyFor @NonNull @Initialized String getErrorContext() {
                        return NaiveProcessFn.class.getSimpleName() + ".invokeNewWatermarkEstimator";
                    }
                });
                DoFn.ProcessContinuation continuation = this.invoker.invokeProcessElement(new NestedProcessContext(this.fn, c, ((KV)c.element()).getKey(), w, tracker, watermarkEstimator, this.sideInputMapping, null));
                if (!continuation.shouldResume()) break;
                watermarkEstimatorState = watermarkEstimator.getState();
                SplitResult split = tracker.trySplit(0.0);
                if (split == null) break;
                restriction = split.getResidual();
                Uninterruptibles.sleepUninterruptibly(continuation.resumeDelay().getMillis(), TimeUnit.MILLISECONDS);
            }
        }

        @DoFn.FinishBundle
        public void finishBundle(final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized FinishBundleContext c) {
            this.invoker.invokeFinishBundle(new DoFnInvoker.BaseArgumentProvider<InputT, OutputT>(){

                @Override
                public @UnknownKeyFor @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized FinishBundleContext finishBundleContext(@UnknownKeyFor @NonNull @Initialized DoFn<InputT, OutputT> doFn) {
                    return new DoFn.FinishBundleContext(){

                        @Override
                        @Pure
                        public @UnknownKeyFor @NonNull @Initialized PipelineOptions getPipelineOptions() {
                            return c.getPipelineOptions();
                        }

                        @Override
                        public void output(@Nullable OutputT output, @UnknownKeyFor @NonNull @Initialized Instant timestamp, @UnknownKeyFor @NonNull @Initialized BoundedWindow window) {
                            throw new UnsupportedOperationException("Output from FinishBundle for SDF is not supported in naive implementation");
                        }

                        @Override
                        public <T> void output(@UnknownKeyFor @NonNull @Initialized TupleTag<T> tag, T output, @UnknownKeyFor @NonNull @Initialized Instant timestamp, @UnknownKeyFor @NonNull @Initialized BoundedWindow window) {
                            throw new UnsupportedOperationException("Output from FinishBundle for SDF is not supported in naive implementation");
                        }
                    };
                }

                @Override
                public @UnknownKeyFor @NonNull @Initialized PipelineOptions pipelineOptions() {
                    return c.getPipelineOptions();
                }

                @Override
                public @UnknownKeyFor @NonNull @Initialized String getErrorContext() {
                    return "SplittableParDoNaiveBounded/StartBundle";
                }
            });
        }

        @DoFn.Teardown
        public void teardown() {
            this.invoker.invokeTeardown();
        }

        private static class NestedProcessContext<@UnknownKeyFor InputT, @UnknownKeyFor OutputT, @UnknownKeyFor RestrictionT, @UnknownKeyFor TrackerT/*
         * Issues handling annotations - annotations may be inaccurate
         */
         extends @UnknownKeyFor @NonNull @Initialized RestrictionTracker<RestrictionT, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor WatermarkEstimatorStateT, @UnknownKeyFor WatermarkEstimatorT extends @UnknownKeyFor @NonNull @Initialized WatermarkEstimator<WatermarkEstimatorStateT>>
        extends DoFn.ProcessContext
        implements DoFnInvoker.ArgumentProvider<InputT, OutputT> {
            private final @UnknownKeyFor @NonNull @Initialized BoundedWindow window;
            private final /*
             * Issues handling annotations - annotations may be inaccurate
             */
            @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext outerContext;
            private final InputT element;
            private final TrackerT tracker;
            private final WatermarkEstimatorT watermarkEstimator;
            private final /*
             * Issues handling annotations - annotations may be inaccurate
             */
            @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> sideInputMapping;

            private NestedProcessContext(@UnknownKeyFor @NonNull @Initialized DoFn<InputT, OutputT> fn, /*
             * Issues handling annotations - annotations may be inaccurate
             */
            @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext outerContext, InputT element, @UnknownKeyFor @NonNull @Initialized BoundedWindow window, TrackerT tracker, WatermarkEstimatorT watermarkEstimator, /*
             * Issues handling annotations - annotations may be inaccurate
             */
            @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> sideInputMapping) {
                this.window = window;
                this.outerContext = outerContext;
                this.element = element;
                this.tracker = tracker;
                this.watermarkEstimator = watermarkEstimator;
                this.sideInputMapping = sideInputMapping;
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized BoundedWindow window() {
                return this.window;
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized PaneInfo paneInfo(@UnknownKeyFor @NonNull @Initialized DoFn<InputT, OutputT> doFn) {
                return this.outerContext.pane();
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized PipelineOptions pipelineOptions() {
                return this.outerContext.getPipelineOptions();
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext processContext(@UnknownKeyFor @NonNull @Initialized DoFn<InputT, OutputT> doFn) {
                return this;
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized OnTimerContext onTimerContext(@UnknownKeyFor @NonNull @Initialized DoFn<InputT, OutputT> doFn) {
                throw new IllegalStateException();
            }

            @Override
            public InputT element(@UnknownKeyFor @NonNull @Initialized DoFn<InputT, OutputT> doFn) {
                return this.element;
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized Object key() {
                throw new UnsupportedOperationException();
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized Object sideInput(@UnknownKeyFor @NonNull @Initialized String tagId) {
                PCollectionView<?> view = this.sideInputMapping.get(tagId);
                if (view == null) {
                    throw new IllegalArgumentException("calling getSideInput() with unknown view");
                }
                return this.sideInput(view);
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized TimerMap timerFamily(@UnknownKeyFor @NonNull @Initialized String tagId) {
                throw new UnsupportedOperationException();
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized Object schemaElement(@UnknownKeyFor @NonNull @Initialized int index) {
                throw new UnsupportedOperationException();
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized Instant timestamp(@UnknownKeyFor @NonNull @Initialized DoFn<InputT, OutputT> doFn) {
                return this.outerContext.timestamp();
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized String timerId(@UnknownKeyFor @NonNull @Initialized DoFn<InputT, OutputT> doFn) {
                throw new UnsupportedOperationException();
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<OutputT> outputReceiver(@UnknownKeyFor @NonNull @Initialized DoFn<InputT, OutputT> doFn) {
                return new DoFn.OutputReceiver<OutputT>(){

                    @Override
                    public void output(OutputT output) {
                        outerContext.output(output);
                    }

                    @Override
                    public void outputWithTimestamp(OutputT output, @UnknownKeyFor @NonNull @Initialized Instant timestamp) {
                        outerContext.outputWithTimestamp(output, timestamp);
                    }

                    @Override
                    public void outputWindowedValue(OutputT output, @UnknownKeyFor @NonNull @Initialized Instant timestamp, @UnknownKeyFor @NonNull @Initialized Collection<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized BoundedWindow> windows, @UnknownKeyFor @NonNull @Initialized PaneInfo paneInfo) {
                        outerContext.outputWindowedValue(output, timestamp, windows, paneInfo);
                    }
                };
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized DoFn.MultiOutputReceiver taggedOutputReceiver(@UnknownKeyFor @NonNull @Initialized DoFn<InputT, OutputT> doFn) {
                return new DoFn.MultiOutputReceiver(){

                    @Override
                    public <T> @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<T> get(final @UnknownKeyFor @NonNull @Initialized TupleTag<T> tag) {
                        return new DoFn.OutputReceiver<T>(){

                            @Override
                            public void output(T output) {
                                outerContext.output(tag, output);
                            }

                            @Override
                            public void outputWithTimestamp(T output, @UnknownKeyFor @NonNull @Initialized Instant timestamp) {
                                outerContext.outputWithTimestamp(tag, output, timestamp);
                            }

                            @Override
                            public void outputWindowedValue(T output, @UnknownKeyFor @NonNull @Initialized Instant timestamp, @UnknownKeyFor @NonNull @Initialized Collection<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized BoundedWindow> windows, @UnknownKeyFor @NonNull @Initialized PaneInfo paneInfo) {
                                outerContext.outputWindowedValue(tag, output, timestamp, windows, paneInfo);
                            }
                        };
                    }

                    @Override
                    public <T> @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized Row> getRowReceiver(@UnknownKeyFor @NonNull @Initialized TupleTag<T> tag) {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized DoFn.BundleFinalizer bundleFinalizer() {
                throw new UnsupportedOperationException();
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized Object restriction() {
                return ((RestrictionTracker)this.tracker).currentRestriction();
            }

            @Override
            public /*
             * Issues handling annotations - annotations may be inaccurate
             */
            @UnknownKeyFor @NonNull @Initialized RestrictionTracker<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> restrictionTracker() {
                return this.tracker;
            }

            @Override
            @Pure
            public @UnknownKeyFor @NonNull @Initialized PipelineOptions getPipelineOptions() {
                return this.outerContext.getPipelineOptions();
            }

            @Override
            public void output(OutputT output) {
                this.outerContext.output(output);
            }

            @Override
            public void outputWithTimestamp(OutputT output, @UnknownKeyFor @NonNull @Initialized Instant timestamp) {
                this.outerContext.outputWithTimestamp(output, timestamp);
            }

            @Override
            public void outputWindowedValue(OutputT output, @UnknownKeyFor @NonNull @Initialized Instant timestamp, @UnknownKeyFor @NonNull @Initialized Collection<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized BoundedWindow> windows, @UnknownKeyFor @NonNull @Initialized PaneInfo paneInfo) {
                this.outerContext.outputWindowedValue(output, timestamp, windows, paneInfo);
            }

            @Override
            public <T> void output(@UnknownKeyFor @NonNull @Initialized TupleTag<T> tag, T output) {
                this.outerContext.output(tag, output);
            }

            @Override
            public <T> void outputWithTimestamp(@UnknownKeyFor @NonNull @Initialized TupleTag<T> tag, T output, @UnknownKeyFor @NonNull @Initialized Instant timestamp) {
                this.outerContext.outputWithTimestamp(tag, output, timestamp);
            }

            @Override
            public <T> void outputWindowedValue(@UnknownKeyFor @NonNull @Initialized TupleTag<T> tag, T output, @UnknownKeyFor @NonNull @Initialized Instant timestamp, @UnknownKeyFor @NonNull @Initialized Collection<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized BoundedWindow> windows, @UnknownKeyFor @NonNull @Initialized PaneInfo paneInfo) {
                this.outerContext.outputWindowedValue(tag, output, timestamp, windows, paneInfo);
            }

            @Override
            @Pure
            public InputT element() {
                return this.element;
            }

            @Override
            @Pure
            public <T> T sideInput(@UnknownKeyFor @NonNull @Initialized PCollectionView<T> view) {
                return this.outerContext.sideInput(view);
            }

            @Override
            @Pure
            public @UnknownKeyFor @NonNull @Initialized Instant timestamp() {
                return this.outerContext.timestamp();
            }

            @Override
            @Pure
            public @UnknownKeyFor @NonNull @Initialized PaneInfo pane() {
                return this.outerContext.pane();
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized Object watermarkEstimatorState() {
                throw new UnsupportedOperationException("@WatermarkEstimatorState parameters are not supported.");
            }

            @Override
            public /*
             * Issues handling annotations - annotations may be inaccurate
             */
            @UnknownKeyFor @NonNull @Initialized WatermarkEstimator<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> watermarkEstimator() {
                return this.watermarkEstimator;
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized StartBundleContext startBundleContext(@UnknownKeyFor @NonNull @Initialized DoFn<InputT, OutputT> doFn) {
                throw new IllegalStateException();
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized FinishBundleContext finishBundleContext(@UnknownKeyFor @NonNull @Initialized DoFn<InputT, OutputT> doFn) {
                throw new IllegalStateException();
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized Row> outputRowReceiver(@UnknownKeyFor @NonNull @Initialized DoFn<InputT, OutputT> doFn) {
                throw new UnsupportedOperationException();
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized TimeDomain timeDomain(@UnknownKeyFor @NonNull @Initialized DoFn<InputT, OutputT> doFn) {
                throw new IllegalStateException();
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized State state(@UnknownKeyFor @NonNull @Initialized String stateId, @UnknownKeyFor @NonNull @Initialized boolean alwaysFetched) {
                throw new UnsupportedOperationException();
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized Timer timer(@UnknownKeyFor @NonNull @Initialized String timerId) {
                throw new UnsupportedOperationException();
            }

            /* synthetic */ NestedProcessContext(DoFn x0, DoFn.ProcessContext x1, Object x2, BoundedWindow x3, RestrictionTracker x4, WatermarkEstimator x5, Map x6, 1 x7) {
                this(x0, x1, x2, x3, x4, x5, x6);
            }
        }
    }

    static class SplittableProcessNaive<@UnknownKeyFor InputT, @UnknownKeyFor OutputT, @UnknownKeyFor RestrictionT, @UnknownKeyFor PositionT, @UnknownKeyFor WatermarkEstimatorStateT>
    extends PTransform<PCollection<KV<byte[], KV<InputT, RestrictionT>>>, PCollectionTuple> {
        private final  @UnknownKeyFor @NonNull @Initialized SplittableParDo.ProcessKeyedElements<InputT, OutputT, RestrictionT, WatermarkEstimatorStateT> original;

        SplittableProcessNaive( @UnknownKeyFor @NonNull @Initialized SplittableParDo.ProcessKeyedElements<InputT, OutputT, RestrictionT, WatermarkEstimatorStateT> original) {
            this.original = original;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollectionTuple expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [], @UnknownKeyFor @NonNull @Initialized KV<InputT, RestrictionT>>> input) {
            return (PCollectionTuple)((PCollection)((PCollection)input.apply("Reshuffle", Reshuffle.of())).apply("Drop key", Values.create())).apply("NaiveProcess", ParDo.of(new NaiveProcessFn(this.original.getFn(), this.original.getSideInputMapping())).withSideInputs(this.original.getSideInputs()).withOutputTags(this.original.getMainOutputTag(), this.original.getAdditionalOutputTags()));
        }
    }

    public static class OverrideFactory<@UnknownKeyFor InputT, @UnknownKeyFor OutputT, @UnknownKeyFor RestrictionT, @UnknownKeyFor WatermarkEstimatorStateT>
    implements PTransformOverrideFactory<PCollection<KV<byte[], KV<InputT, RestrictionT>>>, PCollectionTuple, SplittableParDo.ProcessKeyedElements<InputT, OutputT, RestrictionT, WatermarkEstimatorStateT>> {
        @Override
        public @UnknownKeyFor @NonNull @Initialized PTransformOverrideFactory.PTransformReplacement<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [], @UnknownKeyFor @NonNull @Initialized KV<InputT, RestrictionT>>>, @UnknownKeyFor @NonNull @Initialized PCollectionTuple> getReplacementTransform(@UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [], @UnknownKeyFor @NonNull @Initialized KV<InputT, RestrictionT>>>, @UnknownKeyFor @NonNull @Initialized PCollectionTuple,  @UnknownKeyFor @NonNull @Initialized SplittableParDo.ProcessKeyedElements<InputT, OutputT, RestrictionT, WatermarkEstimatorStateT>> transform) {
            Preconditions.checkArgument(DoFnSignatures.signatureForDoFn(transform.getTransform().getFn()).isBoundedPerElement() == PCollection.IsBounded.BOUNDED, "Expecting a bounded-per-element splittable DoFn");
            return PTransformOverrideFactory.PTransformReplacement.of(PTransformReplacements.getSingletonMainInput(transform), new SplittableProcessNaive(transform.getTransform()));
        }

        @Override
        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized PTransformOverrideFactory.ReplacementOutput> mapOutputs(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> outputs, @UnknownKeyFor @NonNull @Initialized PCollectionTuple newOutput) {
            return ReplacementOutputs.tagged(outputs, newOutput);
        }
    }
}

