/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.testing;

import com.google.auto.value.AutoValue;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.DurationCoder;
import org.apache.beam.sdk.coders.InstantCoder;
import org.apache.beam.sdk.coders.StructuredCoder;
import org.apache.beam.sdk.coders.VarIntCoder;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.SchemaCoder;
import org.apache.beam.sdk.testing.AutoValue_TestStream_ElementEvent;
import org.apache.beam.sdk.testing.AutoValue_TestStream_ProcessingTimeEvent;
import org.apache.beam.sdk.testing.AutoValue_TestStream_WatermarkEvent;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TimestampedValue;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableCollection;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Iterables;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;

public final class TestStream<@UnknownKeyFor T>
extends PTransform<PBegin, PCollection<T>> {
    private final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Event<T>> events;
    private final @UnknownKeyFor @NonNull @Initialized Coder<T> coder;

    public static <T> @UnknownKeyFor @NonNull @Initialized Builder<T> create(@UnknownKeyFor @NonNull @Initialized Coder<T> coder) {
        return new Builder(coder);
    }

    public static @UnknownKeyFor @NonNull @Initialized Builder<@UnknownKeyFor @NonNull @Initialized Row> create(@UnknownKeyFor @NonNull @Initialized Schema schema) {
        return TestStream.create(SchemaCoder.of(schema));
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized Builder<T> create(@UnknownKeyFor @NonNull @Initialized Schema schema, @UnknownKeyFor @NonNull @Initialized TypeDescriptor<T> typeDescriptor, @UnknownKeyFor @NonNull @Initialized SerializableFunction<T, @UnknownKeyFor @NonNull @Initialized Row> toRowFunction, @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized Row, T> fromRowFunction) {
        return TestStream.create(SchemaCoder.of(schema, typeDescriptor, toRowFunction, fromRowFunction));
    }

    private TestStream(@UnknownKeyFor @NonNull @Initialized Coder<T> coder, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Event<T>> events) {
        this.coder = coder;
        this.events = Preconditions.checkNotNull(events);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized PCollection<T> expand(@UnknownKeyFor @NonNull @Initialized PBegin input) {
        return PCollection.createPrimitiveOutputInternal(input.getPipeline(), WindowingStrategy.globalDefault(), PCollection.IsBounded.UNBOUNDED, this.coder);
    }

    public @UnknownKeyFor @NonNull @Initialized Coder<T> getValueCoder() {
        return this.coder;
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Event<T>> getEvents() {
        return this.events;
    }

    @Internal
    public static <T> @UnknownKeyFor @NonNull @Initialized TestStream<T> fromRawEvents(@UnknownKeyFor @NonNull @Initialized Coder<T> coder, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Event<T>> events) {
        return new TestStream<T>(coder, events);
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object other) {
        if (!(other instanceof TestStream)) {
            return false;
        }
        TestStream that = (TestStream)other;
        return this.getValueCoder().equals(that.getValueCoder()) && this.getEvents().equals(that.getEvents());
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        return Objects.hash(TestStream.class, this.getValueCoder(), this.getEvents());
    }

    public static class TestStreamCoder<@UnknownKeyFor T>
    extends StructuredCoder<TestStream<T>> {
        private final @UnknownKeyFor @NonNull @Initialized TimestampedValue.TimestampedValueCoder<T> elementCoder;

        public static <T> @UnknownKeyFor @NonNull @Initialized TestStreamCoder<T> of(@UnknownKeyFor @NonNull @Initialized Coder<T> valueCoder) {
            return new TestStreamCoder<T>(valueCoder);
        }

        private TestStreamCoder(@UnknownKeyFor @NonNull @Initialized Coder<T> valueCoder) {
            this.elementCoder = TimestampedValue.TimestampedValueCoder.of(valueCoder);
        }

        @Override
        public void encode(@UnknownKeyFor @NonNull @Initialized TestStream<T> value, @UnknownKeyFor @NonNull @Initialized OutputStream outStream) throws @UnknownKeyFor @NonNull @Initialized IOException {
            List<Event<T>> events = value.getEvents();
            VarIntCoder.of().encode(events.size(), outStream);
            for (Event<T> event : events) {
                if (event instanceof ElementEvent) {
                    outStream.write(event.getType().ordinal());
                    Iterable elements = ((ElementEvent)event).getElements();
                    VarIntCoder.of().encode(Iterables.size(elements), outStream);
                    for (TimestampedValue element : elements) {
                        this.elementCoder.encode(element, outStream);
                    }
                    continue;
                }
                if (event instanceof WatermarkEvent) {
                    outStream.write(event.getType().ordinal());
                    Instant watermark = ((WatermarkEvent)event).getWatermark();
                    InstantCoder.of().encode(watermark, outStream);
                    continue;
                }
                if (!(event instanceof ProcessingTimeEvent)) continue;
                outStream.write(event.getType().ordinal());
                Duration processingTimeAdvance = ((ProcessingTimeEvent)event).getProcessingTimeAdvance();
                DurationCoder.of().encode((ReadableDuration)processingTimeAdvance, outStream);
            }
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized TestStream<T> decode(@UnknownKeyFor @NonNull @Initialized InputStream inStream) throws @UnknownKeyFor @NonNull @Initialized IOException {
            Integer numberOfEvents = VarIntCoder.of().decode(inStream);
            ArrayList events = new ArrayList(numberOfEvents);
            block5: for (int i = 0; i < numberOfEvents; ++i) {
                EventType eventType = EventType.values()[inStream.read()];
                switch (eventType) {
                    case ELEMENT: {
                        int numElements = VarIntCoder.of().decode(inStream);
                        ArrayList elements = new ArrayList(numElements);
                        for (int j = 0; j < numElements; ++j) {
                            elements.add(this.elementCoder.decode(inStream));
                        }
                        events.add(ElementEvent.add(elements));
                        continue block5;
                    }
                    case WATERMARK: {
                        Instant watermark = InstantCoder.of().decode(inStream);
                        events.add(WatermarkEvent.advanceTo(watermark));
                        continue block5;
                    }
                    case PROCESSING_TIME: {
                        Duration duration = DurationCoder.of().decode(inStream).toDuration();
                        events.add(ProcessingTimeEvent.advanceBy(duration));
                        continue block5;
                    }
                    default: {
                        throw new IllegalStateException("Unknown event type + " + (Object)((Object)eventType));
                    }
                }
            }
            return TestStream.fromRawEvents(this.elementCoder.getValueCoder(), events);
        }

        @Override
        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized List<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> getCoderArguments() {
            return Collections.singletonList(this.elementCoder);
        }

        @Override
        public void verifyDeterministic() throws @UnknownKeyFor @NonNull @Initialized Coder.NonDeterministicException {
        }
    }

    @AutoValue
    public static abstract class ProcessingTimeEvent<@UnknownKeyFor T>
    implements Event<T> {
        public abstract @UnknownKeyFor @NonNull @Initialized Duration getProcessingTimeAdvance();

        @Internal
        public static <T> @UnknownKeyFor @NonNull @Initialized Event<T> advanceBy(@UnknownKeyFor @NonNull @Initialized Duration amount) {
            return new AutoValue_TestStream_ProcessingTimeEvent(EventType.PROCESSING_TIME, amount);
        }
    }

    @AutoValue
    public static abstract class WatermarkEvent<@UnknownKeyFor T>
    implements Event<T> {
        public abstract @UnknownKeyFor @NonNull @Initialized Instant getWatermark();

        @Internal
        public static <T> @UnknownKeyFor @NonNull @Initialized Event<T> advanceTo(@UnknownKeyFor @NonNull @Initialized Instant newWatermark) {
            return new AutoValue_TestStream_WatermarkEvent(EventType.WATERMARK, newWatermark);
        }
    }

    @AutoValue
    public static abstract class ElementEvent<@UnknownKeyFor T>
    implements Event<T> {
        public abstract @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized TimestampedValue<T>> getElements();

        @SafeVarargs
        static <T> @UnknownKeyFor @NonNull @Initialized Event<T> add(@UnknownKeyFor @NonNull @Initialized TimestampedValue<T> element, TimestampedValue<T> ... elements) {
            return ElementEvent.add(((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().add(element)).add(elements)).build());
        }

        @Internal
        public static <T> @UnknownKeyFor @NonNull @Initialized Event<T> add(@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized TimestampedValue<T>> elements) {
            return new AutoValue_TestStream_ElementEvent<T>(EventType.ELEMENT, elements);
        }
    }

    public static enum EventType {
        ELEMENT,
        WATERMARK,
        PROCESSING_TIME;

    }

    public static interface Event<@UnknownKeyFor T> {
        public @UnknownKeyFor @NonNull @Initialized EventType getType();
    }

    public static class Builder<@UnknownKeyFor T> {
        private final @UnknownKeyFor @NonNull @Initialized Coder<T> coder;
        private final @UnknownKeyFor @NonNull @Initialized ImmutableList<@UnknownKeyFor @NonNull @Initialized Event<T>> events;
        private final @UnknownKeyFor @NonNull @Initialized Instant currentWatermark;

        private Builder(@UnknownKeyFor @NonNull @Initialized Coder<T> coder) {
            this(coder, ImmutableList.of(), BoundedWindow.TIMESTAMP_MIN_VALUE);
        }

        private Builder(@UnknownKeyFor @NonNull @Initialized Coder<T> coder, @UnknownKeyFor @NonNull @Initialized ImmutableList<@UnknownKeyFor @NonNull @Initialized Event<T>> events, @UnknownKeyFor @NonNull @Initialized Instant currentWatermark) {
            this.coder = coder;
            this.events = events;
            this.currentWatermark = currentWatermark;
        }

        @SafeVarargs
        public final @UnknownKeyFor @NonNull @Initialized Builder<T> addElements(T element, T ... elements) {
            TimestampedValue<T> firstElement = TimestampedValue.of(element, this.currentWatermark);
            TimestampedValue[] remainingElements = new TimestampedValue[elements.length];
            for (int i = 0; i < elements.length; ++i) {
                remainingElements[i] = TimestampedValue.of(elements[i], this.currentWatermark);
            }
            return this.addElements(firstElement, remainingElements);
        }

        @SafeVarargs
        public final @UnknownKeyFor @NonNull @Initialized Builder<T> addElements(@UnknownKeyFor @NonNull @Initialized TimestampedValue<T> element, TimestampedValue<T> ... elements) {
            Preconditions.checkArgument(element.getTimestamp().isBefore((ReadableInstant)BoundedWindow.TIMESTAMP_MAX_VALUE), "Elements must have timestamps before %s. Got: %s", (Object)BoundedWindow.TIMESTAMP_MAX_VALUE, (Object)element.getTimestamp());
            for (TimestampedValue<T> multiElement : elements) {
                Preconditions.checkArgument(multiElement.getTimestamp().isBefore((ReadableInstant)BoundedWindow.TIMESTAMP_MAX_VALUE), "Elements must have timestamps before %s. Got: %s", (Object)BoundedWindow.TIMESTAMP_MAX_VALUE, (Object)multiElement.getTimestamp());
            }
            ImmutableCollection newEvents = ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(this.events)).add(ElementEvent.add(element, elements))).build();
            return new Builder<T>(this.coder, newEvents, this.currentWatermark);
        }

        public @UnknownKeyFor @NonNull @Initialized Builder<T> advanceWatermarkTo(@UnknownKeyFor @NonNull @Initialized Instant newWatermark) {
            Preconditions.checkArgument(!newWatermark.isBefore((ReadableInstant)this.currentWatermark), "The watermark must monotonically advance");
            Preconditions.checkArgument(newWatermark.isBefore((ReadableInstant)BoundedWindow.TIMESTAMP_MAX_VALUE), "The Watermark cannot progress beyond the maximum. Got: %s. Maximum: %s", (Object)newWatermark, (Object)BoundedWindow.TIMESTAMP_MAX_VALUE);
            ImmutableCollection newEvents = ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(this.events)).add(WatermarkEvent.advanceTo(newWatermark))).build();
            return new Builder<T>(this.coder, newEvents, newWatermark);
        }

        public @UnknownKeyFor @NonNull @Initialized Builder<T> advanceProcessingTime(@UnknownKeyFor @NonNull @Initialized Duration amount) {
            Preconditions.checkArgument(amount.getMillis() > 0L, "Must advance the processing time by a positive amount. Got: %s", (Object)amount);
            ImmutableCollection newEvents = ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(this.events)).add(ProcessingTimeEvent.advanceBy(amount))).build();
            return new Builder<T>(this.coder, newEvents, this.currentWatermark);
        }

        public @UnknownKeyFor @NonNull @Initialized TestStream<T> advanceWatermarkToInfinity() {
            ImmutableCollection newEvents = ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(this.events)).add(WatermarkEvent.advanceTo(BoundedWindow.TIMESTAMP_MAX_VALUE))).build();
            return new TestStream(this.coder, (List)((Object)newEvents));
        }
    }
}

