/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.schemas.transforms;

import com.google.auto.value.AutoOneOf;
import com.google.auto.value.AutoValue;
import java.io.Serializable;
import java.util.List;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.schemas.FieldAccessDescriptor;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.SchemaCoder;
import org.apache.beam.sdk.schemas.transforms.AutoOneOf_Group_CombineFieldsByFields_Fanout;
import org.apache.beam.sdk.schemas.transforms.AutoValue_Group_ByFields;
import org.apache.beam.sdk.schemas.transforms.AutoValue_Group_CombineFieldsByFields;
import org.apache.beam.sdk.schemas.transforms.Convert;
import org.apache.beam.sdk.schemas.transforms.SchemaAggregateFn;
import org.apache.beam.sdk.schemas.utils.RowSelector;
import org.apache.beam.sdk.schemas.utils.SelectHelpers;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.GroupByKey;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.Values;
import org.apache.beam.sdk.transforms.WithKeys;
import org.apache.beam.sdk.transforms.windowing.GlobalWindows;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TypeDescriptors;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Lists;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class Group {
    public static <T> @UnknownKeyFor @NonNull @Initialized Global<T> globally() {
        return new Global();
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized ByFields<T> byFieldNames(String ... fieldNames) {
        return ByFields.of(FieldAccessDescriptor.withFieldNames(fieldNames));
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized ByFields<T> byFieldNames(@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized String> fieldNames) {
        return ByFields.of(FieldAccessDescriptor.withFieldNames(fieldNames));
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized ByFields<T> byFieldIds(Integer ... fieldIds) {
        return ByFields.of(FieldAccessDescriptor.withFieldIds(fieldIds));
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized ByFields<T> byFieldIds(@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized Integer> fieldIds) {
        return ByFields.of(FieldAccessDescriptor.withFieldIds(fieldIds));
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized ByFields<T> byFieldAccessDescriptor(@UnknownKeyFor @NonNull @Initialized FieldAccessDescriptor fieldAccess) {
        return ByFields.of(fieldAccess);
    }

    @AutoValue
    public static abstract class CombineFieldsByFields<@UnknownKeyFor InputT>
    extends AggregateCombiner<InputT> {
        abstract @Nullable @UnknownKeyFor @Initialized Fanout getFanout();

        abstract @UnknownKeyFor @NonNull @Initialized Boolean getFewKeys();

        abstract @UnknownKeyFor @NonNull @Initialized ByFields<InputT> getByFields();

        abstract @UnknownKeyFor @NonNull @Initialized SchemaAggregateFn.Inner getSchemaAggregateFn();

        abstract @UnknownKeyFor @NonNull @Initialized String getKeyField();

        abstract @UnknownKeyFor @NonNull @Initialized String getValueField();

        abstract @UnknownKeyFor @NonNull @Initialized Builder<InputT> toBuilder();

        static <InputT> @UnknownKeyFor @NonNull @Initialized CombineFieldsByFields<InputT> of(@UnknownKeyFor @NonNull @Initialized ByFields<InputT> byFields, @UnknownKeyFor @NonNull @Initialized SchemaAggregateFn.Inner schemaAggregateFn, @UnknownKeyFor @NonNull @Initialized String keyField, @UnknownKeyFor @NonNull @Initialized String valueField) {
            return new AutoValue_Group_CombineFieldsByFields.Builder<InputT>().setByFields(byFields).setSchemaAggregateFn(schemaAggregateFn).setKeyField(keyField).setValueField(valueField).setFewKeys(true).build();
        }

        public @UnknownKeyFor @NonNull @Initialized CombineFieldsByFields<InputT> withKeyField(@UnknownKeyFor @NonNull @Initialized String keyField) {
            return this.toBuilder().setKeyField(keyField).build();
        }

        public @UnknownKeyFor @NonNull @Initialized CombineFieldsByFields<InputT> witValueField(@UnknownKeyFor @NonNull @Initialized String valueField) {
            return this.toBuilder().setValueField(valueField).build();
        }

        public @UnknownKeyFor @NonNull @Initialized CombineFieldsByFields<InputT> withPrecombining(@UnknownKeyFor @NonNull @Initialized boolean value) {
            return this.toBuilder().setFewKeys(value).build();
        }

        public @UnknownKeyFor @NonNull @Initialized CombineFieldsByFields<InputT> withHotKeyFanout(@UnknownKeyFor @NonNull @Initialized int n) {
            return this.toBuilder().setFanout(Fanout.of(n)).build();
        }

        public @UnknownKeyFor @NonNull @Initialized CombineFieldsByFields<InputT> withHotKeyFanout(@UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized Row, @UnknownKeyFor @NonNull @Initialized Integer> f) {
            return this.toBuilder().setFanout(Fanout.of(f)).build();
        }

        public <CombineInputT, AccumT, CombineOutputT> @UnknownKeyFor @NonNull @Initialized CombineFieldsByFields<InputT> aggregateField(@UnknownKeyFor @NonNull @Initialized String inputFieldName, @UnknownKeyFor @NonNull @Initialized Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, @UnknownKeyFor @NonNull @Initialized String outputFieldName) {
            return this.toBuilder().setSchemaAggregateFn(this.getSchemaAggregateFn().aggregateFields(FieldAccessDescriptor.withFieldNames(inputFieldName), false, fn, outputFieldName)).build();
        }

        public <CombineInputT, AccumT, CombineOutputT> @UnknownKeyFor @NonNull @Initialized CombineFieldsByFields<InputT> aggregateFieldBaseValue(@UnknownKeyFor @NonNull @Initialized String inputFieldName, @UnknownKeyFor @NonNull @Initialized Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, @UnknownKeyFor @NonNull @Initialized String outputFieldName) {
            return this.toBuilder().setSchemaAggregateFn(this.getSchemaAggregateFn().aggregateFields(FieldAccessDescriptor.withFieldNames(inputFieldName), true, fn, outputFieldName)).build();
        }

        public <CombineInputT, AccumT, CombineOutputT> @UnknownKeyFor @NonNull @Initialized CombineFieldsByFields<InputT> aggregateField(@UnknownKeyFor @NonNull @Initialized int inputFieldId, @UnknownKeyFor @NonNull @Initialized Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, @UnknownKeyFor @NonNull @Initialized String outputFieldName) {
            return this.toBuilder().setSchemaAggregateFn(this.getSchemaAggregateFn().aggregateFields(FieldAccessDescriptor.withFieldIds(inputFieldId), false, fn, outputFieldName)).build();
        }

        public <CombineInputT, AccumT, CombineOutputT> @UnknownKeyFor @NonNull @Initialized CombineFieldsByFields<InputT> aggregateFieldBaseValue(@UnknownKeyFor @NonNull @Initialized int inputFieldId, @UnknownKeyFor @NonNull @Initialized Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, @UnknownKeyFor @NonNull @Initialized String outputFieldName) {
            return this.toBuilder().setSchemaAggregateFn(this.getSchemaAggregateFn().aggregateFields(FieldAccessDescriptor.withFieldIds(inputFieldId), true, fn, outputFieldName)).build();
        }

        @Override
        public <CombineInputT, AccumT, CombineOutputT> @UnknownKeyFor @NonNull @Initialized CombineFieldsByFields<InputT> aggregateField(@UnknownKeyFor @NonNull @Initialized String inputFieldName, @UnknownKeyFor @NonNull @Initialized Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, @UnknownKeyFor @NonNull @Initialized Schema.Field outputField) {
            return this.toBuilder().setSchemaAggregateFn(this.getSchemaAggregateFn().aggregateFields(FieldAccessDescriptor.withFieldNames(inputFieldName), false, fn, outputField)).build();
        }

        public <CombineInputT, AccumT, CombineOutputT> @UnknownKeyFor @NonNull @Initialized CombineFieldsByFields<InputT> aggregateFieldBaseValue(@UnknownKeyFor @NonNull @Initialized String inputFieldName, @UnknownKeyFor @NonNull @Initialized Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, @UnknownKeyFor @NonNull @Initialized Schema.Field outputField) {
            return this.toBuilder().setSchemaAggregateFn(this.getSchemaAggregateFn().aggregateFields(FieldAccessDescriptor.withFieldNames(inputFieldName), true, fn, outputField)).build();
        }

        @Override
        public <CombineInputT, AccumT, CombineOutputT> @UnknownKeyFor @NonNull @Initialized CombineFieldsByFields<InputT> aggregateField(@UnknownKeyFor @NonNull @Initialized int inputFieldId, @UnknownKeyFor @NonNull @Initialized Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, @UnknownKeyFor @NonNull @Initialized Schema.Field outputField) {
            return this.toBuilder().setSchemaAggregateFn(this.getSchemaAggregateFn().aggregateFields(FieldAccessDescriptor.withFieldIds(inputFieldId), false, fn, outputField)).build();
        }

        public <CombineInputT, AccumT, CombineOutputT> @UnknownKeyFor @NonNull @Initialized CombineFieldsByFields<InputT> aggregateFieldBaseValue(@UnknownKeyFor @NonNull @Initialized int inputFieldId, @UnknownKeyFor @NonNull @Initialized Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, @UnknownKeyFor @NonNull @Initialized Schema.Field outputField) {
            return this.toBuilder().setSchemaAggregateFn(this.getSchemaAggregateFn().aggregateFields(FieldAccessDescriptor.withFieldIds(inputFieldId), true, fn, outputField)).build();
        }

        public <CombineInputT, AccumT, CombineOutputT> @UnknownKeyFor @NonNull @Initialized CombineFieldsByFields<InputT> aggregateFields(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> inputFieldNames, @UnknownKeyFor @NonNull @Initialized Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, @UnknownKeyFor @NonNull @Initialized String outputFieldName) {
            return this.aggregateFields(FieldAccessDescriptor.withFieldNames(inputFieldNames), fn, outputFieldName);
        }

        public <CombineInputT, AccumT, CombineOutputT> @UnknownKeyFor @NonNull @Initialized CombineFieldsByFields<InputT> aggregateFields(@UnknownKeyFor @NonNull @Initialized FieldAccessDescriptor fieldsToAggregate, @UnknownKeyFor @NonNull @Initialized Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, @UnknownKeyFor @NonNull @Initialized String outputFieldName) {
            return this.toBuilder().setSchemaAggregateFn(this.getSchemaAggregateFn().aggregateFields(fieldsToAggregate, false, fn, outputFieldName)).build();
        }

        public <CombineInputT, AccumT, CombineOutputT> @UnknownKeyFor @NonNull @Initialized CombineFieldsByFields<InputT> aggregateFields(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> inputFieldNames, @UnknownKeyFor @NonNull @Initialized Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, @UnknownKeyFor @NonNull @Initialized Schema.Field outputField) {
            return this.aggregateFields(FieldAccessDescriptor.withFieldNames(inputFieldNames), fn, outputField);
        }

        @Override
        public <CombineInputT, AccumT, CombineOutputT> @UnknownKeyFor @NonNull @Initialized CombineFieldsByFields<InputT> aggregateFieldsById(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Integer> inputFieldIds, @UnknownKeyFor @NonNull @Initialized Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, @UnknownKeyFor @NonNull @Initialized Schema.Field outputField) {
            return this.aggregateFields(FieldAccessDescriptor.withFieldIds(inputFieldIds), fn, outputField);
        }

        public <CombineInputT, AccumT, CombineOutputT> @UnknownKeyFor @NonNull @Initialized CombineFieldsByFields<InputT> aggregateFields(@UnknownKeyFor @NonNull @Initialized FieldAccessDescriptor fieldsToAggregate, @UnknownKeyFor @NonNull @Initialized Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, @UnknownKeyFor @NonNull @Initialized Schema.Field outputField) {
            return this.toBuilder().setSchemaAggregateFn(this.getSchemaAggregateFn().aggregateFields(fieldsToAggregate, false, fn, outputField)).build();
        }

        @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized Row, @UnknownKeyFor @NonNull @Initialized Row>>, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized Row, @UnknownKeyFor @NonNull @Initialized Row>>> getCombineTransform(@UnknownKeyFor @NonNull @Initialized Schema schema) {
            SchemaAggregateFn.Inner fn = this.getSchemaAggregateFn().withSchema(schema);
            @Nullable Fanout fanout = this.getFanout();
            if (fanout != null) {
                switch (fanout.getKind()) {
                    case NUMBER: {
                        return Combine.perKey(fn).withHotKeyFanout(fanout.getNumber());
                    }
                    case FUNCTION: {
                        return Combine.perKey(fn).withHotKeyFanout(fanout.getFunction());
                    }
                }
                throw new RuntimeException("Unexpected kind: " + (Object)((Object)fanout.getKind()));
            }
            return this.getFewKeys() != false ? Combine.fewKeys(fn) : Combine.perKey(fn);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row> expand(@UnknownKeyFor @NonNull @Initialized PCollection<InputT> input) {
            Schema keySchema = this.getByFields().getKeySchema(input.getSchema());
            final Schema outputSchema = Schema.builder().addRowField(this.getKeyField(), keySchema).addRowField(this.getValueField(), this.getSchemaAggregateFn().getOutputSchema()).build();
            return ((PCollection)((Object)((PCollection)input.apply("ToKvs", this.getByFields().getToKV())).apply("Combine", this.getCombineTransform(input.getSchema())).apply("ToRow", ParDo.of(new DoFn<KV<Row, Row>, Row>(){

                @DoFn.ProcessElement
                public void process(@DoFn.Element @UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized Row, @UnknownKeyFor @NonNull @Initialized Row> element, @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized Row> o) {
                    o.output(Row.withSchema(outputSchema).attachValues(Lists.newArrayList(element.getKey(), element.getValue())));
                }
            })))).setRowSchema(outputSchema);
        }

        @AutoValue.Builder
        static abstract class Builder<@UnknownKeyFor InputT> {
            Builder() {
            }

            public abstract @UnknownKeyFor @NonNull @Initialized Builder<InputT> setFanout(@Nullable @UnknownKeyFor @Initialized Fanout var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder<InputT> setFewKeys(@UnknownKeyFor @NonNull @Initialized Boolean var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<InputT> setByFields(@UnknownKeyFor @NonNull @Initialized ByFields<InputT> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<InputT> setSchemaAggregateFn(@UnknownKeyFor @NonNull @Initialized SchemaAggregateFn.Inner var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<InputT> setKeyField(@UnknownKeyFor @NonNull @Initialized String var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<InputT> setValueField(@UnknownKeyFor @NonNull @Initialized String var1);

            abstract @UnknownKeyFor @NonNull @Initialized CombineFieldsByFields<InputT> build();
        }

        @AutoOneOf(value=Kind.class)
        public static abstract class Fanout
        implements Serializable {
            public abstract @UnknownKeyFor @NonNull @Initialized Kind getKind();

            public abstract @UnknownKeyFor @NonNull @Initialized Integer getNumber();

            public abstract @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized Row, @UnknownKeyFor @NonNull @Initialized Integer> getFunction();

            public static @UnknownKeyFor @NonNull @Initialized Fanout of(@UnknownKeyFor @NonNull @Initialized int n) {
                return AutoOneOf_Group_CombineFieldsByFields_Fanout.number(n);
            }

            public static @UnknownKeyFor @NonNull @Initialized Fanout of(@UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized Row, @UnknownKeyFor @NonNull @Initialized Integer> f) {
                return AutoOneOf_Group_CombineFieldsByFields_Fanout.function(f);
            }

            public static enum Kind {
                NUMBER,
                FUNCTION;

            }
        }
    }

    @AutoValue
    public static abstract class ByFields<@UnknownKeyFor InputT>
    extends AggregateCombiner<InputT> {
        abstract @UnknownKeyFor @NonNull @Initialized FieldAccessDescriptor getFieldAccessDescriptor();

        abstract @UnknownKeyFor @NonNull @Initialized String getKeyField();

        abstract @UnknownKeyFor @NonNull @Initialized String getValueField();

        abstract @UnknownKeyFor @NonNull @Initialized Builder<InputT> toBuilder();

        public @UnknownKeyFor @NonNull @Initialized ByFields. @UnknownKeyFor @NonNull @Initialized ToKV getToKV() {
            return new ToKV();
        }

        private static <InputT> @UnknownKeyFor @NonNull @Initialized ByFields<InputT> of(@UnknownKeyFor @NonNull @Initialized FieldAccessDescriptor fieldAccessDescriptor) {
            return new AutoValue_Group_ByFields.Builder().setFieldAccessDescriptor(fieldAccessDescriptor).setKeyField("key").setValueField("value").build();
        }

        public @UnknownKeyFor @NonNull @Initialized ByFields<InputT> withKeyField(@UnknownKeyFor @NonNull @Initialized String keyField) {
            return this.toBuilder().setKeyField(keyField).build();
        }

        public @UnknownKeyFor @NonNull @Initialized ByFields<InputT> withValueField(@UnknownKeyFor @NonNull @Initialized String valueField) {
            return this.toBuilder().setValueField(valueField).build();
        }

        public <CombineInputT, AccumT, CombineOutputT> @UnknownKeyFor @NonNull @Initialized CombineFieldsByFields<InputT> aggregateField(@UnknownKeyFor @NonNull @Initialized String inputFieldName, @UnknownKeyFor @NonNull @Initialized Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, @UnknownKeyFor @NonNull @Initialized String outputFieldName) {
            return CombineFieldsByFields.of(this, SchemaAggregateFn.create().aggregateFields(FieldAccessDescriptor.withFieldNames(inputFieldName), false, fn, outputFieldName), this.getKeyField(), this.getValueField());
        }

        public <CombineInputT, AccumT, CombineOutputT> @UnknownKeyFor @NonNull @Initialized CombineFieldsByFields<InputT> aggregateFieldBaseValue(@UnknownKeyFor @NonNull @Initialized String inputFieldName, @UnknownKeyFor @NonNull @Initialized Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, @UnknownKeyFor @NonNull @Initialized String outputFieldName) {
            return CombineFieldsByFields.of(this, SchemaAggregateFn.create().aggregateFields(FieldAccessDescriptor.withFieldNames(inputFieldName), true, fn, outputFieldName), this.getKeyField(), this.getValueField());
        }

        public <CombineInputT, AccumT, CombineOutputT> @UnknownKeyFor @NonNull @Initialized CombineFieldsByFields<InputT> aggregateField(@UnknownKeyFor @NonNull @Initialized int inputFieldId, @UnknownKeyFor @NonNull @Initialized Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, @UnknownKeyFor @NonNull @Initialized String outputFieldName) {
            return CombineFieldsByFields.of(this, SchemaAggregateFn.create().aggregateFields(FieldAccessDescriptor.withFieldIds(inputFieldId), false, fn, outputFieldName), this.getKeyField(), this.getValueField());
        }

        public <CombineInputT, AccumT, CombineOutputT> @UnknownKeyFor @NonNull @Initialized CombineFieldsByFields<InputT> aggregateFieldBaseValue(@UnknownKeyFor @NonNull @Initialized int inputFieldId, @UnknownKeyFor @NonNull @Initialized Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, @UnknownKeyFor @NonNull @Initialized String outputFieldName) {
            return CombineFieldsByFields.of(this, SchemaAggregateFn.create().aggregateFields(FieldAccessDescriptor.withFieldIds(inputFieldId), true, fn, outputFieldName), this.getKeyField(), this.getValueField());
        }

        @Override
        public <CombineInputT, AccumT, CombineOutputT> @UnknownKeyFor @NonNull @Initialized CombineFieldsByFields<InputT> aggregateField(@UnknownKeyFor @NonNull @Initialized String inputFieldName, @UnknownKeyFor @NonNull @Initialized Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, @UnknownKeyFor @NonNull @Initialized Schema.Field outputField) {
            return CombineFieldsByFields.of(this, SchemaAggregateFn.create().aggregateFields(FieldAccessDescriptor.withFieldNames(inputFieldName), false, fn, outputField), this.getKeyField(), this.getValueField());
        }

        public <CombineInputT, AccumT, CombineOutputT> @UnknownKeyFor @NonNull @Initialized CombineFieldsByFields<InputT> aggregateFieldBaseValue(@UnknownKeyFor @NonNull @Initialized String inputFieldName, @UnknownKeyFor @NonNull @Initialized Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, @UnknownKeyFor @NonNull @Initialized Schema.Field outputField) {
            return CombineFieldsByFields.of(this, SchemaAggregateFn.create().aggregateFields(FieldAccessDescriptor.withFieldNames(inputFieldName), true, fn, outputField), this.getKeyField(), this.getValueField());
        }

        @Override
        public <CombineInputT, AccumT, CombineOutputT> @UnknownKeyFor @NonNull @Initialized CombineFieldsByFields<InputT> aggregateField(@UnknownKeyFor @NonNull @Initialized int inputFieldId, @UnknownKeyFor @NonNull @Initialized Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, @UnknownKeyFor @NonNull @Initialized Schema.Field outputField) {
            return CombineFieldsByFields.of(this, SchemaAggregateFn.create().aggregateFields(FieldAccessDescriptor.withFieldIds(inputFieldId), false, fn, outputField), this.getKeyField(), this.getValueField());
        }

        public <CombineInputT, AccumT, CombineOutputT> @UnknownKeyFor @NonNull @Initialized CombineFieldsByFields<InputT> aggregateFieldBaseValue(@UnknownKeyFor @NonNull @Initialized int inputFieldId, @UnknownKeyFor @NonNull @Initialized Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, @UnknownKeyFor @NonNull @Initialized Schema.Field outputField) {
            return CombineFieldsByFields.of(this, SchemaAggregateFn.create().aggregateFields(FieldAccessDescriptor.withFieldIds(inputFieldId), true, fn, outputField), this.getKeyField(), this.getValueField());
        }

        public <CombineInputT, AccumT, CombineOutputT> @UnknownKeyFor @NonNull @Initialized CombineFieldsByFields<InputT> aggregateFields(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> inputFieldNames, @UnknownKeyFor @NonNull @Initialized Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, @UnknownKeyFor @NonNull @Initialized String outputFieldName) {
            return this.aggregateFields(FieldAccessDescriptor.withFieldNames(inputFieldNames), fn, outputFieldName);
        }

        public <CombineInputT, AccumT, CombineOutputT> @UnknownKeyFor @NonNull @Initialized CombineFieldsByFields<InputT> aggregateFieldsById(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Integer> inputFieldIds, @UnknownKeyFor @NonNull @Initialized Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, @UnknownKeyFor @NonNull @Initialized String outputFieldName) {
            return this.aggregateFields(FieldAccessDescriptor.withFieldIds(inputFieldIds), fn, outputFieldName);
        }

        public <CombineInputT, AccumT, CombineOutputT> @UnknownKeyFor @NonNull @Initialized CombineFieldsByFields<InputT> aggregateFields(@UnknownKeyFor @NonNull @Initialized FieldAccessDescriptor fieldsToAggregate, @UnknownKeyFor @NonNull @Initialized Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, @UnknownKeyFor @NonNull @Initialized String outputFieldName) {
            return CombineFieldsByFields.of(this, SchemaAggregateFn.create().aggregateFields(fieldsToAggregate, false, fn, outputFieldName), this.getKeyField(), this.getValueField());
        }

        public <CombineInputT, AccumT, CombineOutputT> @UnknownKeyFor @NonNull @Initialized CombineFieldsByFields<InputT> aggregateFields(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> inputFieldNames, @UnknownKeyFor @NonNull @Initialized Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, @UnknownKeyFor @NonNull @Initialized Schema.Field outputField) {
            return this.aggregateFields(FieldAccessDescriptor.withFieldNames(inputFieldNames), fn, outputField);
        }

        @Override
        public <CombineInputT, AccumT, CombineOutputT> @UnknownKeyFor @NonNull @Initialized CombineFieldsByFields<InputT> aggregateFieldsById(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Integer> inputFieldIds, @UnknownKeyFor @NonNull @Initialized Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, @UnknownKeyFor @NonNull @Initialized Schema.Field outputField) {
            return this.aggregateFields(FieldAccessDescriptor.withFieldIds(inputFieldIds), fn, outputField);
        }

        public <CombineInputT, AccumT, CombineOutputT> @UnknownKeyFor @NonNull @Initialized CombineFieldsByFields<InputT> aggregateFields(@UnknownKeyFor @NonNull @Initialized FieldAccessDescriptor fieldsToAggregate, @UnknownKeyFor @NonNull @Initialized Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, @UnknownKeyFor @NonNull @Initialized Schema.Field outputField) {
            return CombineFieldsByFields.of(this, SchemaAggregateFn.create().aggregateFields(fieldsToAggregate, false, fn, outputField), this.getKeyField(), this.getValueField());
        }

        @UnknownKeyFor @NonNull @Initialized Schema getKeySchema(@UnknownKeyFor @NonNull @Initialized Schema inputSchema) {
            FieldAccessDescriptor resolved = this.getFieldAccessDescriptor().resolve(inputSchema);
            return SelectHelpers.getOutputSchema(inputSchema, resolved);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row> expand(@UnknownKeyFor @NonNull @Initialized PCollection<InputT> input) {
            Schema schema = input.getSchema();
            Schema keySchema = this.getKeySchema(schema);
            final Schema outputSchema = Schema.builder().addRowField(this.getKeyField(), keySchema).addIterableField(this.getValueField(), Schema.FieldType.row(schema)).build();
            return ((PCollection)((Object)((PCollection)((PCollection)input.apply("ToKvs", this.getToKV())).apply("GroupByKey", GroupByKey.create())).apply("ToRow", ParDo.of(new DoFn<KV<Row, Iterable<Row>>, Row>(){

                @DoFn.ProcessElement
                public void process(@DoFn.Element @UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized Row, @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized Row>> e, @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized Row> o) {
                    o.output(Row.withSchema(outputSchema).attachValues(Lists.newArrayList(e.getKey(), e.getValue())));
                }
            })))).setRowSchema(outputSchema);
        }

        class ToKV
        extends PTransform<PCollection<InputT>, PCollection<KV<Row, Row>>> {
            private @UnknownKeyFor @NonNull @Initialized RowSelector rowSelector;

            ToKV() {
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized Row, @UnknownKeyFor @NonNull @Initialized Row>> expand(@UnknownKeyFor @NonNull @Initialized PCollection<InputT> input) {
                Schema schema = input.getSchema();
                FieldAccessDescriptor resolved = ByFields.this.getFieldAccessDescriptor().resolve(schema);
                this.rowSelector = new SelectHelpers.RowSelectorContainer(schema, resolved, true);
                Schema keySchema = ByFields.this.getKeySchema(schema);
                return ((PCollection)input.apply("toRow", Convert.toRows()).apply("selectKeys", WithKeys.of(e -> this.rowSelector.select((Row)e)).withKeyType(TypeDescriptors.rows()))).setCoder(KvCoder.of(SchemaCoder.of(keySchema), SchemaCoder.of(schema)));
            }
        }

        @AutoValue.Builder
        static abstract class Builder<@UnknownKeyFor InputT> {
            Builder() {
            }

            abstract @UnknownKeyFor @NonNull @Initialized Builder<InputT> setFieldAccessDescriptor(@UnknownKeyFor @NonNull @Initialized FieldAccessDescriptor var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<InputT> setKeyField(@UnknownKeyFor @NonNull @Initialized String var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<InputT> setValueField(@UnknownKeyFor @NonNull @Initialized String var1);

            abstract @UnknownKeyFor @NonNull @Initialized ByFields<InputT> build();
        }
    }

    public static class CombineFieldsGlobally<@UnknownKeyFor InputT>
    extends AggregateCombiner<InputT> {
        private final @UnknownKeyFor @NonNull @Initialized SchemaAggregateFn.Inner schemaAggregateFn;
        private final @UnknownKeyFor @NonNull @Initialized int fanout;

        CombineFieldsGlobally(@UnknownKeyFor @NonNull @Initialized SchemaAggregateFn.Inner schemaAggregateFn, @UnknownKeyFor @NonNull @Initialized int fanout) {
            this.schemaAggregateFn = schemaAggregateFn;
            this.fanout = fanout;
        }

        public static /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized CombineFieldsGlobally<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> create() {
            return new CombineFieldsGlobally(SchemaAggregateFn.create(), 0);
        }

        public <CombineInputT, AccumT, CombineOutputT> @UnknownKeyFor @NonNull @Initialized CombineFieldsGlobally<InputT> aggregateField(@UnknownKeyFor @NonNull @Initialized String inputFieldName, @UnknownKeyFor @NonNull @Initialized Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, @UnknownKeyFor @NonNull @Initialized String outputFieldName) {
            return new CombineFieldsGlobally<InputT>(this.schemaAggregateFn.aggregateFields(FieldAccessDescriptor.withFieldNames(inputFieldName), false, fn, outputFieldName), this.fanout);
        }

        public <CombineInputT, AccumT, CombineOutputT> @UnknownKeyFor @NonNull @Initialized CombineFieldsGlobally<InputT> aggregateFieldBaseValue(@UnknownKeyFor @NonNull @Initialized String inputFieldName, @UnknownKeyFor @NonNull @Initialized Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, @UnknownKeyFor @NonNull @Initialized String outputFieldName) {
            return new CombineFieldsGlobally<InputT>(this.schemaAggregateFn.aggregateFields(FieldAccessDescriptor.withFieldNames(inputFieldName), true, fn, outputFieldName), this.fanout);
        }

        public <CombineInputT, AccumT, CombineOutputT> @UnknownKeyFor @NonNull @Initialized CombineFieldsGlobally<InputT> aggregateField(@UnknownKeyFor @NonNull @Initialized int inputFieldId, @UnknownKeyFor @NonNull @Initialized Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, @UnknownKeyFor @NonNull @Initialized String outputFieldName) {
            return new CombineFieldsGlobally<InputT>(this.schemaAggregateFn.aggregateFields(FieldAccessDescriptor.withFieldIds(inputFieldId), false, fn, outputFieldName), this.fanout);
        }

        public <CombineInputT, AccumT, CombineOutputT> @UnknownKeyFor @NonNull @Initialized CombineFieldsGlobally<InputT> aggregateFieldBaseValue(@UnknownKeyFor @NonNull @Initialized int inputFieldId, @UnknownKeyFor @NonNull @Initialized Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, @UnknownKeyFor @NonNull @Initialized String outputFieldName) {
            return new CombineFieldsGlobally<InputT>(this.schemaAggregateFn.aggregateFields(FieldAccessDescriptor.withFieldIds(inputFieldId), true, fn, outputFieldName), this.fanout);
        }

        @Override
        public <CombineInputT, AccumT, CombineOutputT> @UnknownKeyFor @NonNull @Initialized CombineFieldsGlobally<InputT> aggregateField(@UnknownKeyFor @NonNull @Initialized String inputFieldName, @UnknownKeyFor @NonNull @Initialized Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, @UnknownKeyFor @NonNull @Initialized Schema.Field outputField) {
            return new CombineFieldsGlobally<InputT>(this.schemaAggregateFn.aggregateFields(FieldAccessDescriptor.withFieldNames(inputFieldName), false, fn, outputField), this.fanout);
        }

        public <CombineInputT, AccumT, CombineOutputT> @UnknownKeyFor @NonNull @Initialized CombineFieldsGlobally<InputT> aggregateFieldBaseValue(@UnknownKeyFor @NonNull @Initialized String inputFieldName, @UnknownKeyFor @NonNull @Initialized Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, @UnknownKeyFor @NonNull @Initialized Schema.Field outputField) {
            return new CombineFieldsGlobally<InputT>(this.schemaAggregateFn.aggregateFields(FieldAccessDescriptor.withFieldNames(inputFieldName), true, fn, outputField), this.fanout);
        }

        @Override
        public <CombineInputT, AccumT, CombineOutputT> @UnknownKeyFor @NonNull @Initialized CombineFieldsGlobally<InputT> aggregateField(@UnknownKeyFor @NonNull @Initialized int inputFieldId, @UnknownKeyFor @NonNull @Initialized Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, @UnknownKeyFor @NonNull @Initialized Schema.Field outputField) {
            return new CombineFieldsGlobally<InputT>(this.schemaAggregateFn.aggregateFields(FieldAccessDescriptor.withFieldIds(inputFieldId), false, fn, outputField), this.fanout);
        }

        public <CombineInputT, AccumT, CombineOutputT> @UnknownKeyFor @NonNull @Initialized CombineFieldsGlobally<InputT> aggregateFieldBaseValue(@UnknownKeyFor @NonNull @Initialized int inputFieldId, @UnknownKeyFor @NonNull @Initialized Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, @UnknownKeyFor @NonNull @Initialized Schema.Field outputField) {
            return new CombineFieldsGlobally<InputT>(this.schemaAggregateFn.aggregateFields(FieldAccessDescriptor.withFieldIds(inputFieldId), true, fn, outputField), this.fanout);
        }

        public <CombineInputT, AccumT, CombineOutputT> @UnknownKeyFor @NonNull @Initialized CombineFieldsGlobally<InputT> aggregateFields(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> inputFieldNames, @UnknownKeyFor @NonNull @Initialized Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, @UnknownKeyFor @NonNull @Initialized String outputFieldName) {
            return this.aggregateFields(FieldAccessDescriptor.withFieldNames(inputFieldNames), fn, outputFieldName);
        }

        public <CombineInputT, AccumT, CombineOutputT> @UnknownKeyFor @NonNull @Initialized CombineFieldsGlobally<InputT> aggregateFieldsById(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Integer> inputFieldIds, @UnknownKeyFor @NonNull @Initialized Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, @UnknownKeyFor @NonNull @Initialized String outputFieldName) {
            return this.aggregateFields(FieldAccessDescriptor.withFieldIds(inputFieldIds), fn, outputFieldName);
        }

        public <CombineInputT, AccumT, CombineOutputT> @UnknownKeyFor @NonNull @Initialized CombineFieldsGlobally<InputT> aggregateFields(@UnknownKeyFor @NonNull @Initialized FieldAccessDescriptor fieldAccessDescriptor, @UnknownKeyFor @NonNull @Initialized Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, @UnknownKeyFor @NonNull @Initialized String outputFieldName) {
            return new CombineFieldsGlobally<InputT>(this.schemaAggregateFn.aggregateFields(fieldAccessDescriptor, false, fn, outputFieldName), this.fanout);
        }

        public <CombineInputT, AccumT, CombineOutputT> @UnknownKeyFor @NonNull @Initialized CombineFieldsGlobally<InputT> aggregateFields(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> inputFieldNames, @UnknownKeyFor @NonNull @Initialized Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, @UnknownKeyFor @NonNull @Initialized Schema.Field outputField) {
            return this.aggregateFields(FieldAccessDescriptor.withFieldNames(inputFieldNames), fn, outputField);
        }

        @Override
        public <CombineInputT, AccumT, CombineOutputT> @UnknownKeyFor @NonNull @Initialized CombineFieldsGlobally<InputT> aggregateFieldsById(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Integer> inputFieldIds, @UnknownKeyFor @NonNull @Initialized Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, @UnknownKeyFor @NonNull @Initialized Schema.Field outputField) {
            return this.aggregateFields(FieldAccessDescriptor.withFieldIds(inputFieldIds), fn, outputField);
        }

        public <CombineInputT, AccumT, CombineOutputT> @UnknownKeyFor @NonNull @Initialized CombineFieldsGlobally<InputT> aggregateFields(@UnknownKeyFor @NonNull @Initialized FieldAccessDescriptor fieldAccessDescriptor, @UnknownKeyFor @NonNull @Initialized Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, @UnknownKeyFor @NonNull @Initialized Schema.Field outputField) {
            return new CombineFieldsGlobally<InputT>(this.schemaAggregateFn.aggregateFields(fieldAccessDescriptor, false, fn, outputField), this.fanout);
        }

        public @UnknownKeyFor @NonNull @Initialized CombineFieldsGlobally<InputT> withFanout(@UnknownKeyFor @NonNull @Initialized int fanout) {
            return new CombineFieldsGlobally<InputT>(this.schemaAggregateFn, fanout);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row> expand(@UnknownKeyFor @NonNull @Initialized PCollection<InputT> input) {
            SchemaAggregateFn.Inner fn = this.schemaAggregateFn.withSchema(input.getSchema());
            Combine.Globally<Row, Row> combineFn = Combine.globally(fn).withFanout(this.fanout);
            if (!(input.getWindowingStrategy().getWindowFn() instanceof GlobalWindows)) {
                combineFn = combineFn.withoutDefaults();
            }
            return ((PCollection)((Object)input.apply("toRows", Convert.toRows()).apply("Global Combine", combineFn))).setRowSchema(fn.getOutputSchema());
        }
    }

    public static abstract class AggregateCombiner<@UnknownKeyFor InputT>
    extends PTransform<PCollection<InputT>, PCollection<Row>> {
        public abstract <CombineInputT, AccumT, CombineOutputT> @UnknownKeyFor @NonNull @Initialized AggregateCombiner<InputT> aggregateField(@UnknownKeyFor @NonNull @Initialized int var1, @UnknownKeyFor @NonNull @Initialized Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> var2, @UnknownKeyFor @NonNull @Initialized Schema.Field var3);

        public abstract <CombineInputT, AccumT, CombineOutputT> @UnknownKeyFor @NonNull @Initialized AggregateCombiner<InputT> aggregateField(@UnknownKeyFor @NonNull @Initialized String var1, @UnknownKeyFor @NonNull @Initialized Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> var2, @UnknownKeyFor @NonNull @Initialized Schema.Field var3);

        public abstract <CombineInputT, AccumT, CombineOutputT> @UnknownKeyFor @NonNull @Initialized AggregateCombiner<InputT> aggregateFieldsById(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Integer> var1, @UnknownKeyFor @NonNull @Initialized Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> var2, @UnknownKeyFor @NonNull @Initialized Schema.Field var3);
    }

    public static class CombineGlobally<@UnknownKeyFor InputT, @UnknownKeyFor OutputT>
    extends PTransform<PCollection<InputT>, PCollection<OutputT>> {
        final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Combine.CombineFn<InputT, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, OutputT> combineFn;
        @UnknownKeyFor @NonNull @Initialized int fanout;

        CombineGlobally(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Combine.CombineFn<InputT, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, OutputT> combineFn, @UnknownKeyFor @NonNull @Initialized int fanout) {
            this.combineFn = combineFn;
            this.fanout = fanout;
        }

        public @UnknownKeyFor @NonNull @Initialized CombineGlobally<InputT, OutputT> withFanout(@UnknownKeyFor @NonNull @Initialized int fanout) {
            return new CombineGlobally<InputT, OutputT>(this.combineFn, fanout);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollection<OutputT> expand(@UnknownKeyFor @NonNull @Initialized PCollection<InputT> input) {
            return (PCollection)input.apply("globalCombine", Combine.globally(this.combineFn).withFanout(this.fanout));
        }
    }

    public static class Global<@UnknownKeyFor InputT>
    extends PTransform<PCollection<InputT>, PCollection<Iterable<InputT>>> {
        public <OutputT> @UnknownKeyFor @NonNull @Initialized CombineGlobally<InputT, OutputT> aggregate(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Combine.CombineFn<InputT, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, OutputT> combineFn) {
            return new CombineGlobally<InputT, OutputT>(combineFn, 0);
        }

        public <CombineInputT, AccumT, CombineOutputT> @UnknownKeyFor @NonNull @Initialized CombineFieldsGlobally<InputT> aggregateField(@UnknownKeyFor @NonNull @Initialized String inputFieldName, @UnknownKeyFor @NonNull @Initialized Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, @UnknownKeyFor @NonNull @Initialized String outputFieldName) {
            return new CombineFieldsGlobally(SchemaAggregateFn.create().aggregateFields(FieldAccessDescriptor.withFieldNames(inputFieldName), false, fn, outputFieldName), 0);
        }

        public <CombineInputT, AccumT, CombineOutputT> @UnknownKeyFor @NonNull @Initialized CombineFieldsGlobally<InputT> aggregateFieldBaseValue(@UnknownKeyFor @NonNull @Initialized String inputFieldName, @UnknownKeyFor @NonNull @Initialized Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, @UnknownKeyFor @NonNull @Initialized String outputFieldName) {
            return new CombineFieldsGlobally(SchemaAggregateFn.create().aggregateFields(FieldAccessDescriptor.withFieldNames(inputFieldName), true, fn, outputFieldName), 0);
        }

        public <CombineInputT, AccumT, CombineOutputT> @UnknownKeyFor @NonNull @Initialized CombineFieldsGlobally<InputT> aggregateField(@UnknownKeyFor @NonNull @Initialized int inputFieldId, @UnknownKeyFor @NonNull @Initialized Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, @UnknownKeyFor @NonNull @Initialized String outputFieldName) {
            return new CombineFieldsGlobally(SchemaAggregateFn.create().aggregateFields(FieldAccessDescriptor.withFieldIds(inputFieldId), false, fn, outputFieldName), 0);
        }

        public <CombineInputT, AccumT, CombineOutputT> @UnknownKeyFor @NonNull @Initialized CombineFieldsGlobally<InputT> aggregateFieldBaseValue(@UnknownKeyFor @NonNull @Initialized int inputFieldId, @UnknownKeyFor @NonNull @Initialized Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, @UnknownKeyFor @NonNull @Initialized String outputFieldName) {
            return new CombineFieldsGlobally(SchemaAggregateFn.create().aggregateFields(FieldAccessDescriptor.withFieldIds(inputFieldId), true, fn, outputFieldName), 0);
        }

        public <CombineInputT, AccumT, CombineOutputT> @UnknownKeyFor @NonNull @Initialized CombineFieldsGlobally<InputT> aggregateField(@UnknownKeyFor @NonNull @Initialized String inputFieldName, @UnknownKeyFor @NonNull @Initialized Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, @UnknownKeyFor @NonNull @Initialized Schema.Field outputField) {
            return new CombineFieldsGlobally(SchemaAggregateFn.create().aggregateFields(FieldAccessDescriptor.withFieldNames(inputFieldName), false, fn, outputField), 0);
        }

        public <CombineInputT, AccumT, CombineOutputT> @UnknownKeyFor @NonNull @Initialized CombineFieldsGlobally<InputT> aggregateFieldBaseValue(@UnknownKeyFor @NonNull @Initialized String inputFieldName, @UnknownKeyFor @NonNull @Initialized Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, @UnknownKeyFor @NonNull @Initialized Schema.Field outputField) {
            return new CombineFieldsGlobally(SchemaAggregateFn.create().aggregateFields(FieldAccessDescriptor.withFieldNames(inputFieldName), true, fn, outputField), 0);
        }

        public <CombineInputT, AccumT, CombineOutputT> @UnknownKeyFor @NonNull @Initialized CombineFieldsGlobally<InputT> aggregateField(@UnknownKeyFor @NonNull @Initialized int inputFielId, @UnknownKeyFor @NonNull @Initialized Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, @UnknownKeyFor @NonNull @Initialized Schema.Field outputField) {
            return new CombineFieldsGlobally(SchemaAggregateFn.create().aggregateFields(FieldAccessDescriptor.withFieldIds(inputFielId), false, fn, outputField), 0);
        }

        public <CombineInputT, AccumT, CombineOutputT> @UnknownKeyFor @NonNull @Initialized CombineFieldsGlobally<InputT> aggregateFieldBaseValue(@UnknownKeyFor @NonNull @Initialized int inputFielId, @UnknownKeyFor @NonNull @Initialized Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, @UnknownKeyFor @NonNull @Initialized Schema.Field outputField) {
            return new CombineFieldsGlobally(SchemaAggregateFn.create().aggregateFields(FieldAccessDescriptor.withFieldIds(inputFielId), true, fn, outputField), 0);
        }

        public <CombineInputT, AccumT, CombineOutputT> @UnknownKeyFor @NonNull @Initialized CombineFieldsGlobally<InputT> aggregateFields(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> inputFieldNames, @UnknownKeyFor @NonNull @Initialized Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, @UnknownKeyFor @NonNull @Initialized String outputFieldName) {
            return this.aggregateFields(FieldAccessDescriptor.withFieldNames(inputFieldNames), fn, outputFieldName);
        }

        public <CombineInputT, AccumT, CombineOutputT> @UnknownKeyFor @NonNull @Initialized CombineFieldsGlobally<InputT> aggregateFieldsById(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Integer> inputFieldIds, @UnknownKeyFor @NonNull @Initialized Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, @UnknownKeyFor @NonNull @Initialized String outputFieldName) {
            return this.aggregateFields(FieldAccessDescriptor.withFieldIds(inputFieldIds), fn, outputFieldName);
        }

        public <CombineInputT, AccumT, CombineOutputT> @UnknownKeyFor @NonNull @Initialized CombineFieldsGlobally<InputT> aggregateFields(@UnknownKeyFor @NonNull @Initialized FieldAccessDescriptor fieldsToAggregate, @UnknownKeyFor @NonNull @Initialized Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, @UnknownKeyFor @NonNull @Initialized String outputFieldName) {
            return new CombineFieldsGlobally(SchemaAggregateFn.create().aggregateFields(fieldsToAggregate, false, fn, outputFieldName), 0);
        }

        public <CombineInputT, AccumT, CombineOutputT> @UnknownKeyFor @NonNull @Initialized CombineFieldsGlobally<InputT> aggregateFields(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> inputFieldNames, @UnknownKeyFor @NonNull @Initialized Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, @UnknownKeyFor @NonNull @Initialized Schema.Field outputField) {
            return this.aggregateFields(FieldAccessDescriptor.withFieldNames(inputFieldNames), fn, outputField);
        }

        public <CombineInputT, AccumT, CombineOutputT> @UnknownKeyFor @NonNull @Initialized CombineFieldsGlobally<InputT> aggregateFieldsById(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Integer> inputFieldIds, @UnknownKeyFor @NonNull @Initialized Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, @UnknownKeyFor @NonNull @Initialized Schema.Field outputField) {
            return this.aggregateFields(FieldAccessDescriptor.withFieldIds(inputFieldIds), fn, outputField);
        }

        public <CombineInputT, AccumT, CombineOutputT> @UnknownKeyFor @NonNull @Initialized CombineFieldsGlobally<InputT> aggregateFields(@UnknownKeyFor @NonNull @Initialized FieldAccessDescriptor fieldsToAggregate, @UnknownKeyFor @NonNull @Initialized Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, @UnknownKeyFor @NonNull @Initialized Schema.Field outputField) {
            return new CombineFieldsGlobally(SchemaAggregateFn.create().aggregateFields(fieldsToAggregate, false, fn, outputField), 0);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Iterable<InputT>> expand(@UnknownKeyFor @NonNull @Initialized PCollection<InputT> input) {
            return (PCollection)((PCollection)((PCollection)input.apply("addNullKey", WithKeys.of((Void)null))).apply("group", GroupByKey.create())).apply("extractValues", Values.create());
        }
    }
}

