/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.schemas;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.beam.sdk.schemas.CachingFactory;
import org.apache.beam.sdk.schemas.Factory;
import org.apache.beam.sdk.schemas.FieldValueGetter;
import org.apache.beam.sdk.schemas.FieldValueTypeInformation;
import org.apache.beam.sdk.schemas.FromRowUsingCreator;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.SchemaProvider;
import org.apache.beam.sdk.schemas.SchemaUserTypeCreator;
import org.apache.beam.sdk.schemas.logicaltypes.EnumerationType;
import org.apache.beam.sdk.schemas.logicaltypes.OneOfType;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Collections2;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Iterables;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Lists;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Maps;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;

@Deprecated
public abstract class GetterBasedSchemaProvider
implements SchemaProvider {
    @Deprecated
    public abstract @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized FieldValueGetter> fieldValueGetters(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> var1, @UnknownKeyFor @NonNull @Initialized Schema var2);

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized FieldValueGetter> fieldValueGetters(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> targetTypeDescriptor, @UnknownKeyFor @NonNull @Initialized Schema schema) {
        return this.fieldValueGetters(targetTypeDescriptor.getRawType(), schema);
    }

    @Deprecated
    public abstract @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized FieldValueTypeInformation> fieldValueTypeInformations(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> var1, @UnknownKeyFor @NonNull @Initialized Schema var2);

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized FieldValueTypeInformation> fieldValueTypeInformations(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> targetTypeDescriptor, @UnknownKeyFor @NonNull @Initialized Schema schema) {
        return this.fieldValueTypeInformations(targetTypeDescriptor.getRawType(), schema);
    }

    @Deprecated
    public abstract @UnknownKeyFor @NonNull @Initialized SchemaUserTypeCreator schemaTypeCreator(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> var1, @UnknownKeyFor @NonNull @Initialized Schema var2);

    public @UnknownKeyFor @NonNull @Initialized SchemaUserTypeCreator schemaTypeCreator(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> targetTypeDescriptor, @UnknownKeyFor @NonNull @Initialized Schema schema) {
        return this.schemaTypeCreator(targetTypeDescriptor.getRawType(), schema);
    }

    @Override
    public <T> @UnknownKeyFor @NonNull @Initialized SerializableFunction<T, @UnknownKeyFor @NonNull @Initialized Row> toRowFunction(@UnknownKeyFor @NonNull @Initialized TypeDescriptor<T> typeDescriptor) {
        Schema schema = this.schemaFor(typeDescriptor);
        return new ToRowWithValueGetters(schema);
    }

    @Override
    public <T> @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized Row, T> fromRowFunction(@UnknownKeyFor @NonNull @Initialized TypeDescriptor<T> typeDescriptor) {
        return new FromRowUsingCreator<T>(typeDescriptor, this);
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        return super.hashCode();
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object obj) {
        return obj != null && this.getClass() == obj.getClass();
    }

    private static class RowValueGettersFactory
    implements Factory<List<FieldValueGetter>> {
        private final @UnknownKeyFor @NonNull @Initialized Factory<@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized FieldValueGetter>> gettersFactory;
        private final @UnknownKeyFor @NonNull @Initialized Factory<@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized FieldValueGetter>> cachingGettersFactory;
        private static final @UnknownKeyFor @NonNull @Initialized FieldValueGetter IDENTITY = new FieldValueGetter(){

            public @Nullable @UnknownKeyFor @Initialized Object get(@UnknownKeyFor @NonNull @Initialized Object object) {
                return object;
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized String name() {
                return null;
            }
        };

        static @UnknownKeyFor @NonNull @Initialized Factory<@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized FieldValueGetter>> of(@UnknownKeyFor @NonNull @Initialized Factory<@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized FieldValueGetter>> gettersFactory) {
            return new RowValueGettersFactory(gettersFactory).cachingGettersFactory;
        }

        RowValueGettersFactory(@UnknownKeyFor @NonNull @Initialized Factory<@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized FieldValueGetter>> gettersFactory) {
            this.gettersFactory = gettersFactory;
            this.cachingGettersFactory = new CachingFactory<List<FieldValueGetter>>(this);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized FieldValueGetter> create(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> typeDescriptor, @UnknownKeyFor @NonNull @Initialized Schema schema) {
            List<FieldValueGetter> getters = this.gettersFactory.create(typeDescriptor, schema);
            ArrayList<FieldValueGetter> rowGetters = new ArrayList<FieldValueGetter>(getters.size());
            for (int i = 0; i < getters.size(); ++i) {
                rowGetters.add(this.rowValueGetter(getters.get(i), schema.getField(i).getType()));
            }
            return rowGetters;
        }

        static @UnknownKeyFor @NonNull @Initialized boolean needsConversion(@UnknownKeyFor @NonNull @Initialized Schema.FieldType type) {
            Schema.TypeName typeName = type.getTypeName();
            return typeName.equals((Object)Schema.TypeName.ROW) || typeName.isLogicalType() || (typeName.equals((Object)Schema.TypeName.ARRAY) || typeName.equals((Object)Schema.TypeName.ITERABLE)) && RowValueGettersFactory.needsConversion(type.getCollectionElementType()) || typeName.equals((Object)Schema.TypeName.MAP) && (RowValueGettersFactory.needsConversion(type.getMapKeyType()) || RowValueGettersFactory.needsConversion(type.getMapValueType()));
        }

        @UnknownKeyFor @NonNull @Initialized FieldValueGetter rowValueGetter(@UnknownKeyFor @NonNull @Initialized FieldValueGetter base, @UnknownKeyFor @NonNull @Initialized Schema.FieldType type) {
            Schema.TypeName typeName = type.getTypeName();
            if (!RowValueGettersFactory.needsConversion(type)) {
                return base;
            }
            if (typeName.equals((Object)Schema.TypeName.ROW)) {
                return new GetRow(base, type.getRowSchema(), this.cachingGettersFactory);
            }
            if (typeName.equals((Object)Schema.TypeName.ARRAY)) {
                Schema.FieldType elementType = type.getCollectionElementType();
                return elementType.getTypeName().equals((Object)Schema.TypeName.ROW) ? new GetEagerCollection(base, this.converter(elementType)) : new GetCollection(base, this.converter(elementType));
            }
            if (typeName.equals((Object)Schema.TypeName.ITERABLE)) {
                return new GetIterable(base, this.converter(type.getCollectionElementType()));
            }
            if (typeName.equals((Object)Schema.TypeName.MAP)) {
                return new GetMap(base, this.converter(type.getMapKeyType()), this.converter(type.getMapValueType()));
            }
            if (type.isLogicalType("OneOf")) {
                OneOfType oneOfType = type.getLogicalType(OneOfType.class);
                Schema oneOfSchema = oneOfType.getOneOfSchema();
                Map<String, Integer> values = oneOfType.getCaseEnumType().getValuesMap();
                HashMap<Integer, FieldValueGetter> converters = Maps.newHashMapWithExpectedSize(values.size());
                for (Map.Entry<String, Integer> kv : values.entrySet()) {
                    Schema.FieldType fieldType = oneOfSchema.getField(kv.getKey()).getType();
                    FieldValueGetter converter = this.converter(fieldType);
                    converters.put(kv.getValue(), converter);
                }
                return new GetOneOf(base, converters, oneOfType);
            }
            if (typeName.isLogicalType()) {
                return new GetLogicalInputType(base, type.getLogicalType());
            }
            return base;
        }

        @UnknownKeyFor @NonNull @Initialized FieldValueGetter converter(@UnknownKeyFor @NonNull @Initialized Schema.FieldType type) {
            return this.rowValueGetter(IDENTITY, type);
        }

        static abstract class Converter<@UnknownKeyFor T>
        implements FieldValueGetter {
            final @UnknownKeyFor @NonNull @Initialized FieldValueGetter getter;

            public Converter(@UnknownKeyFor @NonNull @Initialized FieldValueGetter getter) {
                this.getter = getter;
            }

            abstract @UnknownKeyFor @NonNull @Initialized Object convert(T var1);

            public @Nullable @UnknownKeyFor @Initialized Object get(@UnknownKeyFor @NonNull @Initialized Object object) {
                Object value = this.getter.get(object);
                if (value == null) {
                    return null;
                }
                return this.convert(value);
            }

            public @Nullable @UnknownKeyFor @Initialized Object getRaw(@UnknownKeyFor @NonNull @Initialized Object object) {
                return this.getter.getRaw(object);
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized String name() {
                return this.getter.name();
            }
        }

        static class GetOneOf
        extends Converter<OneOfType.Value> {
            final @UnknownKeyFor @NonNull @Initialized OneOfType oneOfType;
            final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized Integer, @UnknownKeyFor @NonNull @Initialized FieldValueGetter> converters;

            GetOneOf(@UnknownKeyFor @NonNull @Initialized FieldValueGetter getter, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized Integer, @UnknownKeyFor @NonNull @Initialized FieldValueGetter> converters, @UnknownKeyFor @NonNull @Initialized OneOfType oneOfType) {
                super(getter);
                this.converters = converters;
                this.oneOfType = oneOfType;
            }

            @Override
            @UnknownKeyFor @NonNull @Initialized Object convert(@UnknownKeyFor @NonNull @Initialized OneOfType.Value value) {
                EnumerationType.Value caseType = value.getCaseType();
                FieldValueGetter converter = this.converters.get(caseType.getValue());
                Preconditions.checkState(converter != null, "Missing OneOf converter for case %s.", (Object)caseType);
                return this.oneOfType.createValue(caseType, converter.get(value.getValue()));
            }
        }

        static class GetLogicalInputType
        extends Converter<Object> {
            final @UnknownKeyFor @NonNull @Initialized Schema.LogicalType logicalType;

            GetLogicalInputType(@UnknownKeyFor @NonNull @Initialized FieldValueGetter getter, @UnknownKeyFor @NonNull @Initialized Schema.LogicalType logicalType) {
                super(getter);
                this.logicalType = logicalType;
            }

            @Override
            @UnknownKeyFor @NonNull @Initialized Object convert(@UnknownKeyFor @NonNull @Initialized Object value) {
                return this.logicalType.toInputType(value);
            }
        }

        static class GetMap
        extends Converter<Map<?, ?>> {
            final @UnknownKeyFor @NonNull @Initialized FieldValueGetter keyConverter;
            final @UnknownKeyFor @NonNull @Initialized FieldValueGetter valueConverter;

            GetMap(@UnknownKeyFor @NonNull @Initialized FieldValueGetter getter, @UnknownKeyFor @NonNull @Initialized FieldValueGetter keyConverter, @UnknownKeyFor @NonNull @Initialized FieldValueGetter valueConverter) {
                super(getter);
                this.keyConverter = keyConverter;
                this.valueConverter = valueConverter;
            }

            @Override
            @UnknownKeyFor @NonNull @Initialized Object convert(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @KeyForBottom @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @KeyForBottom @Nullable @Initialized @NonNull @Initialized ?> value) {
                HashMap returnMap = Maps.newHashMapWithExpectedSize(value.size());
                for (Map.Entry<?, ?> entry : value.entrySet()) {
                    returnMap.put(this.keyConverter.get(entry.getKey()), this.valueConverter.get(entry.getValue()));
                }
                return returnMap;
            }
        }

        static class GetIterable
        extends Converter<Iterable> {
            final @UnknownKeyFor @NonNull @Initialized FieldValueGetter converter;

            GetIterable(@UnknownKeyFor @NonNull @Initialized FieldValueGetter getter, @UnknownKeyFor @NonNull @Initialized FieldValueGetter converter) {
                super(getter);
                this.converter = converter;
            }

            @Override
            @UnknownKeyFor @NonNull @Initialized Object convert(@UnknownKeyFor @NonNull @Initialized Iterable value) {
                return Iterables.transform(value, this.converter::get);
            }
        }

        static class GetCollection
        extends Converter<Collection> {
            final @UnknownKeyFor @NonNull @Initialized FieldValueGetter converter;

            GetCollection(@UnknownKeyFor @NonNull @Initialized FieldValueGetter getter, @UnknownKeyFor @NonNull @Initialized FieldValueGetter converter) {
                super(getter);
                this.converter = converter;
            }

            @Override
            @UnknownKeyFor @NonNull @Initialized Object convert(@UnknownKeyFor @NonNull @Initialized Collection collection) {
                if (collection instanceof List) {
                    return Lists.transform((List)collection, this.converter::get);
                }
                return Collections2.transform(collection, this.converter::get);
            }
        }

        static class GetEagerCollection
        extends Converter<Collection> {
            final @UnknownKeyFor @NonNull @Initialized FieldValueGetter converter;

            GetEagerCollection(@UnknownKeyFor @NonNull @Initialized FieldValueGetter getter, @UnknownKeyFor @NonNull @Initialized FieldValueGetter converter) {
                super(getter);
                this.converter = converter;
            }

            @Override
            @UnknownKeyFor @NonNull @Initialized Object convert(@UnknownKeyFor @NonNull @Initialized Collection collection) {
                ArrayList newList = new ArrayList(collection.size());
                for (Object obj : collection) {
                    newList.add(this.converter.get(obj));
                }
                return newList;
            }
        }

        static class GetRow
        extends Converter<Object> {
            final @UnknownKeyFor @NonNull @Initialized Schema schema;
            final @UnknownKeyFor @NonNull @Initialized Factory<@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized FieldValueGetter>> factory;

            GetRow(@UnknownKeyFor @NonNull @Initialized FieldValueGetter getter, @UnknownKeyFor @NonNull @Initialized Schema schema, @UnknownKeyFor @NonNull @Initialized Factory<@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized FieldValueGetter>> factory) {
                super(getter);
                this.schema = schema;
                this.factory = factory;
            }

            @Override
            @UnknownKeyFor @NonNull @Initialized Object convert(@UnknownKeyFor @NonNull @Initialized Object value) {
                return Row.withSchema(this.schema).withFieldValueGetters(this.factory, value);
            }
        }
    }

    private class ToRowWithValueGetters<@UnknownKeyFor T>
    implements SerializableFunction<T, Row> {
        private final @UnknownKeyFor @NonNull @Initialized Schema schema;
        private final @UnknownKeyFor @NonNull @Initialized Factory<@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized FieldValueGetter>> getterFactory;

        public ToRowWithValueGetters(Schema schema) {
            this.schema = schema;
            this.getterFactory = RowValueGettersFactory.of(GetterBasedSchemaProvider.this::fieldValueGetters);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Row apply(T input) {
            return Row.withSchema(this.schema).withFieldValueGetters(this.getterFactory, input);
        }

        private @UnknownKeyFor @NonNull @Initialized GetterBasedSchemaProvider getOuter() {
            return GetterBasedSchemaProvider.this;
        }

        @EnsuresNonNullIf(expression={"#1"}, result=true)
        @Pure
        public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ToRowWithValueGetters that = (ToRowWithValueGetters)o;
            return this.getOuter().equals(that.getOuter()) && this.schema.equals(that.schema);
        }

        @Pure
        public @UnknownKeyFor @NonNull @Initialized int hashCode() {
            return Objects.hash(GetterBasedSchemaProvider.this, this.schema);
        }
    }
}

