/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io;

import com.google.auto.value.AutoValue;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.beam.sdk.coders.SerializableCoder;
import org.apache.beam.sdk.io.AutoValue_BoundedReadFromUnboundedSource_Shard;
import org.apache.beam.sdk.io.UnboundedSource;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.Distinct;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.Reshuffle;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.util.BackOff;
import org.apache.beam.sdk.util.FluentBackoff;
import org.apache.beam.sdk.util.NameUtils;
import org.apache.beam.sdk.util.SerializableUtils;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.ValueWithRecordId;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.util.concurrent.Uninterruptibles;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;

public class BoundedReadFromUnboundedSource<@UnknownKeyFor T>
extends PTransform<PBegin, PCollection<T>> {
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized UnboundedSource<T, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> source;
    private final @UnknownKeyFor @NonNull @Initialized long maxNumRecords;
    private final @Nullable @UnknownKeyFor @Initialized Duration maxReadTime;
    private static final @UnknownKeyFor @NonNull @Initialized FluentBackoff BACKOFF_FACTORY = FluentBackoff.DEFAULT.withInitialBackoff(Duration.millis((long)10L)).withMaxBackoff(Duration.standardSeconds((long)10L));

    public @UnknownKeyFor @NonNull @Initialized BoundedReadFromUnboundedSource<T> withMaxNumRecords(@UnknownKeyFor @NonNull @Initialized long maxNumRecords) {
        return new BoundedReadFromUnboundedSource<T>(this.source, maxNumRecords, this.maxReadTime);
    }

    public @UnknownKeyFor @NonNull @Initialized BoundedReadFromUnboundedSource<T> withMaxReadTime(@UnknownKeyFor @NonNull @Initialized Duration maxReadTime) {
        return new BoundedReadFromUnboundedSource<T>(this.source, this.maxNumRecords, maxReadTime);
    }

    BoundedReadFromUnboundedSource(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized UnboundedSource<T, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> source, @UnknownKeyFor @NonNull @Initialized long maxNumRecords, @Nullable @UnknownKeyFor @Initialized Duration maxReadTime) {
        this.source = source;
        this.maxNumRecords = maxNumRecords;
        this.maxReadTime = maxReadTime;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized PCollection<T> expand(@UnknownKeyFor @NonNull @Initialized PBegin input) {
        SerializableCoder<Shard> shardCoder = SerializableCoder.of(Shard.class);
        PCollection read = ((PCollection)((PCollection)((PCollection)((PCollection)input.apply("Create", Create.of(new AutoValue_BoundedReadFromUnboundedSource_Shard.Builder<T>().setSource(this.source).setMaxNumRecords(this.maxNumRecords).setMaxReadTime(this.maxReadTime).build(), new Shard[0]).withCoder(shardCoder))).apply("Split", ParDo.of(new SplitFn()))).setCoder(shardCoder).apply("Reshuffle", Reshuffle.viaRandomKey())).apply("Read", ParDo.of(new ReadFn()))).setCoder(ValueWithRecordId.ValueWithRecordIdCoder.of(this.source.getOutputCoder()));
        if (this.source.requiresDeduping()) {
            read = (PCollection)read.apply(Distinct.withRepresentativeValueFn(ValueWithRecordId::getId).withRepresentativeType(TypeDescriptor.of(byte[].class)));
        }
        return ((PCollection)read.apply("StripIds", ParDo.of(new ValueWithRecordId.StripIdsDoFn()))).setCoder(this.source.getOutputCoder());
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String getKindString() {
        return String.format("Read(%s)", NameUtils.approximateSimpleName(this.source));
    }

    @Override
    public void populateDisplayData(@UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
        builder.add(DisplayData.item("source", this.source.getClass()).withLabel("Read Source")).addIfNotDefault(DisplayData.item("maxRecords", this.maxNumRecords).withLabel("Maximum Read Records"), Long.MAX_VALUE).addIfNotNull(DisplayData.item("maxReadTime", this.maxReadTime).withLabel("Maximum Read Time")).include("source", this.source);
    }

    @AutoValue
    static abstract class Shard<@UnknownKeyFor T>
    implements Serializable {
        Shard() {
        }

        abstract /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @Nullable @UnknownKeyFor @Initialized UnboundedSource<T, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> getSource();

        abstract @UnknownKeyFor @NonNull @Initialized long getMaxNumRecords();

        abstract @Nullable @UnknownKeyFor @Initialized Duration getMaxReadTime();

        abstract @UnknownKeyFor @NonNull @Initialized Builder<T> toBuilder();

        @AutoValue.Builder
        static abstract class Builder<@UnknownKeyFor T> {
            Builder() {
            }

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setSource(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            @UnknownKeyFor @NonNull @Initialized UnboundedSource<T, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setMaxNumRecords(@UnknownKeyFor @NonNull @Initialized long var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setMaxReadTime(@Nullable @UnknownKeyFor @Initialized Duration var1);

            abstract @UnknownKeyFor @NonNull @Initialized Shard<T> build();
        }
    }

    private static class ReadFn<@UnknownKeyFor T>
    extends DoFn<Shard<T>, ValueWithRecordId<T>> {
        private ReadFn() {
        }

        @DoFn.ProcessElement
        @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_WOULD_HAVE_BEEN_A_NPE"}, justification="https://github.com/spotbugs/spotbugs/issues/756")
        public void process(@DoFn.Element @UnknownKeyFor @NonNull @Initialized Shard<T> shard, @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized ValueWithRecordId<T>> out, @UnknownKeyFor @NonNull @Initialized PipelineOptions options) throws @UnknownKeyFor @NonNull @Initialized Exception {
            Instant endTime;
            Instant instant = endTime = shard.getMaxReadTime() == null ? null : Instant.now().plus((ReadableDuration)shard.getMaxReadTime());
            if (shard.getMaxNumRecords() <= 0L || shard.getMaxReadTime() != null && shard.getMaxReadTime().getMillis() == 0L) {
                return;
            }
            try (UnboundedSource.UnboundedReader<T> reader = SerializableUtils.clone(shard.getSource()).createReader(options, null);){
                for (long i = 0L; i < shard.getMaxNumRecords(); ++i) {
                    boolean available;
                    boolean bl = available = i == 0L ? reader.start() : reader.advance();
                    if (!available && !this.advanceWithBackoff(reader, endTime)) break;
                    out.outputWithTimestamp(new ValueWithRecordId(reader.getCurrent(), reader.getCurrentRecordId()), reader.getCurrentTimestamp());
                }
                reader.getCheckpointMark().finalizeCheckpoint();
            }
        }

        private @UnknownKeyFor @NonNull @Initialized boolean advanceWithBackoff(@UnknownKeyFor @NonNull @Initialized UnboundedSource.UnboundedReader<T> reader, @UnknownKeyFor @NonNull @Initialized Instant endTime) throws @UnknownKeyFor @NonNull @Initialized IOException {
            BackOff backoff = BACKOFF_FACTORY.backoff();
            long nextSleep = backoff.nextBackOffMillis();
            while (!(nextSleep == -1L || endTime != null && Instant.now().isAfter((ReadableInstant)endTime))) {
                if (reader.advance()) {
                    return true;
                }
                Uninterruptibles.sleepUninterruptibly(nextSleep, TimeUnit.MILLISECONDS);
                nextSleep = backoff.nextBackOffMillis();
            }
            return false;
        }
    }

    private static class SplitFn<@UnknownKeyFor T>
    extends DoFn<Shard<T>, Shard<T>> {
        private SplitFn() {
        }

        private static @UnknownKeyFor @NonNull @Initialized long @UnknownKeyFor @NonNull @Initialized [] splitNumRecords(@UnknownKeyFor @NonNull @Initialized long numRecords, @UnknownKeyFor @NonNull @Initialized int numSplits) {
            int i;
            long[] splitNumRecords = new long[numSplits];
            for (i = 0; i < numSplits; ++i) {
                splitNumRecords[i] = numRecords / (long)numSplits;
            }
            i = 0;
            while ((long)i < numRecords % (long)numSplits) {
                splitNumRecords[i] = splitNumRecords[i] + 1L;
                ++i;
            }
            return splitNumRecords;
        }

        private static @UnknownKeyFor @NonNull @Initialized int numInitialSplits(@UnknownKeyFor @NonNull @Initialized long numRecords) {
            int maxSplits = 100;
            long recordsPerSplit = 10000L;
            return (int)Math.min(100L, numRecords / 10000L + 1L);
        }

        @DoFn.ProcessElement
        public void process(@DoFn.Element @UnknownKeyFor @NonNull @Initialized Shard<T> shard, @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized Shard<T>> out, @UnknownKeyFor @NonNull @Initialized PipelineOptions options) throws @UnknownKeyFor @NonNull @Initialized Exception {
            int numInitialSplits = SplitFn.numInitialSplits(shard.getMaxNumRecords());
            List<UnboundedSource<T, ?>> splits = shard.getSource().split(numInitialSplits, options);
            int numSplits = splits.size();
            long[] numRecords = SplitFn.splitNumRecords(shard.getMaxNumRecords(), numSplits);
            for (int i = 0; i < numSplits; ++i) {
                out.output(shard.toBuilder().setSource(splits.get(i)).setMaxNumRecords(numRecords[i]).setMaxReadTime(shard.getMaxReadTime()).build());
            }
        }
    }
}

