/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.coders;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UTFDataFormatException;
import org.apache.beam.sdk.coders.AtomicCoder;
import org.apache.beam.sdk.coders.BitConverters;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Instant;

public class InstantCoder
extends AtomicCoder<Instant> {
    private static final @UnknownKeyFor @NonNull @Initialized InstantCoder INSTANCE = new InstantCoder();
    private static final @UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @NonNull @Initialized Instant> TYPE_DESCRIPTOR = new TypeDescriptor<Instant>(){};

    public static @UnknownKeyFor @NonNull @Initialized InstantCoder of() {
        return INSTANCE;
    }

    private InstantCoder() {
    }

    @Override
    public void encode(@UnknownKeyFor @NonNull @Initialized Instant value, @UnknownKeyFor @NonNull @Initialized OutputStream outStream) throws @UnknownKeyFor @NonNull @Initialized CoderException, @UnknownKeyFor @NonNull @Initialized IOException {
        if (value == null) {
            throw new CoderException("cannot encode a null Instant");
        }
        long shiftedMillis = value.getMillis() - Long.MIN_VALUE;
        BitConverters.writeBigEndianLong(shiftedMillis, outStream);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Instant decode(@UnknownKeyFor @NonNull @Initialized InputStream inStream) throws @UnknownKeyFor @NonNull @Initialized CoderException, @UnknownKeyFor @NonNull @Initialized IOException {
        long shiftedMillis;
        try {
            shiftedMillis = BitConverters.readBigEndianLong(inStream);
        }
        catch (EOFException | UTFDataFormatException exn) {
            throw new CoderException(exn);
        }
        return new Instant(shiftedMillis + Long.MIN_VALUE);
    }

    @Override
    public void verifyDeterministic() {
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean consistentWithEquals() {
        return true;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean isRegisterByteSizeObserverCheap(@UnknownKeyFor @NonNull @Initialized Instant value) {
        return true;
    }

    @Override
    protected @UnknownKeyFor @NonNull @Initialized long getEncodedElementByteSize(@UnknownKeyFor @NonNull @Initialized Instant value) throws @UnknownKeyFor @NonNull @Initialized Exception {
        if (value == null) {
            throw new CoderException("cannot encode a null Instant");
        }
        return 8L;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @NonNull @Initialized Instant> getEncodedTypeDescriptor() {
        return TYPE_DESCRIPTOR;
    }
}

