/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.fnexecution.environment;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class ProcessManager {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(ProcessManager.class);
    public static final @UnknownKeyFor @NonNull @Initialized File INHERIT_IO_FILE = new File("_inherit_io_unused_filename_");
    private static final @UnknownKeyFor @NonNull @Initialized boolean INHERIT_IO = LOG.isDebugEnabled();
    private static final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized ProcessManager> ALL_PROCESS_MANAGERS = new ArrayList<ProcessManager>();
    @VisibleForTesting
    static @UnknownKeyFor @NonNull @Initialized Thread shutdownHook = null;
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Process> processes = Collections.synchronizedMap(new HashMap());

    public static @UnknownKeyFor @NonNull @Initialized ProcessManager create() {
        return new ProcessManager();
    }

    private ProcessManager() {
    }

    @UnknownKeyFor @NonNull @Initialized RunningProcess startProcess(@UnknownKeyFor @NonNull @Initialized String id, @UnknownKeyFor @NonNull @Initialized String command, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> args) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return this.startProcess(id, command, args, Collections.emptyMap());
    }

    public @UnknownKeyFor @NonNull @Initialized RunningProcess startProcess(@UnknownKeyFor @NonNull @Initialized String id, @UnknownKeyFor @NonNull @Initialized String command, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> args, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> env) throws @UnknownKeyFor @NonNull @Initialized IOException {
        File outputFile;
        if (INHERIT_IO) {
            LOG.debug("==> DEBUG enabled: Inheriting stdout/stderr of process (adjustable in ProcessManager)");
            outputFile = INHERIT_IO_FILE;
        } else {
            outputFile = System.getProperty("os.name", "").startsWith("Windows") ? new File("nul") : new File("/dev/null");
        }
        return this.startProcess(id, command, args, env, outputFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"})
    public @UnknownKeyFor @NonNull @Initialized RunningProcess startProcess(@UnknownKeyFor @NonNull @Initialized String id, @UnknownKeyFor @NonNull @Initialized String command, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> args, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> env, @UnknownKeyFor @NonNull @Initialized File outputFile) throws @UnknownKeyFor @NonNull @Initialized IOException {
        Preconditions.checkNotNull(id, "Process id must not be null");
        Preconditions.checkNotNull(command, "Command must not be null");
        Preconditions.checkNotNull(args, "Process args must not be null");
        Preconditions.checkNotNull(env, "Environment map must not be null");
        Preconditions.checkNotNull(outputFile, "Output redirect file must not be null");
        ProcessBuilder pb = new ProcessBuilder((List<String>)((Object)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().add(command)).addAll(args)).build()));
        pb.environment().putAll(env);
        if (INHERIT_IO_FILE.equals(outputFile)) {
            pb.inheritIO();
        } else {
            pb.redirectErrorStream(true);
            pb.redirectOutput(outputFile);
        }
        LOG.debug("Attempting to start process with command: {}", pb.command());
        Process newProcess = pb.start();
        Process oldProcess = this.processes.put(id, newProcess);
        List<ProcessManager> list = ALL_PROCESS_MANAGERS;
        synchronized (list) {
            if (!ALL_PROCESS_MANAGERS.contains(this)) {
                ALL_PROCESS_MANAGERS.add(this);
            }
            if (shutdownHook == null) {
                shutdownHook = ShutdownHook.create();
                Runtime.getRuntime().addShutdownHook(shutdownHook);
            }
        }
        if (oldProcess != null) {
            this.stopProcess(id, oldProcess);
            this.stopProcess(id, newProcess);
            throw new IllegalStateException("There was already a process running with id " + id);
        }
        return new RunningProcess(newProcess);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"})
    public void stopProcess(@UnknownKeyFor @NonNull @Initialized String id) {
        Preconditions.checkNotNull(id, "Process id must not be null");
        try {
            Process process = Preconditions.checkNotNull(this.processes.remove(id), "Process for id does not exist: " + id);
            this.stopProcess(id, process);
        }
        finally {
            List<ProcessManager> list = ALL_PROCESS_MANAGERS;
            synchronized (list) {
                if (this.processes.isEmpty()) {
                    ALL_PROCESS_MANAGERS.remove(this);
                }
                if (ALL_PROCESS_MANAGERS.isEmpty() && shutdownHook != null) {
                    Runtime.getRuntime().removeShutdownHook(shutdownHook);
                    shutdownHook = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopProcess(@UnknownKeyFor @NonNull @Initialized String id, @UnknownKeyFor @NonNull @Initialized Process process) {
        if (process.isAlive()) {
            LOG.debug("Attempting to stop process with id {}", (Object)id);
            process.destroy();
            long maxTimeToWait = 500L;
            try {
                if (ProcessManager.waitForProcessToDie(process, maxTimeToWait)) {
                    LOG.debug("Process for worker {} shut down gracefully.", (Object)id);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            finally {
                if (process.isAlive()) {
                    LOG.info("Process for worker {} still running. Killing.", (Object)id);
                    process.destroyForcibly();
                }
            }
        }
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean waitForProcessToDie(@UnknownKeyFor @NonNull @Initialized Process process, @UnknownKeyFor @NonNull @Initialized long maxWaitTimeMillis) throws @UnknownKeyFor @NonNull @Initialized InterruptedException {
        long startTime = System.currentTimeMillis();
        while (process.isAlive() && System.currentTimeMillis() - startTime < maxWaitTimeMillis) {
            Thread.sleep(50L);
        }
        return !process.isAlive();
    }

    private void stopAllProcesses() {
        this.processes.forEach((id, process) -> process.destroy());
    }

    private void killAllProcesses() {
        this.processes.forEach((id, process) -> process.destroyForcibly());
    }

    private static class ShutdownHook
    extends Thread {
        private static @UnknownKeyFor @NonNull @Initialized ShutdownHook create() {
            return new ShutdownHook();
        }

        private ShutdownHook() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @SuppressFBWarnings(value={"SWL_SLEEP_WITH_LOCK_HELD"})
        public void run() {
            List list = ALL_PROCESS_MANAGERS;
            synchronized (list) {
                ALL_PROCESS_MANAGERS.forEach(rec$ -> ((ProcessManager)rec$).stopAllProcesses());
                try {
                    if (ALL_PROCESS_MANAGERS.stream().anyMatch(pm -> ((ProcessManager)pm).processes.values().stream().anyMatch(Process::isAlive))) {
                        Thread.sleep(200L);
                    }
                }
                catch (InterruptedException interruptedException) {
                }
                finally {
                    ALL_PROCESS_MANAGERS.forEach(rec$ -> ((ProcessManager)rec$).killAllProcesses());
                }
            }
        }
    }

    public static class RunningProcess {
        private @UnknownKeyFor @NonNull @Initialized Process process;

        RunningProcess(@UnknownKeyFor @NonNull @Initialized Process process) {
            this.process = process;
        }

        public void isAliveOrThrow() throws @UnknownKeyFor @NonNull @Initialized IllegalStateException {
            if (!this.process.isAlive()) {
                throw new IllegalStateException("Process died with exit code " + this.process.exitValue());
            }
        }

        @VisibleForTesting
        @UnknownKeyFor @NonNull @Initialized Process getUnderlyingProcess() {
            return this.process;
        }
    }
}

