/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.direct;

import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.beam.sdk.io.WriteFiles;
import org.apache.beam.sdk.io.WriteFilesResult;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.runners.PTransformOverrideFactory;
import org.apache.beam.sdk.transforms.Count;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.View;
import org.apache.beam.sdk.transforms.windowing.GlobalWindows;
import org.apache.beam.sdk.transforms.windowing.Window;
import org.apache.beam.sdk.util.construction.PTransformReplacements;
import org.apache.beam.sdk.util.construction.ReplacementOutputs;
import org.apache.beam.sdk.util.construction.WriteFilesTranslation;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Supplier;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Suppliers;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

class WriteWithShardingFactory<@UnknownKeyFor InputT, @UnknownKeyFor DestinationT>
implements PTransformOverrideFactory<PCollection<InputT>, WriteFilesResult<DestinationT>, PTransform<PCollection<InputT>, WriteFilesResult<DestinationT>>> {
    static final @UnknownKeyFor @NonNull @Initialized int MAX_RANDOM_EXTRA_SHARDS = 3;
    @VisibleForTesting
    static final @UnknownKeyFor @NonNull @Initialized int MIN_SHARDS_FOR_LOG = 3;

    WriteWithShardingFactory() {
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized PTransformOverrideFactory.PTransformReplacement<@UnknownKeyFor @NonNull @Initialized PCollection<InputT>, @UnknownKeyFor @NonNull @Initialized WriteFilesResult<DestinationT>> getReplacementTransform(@UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @NonNull @Initialized PCollection<InputT>, @UnknownKeyFor @NonNull @Initialized WriteFilesResult<DestinationT>, @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollection<InputT>, @UnknownKeyFor @NonNull @Initialized WriteFilesResult<DestinationT>>> transform) {
        try {
            WriteFiles replacement = WriteFiles.to(WriteFilesTranslation.getSink(transform)).withSideInputs(WriteFilesTranslation.getDynamicDestinationSideInputs(transform)).withSharding(new LogElementShardsWithDrift());
            if (WriteFilesTranslation.isWindowedWrites(transform)) {
                replacement = replacement.withWindowedWrites();
            }
            return PTransformOverrideFactory.PTransformReplacement.of(PTransformReplacements.getSingletonMainInput(transform), replacement);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized PTransformOverrideFactory.ReplacementOutput> mapOutputs(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> outputs, @UnknownKeyFor @NonNull @Initialized WriteFilesResult<DestinationT> newOutput) {
        return ReplacementOutputs.tagged(outputs, newOutput);
    }

    private static class BoundedRandomIntSupplier
    implements Supplier<Integer>,
    Serializable {
        private final @UnknownKeyFor @NonNull @Initialized int upperBound;

        private BoundedRandomIntSupplier(@UnknownKeyFor @NonNull @Initialized int upperBound) {
            this.upperBound = upperBound;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Integer get() {
            return ThreadLocalRandom.current().nextInt(0, this.upperBound);
        }
    }

    @VisibleForTesting
    static class CalculateShardsFn
    extends DoFn<Long, Integer> {
        private final @UnknownKeyFor @NonNull @Initialized Supplier<@UnknownKeyFor @NonNull @Initialized Integer> extraShardsSupplier;

        public CalculateShardsFn() {
            this(new BoundedRandomIntSupplier(3));
        }

        @VisibleForTesting
        CalculateShardsFn(@UnknownKeyFor @NonNull @Initialized int constantExtraShards) {
            this(Suppliers.ofInstance(constantExtraShards));
        }

        private CalculateShardsFn(@UnknownKeyFor @NonNull @Initialized Supplier<@UnknownKeyFor @NonNull @Initialized Integer> extraShardsSupplier) {
            this.extraShardsSupplier = extraShardsSupplier;
        }

        @DoFn.ProcessElement
        public void process(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext ctxt) {
            ctxt.output(this.calculateShards((Long)ctxt.element()));
        }

        private @UnknownKeyFor @NonNull @Initialized int calculateShards(@UnknownKeyFor @NonNull @Initialized long totalRecords) {
            if (totalRecords == 0L) {
                return 1;
            }
            int extraShards = this.extraShardsSupplier.get();
            if (totalRecords < (long)(3 + extraShards)) {
                return (int)totalRecords;
            }
            int floorLogRecs = (int)Math.log10(totalRecords);
            return Math.max(floorLogRecs, 3) + extraShards;
        }
    }

    private static class LogElementShardsWithDrift<@UnknownKeyFor T>
    extends PTransform<PCollection<T>, PCollectionView<Integer>> {
        private LogElementShardsWithDrift() {
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized Integer> expand(@UnknownKeyFor @NonNull @Initialized PCollection<T> records) {
            return (PCollectionView)((PCollection)((Object)((PCollection)records.apply(Window.into(new GlobalWindows()))).apply("CountRecords", Count.globally()).apply("GenerateShardCount", ParDo.of(new CalculateShardsFn())))).apply(View.asSingleton());
        }
    }
}

