/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.beam.runners.core.ActiveWindowSet;
import org.apache.beam.runners.core.LateDataUtils;
import org.apache.beam.runners.core.MergingActiveWindowSet;
import org.apache.beam.runners.core.NonEmptyPanes;
import org.apache.beam.runners.core.NonMergingActiveWindowSet;
import org.apache.beam.runners.core.OutputWindowedValue;
import org.apache.beam.runners.core.PaneInfoTracker;
import org.apache.beam.runners.core.ReduceFn;
import org.apache.beam.runners.core.ReduceFnContextFactory;
import org.apache.beam.runners.core.SideInputReader;
import org.apache.beam.runners.core.StateInternals;
import org.apache.beam.runners.core.StateNamespaces;
import org.apache.beam.runners.core.TimerInternals;
import org.apache.beam.runners.core.WatermarkHold;
import org.apache.beam.runners.core.triggers.ExecutableTriggerStateMachine;
import org.apache.beam.runners.core.triggers.TriggerStateMachineContextFactory;
import org.apache.beam.runners.core.triggers.TriggerStateMachineRunner;
import org.apache.beam.sdk.metrics.Counter;
import org.apache.beam.sdk.metrics.Metrics;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.state.TimeDomain;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.PaneInfo;
import org.apache.beam.sdk.transforms.windowing.Window;
import org.apache.beam.sdk.util.WindowTracing;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.FluentIterable;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableSet;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;

public class ReduceFnRunner<@UnknownKeyFor K, @UnknownKeyFor InputT, @UnknownKeyFor OutputT, @UnknownKeyFor W extends @UnknownKeyFor @NonNull @Initialized BoundedWindow> {
    private final @UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @NonNull @Initialized Object, W> windowingStrategy;
    private final @UnknownKeyFor @NonNull @Initialized OutputWindowedValue<@UnknownKeyFor @NonNull @Initialized KV<K, OutputT>> outputter;
    private final @UnknownKeyFor @NonNull @Initialized StateInternals stateInternals;
    private final @UnknownKeyFor @NonNull @Initialized Counter droppedDueToClosedWindow;
    public static final @UnknownKeyFor @NonNull @Initialized String DROPPED_DUE_TO_CLOSED_WINDOW = "droppedDueToClosedWindow";
    private final K key;
    private final @UnknownKeyFor @NonNull @Initialized ActiveWindowSet<W> activeWindows;
    private final @UnknownKeyFor @NonNull @Initialized ReduceFn<K, InputT, OutputT, W> reduceFn;
    private final @UnknownKeyFor @NonNull @Initialized TimerInternals timerInternals;
    private final @UnknownKeyFor @NonNull @Initialized TriggerStateMachineRunner<W> triggerRunner;
    private final @UnknownKeyFor @NonNull @Initialized WatermarkHold<W> watermarkHold;
    private final @UnknownKeyFor @NonNull @Initialized ReduceFnContextFactory<K, InputT, OutputT, W> contextFactory;
    private final @UnknownKeyFor @NonNull @Initialized PaneInfoTracker paneInfoTracker;
    private final @UnknownKeyFor @NonNull @Initialized NonEmptyPanes<K, W> nonEmptyPanes;

    public ReduceFnRunner(K key, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, W> windowingStrategy, @UnknownKeyFor @NonNull @Initialized ExecutableTriggerStateMachine triggerStateMachine, @UnknownKeyFor @NonNull @Initialized StateInternals stateInternals, @UnknownKeyFor @NonNull @Initialized TimerInternals timerInternals, @UnknownKeyFor @NonNull @Initialized OutputWindowedValue<@UnknownKeyFor @NonNull @Initialized KV<K, OutputT>> outputter, @Nullable @UnknownKeyFor @Initialized SideInputReader sideInputReader, @UnknownKeyFor @NonNull @Initialized ReduceFn<K, InputT, OutputT, W> reduceFn, @Nullable @UnknownKeyFor @Initialized PipelineOptions options) {
        this.key = key;
        this.timerInternals = timerInternals;
        this.paneInfoTracker = new PaneInfoTracker(timerInternals);
        this.stateInternals = stateInternals;
        this.outputter = outputter;
        this.reduceFn = reduceFn;
        this.droppedDueToClosedWindow = Metrics.counter(ReduceFnRunner.class, DROPPED_DUE_TO_CLOSED_WINDOW);
        WindowingStrategy<?, W> objectWindowingStrategy = windowingStrategy;
        this.windowingStrategy = objectWindowingStrategy;
        this.nonEmptyPanes = NonEmptyPanes.create(this.windowingStrategy, this.reduceFn);
        this.activeWindows = this.createActiveWindowSet();
        this.contextFactory = new ReduceFnContextFactory<K, InputT, OutputT, W>(key, reduceFn, this.windowingStrategy, stateInternals, this.activeWindows, timerInternals, sideInputReader, options);
        this.watermarkHold = new WatermarkHold<W>(timerInternals, windowingStrategy);
        this.triggerRunner = new TriggerStateMachineRunner<W>(triggerStateMachine, new TriggerStateMachineContextFactory<W>(windowingStrategy.getWindowFn(), stateInternals, this.activeWindows));
    }

    private @UnknownKeyFor @NonNull @Initialized ActiveWindowSet<W> createActiveWindowSet() {
        return !this.windowingStrategy.needsMerge() ? new NonMergingActiveWindowSet() : new MergingActiveWindowSet<W>(this.windowingStrategy.getWindowFn(), this.stateInternals);
    }

    @VisibleForTesting
    @UnknownKeyFor @NonNull @Initialized boolean isFinished(W window) {
        return this.triggerRunner.isClosed(this.contextFactory.base(window, ReduceFnContextFactory.StateStyle.DIRECT).state());
    }

    @VisibleForTesting
    @UnknownKeyFor @NonNull @Initialized boolean hasNoActiveWindows() {
        return this.activeWindows.getActiveAndNewWindows().isEmpty();
    }

    private @UnknownKeyFor @NonNull @Initialized Set<W> windowsThatAreOpen(@UnknownKeyFor @NonNull @Initialized Collection<W> windows) {
        HashSet<BoundedWindow> result = new HashSet<BoundedWindow>();
        for (BoundedWindow window : windows) {
            ReduceFn.Context directContext = this.contextFactory.base(window, ReduceFnContextFactory.StateStyle.DIRECT);
            if (this.triggerRunner.isClosed(directContext.state())) continue;
            result.add(window);
        }
        return result;
    }

    private @UnknownKeyFor @NonNull @Initialized Collection<W> windowsThatShouldFire(@UnknownKeyFor @NonNull @Initialized Set<W> windows) throws @UnknownKeyFor @NonNull @Initialized Exception {
        ArrayList<BoundedWindow> result = new ArrayList<BoundedWindow>();
        for (BoundedWindow window : windows) {
            ReduceFn.Context directContext = this.contextFactory.base(window, ReduceFnContextFactory.StateStyle.DIRECT);
            if (!this.triggerRunner.shouldFire(directContext.window(), directContext.timers(), directContext.state())) continue;
            result.add(window);
        }
        return result;
    }

    public void processElements(@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized WindowedValue<InputT>> values) throws @UnknownKeyFor @NonNull @Initialized Exception {
        if (!values.iterator().hasNext()) {
            return;
        }
        Set<W> windows = this.collectWindows(values);
        Map<W, W> windowToMergeResult = this.mergeWindows(windows);
        if (!windowToMergeResult.isEmpty()) {
            ArrayList<BoundedWindow> addedWindows = new ArrayList<BoundedWindow>(windowToMergeResult.size());
            for (Map.Entry<Object, Object> entry : windowToMergeResult.entrySet()) {
                windows.remove(entry.getKey());
                addedWindows.add((BoundedWindow)entry.getValue());
            }
            windows.addAll(addedWindows);
        }
        this.prefetchWindowsForValues(windows);
        Set<W> windowsToConsider = this.windowsThatAreOpen(windows);
        for (BoundedWindow boundedWindow : windowsToConsider) {
            this.triggerRunner.prefetchShouldFire(boundedWindow, this.contextFactory.base(boundedWindow, ReduceFnContextFactory.StateStyle.DIRECT).state());
        }
        for (WindowedValue windowedValue : values) {
            this.processElement(windowToMergeResult, windowedValue);
        }
        Collection<W> windowsToFire = this.windowsThatShouldFire(windowsToConsider);
        for (BoundedWindow window : windowsToFire) {
            this.prefetchEmit(this.contextFactory.base(window, ReduceFnContextFactory.StateStyle.DIRECT), this.contextFactory.base(window, ReduceFnContextFactory.StateStyle.RENAMED));
        }
        for (BoundedWindow window : windowsToFire) {
            this.emit(this.contextFactory.base(window, ReduceFnContextFactory.StateStyle.DIRECT), this.contextFactory.base(window, ReduceFnContextFactory.StateStyle.RENAMED));
        }
        this.activeWindows.cleanupTemporaryWindows();
    }

    public void persist() {
        this.activeWindows.persist();
    }

    private @UnknownKeyFor @NonNull @Initialized Set<W> collectWindows(@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized WindowedValue<InputT>> values) throws @UnknownKeyFor @NonNull @Initialized Exception {
        HashSet<BoundedWindow> windows = new HashSet<BoundedWindow>();
        for (WindowedValue<InputT> value : values) {
            Iterator<BoundedWindow> iterator = value.getWindows().iterator();
            while (iterator.hasNext()) {
                BoundedWindow untypedWindow;
                BoundedWindow window = untypedWindow = iterator.next();
                windows.add(window);
            }
        }
        return windows;
    }

    private @UnknownKeyFor @NonNull @Initialized Map<W, W> mergeWindows(@UnknownKeyFor @NonNull @Initialized Set<W> windows) throws @UnknownKeyFor @NonNull @Initialized Exception {
        if (this.windowingStrategy.getWindowFn().isNonMerging()) {
            return Collections.emptyMap();
        }
        HashMap windowToMergeResult = new HashMap();
        for (BoundedWindow window : windows) {
            Set<BoundedWindow> stateAddressWindows;
            if (this.activeWindows.isActive(window) && (stateAddressWindows = this.activeWindows.readStateAddresses(window)).size() > 1) {
                ReduceFn.OnMergeContext premergeContext = this.contextFactory.forPremerge(window);
                this.reduceFn.onMerge(premergeContext);
                this.watermarkHold.onMerge(premergeContext);
                this.activeWindows.merged(window);
            }
            this.activeWindows.ensureWindowExists(window);
        }
        this.activeWindows.merge(new OnMergeCallback(windowToMergeResult));
        return windowToMergeResult;
    }

    private @UnknownKeyFor @NonNull @Initialized ImmutableSet<W> toMergedWindows(@UnknownKeyFor @NonNull @Initialized Map<W, W> windowToMergeResult, @UnknownKeyFor @NonNull @Initialized Collection<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized BoundedWindow> windows) {
        return ImmutableSet.copyOf(FluentIterable.from(windows).transform(untypedWindow -> {
            BoundedWindow window = untypedWindow;
            BoundedWindow mergedWindow = (BoundedWindow)windowToMergeResult.get(window);
            return mergedWindow == null ? window : mergedWindow;
        }));
    }

    private void prefetchWindowsForValues(@UnknownKeyFor @NonNull @Initialized Collection<W> windows) {
        for (BoundedWindow window : windows) {
            ReduceFn.Context directContext = this.contextFactory.base(window, ReduceFnContextFactory.StateStyle.DIRECT);
            this.triggerRunner.prefetchForValue(window, directContext.state());
        }
    }

    private void processElement(@UnknownKeyFor @NonNull @Initialized Map<W, W> windowToMergeResult, @UnknownKeyFor @NonNull @Initialized WindowedValue<InputT> value) throws @UnknownKeyFor @NonNull @Initialized Exception {
        ImmutableSet<W> windows = this.toMergedWindows(windowToMergeResult, value.getWindows());
        for (BoundedWindow window : windows) {
            ReduceFn.ProcessValueContext directContext = this.contextFactory.forValue(window, value.getValue(), value.getTimestamp(), ReduceFnContextFactory.StateStyle.DIRECT);
            if (this.triggerRunner.isClosed(directContext.state())) {
                this.droppedDueToClosedWindow.inc();
                WindowTracing.debug("ReduceFnRunner.processElement: Dropping element at {} for key:{}; window:{} since window is no longer active at inputWatermark:{}; outputWatermark:{}", value.getTimestamp(), this.key, window, this.timerInternals.currentInputWatermarkTime(), this.timerInternals.currentOutputWatermarkTime());
                continue;
            }
            this.activeWindows.ensureWindowIsActive(window);
            ReduceFn.ProcessValueContext renamedContext = this.contextFactory.forValue(window, value.getValue(), value.getTimestamp(), ReduceFnContextFactory.StateStyle.RENAMED);
            this.nonEmptyPanes.recordContent(renamedContext.state());
            this.scheduleGarbageCollectionTimer(directContext);
            this.watermarkHold.addHolds(renamedContext);
            this.reduceFn.processValue(renamedContext);
            this.triggerRunner.processValue(directContext.window(), directContext.timestamp(), directContext.timers(), directContext.state());
        }
    }

    public void onTimers(@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized TimerInternals.TimerData> timers) throws @UnknownKeyFor @NonNull @Initialized Exception {
        ReduceFn.Context directContext;
        if (!timers.iterator().hasNext()) {
            return;
        }
        HashMap windowActivations = new HashMap();
        for (TimerInternals.TimerData timerData : timers) {
            Preconditions.checkArgument(timerData.getNamespace() instanceof StateNamespaces.WindowNamespace, "Expected timer to be in WindowNamespace, but was in %s", (Object)timerData.getNamespace());
            StateNamespaces.WindowNamespace windowNamespace = (StateNamespaces.WindowNamespace)timerData.getNamespace();
            Object window = windowNamespace.getWindow();
            WindowTracing.debug("ReduceFnRunner: Received timer key:{}; window:{}; data:{} with inputWatermark:{}; outputWatermark:{}", this.key, window, timerData, this.timerInternals.currentInputWatermarkTime(), this.timerInternals.currentOutputWatermarkTime());
            if (TimeDomain.EVENT_TIME != timerData.getDomain() && this.windowIsExpired((BoundedWindow)window) || windowActivations.containsKey(window)) continue;
            ReduceFn.Context directContext2 = this.contextFactory.base(window, ReduceFnContextFactory.StateStyle.DIRECT);
            ReduceFn.Context renamedContext = this.contextFactory.base(window, ReduceFnContextFactory.StateStyle.RENAMED);
            WindowActivation windowActivation = new WindowActivation(directContext2, renamedContext);
            windowActivations.put(window, windowActivation);
            if (windowActivation.isGarbageCollection) {
                this.triggerRunner.prefetchIsClosed(directContext2.state());
                continue;
            }
            this.triggerRunner.prefetchShouldFire(directContext2.window(), directContext2.state());
        }
        for (WindowActivation windowActivation : windowActivations.values()) {
            if (!windowActivation.windowIsActiveAndOpen()) continue;
            directContext = windowActivation.directContext;
            if (windowActivation.isGarbageCollection) {
                this.prefetchOnTrigger(directContext, windowActivation.renamedContext);
                continue;
            }
            if (!this.triggerRunner.shouldFire(directContext.window(), directContext.timers(), directContext.state())) continue;
            this.prefetchEmit(directContext, windowActivation.renamedContext);
        }
        for (WindowActivation windowActivation : windowActivations.values()) {
            directContext = windowActivation.directContext;
            ReduceFn.Context renamedContext = windowActivation.renamedContext;
            if (windowActivation.isGarbageCollection) {
                WindowTracing.debug("ReduceFnRunner: Cleaning up for key:{}; window:{} with inputWatermark:{}; outputWatermark:{}", this.key, directContext.window(), this.timerInternals.currentInputWatermarkTime(), this.timerInternals.currentOutputWatermarkTime());
                boolean windowIsActiveAndOpen = windowActivation.windowIsActiveAndOpen();
                if (windowIsActiveAndOpen) {
                    @Nullable Instant newHold = this.onTrigger(directContext, renamedContext, true, windowActivation.isEndOfWindow);
                    Preconditions.checkState(newHold == null, "Hold placed at %s despite isFinished being true.", (Object)newHold);
                }
                this.clearAllState(directContext, renamedContext, windowIsActiveAndOpen);
                continue;
            }
            WindowTracing.debug("{}.onTimers: Triggering for key:{}; window:{} at {} with inputWatermark:{}; outputWatermark:{}", this.key, directContext.window(), this.timerInternals.currentInputWatermarkTime(), this.timerInternals.currentOutputWatermarkTime());
            if (windowActivation.windowIsActiveAndOpen() && this.triggerRunner.shouldFire(directContext.window(), directContext.timers(), directContext.state())) {
                this.emit(directContext, renamedContext);
            }
            if (!windowActivation.isEndOfWindow) continue;
            Preconditions.checkState(this.windowingStrategy.getAllowedLateness().isLongerThan((ReadableDuration)Duration.ZERO), "Unexpected zero getAllowedLateness");
            Instant cleanupTime = LateDataUtils.garbageCollectionTime(directContext.window(), this.windowingStrategy);
            WindowTracing.debug("ReduceFnRunner.onTimer: Scheduling cleanup timer for key:{}; window:{} at {} with inputWatermark:{}; outputWatermark:{}", this.key, directContext.window(), cleanupTime, this.timerInternals.currentInputWatermarkTime(), this.timerInternals.currentOutputWatermarkTime());
            Preconditions.checkState(!cleanupTime.isAfter((ReadableInstant)BoundedWindow.TIMESTAMP_MAX_VALUE), "Cleanup time %s is beyond end-of-time", (Object)cleanupTime);
            directContext.timers().setTimer(cleanupTime, TimeDomain.EVENT_TIME);
        }
    }

    private void clearAllState(@UnknownKeyFor @NonNull @Initialized ReduceFn. @UnknownKeyFor @NonNull @Initialized Context directContext, @UnknownKeyFor @NonNull @Initialized ReduceFn. @UnknownKeyFor @NonNull @Initialized Context renamedContext, @UnknownKeyFor @NonNull @Initialized boolean windowIsActiveAndOpen) throws @UnknownKeyFor @NonNull @Initialized Exception {
        if (windowIsActiveAndOpen) {
            this.reduceFn.clearState(renamedContext);
            this.watermarkHold.clearHolds(renamedContext);
            this.nonEmptyPanes.clearPane(renamedContext.state());
            this.triggerRunner.clearState(directContext.window(), directContext.timers(), directContext.state());
            this.paneInfoTracker.clear(directContext.state());
        } else if (this.windowingStrategy.getMode() == WindowingStrategy.AccumulationMode.DISCARDING_FIRED_PANES && this.windowingStrategy.needsMerge()) {
            this.watermarkHold.clearHolds(directContext);
        }
        this.activeWindows.remove(directContext.window());
        this.triggerRunner.clearFinished(directContext.state());
    }

    private @UnknownKeyFor @NonNull @Initialized boolean shouldDiscardAfterFiring(@UnknownKeyFor @NonNull @Initialized boolean isFinished) {
        if (isFinished) {
            return true;
        }
        return this.windowingStrategy.getMode() == WindowingStrategy.AccumulationMode.DISCARDING_FIRED_PANES;
    }

    private void prefetchEmit(@UnknownKeyFor @NonNull @Initialized ReduceFn. @UnknownKeyFor @NonNull @Initialized Context directContext, @UnknownKeyFor @NonNull @Initialized ReduceFn. @UnknownKeyFor @NonNull @Initialized Context renamedContext) {
        this.triggerRunner.prefetchShouldFire(directContext.window(), directContext.state());
        this.triggerRunner.prefetchIsClosed(directContext.state());
        this.prefetchOnTrigger(directContext, renamedContext);
    }

    private void emit(@UnknownKeyFor @NonNull @Initialized ReduceFn. @UnknownKeyFor @NonNull @Initialized Context directContext, @UnknownKeyFor @NonNull @Initialized ReduceFn. @UnknownKeyFor @NonNull @Initialized Context renamedContext) throws @UnknownKeyFor @NonNull @Initialized Exception {
        Preconditions.checkState(this.triggerRunner.shouldFire(directContext.window(), directContext.timers(), directContext.state()));
        this.triggerRunner.onFire(directContext.window(), directContext.timers(), directContext.state());
        boolean isFinished = this.triggerRunner.isClosed(directContext.state());
        boolean shouldDiscard = this.shouldDiscardAfterFiring(isFinished);
        this.onTrigger(directContext, renamedContext, isFinished, false);
        this.nonEmptyPanes.clearPane(renamedContext.state());
        if (shouldDiscard) {
            this.reduceFn.clearState(renamedContext);
        }
        if (isFinished) {
            this.triggerRunner.clearState(directContext.window(), directContext.timers(), directContext.state());
            this.paneInfoTracker.clear(directContext.state());
            this.activeWindows.remove(directContext.window());
        }
    }

    private @UnknownKeyFor @NonNull @Initialized boolean needToEmit(@UnknownKeyFor @NonNull @Initialized boolean isEmpty, @UnknownKeyFor @NonNull @Initialized boolean isFinished, @UnknownKeyFor @NonNull @Initialized PaneInfo.Timing timing) {
        if (!isEmpty) {
            return true;
        }
        if (timing == PaneInfo.Timing.ON_TIME && this.windowingStrategy.getOnTimeBehavior() == Window.OnTimeBehavior.FIRE_ALWAYS) {
            return true;
        }
        return isFinished && this.windowingStrategy.getClosingBehavior() == Window.ClosingBehavior.FIRE_ALWAYS;
    }

    private void prefetchOnTrigger(@UnknownKeyFor @NonNull @Initialized ReduceFn. @UnknownKeyFor @NonNull @Initialized Context directContext, @UnknownKeyFor @NonNull @Initialized ReduceFn. @UnknownKeyFor @NonNull @Initialized Context renamedContext) {
        this.paneInfoTracker.prefetchPaneInfo(directContext);
        this.watermarkHold.prefetchExtract(renamedContext);
        this.nonEmptyPanes.isEmpty(renamedContext.state()).readLater();
        this.reduceFn.prefetchOnTrigger(directContext.state());
    }

    private @Nullable @UnknownKeyFor @Initialized Instant onTrigger(@UnknownKeyFor @NonNull @Initialized ReduceFn. @UnknownKeyFor @NonNull @Initialized Context directContext, @UnknownKeyFor @NonNull @Initialized ReduceFn. @UnknownKeyFor @NonNull @Initialized Context renamedContext, @UnknownKeyFor @NonNull @Initialized boolean isFinished, @UnknownKeyFor @NonNull @Initialized boolean isEndOfWindow) throws @UnknownKeyFor @NonNull @Initialized Exception {
        PaneInfo pane;
        WatermarkHold.OldAndNewHolds pair = this.watermarkHold.extractAndRelease(renamedContext, isFinished).read();
        Instant outputTimestamp = pair.oldHold;
        @Nullable Instant newHold = pair.newHold;
        boolean isEmpty = this.nonEmptyPanes.isEmpty(renamedContext.state()).read();
        if (isEmpty && this.windowingStrategy.getClosingBehavior() == Window.ClosingBehavior.FIRE_IF_NON_EMPTY && this.windowingStrategy.getOnTimeBehavior() == Window.OnTimeBehavior.FIRE_IF_NON_EMPTY) {
            return newHold;
        }
        Instant inputWM = this.timerInternals.currentInputWatermarkTime();
        if (newHold != null) {
            Preconditions.checkState(!isFinished, "new hold at %s but finished %s", (Object)newHold, directContext.window());
            Preconditions.checkState(!newHold.isBefore((ReadableInstant)inputWM), "new hold %s is before input watermark %s", (Object)newHold, (Object)inputWM);
            if (newHold.isAfter((ReadableInstant)((BoundedWindow)directContext.window()).maxTimestamp())) {
                Preconditions.checkState(newHold.isEqual((ReadableInstant)LateDataUtils.garbageCollectionTime(directContext.window(), this.windowingStrategy)), "new hold %s should be at garbage collection for window %s plus %s", (Object)newHold, directContext.window(), (Object)this.windowingStrategy.getAllowedLateness());
            } else {
                Preconditions.checkState(newHold.isEqual((ReadableInstant)((BoundedWindow)directContext.window()).maxTimestamp()), "new hold %s should be at end of window %s", (Object)newHold, directContext.window());
                Preconditions.checkState(!isEndOfWindow, "new hold at %s for %s but this is the watermark trigger", (Object)newHold, directContext.window());
            }
        }
        if (this.needToEmit(isEmpty, isFinished, (pane = this.paneInfoTracker.getNextPaneInfo(directContext, isFinished).read()).getTiming())) {
            List windows = Collections.singletonList(directContext.window());
            ReduceFn.OnTriggerContext renamedTriggerContext = this.contextFactory.forTrigger(directContext.window(), pane, ReduceFnContextFactory.StateStyle.RENAMED, toOutput -> {
                if (!isFinished) {
                    this.paneInfoTracker.storeCurrentPaneInfo(directContext, pane);
                }
                this.outputter.outputWindowedValue(KV.of(this.key, toOutput), outputTimestamp, windows, pane);
            });
            this.reduceFn.onTrigger(renamedTriggerContext);
        }
        return newHold;
    }

    private void scheduleGarbageCollectionTimer(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized @Nullable @Initialized @NonNull @Initialized @Nullable @Initialized @NonNull @Initialized @NonNull @Initialized ReduceFn. @UnknownKeyFor @NonNull @Initialized Context directContext) {
        Instant inputWM = this.timerInternals.currentInputWatermarkTime();
        Instant gcTime = LateDataUtils.garbageCollectionTime(directContext.window(), this.windowingStrategy);
        WindowTracing.trace("ReduceFnRunner.scheduleGarbageCollectionTimer: Scheduling at {} for key:{}; window:{} where inputWatermark:{}; outputWatermark:{}", gcTime, this.key, directContext.window(), inputWM, this.timerInternals.currentOutputWatermarkTime());
        Preconditions.checkState(!gcTime.isAfter((ReadableInstant)BoundedWindow.TIMESTAMP_MAX_VALUE), "Timer %s is beyond end-of-time", (Object)gcTime);
        directContext.timers().setTimer(gcTime, TimeDomain.EVENT_TIME);
    }

    private void cancelEndOfWindowAndGarbageCollectionTimers(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized @Nullable @Initialized @NonNull @Initialized @Nullable @Initialized @NonNull @Initialized @NonNull @Initialized ReduceFn. @UnknownKeyFor @NonNull @Initialized Context directContext) {
        WindowTracing.debug("ReduceFnRunner.cancelEndOfWindowAndGarbageCollectionTimers: Deleting timers for key:{}; window:{} where inputWatermark:{}; outputWatermark:{}", this.key, directContext.window(), this.timerInternals.currentInputWatermarkTime(), this.timerInternals.currentOutputWatermarkTime());
        Instant eow = ((BoundedWindow)directContext.window()).maxTimestamp();
        directContext.timers().deleteTimer(eow, TimeDomain.EVENT_TIME);
        Instant gc = LateDataUtils.garbageCollectionTime(directContext.window(), this.windowingStrategy);
        if (gc.isAfter((ReadableInstant)eow)) {
            directContext.timers().deleteTimer(gc, TimeDomain.EVENT_TIME);
        }
    }

    private @UnknownKeyFor @NonNull @Initialized boolean windowIsExpired(@UnknownKeyFor @NonNull @Initialized BoundedWindow w) {
        return this.timerInternals.currentInputWatermarkTime().isAfter((ReadableInstant)w.maxTimestamp().plus((ReadableDuration)this.windowingStrategy.getAllowedLateness()));
    }

    private class WindowActivation {
        public final @UnknownKeyFor @NonNull @Initialized ReduceFn. @UnknownKeyFor @NonNull @Initialized Context directContext;
        public final @UnknownKeyFor @NonNull @Initialized ReduceFn. @UnknownKeyFor @NonNull @Initialized Context renamedContext;
        public final @UnknownKeyFor @NonNull @Initialized boolean isEndOfWindow;
        public final @UnknownKeyFor @NonNull @Initialized boolean isGarbageCollection;

        WindowActivation(@UnknownKeyFor @NonNull @Initialized ReduceFn. @UnknownKeyFor @NonNull @Initialized Context directContext, ReduceFn.Context renamedContext) {
            this.directContext = directContext;
            this.renamedContext = renamedContext;
            Object window = directContext.window();
            boolean outputWatermarkBeforeEOW = ReduceFnRunner.this.timerInternals.currentOutputWatermarkTime() == null || !ReduceFnRunner.this.timerInternals.currentOutputWatermarkTime().isAfter((ReadableInstant)((BoundedWindow)window).maxTimestamp());
            this.isEndOfWindow = ReduceFnRunner.this.timerInternals.currentInputWatermarkTime().isAfter((ReadableInstant)((BoundedWindow)window).maxTimestamp()) && outputWatermarkBeforeEOW;
            this.isGarbageCollection = ReduceFnRunner.this.timerInternals.currentInputWatermarkTime().isAfter((ReadableInstant)LateDataUtils.garbageCollectionTime(window, ReduceFnRunner.this.windowingStrategy));
        }

        public @UnknownKeyFor @NonNull @Initialized boolean windowIsActiveAndOpen() {
            return ReduceFnRunner.this.activeWindows.isActive(this.directContext.window()) && !ReduceFnRunner.this.triggerRunner.isClosed(this.directContext.state());
        }
    }

    private class OnMergeCallback
    implements ActiveWindowSet.MergeCallback<W> {
        private final @UnknownKeyFor @NonNull @Initialized Map<W, W> windowToMergeResult;

        OnMergeCallback(Map<W, W> windowToMergeResult) {
            this.windowToMergeResult = windowToMergeResult;
        }

        private @UnknownKeyFor @NonNull @Initialized List<W> activeWindows(@UnknownKeyFor @NonNull @Initialized Iterable<W> windows) {
            ArrayList<BoundedWindow> active = new ArrayList<BoundedWindow>();
            for (BoundedWindow window : windows) {
                if (!ReduceFnRunner.this.activeWindows.isActive(window)) continue;
                active.add(window);
            }
            return active;
        }

        @Override
        public void prefetchOnMerge(@UnknownKeyFor @NonNull @Initialized Collection<W> toBeMerged, W mergeResult) throws @UnknownKeyFor @NonNull @Initialized Exception {
            List activeToBeMerged = this.activeWindows(toBeMerged);
            ReduceFn.OnMergeContext directMergeContext = ReduceFnRunner.this.contextFactory.forMerge(activeToBeMerged, mergeResult, ReduceFnContextFactory.StateStyle.DIRECT);
            ReduceFn.OnMergeContext renamedMergeContext = ReduceFnRunner.this.contextFactory.forMerge(activeToBeMerged, mergeResult, ReduceFnContextFactory.StateStyle.RENAMED);
            ReduceFnRunner.this.triggerRunner.prefetchForMerge(mergeResult, activeToBeMerged, directMergeContext.state());
            ReduceFnRunner.this.reduceFn.prefetchOnMerge(renamedMergeContext.state());
            ReduceFnRunner.this.watermarkHold.prefetchOnMerge(renamedMergeContext.state());
            ReduceFnRunner.this.nonEmptyPanes.prefetchOnMerge(renamedMergeContext.state());
        }

        @Override
        public void onMerge(@UnknownKeyFor @NonNull @Initialized Collection<W> toBeMerged, W mergeResult) throws @UnknownKeyFor @NonNull @Initialized Exception {
            for (BoundedWindow window : toBeMerged) {
                this.windowToMergeResult.put(window, mergeResult);
            }
            List activeToBeMerged = this.activeWindows(toBeMerged);
            ReduceFn.OnMergeContext directMergeContext = ReduceFnRunner.this.contextFactory.forMerge(activeToBeMerged, mergeResult, ReduceFnContextFactory.StateStyle.DIRECT);
            ReduceFn.OnMergeContext renamedMergeContext = ReduceFnRunner.this.contextFactory.forMerge(activeToBeMerged, mergeResult, ReduceFnContextFactory.StateStyle.RENAMED);
            ReduceFnRunner.this.reduceFn.onMerge(renamedMergeContext);
            ReduceFnRunner.this.watermarkHold.onMerge(renamedMergeContext);
            ReduceFnRunner.this.nonEmptyPanes.onMerge(renamedMergeContext.state());
            ReduceFnRunner.this.triggerRunner.onMerge(directMergeContext.window(), directMergeContext.timers(), directMergeContext.state());
            for (BoundedWindow active : activeToBeMerged) {
                if (active.equals(mergeResult)) continue;
                WindowTracing.debug("ReduceFnRunner.onMerge: Merging {} into {}", active, mergeResult);
                ReduceFn.Context directClearContext = ReduceFnRunner.this.contextFactory.base(active, ReduceFnContextFactory.StateStyle.DIRECT);
                ReduceFnRunner.this.cancelEndOfWindowAndGarbageCollectionTimers(directClearContext);
                ReduceFnRunner.this.paneInfoTracker.clear(directClearContext.state());
            }
        }
    }
}

