/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.core;

import java.util.ArrayList;
import java.util.Comparator;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.IterableCoder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.GroupByKey;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class GroupByKeyViaGroupByKeyOnly<@UnknownKeyFor K, @UnknownKeyFor V>
extends PTransform<PCollection<KV<K, V>>, PCollection<KV<K, Iterable<V>>>> {
    private final @UnknownKeyFor @NonNull @Initialized GroupByKey<K, V> gbkTransform;

    public GroupByKeyViaGroupByKeyOnly(@UnknownKeyFor @NonNull @Initialized GroupByKey<K, V> originalTransform) {
        this.gbkTransform = originalTransform;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, @UnknownKeyFor @NonNull @Initialized Iterable<V>>> expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, V>> input) {
        WindowingStrategy<?, ?> windowingStrategy = input.getWindowingStrategy();
        return ((PCollection)((PCollection)((PCollection)input.apply(new GroupByKeyOnly())).apply(new SortValuesByTimestamp())).apply(new GroupAlsoByWindow(windowingStrategy))).setWindowingStrategyInternal(this.gbkTransform.updateWindowingStrategy(windowingStrategy));
    }

    public static class GroupAlsoByWindow<@UnknownKeyFor K, @UnknownKeyFor V>
    extends PTransform<PCollection<KV<K, Iterable<WindowedValue<V>>>>, PCollection<KV<K, Iterable<V>>>> {
        private final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> windowingStrategy;

        public GroupAlsoByWindow(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> windowingStrategy) {
            this.windowingStrategy = windowingStrategy;
        }

        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> getWindowingStrategy() {
            return this.windowingStrategy;
        }

        private @UnknownKeyFor @NonNull @Initialized KvCoder<K, @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized WindowedValue<V>>> getKvCoder(@UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized KV<K, @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized WindowedValue<V>>>> inputCoder) {
            Preconditions.checkArgument(inputCoder instanceof KvCoder, "%s requires a %s<...> but got %s", (Object)this.getClass().getSimpleName(), (Object)KvCoder.class.getSimpleName(), inputCoder);
            KvCoder kvCoder = (KvCoder)inputCoder;
            return kvCoder;
        }

        public @UnknownKeyFor @NonNull @Initialized Coder<K> getKeyCoder(@UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized KV<K, @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized WindowedValue<V>>>> inputCoder) {
            return this.getKvCoder(inputCoder).getKeyCoder();
        }

        public @UnknownKeyFor @NonNull @Initialized Coder<V> getValueCoder(@UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized KV<K, @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized WindowedValue<V>>>> inputCoder) {
            Coder<Iterable<WindowedValue<V>>> iterableWindowedValueCoder = this.getKvCoder(inputCoder).getValueCoder();
            Preconditions.checkArgument(iterableWindowedValueCoder instanceof IterableCoder, "%s requires a %s<..., %s> but got a %s", (Object)this.getClass().getSimpleName(), (Object)KvCoder.class.getSimpleName(), (Object)IterableCoder.class.getSimpleName(), iterableWindowedValueCoder);
            IterableCoder iterableCoder = (IterableCoder)iterableWindowedValueCoder;
            Coder iterableElementCoder = iterableCoder.getElemCoder();
            Preconditions.checkArgument(iterableElementCoder instanceof WindowedValue.WindowedValueCoder, "%s requires a %s<..., %s<%s>> but got a %s", this.getClass().getSimpleName(), KvCoder.class.getSimpleName(), IterableCoder.class.getSimpleName(), WindowedValue.WindowedValueCoder.class.getSimpleName(), iterableElementCoder);
            WindowedValue.WindowedValueCoder windowedValueCoder = (WindowedValue.WindowedValueCoder)iterableElementCoder;
            return windowedValueCoder.getValueCoder();
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, @UnknownKeyFor @NonNull @Initialized Iterable<V>>> expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized WindowedValue<V>>>> input) {
            KvCoder inputKvCoder = (KvCoder)input.getCoder();
            Coder keyCoder = inputKvCoder.getKeyCoder();
            Coder inputValueCoder = inputKvCoder.getValueCoder();
            IterableCoder inputIterableValueCoder = (IterableCoder)inputValueCoder;
            Coder inputIterableElementCoder = inputIterableValueCoder.getElemCoder();
            WindowedValue.WindowedValueCoder inputIterableWindowedValueCoder = (WindowedValue.WindowedValueCoder)inputIterableElementCoder;
            Coder inputIterableElementValueCoder = inputIterableWindowedValueCoder.getValueCoder();
            IterableCoder outputValueCoder = IterableCoder.of(inputIterableElementValueCoder);
            KvCoder outputKvCoder = KvCoder.of(keyCoder, outputValueCoder);
            return PCollection.createPrimitiveOutputInternal(input.getPipeline(), this.windowingStrategy, input.isBounded(), outputKvCoder);
        }
    }

    private static class SortValuesByTimestamp<@UnknownKeyFor K, @UnknownKeyFor V>
    extends PTransform<PCollection<KV<K, Iterable<WindowedValue<V>>>>, PCollection<KV<K, Iterable<WindowedValue<V>>>>> {
        private SortValuesByTimestamp() {
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized WindowedValue<V>>>> expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized WindowedValue<V>>>> input) {
            return ((PCollection)input.apply(ParDo.of(new DoFn<KV<K, Iterable<WindowedValue<V>>>, KV<K, Iterable<WindowedValue<V>>>>(){

                @DoFn.ProcessElement
                public void processElement(/*
                 * Issues handling annotations - annotations may be inaccurate
                 */
                @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) {
                    KV kvs = (KV)c.element();
                    Object key = kvs.getKey();
                    Iterable unsortedValues = (Iterable)kvs.getValue();
                    ArrayList<WindowedValue> sortedValues = new ArrayList<WindowedValue>();
                    for (WindowedValue value : unsortedValues) {
                        sortedValues.add(value);
                    }
                    sortedValues.sort(Comparator.comparing(WindowedValue::getTimestamp));
                    c.output(KV.of(key, sortedValues));
                }
            }))).setCoder(input.getCoder());
        }
    }

    public static class GroupByKeyOnly<@UnknownKeyFor K, @UnknownKeyFor V>
    extends PTransform<PCollection<KV<K, V>>, PCollection<KV<K, Iterable<WindowedValue<V>>>>> {
        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized WindowedValue<V>>>> expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, V>> input) {
            return PCollection.createPrimitiveOutputInternal(input.getPipeline(), input.getWindowingStrategy(), input.isBounded(), GroupByKey.getOutputKvCoder(input.getCoder()));
        }
    }
}

