/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.actions.createfolder;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileType;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.Result;
import org.apache.hop.core.annotations.Action;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.ActionBase;
import org.apache.hop.workflow.action.IAction;
import org.apache.hop.workflow.action.validator.AbstractFileValidator;
import org.apache.hop.workflow.action.validator.ActionValidatorUtils;
import org.apache.hop.workflow.action.validator.AndValidator;
import org.apache.hop.workflow.action.validator.IActionValidator;
import org.apache.hop.workflow.action.validator.ValidatorContext;

@Action(id="CREATE_FOLDER", name="i18n::ActionCreateFolder.Name", description="i18n::ActionCreateFolder.Description", image="CreateFolder.svg", categoryDescription="i18n:org.apache.hop.workflow:ActionCategory.Category.FileManagement", keywords={"i18n::ActionCreateFolder.keyword"}, documentationUrl="/workflow/actions/createfolder.html")
public class ActionCreateFolder
extends ActionBase
implements Cloneable,
IAction {
    private static final String CONST_FOLDER = "Folder [";
    @HopMetadataProperty(key="foldername")
    private String folderName;
    @HopMetadataProperty(key="fail_of_folder_exists")
    private boolean failIfFolderExists;

    public ActionCreateFolder(String n) {
        super(n, "");
        this.folderName = null;
        this.failIfFolderExists = true;
    }

    public ActionCreateFolder() {
        this("");
    }

    public ActionCreateFolder(ActionCreateFolder f) {
        super(f.getName(), f.getDescription(), f.getPluginId());
        this.folderName = f.folderName;
        this.failIfFolderExists = f.failIfFolderExists;
    }

    public ActionCreateFolder clone() {
        return new ActionCreateFolder(this);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Result execute(Result previousResult, int nr) {
        Result result = previousResult;
        result.setResult(false);
        if (StringUtils.isEmpty((String)this.folderName)) {
            this.logError("No folder name is defined.");
            return result;
        }
        String realFolderName = this.getRealFolderName();
        try (FileObject folderObject = HopVfs.getFileObject((String)realFolderName, (IVariables)this.getVariables());){
            if (folderObject.exists()) {
                boolean isFolder;
                boolean bl = isFolder = folderObject.getType() == FileType.FOLDER;
                if (this.isFailIfFolderExists()) {
                    result.setResult(false);
                    if (isFolder) {
                        this.logError(CONST_FOLDER + realFolderName + "] exists, failing.");
                    } else {
                        this.logError("File [" + realFolderName + "] exists, failing.");
                    }
                } else {
                    result.setResult(true);
                    if (this.log.isDetailed()) {
                        this.logDetailed(CONST_FOLDER + realFolderName + "] already exists, not recreating.");
                    }
                }
                Result result2 = result;
                return result2;
            }
            folderObject.createFolder();
            if (this.log.isDetailed()) {
                this.logDetailed(CONST_FOLDER + realFolderName + "] created!");
            }
            result.setResult(true);
            return result;
        }
        catch (Exception e) {
            this.logError("Could not create Folder [" + realFolderName + "]", e);
            result.setResult(false);
            result.setNrErrors(1L);
        }
        return result;
    }

    public boolean isEvaluation() {
        return true;
    }

    public void check(List<ICheckResult> remarks, WorkflowMeta workflowMeta, IVariables variables, IHopMetadataProvider metadataProvider) {
        ValidatorContext ctx = new ValidatorContext();
        AbstractFileValidator.putVariableSpace((ValidatorContext)ctx, (IVariables)this.getVariables());
        AndValidator.putValidators((ValidatorContext)ctx, (IActionValidator[])new IActionValidator[]{ActionValidatorUtils.notNullValidator(), ActionValidatorUtils.fileDoesNotExistValidator()});
        ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, "filename", remarks, ctx);
    }

    public String getRealFolderName() {
        return this.resolve(this.getFolderName());
    }

    public String getFolderName() {
        return this.folderName;
    }

    public void setFolderName(String folderName) {
        this.folderName = folderName;
    }

    public boolean isFailIfFolderExists() {
        return this.failIfFolderExists;
    }

    public void setFailIfFolderExists(boolean failIfFolderExists) {
        this.failIfFolderExists = failIfFolderExists;
    }
}

