/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.creditcardvalidator;

import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transforms.creditcardvalidator.CreditCardValidatorMeta;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.apache.hop.ui.pipeline.transform.ComponentSelectionListener;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class CreditCardValidatorDialog
extends BaseTransformDialog {
    private static final Class<?> PKG = CreditCardValidatorMeta.class;
    private boolean gotPreviousFields = false;
    private CCombo wFieldName;
    private TextVar wResult;
    private TextVar wFileType;
    private TextVar wNotValidMsg;
    private Button wgetOnlyDigits;
    private final CreditCardValidatorMeta input;

    public CreditCardValidatorDialog(Shell parent, IVariables variables, CreditCardValidatorMeta transformMeta, PipelineMeta pipelineMeta) {
        super(parent, variables, (ITransformMeta)transformMeta, pipelineMeta);
        this.input = transformMeta;
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        PropsUi.setLook((Widget)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.input);
        ModifyListener lsMod = e -> this.input.setChanged();
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"CreditCardValidatorDialog.Shell.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = PropsUi.getMargin();
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"CreditCardValidatorDialog.TransformName.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.right = new FormAttachment(middle, -margin);
        this.fdlTransformName.top = new FormAttachment(0, margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        PropsUi.setLook((Widget)this.wTransformName);
        this.wTransformName.addModifyListener(lsMod);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(middle, 0);
        this.fdTransformName.top = new FormAttachment(0, margin);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        Label wlFieldName = new Label((Composite)this.shell, 131072);
        wlFieldName.setText(BaseMessages.getString(PKG, (String)"CreditCardValidatorDialog.FieldName.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlFieldName);
        FormData fdlFieldName = new FormData();
        fdlFieldName.left = new FormAttachment(0, 0);
        fdlFieldName.right = new FormAttachment(middle, -margin);
        fdlFieldName.top = new FormAttachment((Control)this.wTransformName, margin);
        wlFieldName.setLayoutData((Object)fdlFieldName);
        this.wFieldName = new CCombo((Composite)this.shell, 2056);
        PropsUi.setLook((Widget)this.wFieldName);
        this.wFieldName.addModifyListener(lsMod);
        FormData fdFieldName = new FormData();
        fdFieldName.left = new FormAttachment(middle, 0);
        fdFieldName.top = new FormAttachment((Control)this.wTransformName, margin);
        fdFieldName.right = new FormAttachment(100, -margin);
        this.wFieldName.setLayoutData((Object)fdFieldName);
        this.wFieldName.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                Cursor busy = new Cursor((Device)CreditCardValidatorDialog.this.shell.getDisplay(), 1);
                CreditCardValidatorDialog.this.shell.setCursor(busy);
                CreditCardValidatorDialog.this.get();
                CreditCardValidatorDialog.this.shell.setCursor(null);
                busy.dispose();
            }
        });
        Label wlgetOnlyDigits = new Label((Composite)this.shell, 131072);
        wlgetOnlyDigits.setText(BaseMessages.getString(PKG, (String)"CreditCardValidator.getOnlyDigits.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlgetOnlyDigits);
        FormData fdlgetOnlyDigits = new FormData();
        fdlgetOnlyDigits.left = new FormAttachment(0, 0);
        fdlgetOnlyDigits.top = new FormAttachment((Control)this.wFieldName, margin);
        fdlgetOnlyDigits.right = new FormAttachment(middle, -margin);
        wlgetOnlyDigits.setLayoutData((Object)fdlgetOnlyDigits);
        this.wgetOnlyDigits = new Button((Composite)this.shell, 32);
        PropsUi.setLook((Widget)this.wgetOnlyDigits);
        this.wgetOnlyDigits.setToolTipText(BaseMessages.getString(PKG, (String)"CreditCardValidator.getOnlyDigits.Tooltip", (String[])new String[0]));
        FormData fdgetOnlyDigits = new FormData();
        fdgetOnlyDigits.left = new FormAttachment(middle, 0);
        fdgetOnlyDigits.top = new FormAttachment((Control)this.wFieldName, margin);
        this.wgetOnlyDigits.setLayoutData((Object)fdgetOnlyDigits);
        this.wgetOnlyDigits.addSelectionListener((SelectionListener)new ComponentSelectionListener((BaseTransformMeta)this.input));
        Group wOutputFields = new Group((Composite)this.shell, 32);
        PropsUi.setLook((Widget)wOutputFields);
        wOutputFields.setText(BaseMessages.getString(PKG, (String)"CreditCardValidatorDialog.OutputFields.Label", (String[])new String[0]));
        FormLayout outputFieldsgroupLayout = new FormLayout();
        outputFieldsgroupLayout.marginWidth = 10;
        outputFieldsgroupLayout.marginHeight = 10;
        wOutputFields.setLayout((Layout)outputFieldsgroupLayout);
        Label wlResult = new Label((Composite)wOutputFields, 131072);
        wlResult.setText(BaseMessages.getString(PKG, (String)"CreditCardValidatorDialog.ResultField.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlResult);
        FormData fdlResult = new FormData();
        fdlResult.left = new FormAttachment(0, -margin);
        fdlResult.right = new FormAttachment(middle, -2 * margin);
        fdlResult.top = new FormAttachment((Control)this.wgetOnlyDigits, 2 * margin);
        wlResult.setLayoutData((Object)fdlResult);
        this.wResult = new TextVar(this.variables, (Composite)wOutputFields, 18436);
        this.wResult.setToolTipText(BaseMessages.getString(PKG, (String)"CreditCardValidatorDialog.ResultField.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wResult);
        this.wResult.addModifyListener(lsMod);
        FormData fdResult = new FormData();
        fdResult.left = new FormAttachment(middle, -margin);
        fdResult.top = new FormAttachment((Control)this.wgetOnlyDigits, 2 * margin);
        fdResult.right = new FormAttachment(100, 0);
        this.wResult.setLayoutData((Object)fdResult);
        Label wlCardType = new Label((Composite)wOutputFields, 131072);
        wlCardType.setText(BaseMessages.getString(PKG, (String)"CreditCardValidatorDialog.CardType.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlCardType);
        FormData fdlCardType = new FormData();
        fdlCardType.left = new FormAttachment(0, -margin);
        fdlCardType.right = new FormAttachment(middle, -2 * margin);
        fdlCardType.top = new FormAttachment((Control)this.wResult, margin);
        wlCardType.setLayoutData((Object)fdlCardType);
        this.wFileType = new TextVar(this.variables, (Composite)wOutputFields, 18436);
        this.wFileType.setToolTipText(BaseMessages.getString(PKG, (String)"CreditCardValidatorDialog.CardType.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wFileType);
        this.wFileType.addModifyListener(lsMod);
        FormData fdCardType = new FormData();
        fdCardType.left = new FormAttachment(middle, -margin);
        fdCardType.top = new FormAttachment((Control)this.wResult, margin);
        fdCardType.right = new FormAttachment(100, 0);
        this.wFileType.setLayoutData((Object)fdCardType);
        Label wlNotValidMsg = new Label((Composite)wOutputFields, 131072);
        wlNotValidMsg.setText(BaseMessages.getString(PKG, (String)"CreditCardValidatorDialog.NotValidMsg.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlNotValidMsg);
        FormData fdlNotValidMsg = new FormData();
        fdlNotValidMsg.left = new FormAttachment(0, -margin);
        fdlNotValidMsg.right = new FormAttachment(middle, -2 * margin);
        fdlNotValidMsg.top = new FormAttachment((Control)this.wFileType, margin);
        wlNotValidMsg.setLayoutData((Object)fdlNotValidMsg);
        this.wNotValidMsg = new TextVar(this.variables, (Composite)wOutputFields, 18436);
        this.wNotValidMsg.setToolTipText(BaseMessages.getString(PKG, (String)"CreditCardValidatorDialog.NotValidMsg.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wNotValidMsg);
        this.wNotValidMsg.addModifyListener(lsMod);
        FormData fdNotValidMsg = new FormData();
        fdNotValidMsg.left = new FormAttachment(middle, -margin);
        fdNotValidMsg.top = new FormAttachment((Control)this.wFileType, margin);
        fdNotValidMsg.right = new FormAttachment(100, 0);
        this.wNotValidMsg.setLayoutData((Object)fdNotValidMsg);
        FormData fdAdditionalFields = new FormData();
        fdAdditionalFields.left = new FormAttachment(0, margin);
        fdAdditionalFields.top = new FormAttachment((Control)this.wgetOnlyDigits, 2 * margin);
        fdAdditionalFields.right = new FormAttachment(100, -margin);
        wOutputFields.setLayoutData((Object)fdAdditionalFields);
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.setButtonPositions(new Button[]{this.wOk, this.wCancel}, margin, (Control)wOutputFields);
        this.wOk.addListener(13, e -> this.ok());
        this.wCancel.addListener(13, e -> this.cancel());
        this.getData();
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    public void getData() {
        this.wFieldName.setText(Const.NVL((String)this.input.getFieldName(), (String)""));
        this.wgetOnlyDigits.setSelection(this.input.isOnlyDigits());
        this.wResult.setText(Const.NVL((String)this.input.getResultFieldName(), (String)""));
        this.wFileType.setText(Const.NVL((String)this.input.getCardType(), (String)""));
        this.wNotValidMsg.setText(Const.NVL((String)this.input.getNotValidMessage(), (String)""));
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    private void cancel() {
        this.transformName = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wTransformName.getText())) {
            return;
        }
        this.input.setFieldName(this.wFieldName.getText());
        this.input.setOnlyDigits(this.wgetOnlyDigits.getSelection());
        this.input.setResultFieldName(this.wResult.getText());
        this.input.setCardType(this.wFileType.getText());
        this.input.setNotValidMessage(this.wNotValidMsg.getText());
        this.transformName = this.wTransformName.getText();
        this.dispose();
    }

    private void get() {
        if (!this.gotPreviousFields) {
            try {
                String columnName = this.wFieldName.getText();
                this.wFieldName.removeAll();
                IRowMeta r = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName);
                if (r != null) {
                    r.getFieldNames();
                    for (int i = 0; i < r.getFieldNames().length; ++i) {
                        this.wFieldName.add(r.getFieldNames()[i]);
                    }
                }
                this.wFieldName.setText(columnName);
                this.gotPreviousFields = true;
            }
            catch (HopException ke) {
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"CreditCardValidatorDialog.FailedToGetFields.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CreditCardValidatorDialog.FailedToGetFields.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
            }
        }
    }
}

