/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.core.widget;

import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.ui.core.FormDataBuilder;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.widget.ControlSpaceKeyAdapter;
import org.apache.hop.ui.core.widget.OsHelper;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class StyledTextComp
extends Composite {
    private static final Class<?> PKG = StyledTextComp.class;
    private final Text textWidget;
    private final Menu styledTextPopupmenu;
    private final Composite xParent;
    private Image image;

    public StyledTextComp(IVariables variables, Composite parent, int args) {
        this(variables, parent, args, true, false);
    }

    public StyledTextComp(IVariables variables, Composite parent, int args, boolean varsSensitive) {
        this(variables, parent, args, varsSensitive, false);
    }

    public StyledTextComp(IVariables variables, Composite parent, int args, boolean varsSensitive, boolean variableIconOnTop) {
        super(parent, 0);
        this.textWidget = new Text((Composite)this, args);
        this.styledTextPopupmenu = new Menu((Decorations)parent.getShell(), 8);
        this.xParent = parent;
        this.setLayout((Layout)new FormLayout());
        this.buildingStyledTextMenu();
        this.textWidget.setLayoutData((Object)new FormDataBuilder().top().left().right(100, 0).bottom(100, 0).result());
        if (varsSensitive) {
            this.textWidget.addKeyListener((KeyListener)new ControlSpaceKeyAdapter(variables, (Control)this.textWidget));
            this.image = GuiResource.getInstance().getImageVariableMini();
            if (variableIconOnTop) {
                Label wIcon = new Label((Composite)this, 131072);
                PropsUi.setLook((Widget)wIcon);
                wIcon.setToolTipText(BaseMessages.getString(PKG, (String)"StyledTextComp.tooltip.InsertVariable", (String[])new String[0]));
                wIcon.setImage(this.image);
                wIcon.setLayoutData((Object)new FormDataBuilder().top().right(100, 0).result());
                this.textWidget.setLayoutData((Object)new FormDataBuilder().top(new FormAttachment((Control)wIcon, 0, 0)).left().right(100, 0).bottom(100, 0).result());
            } else {
                Label controlDecoration = new Label((Composite)this, 0);
                controlDecoration.setImage(this.image);
                controlDecoration.setToolTipText(BaseMessages.getString(PKG, (String)"StyledTextComp.tooltip.InsertVariable", (String[])new String[0]));
                PropsUi.setLook((Widget)controlDecoration);
                controlDecoration.setLayoutData((Object)new FormDataBuilder().top().right(100, 0).result());
                this.textWidget.setLayoutData((Object)new FormDataBuilder().top().left().right(new FormAttachment((Control)controlDecoration, 0, 0)).bottom(100, 0).result());
            }
        }
    }

    public String getSelectionText() {
        return this.textWidget.getSelectionText();
    }

    public String getText() {
        return this.textWidget.getText();
    }

    public void setText(String text) {
        this.textWidget.setText(text);
    }

    public void insert(String strInsert) {
        this.textWidget.insert(strInsert);
    }

    public void addListener(int eventType, Listener listener) {
        this.textWidget.addListener(eventType, listener);
    }

    public void addModifyListener(ModifyListener lsMod) {
        this.textWidget.addModifyListener(lsMod);
    }

    public void addKeyListener(KeyAdapter keyAdapter) {
        this.textWidget.addKeyListener((KeyListener)keyAdapter);
    }

    public void addFocusListener(FocusAdapter focusAdapter) {
        this.textWidget.addFocusListener((FocusListener)focusAdapter);
    }

    public void addMouseListener(MouseAdapter mouseAdapter) {
        this.textWidget.addMouseListener((MouseListener)mouseAdapter);
    }

    public int getSelectionCount() {
        return this.textWidget.getSelectionCount();
    }

    public void setSelection(int arg0) {
        this.textWidget.setSelection(arg0);
    }

    public void setSelection(int arg0, int arg1) {
        this.textWidget.setSelection(arg0, arg1);
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        this.textWidget.setBackground(color);
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        this.textWidget.setForeground(color);
    }

    public void setFont(Font fnt) {
        this.textWidget.setFont(fnt);
    }

    private void buildingStyledTextMenu() {
        MenuItem cutItem = new MenuItem(this.styledTextPopupmenu, 8);
        cutItem.setText(OsHelper.customizeMenuitemText(BaseMessages.getString(PKG, (String)"WidgetDialog.Styled.Cut", (String[])new String[0])));
        cutItem.setImage(GuiResource.getInstance().getImage("ui/images/cut.svg", 16, 16));
        cutItem.addListener(13, e -> this.textWidget.cut());
        MenuItem copyItem = new MenuItem(this.styledTextPopupmenu, 8);
        copyItem.setText(OsHelper.customizeMenuitemText(BaseMessages.getString(PKG, (String)"WidgetDialog.Styled.Copy", (String[])new String[0])));
        copyItem.setImage(GuiResource.getInstance().getImage("ui/images/copy.svg", 16, 16));
        copyItem.addListener(13, e -> this.textWidget.copy());
        MenuItem pasteItem = new MenuItem(this.styledTextPopupmenu, 8);
        pasteItem.setText(OsHelper.customizeMenuitemText(BaseMessages.getString(PKG, (String)"WidgetDialog.Styled.Paste", (String[])new String[0])));
        pasteItem.setImage(GuiResource.getInstance().getImage("ui/images/paste.svg", 16, 16));
        pasteItem.addListener(13, e -> this.textWidget.paste());
        new MenuItem(this.styledTextPopupmenu, 2);
        MenuItem selectAllItem = new MenuItem(this.styledTextPopupmenu, 8);
        selectAllItem.setText(OsHelper.customizeMenuitemText(BaseMessages.getString(PKG, (String)"WidgetDialog.Styled.SelectAll", (String[])new String[0])));
        selectAllItem.setImage(GuiResource.getInstance().getImage("ui/images/select-all.svg", 16, 16));
        selectAllItem.addListener(13, e -> this.textWidget.selectAll());
        this.textWidget.addMenuDetectListener(e -> {
            pasteItem.setEnabled(this.checkPaste());
            if (this.textWidget.getSelectionCount() > 0) {
                cutItem.setEnabled(true);
                copyItem.setEnabled(true);
            } else {
                cutItem.setEnabled(false);
                copyItem.setEnabled(false);
            }
        });
        this.textWidget.setMenu(this.styledTextPopupmenu);
    }

    private boolean checkPaste() {
        try {
            Clipboard clipboard = new Clipboard(this.xParent.getDisplay());
            TextTransfer transfer = TextTransfer.getInstance();
            String text = (String)clipboard.getContents((Transfer)transfer);
            return text != null && text.length() > 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    public Image getImage() {
        return this.image;
    }

    public Text getTextWidget() {
        return this.textWidget;
    }

    public boolean isEditable() {
        return this.textWidget.getEditable();
    }

    public void setEditable(boolean canEdit) {
        this.textWidget.setEditable(canEdit);
    }

    public void setEnabled(boolean enabled) {
        this.textWidget.setEnabled(enabled);
        if (Display.getDefault() != null) {
            Color foreground = Display.getDefault().getSystemColor(enabled ? 2 : 16);
            Color background = Display.getDefault().getSystemColor(enabled ? 1 : 22);
            GuiResource guiResource = GuiResource.getInstance();
            this.textWidget.setForeground(guiResource.getColor(foreground.getRed(), foreground.getGreen(), foreground.getBlue()));
            this.textWidget.setBackground(guiResource.getColor(background.getRed(), background.getGreen(), background.getBlue()));
        }
    }

    public int getLineNumber() {
        String text = this.textWidget.getText();
        if (StringUtils.isEmpty((String)text)) {
            return 1;
        }
        int rowNumber = 1;
        for (int textPosition = this.textWidget.getCaretPosition(); textPosition > 0; --textPosition) {
            if (text.charAt(textPosition - 1) != '\n') continue;
            ++rowNumber;
        }
        return rowNumber;
    }

    public int getColumnNumber() {
        String text = this.textWidget.getText();
        if (StringUtils.isEmpty((String)text)) {
            return 1;
        }
        int columnNumber = 1;
        int textPosition = this.textWidget.getCaretPosition();
        while (textPosition > 0 && text.charAt(textPosition - 1) != '\n' && text.charAt(textPosition - 1) != '\r') {
            --textPosition;
            ++columnNumber;
        }
        return columnNumber;
    }

    public int getCaretPosition() {
        return this.textWidget.getCaretPosition();
    }
}

