/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.actions.repeat;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.config.PipelineRunConfiguration;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.MessageBox;
import org.apache.hop.ui.core.metadata.MetadataManager;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.ComboVar;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.hopgui.file.pipeline.HopPipelineFileType;
import org.apache.hop.ui.hopgui.file.workflow.HopWorkflowFileType;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.apache.hop.ui.workflow.action.ActionDialog;
import org.apache.hop.ui.workflow.dialog.WorkflowDialog;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.IAction;
import org.apache.hop.workflow.actions.repeat.ParameterDetails;
import org.apache.hop.workflow.actions.repeat.Repeat;
import org.apache.hop.workflow.config.WorkflowRunConfiguration;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class RepeatDialog
extends ActionDialog {
    private static final Class<?> PKG = RepeatDialog.class;
    private static final String COLON_SEPARATOR = " : ";
    private Repeat action;
    private Text wName;
    private TextVar wFilename;
    private TextVar wVariableName;
    private TextVar wVariableValue;
    private TextVar wDelay;
    private Button wKeepValues;
    private TableView wParameters;
    private Button wLogFileEnabled;
    private Label wlLogFileBase;
    private TextVar wLogFileBase;
    private Label wlLogFileExtension;
    private TextVar wLogFileExtension;
    private Label wlLogFileDateAdded;
    private Button wLogFileDateAdded;
    private Label wlLogFileTimeAdded;
    private Button wLogFileTimeAdded;
    private Label wlLogFileRepetitionAdded;
    private Button wLogFileRepetitionAdded;
    private Label wlLogFileAppended;
    private Button wLogFileAppended;
    private Label wlLogFileUpdateInterval;
    private TextVar wLogFileUpdateInterval;
    private ComboVar wRunConfiguration;

    public RepeatDialog(Shell parent, Repeat action, WorkflowMeta workflowMeta, IVariables variables) {
        super(parent, workflowMeta, variables);
        this.action = action;
        if (this.action.getName() == null) {
            this.action.setName(BaseMessages.getString(PKG, (String)"Repeat.Name", (String[])new String[0]));
        }
    }

    public IAction open() {
        this.shell = new Shell(this.getParent(), 3312);
        PropsUi.setLook((Widget)this.shell);
        WorkflowDialog.setShellImage((Shell)this.shell, (IAction)this.action);
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"Repeat.Name", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = PropsUi.getMargin();
        Label wlName = new Label((Composite)this.shell, 131072);
        wlName.setText("Action name");
        PropsUi.setLook((Widget)wlName);
        FormData fdlName = new FormData();
        fdlName.left = new FormAttachment(0, 0);
        fdlName.right = new FormAttachment(middle, -margin);
        fdlName.top = new FormAttachment(0, margin);
        wlName.setLayoutData((Object)fdlName);
        this.wName = new Text((Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wName);
        FormData fdName = new FormData();
        fdName.left = new FormAttachment(middle, 0);
        fdName.top = new FormAttachment(0, margin);
        fdName.right = new FormAttachment(100, 0);
        this.wName.setLayoutData((Object)fdName);
        Text lastControl = this.wName;
        Label wlFilename = new Label((Composite)this.shell, 131072);
        wlFilename.setText(BaseMessages.getString(PKG, (String)"Repeat.FileToRepeat.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlFilename);
        FormData fdlFilename = new FormData();
        fdlFilename.left = new FormAttachment(0, 0);
        fdlFilename.right = new FormAttachment(middle, -margin);
        fdlFilename.top = new FormAttachment((Control)lastControl, margin);
        wlFilename.setLayoutData((Object)fdlFilename);
        Button wbbFilename = new Button((Composite)this.shell, 0x1000008);
        PropsUi.setLook((Widget)wbbFilename);
        wbbFilename.setText(BaseMessages.getString(PKG, (String)"System.Button.Browse", (String[])new String[0]));
        wbbFilename.setToolTipText(BaseMessages.getString(PKG, (String)"System.Tooltip.BrowseForFileOrDirAndAdd", (String[])new String[0]));
        FormData fdbFilename = new FormData();
        fdbFilename.top = new FormAttachment((Control)wlFilename, 0, 0x1000000);
        fdbFilename.right = new FormAttachment(100, 0);
        wbbFilename.setLayoutData((Object)fdbFilename);
        wbbFilename.addListener(13, e -> this.browseForFile());
        this.wFilename = new TextVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wFilename);
        FormData fdFilename = new FormData();
        fdFilename.left = new FormAttachment(middle, 0);
        fdFilename.right = new FormAttachment((Control)wbbFilename, -margin);
        fdFilename.top = new FormAttachment((Control)wlFilename, 0, 0x1000000);
        this.wFilename.setLayoutData((Object)fdFilename);
        lastControl = this.wFilename;
        Label wlRunConfiguration = new Label((Composite)this.shell, 131072);
        wlRunConfiguration.setText(BaseMessages.getString(PKG, (String)"Repeat.RunConfiguration.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlRunConfiguration);
        FormData fdlRunConfiguration = new FormData();
        fdlRunConfiguration.left = new FormAttachment(0, 0);
        fdlRunConfiguration.top = new FormAttachment((Control)lastControl, Const.isOSX() ? 0 : 5);
        fdlRunConfiguration.right = new FormAttachment(middle, -margin);
        wlRunConfiguration.setLayoutData((Object)fdlRunConfiguration);
        this.wRunConfiguration = new ComboVar(this.variables, (Composite)this.shell, 18432);
        PropsUi.setLook((Widget)this.wRunConfiguration);
        FormData fdRunConfiguration = new FormData();
        fdRunConfiguration.left = new FormAttachment(middle, 0);
        fdRunConfiguration.top = new FormAttachment((Control)wlRunConfiguration, 0, 0x1000000);
        fdRunConfiguration.right = new FormAttachment(100, 0);
        this.wRunConfiguration.setLayoutData((Object)fdRunConfiguration);
        lastControl = this.wRunConfiguration;
        Label wlVariableName = new Label((Composite)this.shell, 131072);
        wlVariableName.setText(BaseMessages.getString(PKG, (String)"Repeat.StopRepeatingVar.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlVariableName);
        FormData fdlVariableName = new FormData();
        fdlVariableName.left = new FormAttachment(0, 0);
        fdlVariableName.right = new FormAttachment(middle, 0);
        fdlVariableName.top = new FormAttachment((Control)lastControl, margin);
        wlVariableName.setLayoutData((Object)fdlVariableName);
        this.wVariableName = new TextVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wVariableName);
        FormData fdVariableName = new FormData();
        fdVariableName.left = new FormAttachment(middle, 0);
        fdVariableName.right = new FormAttachment(100, 0);
        fdVariableName.top = new FormAttachment((Control)wlVariableName, 0, 0x1000000);
        this.wVariableName.setLayoutData((Object)fdVariableName);
        lastControl = this.wVariableName;
        Label wlVariableValue = new Label((Composite)this.shell, 131072);
        wlVariableValue.setText(BaseMessages.getString(PKG, (String)"Repeat.OptionalVarValue.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlVariableValue);
        FormData fdlVariableValue = new FormData();
        fdlVariableValue.left = new FormAttachment(0, 0);
        fdlVariableValue.right = new FormAttachment(middle, -margin);
        fdlVariableValue.top = new FormAttachment((Control)lastControl, margin);
        wlVariableValue.setLayoutData((Object)fdlVariableValue);
        this.wVariableValue = new TextVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wVariableValue);
        FormData fdVariableValue = new FormData();
        fdVariableValue.left = new FormAttachment(middle, 0);
        fdVariableValue.right = new FormAttachment(100, 0);
        fdVariableValue.top = new FormAttachment((Control)wlVariableValue, 0, 0x1000000);
        this.wVariableValue.setLayoutData((Object)fdVariableValue);
        lastControl = this.wVariableValue;
        Label wlDelay = new Label((Composite)this.shell, 131072);
        wlDelay.setText(BaseMessages.getString(PKG, (String)"Repeat.Delay.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlDelay);
        FormData fdlDelay = new FormData();
        fdlDelay.left = new FormAttachment(0, 0);
        fdlDelay.right = new FormAttachment(middle, -margin);
        fdlDelay.top = new FormAttachment((Control)lastControl, margin);
        wlDelay.setLayoutData((Object)fdlDelay);
        this.wDelay = new TextVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wDelay);
        FormData fdDelay = new FormData();
        fdDelay.left = new FormAttachment(middle, 0);
        fdDelay.right = new FormAttachment(100, 0);
        fdDelay.top = new FormAttachment((Control)wlDelay, 0, 0x1000000);
        this.wDelay.setLayoutData((Object)fdDelay);
        lastControl = this.wDelay;
        Label wlKeepValues = new Label((Composite)this.shell, 131072);
        wlKeepValues.setText(BaseMessages.getString(PKG, (String)"Repeat.KeepVariableValues.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlKeepValues);
        FormData fdlKeepValues = new FormData();
        fdlKeepValues.left = new FormAttachment(0, 0);
        fdlKeepValues.right = new FormAttachment(middle, -margin);
        fdlKeepValues.top = new FormAttachment((Control)lastControl, margin);
        wlKeepValues.setLayoutData((Object)fdlKeepValues);
        this.wKeepValues = new Button((Composite)this.shell, 16416);
        PropsUi.setLook((Widget)this.wKeepValues);
        FormData fdKeepValues = new FormData();
        fdKeepValues.left = new FormAttachment(middle, 0);
        fdKeepValues.right = new FormAttachment(100, 0);
        fdKeepValues.top = new FormAttachment((Control)wlKeepValues, 0, 0x1000000);
        this.wKeepValues.setLayoutData((Object)fdKeepValues);
        lastControl = wlKeepValues;
        Group wLogFileGroup = new Group((Composite)this.shell, 32);
        PropsUi.setLook((Widget)wLogFileGroup);
        wLogFileGroup.setText(BaseMessages.getString(PKG, (String)"Repeat.LoggingFileGroup.Label", (String[])new String[0]));
        FormLayout logFileGroupLayout = new FormLayout();
        logFileGroupLayout.marginLeft = PropsUi.getMargin();
        logFileGroupLayout.marginRight = PropsUi.getMargin();
        logFileGroupLayout.marginTop = 2 * PropsUi.getMargin();
        logFileGroupLayout.marginBottom = 2 * PropsUi.getMargin();
        wLogFileGroup.setLayout((Layout)logFileGroupLayout);
        Label wlLogFileEnabled = new Label((Composite)wLogFileGroup, 131072);
        wlLogFileEnabled.setText(BaseMessages.getString(PKG, (String)"Repeat.LogToFile.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlLogFileEnabled);
        FormData fdlLogFileEnabled = new FormData();
        fdlLogFileEnabled.left = new FormAttachment(0, 0);
        fdlLogFileEnabled.right = new FormAttachment(middle, -margin);
        fdlLogFileEnabled.top = new FormAttachment(0, 0);
        wlLogFileEnabled.setLayoutData((Object)fdlLogFileEnabled);
        this.wLogFileEnabled = new Button((Composite)wLogFileGroup, 16416);
        PropsUi.setLook((Widget)this.wLogFileEnabled);
        FormData fdLogFileEnabled = new FormData();
        fdLogFileEnabled.left = new FormAttachment(middle, 0);
        fdLogFileEnabled.right = new FormAttachment(100, 0);
        fdLogFileEnabled.top = new FormAttachment((Control)wlLogFileEnabled, 0, 0x1000000);
        this.wLogFileEnabled.setLayoutData((Object)fdLogFileEnabled);
        this.wLogFileEnabled.addListener(13, e -> this.enableControls());
        Label lastLogControl = wlLogFileEnabled;
        this.wlLogFileBase = new Label((Composite)wLogFileGroup, 131072);
        this.wlLogFileBase.setText(BaseMessages.getString(PKG, (String)"Repeat.BaseLogFilename.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlLogFileBase);
        FormData fdlLogFileBase = new FormData();
        fdlLogFileBase.left = new FormAttachment(0, 0);
        fdlLogFileBase.right = new FormAttachment(middle, -margin);
        fdlLogFileBase.top = new FormAttachment((Control)lastLogControl, margin);
        this.wlLogFileBase.setLayoutData((Object)fdlLogFileBase);
        this.wLogFileBase = new TextVar(this.variables, (Composite)wLogFileGroup, 18436);
        PropsUi.setLook((Widget)this.wLogFileBase);
        FormData fdLogFileBase = new FormData();
        fdLogFileBase.left = new FormAttachment(middle, 0);
        fdLogFileBase.right = new FormAttachment(100, 0);
        fdLogFileBase.top = new FormAttachment((Control)this.wlLogFileBase, 0, 0x1000000);
        this.wLogFileBase.setLayoutData((Object)fdLogFileBase);
        lastLogControl = this.wLogFileBase;
        this.wlLogFileExtension = new Label((Composite)wLogFileGroup, 131072);
        this.wlLogFileExtension.setText(BaseMessages.getString(PKG, (String)"Repeat.LogFilenameExt.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlLogFileExtension);
        FormData fdlLogFileExtension = new FormData();
        fdlLogFileExtension.left = new FormAttachment(0, 0);
        fdlLogFileExtension.right = new FormAttachment(middle, -margin);
        fdlLogFileExtension.top = new FormAttachment((Control)lastLogControl, margin);
        this.wlLogFileExtension.setLayoutData((Object)fdlLogFileExtension);
        this.wLogFileExtension = new TextVar(this.variables, (Composite)wLogFileGroup, 18436);
        PropsUi.setLook((Widget)this.wLogFileExtension);
        FormData fdLogFileExtension = new FormData();
        fdLogFileExtension.left = new FormAttachment(middle, 0);
        fdLogFileExtension.right = new FormAttachment(100, 0);
        fdLogFileExtension.top = new FormAttachment((Control)this.wlLogFileExtension, 0, 0x1000000);
        this.wLogFileExtension.setLayoutData((Object)fdLogFileExtension);
        lastLogControl = this.wLogFileExtension;
        this.wlLogFileDateAdded = new Label((Composite)wLogFileGroup, 131072);
        this.wlLogFileDateAdded.setText(BaseMessages.getString(PKG, (String)"Repeat.AddDateToFilename.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlLogFileDateAdded);
        FormData fdlLogFileDateAdded = new FormData();
        fdlLogFileDateAdded.left = new FormAttachment(0, 0);
        fdlLogFileDateAdded.right = new FormAttachment(middle, -margin);
        fdlLogFileDateAdded.top = new FormAttachment((Control)lastLogControl, margin);
        this.wlLogFileDateAdded.setLayoutData((Object)fdlLogFileDateAdded);
        this.wLogFileDateAdded = new Button((Composite)wLogFileGroup, 16416);
        PropsUi.setLook((Widget)this.wLogFileDateAdded);
        FormData fdLogFileDateAdded = new FormData();
        fdLogFileDateAdded.left = new FormAttachment(middle, 0);
        fdLogFileDateAdded.right = new FormAttachment(100, 0);
        fdLogFileDateAdded.top = new FormAttachment((Control)this.wlLogFileDateAdded, 0, 0x1000000);
        this.wLogFileDateAdded.setLayoutData((Object)fdLogFileDateAdded);
        lastLogControl = this.wlLogFileDateAdded;
        this.wlLogFileTimeAdded = new Label((Composite)wLogFileGroup, 131072);
        this.wlLogFileTimeAdded.setText(BaseMessages.getString(PKG, (String)"Repeat.AddTimeToFilename.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlLogFileTimeAdded);
        FormData fdlLogFileTimeAdded = new FormData();
        fdlLogFileTimeAdded.left = new FormAttachment(0, 0);
        fdlLogFileTimeAdded.right = new FormAttachment(middle, -margin);
        fdlLogFileTimeAdded.top = new FormAttachment((Control)lastLogControl, margin);
        this.wlLogFileTimeAdded.setLayoutData((Object)fdlLogFileTimeAdded);
        this.wLogFileTimeAdded = new Button((Composite)wLogFileGroup, 16416);
        PropsUi.setLook((Widget)this.wLogFileTimeAdded);
        FormData fdLogFileTimeAdded = new FormData();
        fdLogFileTimeAdded.left = new FormAttachment(middle, 0);
        fdLogFileTimeAdded.right = new FormAttachment(100, 0);
        fdLogFileTimeAdded.top = new FormAttachment((Control)this.wlLogFileTimeAdded, 0, 0x1000000);
        this.wLogFileTimeAdded.setLayoutData((Object)fdLogFileTimeAdded);
        lastLogControl = this.wlLogFileTimeAdded;
        this.wlLogFileRepetitionAdded = new Label((Composite)wLogFileGroup, 131072);
        this.wlLogFileRepetitionAdded.setText(BaseMessages.getString(PKG, (String)"Repeat.AddReptNumToFilename.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlLogFileRepetitionAdded);
        FormData fdlLogFileRepetitionAdded = new FormData();
        fdlLogFileRepetitionAdded.left = new FormAttachment(0, 0);
        fdlLogFileRepetitionAdded.right = new FormAttachment(middle, -margin);
        fdlLogFileRepetitionAdded.top = new FormAttachment((Control)lastLogControl, margin);
        this.wlLogFileRepetitionAdded.setLayoutData((Object)fdlLogFileRepetitionAdded);
        this.wLogFileRepetitionAdded = new Button((Composite)wLogFileGroup, 16416);
        PropsUi.setLook((Widget)this.wLogFileRepetitionAdded);
        FormData fdLogFileRepetitionAdded = new FormData();
        fdLogFileRepetitionAdded.left = new FormAttachment(middle, 0);
        fdLogFileRepetitionAdded.right = new FormAttachment(100, 0);
        fdLogFileRepetitionAdded.top = new FormAttachment((Control)this.wlLogFileRepetitionAdded, 0, 0x1000000);
        this.wLogFileRepetitionAdded.setLayoutData((Object)fdLogFileRepetitionAdded);
        lastLogControl = this.wlLogFileRepetitionAdded;
        this.wlLogFileAppended = new Label((Composite)wLogFileGroup, 131072);
        this.wlLogFileAppended.setText(BaseMessages.getString(PKG, (String)"Repeat.AppendToExistingFile.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlLogFileAppended);
        FormData fdlLogFileAppended = new FormData();
        fdlLogFileAppended.left = new FormAttachment(0, 0);
        fdlLogFileAppended.right = new FormAttachment(middle, -margin);
        fdlLogFileAppended.top = new FormAttachment((Control)lastLogControl, margin);
        this.wlLogFileAppended.setLayoutData((Object)fdlLogFileAppended);
        this.wLogFileAppended = new Button((Composite)wLogFileGroup, 16416);
        PropsUi.setLook((Widget)this.wLogFileAppended);
        FormData fdLogFileAppended = new FormData();
        fdLogFileAppended.left = new FormAttachment(middle, 0);
        fdLogFileAppended.right = new FormAttachment(100, 0);
        fdLogFileAppended.top = new FormAttachment((Control)this.wlLogFileAppended, 0, 0x1000000);
        this.wLogFileAppended.setLayoutData((Object)fdLogFileAppended);
        lastLogControl = this.wlLogFileAppended;
        this.wlLogFileUpdateInterval = new Label((Composite)wLogFileGroup, 131072);
        this.wlLogFileUpdateInterval.setText(BaseMessages.getString(PKG, (String)"Repeat.LogFileUpdateInterval.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlLogFileUpdateInterval);
        FormData fdlLogFileUpdateInterval = new FormData();
        fdlLogFileUpdateInterval.left = new FormAttachment(0, 0);
        fdlLogFileUpdateInterval.right = new FormAttachment(middle, -margin);
        fdlLogFileUpdateInterval.top = new FormAttachment((Control)lastLogControl, margin);
        this.wlLogFileUpdateInterval.setLayoutData((Object)fdlLogFileUpdateInterval);
        this.wLogFileUpdateInterval = new TextVar(this.variables, (Composite)wLogFileGroup, 18436);
        PropsUi.setLook((Widget)this.wLogFileUpdateInterval);
        FormData fdLogFileUpdateInterval = new FormData();
        fdLogFileUpdateInterval.left = new FormAttachment(middle, 0);
        fdLogFileUpdateInterval.right = new FormAttachment(100, 0);
        fdLogFileUpdateInterval.top = new FormAttachment((Control)this.wlLogFileUpdateInterval, 0, 0x1000000);
        this.wLogFileUpdateInterval.setLayoutData((Object)fdLogFileUpdateInterval);
        FormData fdLogFileGroup = new FormData();
        fdLogFileGroup.left = new FormAttachment(0, 0);
        fdLogFileGroup.right = new FormAttachment(100, 0);
        fdLogFileGroup.top = new FormAttachment((Control)lastControl, 2 * margin);
        wLogFileGroup.setLayoutData((Object)fdLogFileGroup);
        wLogFileGroup.pack();
        lastControl = wLogFileGroup;
        Label wlParameters = new Label((Composite)this.shell, 16384);
        wlParameters.setText(BaseMessages.getString(PKG, (String)"Repeat.ParmsVarGroup.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlParameters);
        FormData fdlParameters = new FormData();
        fdlParameters.left = new FormAttachment(0, 0);
        fdlParameters.top = new FormAttachment((Control)lastControl, 2 * margin);
        fdlParameters.right = new FormAttachment(100, 0);
        wlParameters.setLayoutData((Object)fdlParameters);
        lastControl = wlParameters;
        Button wOK = new Button((Composite)this.shell, 8);
        wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        wOK.addListener(13, e -> this.ok());
        Button wCancel = new Button((Composite)this.shell, 8);
        wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        wCancel.addListener(13, e -> this.cancel());
        BaseTransformDialog.positionBottomButtons((Composite)this.shell, (Button[])new Button[]{wOK, wCancel}, (int)margin, null);
        ColumnInfo[] columnInfos = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"Repeat.ParmsVarGroup.Name.Column.Header", (String[])new String[0]), 1, false, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"Repeat.ParmsVarGroup.Value.Column.Header", (String[])new String[0]), 1, false, false)};
        columnInfos[1].setUsingVariables(true);
        this.wParameters = new TableView(this.variables, (Composite)this.shell, 2048, columnInfos, this.action.getParameters().size(), null, this.props);
        PropsUi.setLook((Widget)this.wParameters);
        FormData fdParameters = new FormData();
        fdParameters.left = new FormAttachment(0, 0);
        fdParameters.right = new FormAttachment(100, 0);
        fdParameters.top = new FormAttachment((Control)lastControl, margin);
        fdParameters.bottom = new FormAttachment((Control)wOK, -margin * 2);
        this.wParameters.setLayoutData((Object)fdParameters);
        this.getData();
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.action;
    }

    private void browseForFile() {
        HopPipelineFileType pipelineFileType = new HopPipelineFileType();
        HopWorkflowFileType workflowFileType = new HopWorkflowFileType();
        ArrayList<Object> filterExtensions = new ArrayList<Object>();
        filterExtensions.add(pipelineFileType.getFilterExtensions()[0] + ";" + workflowFileType.getFilterExtensions()[0]);
        filterExtensions.addAll(Arrays.asList(pipelineFileType.getFilterExtensions()));
        filterExtensions.addAll(Arrays.asList(workflowFileType.getFilterExtensions()));
        filterExtensions.add("*.*");
        ArrayList<Object> filterNames = new ArrayList<Object>();
        filterNames.add(pipelineFileType.getFilterNames()[0] + " and " + workflowFileType.getFilterNames()[0]);
        filterNames.addAll(Arrays.asList(pipelineFileType.getFilterNames()));
        filterNames.addAll(Arrays.asList(workflowFileType.getFilterNames()));
        filterNames.add(BaseMessages.getString(PKG, (String)"System.FileType.AllFiles", (String[])new String[0]));
        BaseDialog.presentFileDialog((Shell)this.shell, (TextVar)this.wFilename, (IVariables)this.variables, (String[])filterExtensions.toArray(new String[0]), (String[])filterNames.toArray(new String[0]), (boolean)true);
    }

    private void enableControls() {
        boolean logEnabled = this.wLogFileEnabled.getSelection();
        this.wlLogFileBase.setEnabled(logEnabled);
        this.wLogFileBase.setEnabled(logEnabled);
        this.wlLogFileExtension.setEnabled(logEnabled);
        this.wLogFileExtension.setEnabled(logEnabled);
        this.wlLogFileDateAdded.setEnabled(logEnabled);
        this.wLogFileDateAdded.setEnabled(logEnabled);
        this.wlLogFileTimeAdded.setEnabled(logEnabled);
        this.wLogFileTimeAdded.setEnabled(logEnabled);
        this.wlLogFileRepetitionAdded.setEnabled(logEnabled);
        this.wLogFileRepetitionAdded.setEnabled(logEnabled);
        this.wlLogFileAppended.setEnabled(logEnabled);
        this.wLogFileAppended.setEnabled(logEnabled);
        this.wlLogFileUpdateInterval.setEnabled(logEnabled);
        this.wLogFileUpdateInterval.setEnabled(logEnabled);
    }

    private void cancel() {
        this.action = null;
        this.dispose();
    }

    private void getData() {
        this.wName.setText(Const.NVL((String)this.action.getName(), (String)""));
        this.wFilename.setText(Const.NVL((String)this.action.getFilename(), (String)""));
        this.wVariableName.setText(Const.NVL((String)this.action.getVariableName(), (String)""));
        this.wVariableValue.setText(Const.NVL((String)this.action.getVariableValue(), (String)""));
        this.wDelay.setText(Const.NVL((String)this.action.getDelay(), (String)""));
        this.wKeepValues.setSelection(this.action.isKeepingValues());
        this.wLogFileEnabled.setSelection(this.action.isLogFileEnabled());
        this.wLogFileBase.setText(Const.NVL((String)this.action.getLogFileBase(), (String)""));
        this.wLogFileExtension.setText(Const.NVL((String)this.action.getLogFileExtension(), (String)""));
        this.wLogFileDateAdded.setSelection(this.action.isLogFileDateAdded());
        this.wLogFileTimeAdded.setSelection(this.action.isLogFileTimeAdded());
        this.wLogFileRepetitionAdded.setSelection(this.action.isLogFileRepetitionAdded());
        this.wLogFileAppended.setSelection(this.action.isLogFileAppended());
        this.wLogFileUpdateInterval.setText(Const.NVL((String)this.action.getLogFileUpdateInterval(), (String)"5000"));
        int rowNr = 0;
        for (ParameterDetails parameter : this.action.getParameters()) {
            TableItem item = this.wParameters.table.getItem(rowNr++);
            item.setText(1, Const.NVL((String)parameter.getName(), (String)""));
            item.setText(2, Const.NVL((String)parameter.getField(), (String)""));
        }
        this.wParameters.setRowNums();
        this.wParameters.optWidth(true);
        MetadataManager prcManager = new MetadataManager(this.variables, this.getMetadataProvider(), PipelineRunConfiguration.class, this.shell);
        MetadataManager wrcManager = new MetadataManager(this.variables, this.getMetadataProvider(), WorkflowRunConfiguration.class, this.shell);
        ArrayList entries = new ArrayList();
        try {
            prcManager.getNames().forEach(name -> entries.add("Pipeline : " + name));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            wrcManager.getNames().forEach(name -> entries.add("Workflow : " + name));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.wRunConfiguration.setItems(entries.toArray(new String[0]));
        if (StringUtils.isNotEmpty((String)this.action.getRunConfigurationName())) {
            String realFilename = this.variables.resolve(this.wFilename.getText());
            try {
                if (this.action.isPipeline(realFilename)) {
                    this.wRunConfiguration.setText("Pipeline : " + this.action.getRunConfigurationName());
                } else if (this.action.isWorkflow(realFilename)) {
                    this.wRunConfiguration.setText("Workflow : " + this.action.getRunConfigurationName());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.wName.selectAll();
        this.wName.setFocus();
        this.enableControls();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wName.getText())) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setText(BaseMessages.getString(PKG, (String)"Repeat.Dialog.ActionMissing.Header", (String[])new String[0]));
            mb.setMessage(BaseMessages.getString(PKG, (String)"Repeat.Dialog.ActionMissing.Message", (String[])new String[0]));
            mb.open();
            return;
        }
        this.action.setName(this.wName.getText());
        if (Utils.isEmpty((CharSequence)this.wFilename.getText())) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setText(BaseMessages.getString(PKG, (String)"Repeat.Dialog.FilenameMissing.Header", (String[])new String[0]));
            mb.setMessage(BaseMessages.getString(PKG, (String)"Repeat.Dialog.FilenameMissing.Message", (String[])new String[0]));
            mb.open();
            return;
        }
        if (this.isSelfReferencing()) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setText(BaseMessages.getString(PKG, (String)"Repeat.Dialog.SelfReference.Header", (String[])new String[0]));
            mb.setMessage(BaseMessages.getString(PKG, (String)"Repeat.Dialog.SelfReference.Message", (String[])new String[0]));
            mb.open();
            return;
        }
        this.action.setFilename(this.wFilename.getText());
        this.action.setVariableName(this.wVariableName.getText());
        this.action.setVariableValue(this.wVariableValue.getText());
        this.action.setDelay(this.wDelay.getText());
        this.action.setKeepingValues(this.wKeepValues.getSelection());
        this.action.setLogFileEnabled(this.wLogFileEnabled.getSelection());
        this.action.setLogFileAppended(this.wLogFileAppended.getSelection());
        this.action.setLogFileBase(this.wLogFileBase.getText());
        this.action.setLogFileExtension(this.wLogFileExtension.getText());
        this.action.setLogFileDateAdded(this.wLogFileDateAdded.getSelection());
        this.action.setLogFileTimeAdded(this.wLogFileTimeAdded.getSelection());
        this.action.setLogFileRepetitionAdded(this.wLogFileRepetitionAdded.getSelection());
        this.action.setLogFileUpdateInterval(this.wLogFileUpdateInterval.getText());
        this.action.getParameters().clear();
        for (int i = 0; i < this.wParameters.nrNonEmpty(); ++i) {
            TableItem item = this.wParameters.getNonEmpty(i);
            this.action.getParameters().add(new ParameterDetails(item.getText(1), item.getText(2)));
        }
        String runConfigRaw = this.wRunConfiguration.getText();
        if (StringUtils.isEmpty((String)runConfigRaw)) {
            this.action.setRunConfigurationName(null);
        } else {
            int colonIndex = runConfigRaw.indexOf(COLON_SEPARATOR);
            if (colonIndex > 0 && colonIndex + COLON_SEPARATOR.length() < runConfigRaw.length()) {
                this.action.setRunConfigurationName(runConfigRaw.substring(colonIndex + COLON_SEPARATOR.length()));
            } else {
                this.action.setRunConfigurationName(runConfigRaw);
            }
        }
        this.action.setChanged();
        this.dispose();
    }

    private boolean isSelfReferencing() {
        return this.variables.resolve(this.wFilename.getText()).equals(this.variables.resolve(this.workflowMeta.getFilename()));
    }
}

