/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.databases.mysql;

import com.google.common.collect.Sets;
import java.sql.DatabaseMetaData;
import java.sql.ResultSetMetaData;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.hop.core.Const;
import org.apache.hop.core.database.BaseDatabaseMeta;
import org.apache.hop.core.database.DatabaseMetaPlugin;
import org.apache.hop.core.database.IDatabase;
import org.apache.hop.core.exception.HopDatabaseException;
import org.apache.hop.core.gui.plugin.GuiElementType;
import org.apache.hop.core.gui.plugin.GuiPlugin;
import org.apache.hop.core.gui.plugin.GuiWidgetElement;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;

@DatabaseMetaPlugin(type="MYSQL", typeDescription="MySQL", documentationUrl="/database/databases/mysql.html")
@GuiPlugin(id="GUI-MySQLDatabaseMeta")
public class MySqlDatabaseMeta
extends BaseDatabaseMeta
implements IDatabase {
    private static final Class<?> PKG = MySqlDatabaseMeta.class;
    public static final String CONST_MYSQL_8 = "Mysql 8+";
    @GuiWidgetElement(id="resultStreaming", order="10", parentId="DatabaseMeta-PluginSpecific-Options", type=GuiElementType.CHECKBOX, label="i18n:org.apache.hop.ui.core.database:DatabaseDialog.label.MySQLStreamResults")
    private boolean resultStreaming;
    @GuiWidgetElement(id="mySqlDriverClass", order="20", parentId="DatabaseMeta-PluginSpecific-Options", type=GuiElementType.COMBO, variables=false, comboValuesMethod="getDriverClassNames", label="i18n::MySQLDatabaseMeta.label.MySQLDriverType")
    @HopMetadataProperty(key="driverClassName")
    private String driverClassName = "Mysql 8+";
    private static final int VARCHAR_LIMIT = 65535;
    private static final Set<String> SHORT_MESSAGE_EXCEPTIONS = Sets.newHashSet((Object[])new String[]{"com.mysql.jdbc.PacketTooBigException", "com.mysql.jdbc.MysqlDataTruncation"});

    public boolean isResultStreaming() {
        String streaming = this.getAttributeProperty("STREAM_RESULTS");
        return "Y".equalsIgnoreCase(streaming);
    }

    public void setResultStreaming(boolean resultStreaming) {
        this.getAttributes().put("STREAM_RESULTS", resultStreaming ? "Y" : "N");
    }

    public int[] getAccessTypeList() {
        return new int[]{0};
    }

    public int getDefaultDatabasePort() {
        if (this.getAccessType() == 0) {
            return 3306;
        }
        return -1;
    }

    public String getLimitClause(int nrRows) {
        return " LIMIT " + nrRows;
    }

    public String getSqlQueryFields(String tableName) {
        return "SELECT * FROM " + tableName + " LIMIT 0";
    }

    public String getSqlTableExists(String tableName) {
        return this.getSqlQueryFields(tableName);
    }

    public String getSqlColumnExists(String columnname, String tableName) {
        return this.getSqlQueryColumnFields(columnname, tableName);
    }

    public String getSqlQueryColumnFields(String columnname, String tableName) {
        return "SELECT " + columnname + " FROM " + tableName + " LIMIT 0";
    }

    public int getNotFoundTK(boolean useAutoinc) {
        if (this.isSupportsAutoInc() && useAutoinc) {
            return 1;
        }
        return super.getNotFoundTK(useAutoinc);
    }

    public String getDriverClass() {
        switch (this.driverClassName) {
            case "Mysql": {
                return "org.gjt.mm.mysql.Driver";
            }
            case "Mysql 8+": {
                return "com.mysql.cj.jdbc.Driver";
            }
        }
        return "com.mysql.cj.jdbc.Driver";
    }

    public String getDriverClassName() {
        return this.driverClassName;
    }

    public void setDriverClassName(String driverClassName) {
        this.driverClassName = driverClassName;
    }

    public String getURL(String hostname, String port, String databaseName) {
        if (Utils.isEmpty((CharSequence)port)) {
            return "jdbc:mysql://" + hostname + "/" + databaseName;
        }
        return "jdbc:mysql://" + hostname + ":" + port + "/" + databaseName;
    }

    public String getExtraOptionSeparator() {
        return "&";
    }

    public String getExtraOptionIndicator() {
        return "?";
    }

    public boolean isSupportsTransactions() {
        return false;
    }

    public boolean isSupportsBitmapIndex() {
        return false;
    }

    public boolean isSupportsViews() {
        return true;
    }

    public boolean isSupportsSynonyms() {
        return false;
    }

    public boolean isSupportsBooleanDataType() {
        return true;
    }

    public String getAddColumnStatement(String tableName, IValueMeta v, String tk, boolean useAutoinc, String pk, boolean semicolon) {
        return "ALTER TABLE " + tableName + " ADD " + this.getFieldDefinition(v, tk, pk, useAutoinc, true, false);
    }

    public String getModifyColumnStatement(String tableName, IValueMeta v, String tk, boolean useAutoinc, String pk, boolean semicolon) {
        return "ALTER TABLE " + tableName + " MODIFY " + this.getFieldDefinition(v, tk, pk, useAutoinc, true, false);
    }

    public String getFieldDefinition(IValueMeta v, String tk, String pk, boolean useAutoinc, boolean addFieldName, boolean addCR) {
        Object retval = "";
        String fieldname = v.getName();
        if (v.getLength() == 9999999) {
            v.setLength(this.getMaxTextFieldLength());
        }
        int length = v.getLength();
        int precision = v.getPrecision();
        if (addFieldName) {
            retval = (String)retval + fieldname + " ";
        }
        int type = v.getType();
        switch (type) {
            case 3: 
            case 9: {
                retval = (String)retval + "DATETIME";
                break;
            }
            case 4: {
                if (this.isSupportsBooleanDataType()) {
                    retval = (String)retval + "BOOLEAN";
                    break;
                }
                retval = (String)retval + "CHAR(1)";
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                if (fieldname.equalsIgnoreCase(tk) || fieldname.equalsIgnoreCase(pk)) {
                    if (useAutoinc) {
                        retval = (String)retval + "BIGINT AUTO_INCREMENT NOT NULL PRIMARY KEY";
                        break;
                    }
                    retval = (String)retval + "BIGINT NOT NULL PRIMARY KEY";
                    break;
                }
                if (precision == 0) {
                    if (length > 9) {
                        if (length < 19) {
                            retval = (String)retval + "BIGINT";
                            break;
                        }
                        retval = (String)retval + "DECIMAL(" + length + ")";
                        break;
                    }
                    retval = (String)retval + "INT";
                    break;
                }
                if (length > 15) {
                    retval = (String)retval + "DECIMAL(" + length;
                    if (precision > 0) {
                        retval = (String)retval + ", " + precision;
                    }
                    retval = (String)retval + ")";
                    break;
                }
                retval = (String)retval + "DOUBLE";
                break;
            }
            case 2: {
                if (length > 0) {
                    if (length == 1) {
                        retval = (String)retval + "CHAR(1)";
                        break;
                    }
                    if (length < 256) {
                        retval = (String)retval + "VARCHAR(" + length + ")";
                        break;
                    }
                    if (length < 65536) {
                        retval = (String)retval + "TEXT";
                        break;
                    }
                    if (length < 0x1000000) {
                        retval = (String)retval + "MEDIUMTEXT";
                        break;
                    }
                    retval = (String)retval + "LONGTEXT";
                    break;
                }
                retval = (String)retval + "TINYTEXT";
                break;
            }
            case 8: {
                retval = (String)retval + "LONGBLOB";
                break;
            }
            default: {
                retval = (String)retval + " UNKNOWN";
            }
        }
        if (addCR) {
            retval = (String)retval + Const.CR;
        }
        return retval;
    }

    public String[] getReservedWords() {
        return new String[]{"ADD", "ALL", "ALTER", "ANALYZE", "AND", "AS", "ASC", "ASENSITIVE", "BEFORE", "BETWEEN", "BIGINT", "BINARY", "BLOB", "BOTH", "BY", "CALL", "CASCADE", "CASE", "CHANGE", "CHAR", "CHARACTER", "CHECK", "COLLATE", "COLUMN", "CONDITION", "CONNECTION", "CONSTRAINT", "CONTINUE", "CONVERT", "CREATE", "CROSS", "CURRENT_DATE", "CURRENT_TIME", "CURRENT_TIMESTAMP", "CURRENT_USER", "CURSOR", "DATABASE", "DATABASES", "DAY_HOUR", "DAY_MICROSECOND", "DAY_MINUTE", "DAY_SECOND", "DEC", "DECIMAL", "DECLARE", "DEFAULT", "DELAYED", "DELETE", "DESC", "DESCRIBE", "DETERMINISTIC", "DISTINCT", "DISTINCTROW", "DIV", "DOUBLE", "DROP", "DUAL", "EACH", "ELSE", "ELSEIF", "ENCLOSED", "ESCAPED", "EXISTS", "EXIT", "EXPLAIN", "FALSE", "FETCH", "FLOAT", "FOR", "FORCE", "FOREIGN", "FROM", "FULLTEXT", "GOTO", "GRANT", "GROUP", "HAVING", "HIGH_PRIORITY", "HOUR_MICROSECOND", "HOUR_MINUTE", "HOUR_SECOND", "IF", "IGNORE", "IN", "INDEX", "INFILE", "INNER", "INOUT", "INSENSITIVE", "INSERT", "INT", "INTEGER", "INTERVAL", "INTO", "IS", "ITERATE", "JOIN", "KEY", "KEYS", "KILL", "LEADING", "LEAVE", "LEFT", "LIKE", "LIMIT", "LINES", "LOAD", "LOCALTIME", "LOCALTIMESTAMP", "LOCATE", "LOCK", "LONG", "LONGBLOB", "LONGTEXT", "LOOP", "LOW_PRIORITY", "MATCH", "MEDIUMBLOB", "MEDIUMINT", "MEDIUMTEXT", "MIDDLEINT", "MINUTE_MICROSECOND", "MINUTE_SECOND", "MOD", "MODIFIES", "NATURAL", "NOT", "NO_WRITE_TO_BINLOG", "NULL", "NUMERIC", "ON", "OPTIMIZE", "OPTION", "OPTIONALLY", "OR", "ORDER", "OUT", "OUTER", "OUTFILE", "POSITION", "PRECISION", "PRIMARY", "PROCEDURE", "PURGE", "READ", "READS", "REAL", "REFERENCES", "REGEXP", "RENAME", "REPEAT", "REPLACE", "REQUIRE", "RESTRICT", "RETURN", "REVOKE", "RIGHT", "RLIKE", "SCHEMA", "SCHEMAS", "SECOND_MICROSECOND", "SELECT", "SENSITIVE", "SEPARATOR", "SET", "SHOW", "SMALLINT", "SONAME", "SPATIAL", "SPECIFIC", "SQL", "SQLEXCEPTION", "SQLSTATE", "SQLWARNING", "SQL_BIG_RESULT", "SQL_CALC_FOUND_ROWS", "SQL_SMALL_RESULT", "SSL", "STARTING", "STRAIGHT_JOIN", "TABLE", "TERMINATED", "THEN", "TINYBLOB", "TINYINT", "TINYTEXT", "TO", "TRAILING", "TRIGGER", "TRUE", "UNDO", "UNION", "UNIQUE", "UNLOCK", "UNSIGNED", "UPDATE", "USAGE", "USE", "USING", "UTC_DATE", "UTC_TIME", "UTC_TIMESTAMP", "VALUES", "VARBINARY", "VARCHAR", "VARCHARACTER", "VARYING", "WHEN", "WHERE", "WHILE", "WITH", "WRITE", "XOR", "YEAR_MONTH", "ZEROFILL"};
    }

    public String getStartQuote() {
        return "`";
    }

    public String getEndQuote() {
        return "`";
    }

    public String getSqlLockTables(String[] tableNames) {
        Object sql = "LOCK TABLES ";
        for (int i = 0; i < tableNames.length; ++i) {
            if (i > 0) {
                sql = (String)sql + ", ";
            }
            sql = (String)sql + tableNames[i] + " WRITE";
        }
        sql = (String)sql + ";" + Const.CR;
        return sql;
    }

    public String getSqlUnlockTables(String[] tableName) {
        return "UNLOCK TABLES";
    }

    public String getExtraOptionsHelpText() {
        return "http://dev.mysql.com/doc/refman/5.0/en/connector-j-reference-configuration-properties.html";
    }

    public boolean isSystemTable(String tableName) {
        return tableName.startsWith("sys") || tableName.equals("dtproperties");
    }

    public String getSqlInsertAutoIncUnknownDimensionRow(String schemaTable, String keyField, String versionField) {
        return "insert into " + schemaTable + "(" + keyField + ", " + versionField + ") values (1, 1)";
    }

    public String quoteSqlString(String string) {
        string = string.replace("'", "\\\\'");
        string = string.replace("\\n", "\\\\n");
        string = string.replace("\\r", "\\\\r");
        return "'" + string + "'";
    }

    public boolean isMySqlVariant() {
        return true;
    }

    public boolean isReleaseSavepoint() {
        return false;
    }

    public boolean IsSupportsErrorHandlingOnBatchUpdates() {
        return true;
    }

    public boolean isRequiringTransactionsOnQueries() {
        return false;
    }

    public boolean isFullExceptionLog(Exception e) {
        Throwable cause = e == null ? null : e.getCause();
        return cause == null || !SHORT_MESSAGE_EXCEPTIONS.contains(cause.getClass().getName());
    }

    public void addDefaultOptions() {
        this.addExtraOption(this.getPluginId(), "defaultFetchSize", "500");
        this.addExtraOption(this.getPluginId(), "useCursorFetch", "true");
        this.addExtraOption(this.getPluginId(), "zeroDateTimeBehaviorValue", "CONVERT_TO_NULL");
    }

    public int getMaxVARCHARLength() {
        return 65535;
    }

    public int getMaxTextFieldLength() {
        return Integer.MAX_VALUE;
    }

    public String getLegacyColumnName(DatabaseMetaData dbMetaData, ResultSetMetaData rsMetaData, int index) throws HopDatabaseException {
        if (dbMetaData == null) {
            throw new HopDatabaseException(BaseMessages.getString(PKG, (String)"MySQLDatabaseMeta.Exception.LegacyColumnNameNoDBMetaDataException", (String[])new String[0]));
        }
        if (rsMetaData == null) {
            throw new HopDatabaseException(BaseMessages.getString(PKG, (String)"MySQLDatabaseMeta.Exception.LegacyColumnNameNoRSMetaDataException", (String[])new String[0]));
        }
        try {
            return dbMetaData.getDriverMajorVersion() > 3 ? rsMetaData.getColumnLabel(index) : rsMetaData.getColumnName(index);
        }
        catch (Exception e) {
            throw new HopDatabaseException(String.format("%s: %s", BaseMessages.getString(PKG, (String)"MySQLDatabaseMeta.Exception.LegacyColumnNameException", (String[])new String[0]), e.getMessage()), (Throwable)e);
        }
    }

    public List<String> getDriverClassNames(ILogChannel log, IHopMetadataProvider metadataProvider) {
        ArrayList<String> names = new ArrayList<String>();
        names.add(CONST_MYSQL_8);
        names.add("Mysql");
        return names;
    }
}

